/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.BatchUpdateStatus;
import com.intersystems.jdbc.BufferUtils;
import com.intersystems.jdbc.ConnectionInformation;
import com.intersystems.jdbc.DBList;
import com.intersystems.jdbc.ListWriter;
import com.intersystems.jdbc.LogFileStream;
import com.intersystems.jdbc.MessageHeader;
import com.intersystems.jdbc.Parameter;
import com.intersystems.jdbc.ResultSetRow;
import com.intersystems.jdbc.SQLValidationException;
import com.intersystems.util.ListUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.BatchUpdateException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;

public class BufferWrite
extends ListWriter {
    private static final int STREAM_BUF_SIZE = 32768;
    private static final int maxBufferSize = 65536;
    private static int CHUNKSIZE = 256;
    private int maxFieldSize = 0;

    public BufferWrite(String locale) {
        super(CHUNKSIZE + 14, locale);
        this.clearList();
    }

    BufferWrite(ConnectionInformation info) {
        super(CHUNKSIZE + 14, info);
        this.clearList();
        this.setConnectionInfo(info);
    }

    public BufferWrite(int nLen, String locale) {
        super(nLen + 14, locale);
    }

    @Override
    public void clearList() {
        this.m_iOffset = 14;
        this.m_lastReadOffset = 14;
    }

    public void setConnectionInfo(ConnectionInformation info) {
        this.setLocale(info.serverLocale);
        this.setCompactDoubleEnabled(info.compactDoubleEnabled);
        this.m_isUnicodeServer = info.isUnicodeServer;
    }

    void dumpData(OutputStream out, int count, LogFileStream logFile, String jobID, int deviceID) throws IOException {
        this.dumpData(out, count, this.m_iOffset, logFile, jobID, deviceID);
    }

    void dumpData(OutputStream out, int count, int length, LogFileStream logFile, String jobID, int deviceID) throws IOException {
        MessageHeader.setCount(this.m_aData, count);
        MessageHeader.setMessageLength(this.m_aData, length - 14);
        out.write(this.m_aData, 0, length);
        out.flush();
        if (logFile != null) {
            logFile.dump(this.m_aData, 0, length, 1, null, jobID, deviceID);
        }
    }

    public void writeHeader(int statementID, byte[] type) {
        MessageHeader.setStatementID(this.m_aData, statementID);
        MessageHeader.setMsgType(this.m_aData, type);
        this.m_iOffset = 14;
    }

    public void writeHeader(byte[] type) {
        this.writeHeader(0, type);
    }

    void set2ByteInt(int data) {
        this.stuffRawInt(this.m_iOffset, data, 2);
        this.m_iOffset += 2;
    }

    void setRawBytes(byte[] b) {
        this.checkBufferSize(b.length + 14);
        System.arraycopy(b, 0, this.m_aData, 14, b.length);
        this.m_iOffset += b.length + 14;
    }

    void setVectorBuffer(Parameter par, BatchUpdateStatus bue) throws SQLException {
        if (par.values.size() <= bue.getErrors()) {
            return;
        }
        if (par.outBuffer != null) {
            int i;
            if (bue.getErrors() == 0) {
                return;
            }
            byte[] inBuffer = par.outBuffer.getBuffer();
            int[] listOffsets = ResultSetRow.indexLists(inBuffer, par.outBuffer.getLength(), 14, par.values.size());
            Integer[] arrayRowErrors = bue.getRowErrors();
            int toStart = listOffsets[arrayRowErrors[0]];
            int fromStart = 0;
            int length = 0;
            for (i = 1; i < bue.getErrors(); ++i) {
                if (arrayRowErrors[i - 1] == arrayRowErrors[i] - 1) continue;
                fromStart = listOffsets[arrayRowErrors[i - 1] + 1];
                length = listOffsets[arrayRowErrors[i]] - fromStart;
                BufferUtils.copyByteArray(inBuffer, fromStart, inBuffer, toStart, length);
                toStart += length;
            }
            if (i <= bue.getErrors()) {
                fromStart = listOffsets[arrayRowErrors[i - 1] + 1];
                length = par.outBuffer.getBufferOffset() - fromStart;
                BufferUtils.copyByteArray(inBuffer, fromStart, inBuffer, toStart, length);
                toStart += length;
            }
            par.outBuffer.setBufferOffset(toStart);
            return;
        }
        Boolean fi = true;
        int type = par.type;
        int cnt = -1;
        int nullable = par.nullable;
        int precision = par.precision;
        int truncate = par.truncate;
        for (Object value : par.values) {
            ++cnt;
            try {
                if (value == null) {
                    if (nullable == 0) {
                        throw new SQLValidationException("[SQLCODE: <-108>:<Required field missing; INSERT or UPDATE not allowed>]\n", "is required", 108);
                    }
                    this.setFINull();
                    continue;
                }
                switch (type) {
                    case -15: 
                    case -9: 
                    case 1: 
                    case 12: {
                        if (value instanceof byte[]) {
                            this.setBinary(value, par.precision, fi != false ? par.truncate : 2);
                            break;
                        }
                        this.setFIString(value, precision, (Long)par.minVal, truncate);
                        break;
                    }
                    case -3: {
                        this.setBinary(value, par.precision, fi != false ? par.truncate : 2);
                        break;
                    }
                    case 4: {
                        this.setInt(value, (Long)par.minVal, (Long)par.maxVal);
                        break;
                    }
                    case 6: 
                    case 8: {
                        this.setDouble(value, (Double)par.minVal, (Double)par.maxVal);
                        break;
                    }
                    case 91: {
                        if (!fi.booleanValue()) {
                            this.setOldTemporalParameter(value, null);
                            break;
                        }
                    }
                    case 1091: {
                        this.setDateH(value, null, (Long)par.minVal, (Long)par.maxVal);
                        break;
                    }
                    case 92: {
                        if (!fi.booleanValue()) {
                            this.setOldTemporalParameter(value, par.whatever.size() == 0 ? null : (Calendar)par.whatever.get(cnt));
                            break;
                        }
                    }
                    case 1092: {
                        this.setTimeH(value, par.whatever.size() == 0 ? null : (Calendar)par.whatever.get(cnt), (BigDecimal)par.minVal, (BigDecimal)par.maxVal, par.scale);
                        break;
                    }
                    case 93: {
                        this.setTimestamp(value, par.whatever.size() == 0 ? null : (Calendar)par.whatever.get(cnt), (Timestamp)par.minVal, (Timestamp)par.maxVal, fi != false ? par.truncate : 2);
                        break;
                    }
                    case 1093: {
                        this.setPosix(value, par.whatever.size() == 0 ? null : (Calendar)par.whatever.get(cnt), (Long)par.minVal, (Long)par.maxVal, fi != false ? par.truncate : 2);
                        break;
                    }
                    case -5: {
                        this.setLong(value, (Long)par.minVal, (Long)par.maxVal);
                        break;
                    }
                    case 2: 
                    case 7: {
                        this.setBigDecimal(value, par.whatever.size() == 0 ? null : (Integer)par.whatever.get(cnt), (BigDecimal)par.minVal, (BigDecimal)par.maxVal, par.scale);
                        break;
                    }
                    case -7: {
                        this.setBit(value);
                        break;
                    }
                    case -6: {
                        this.setByte(value, (Long)par.minVal, (Long)par.maxVal);
                        break;
                    }
                    case 5: {
                        this.setShort(value, (Long)par.minVal, (Long)par.maxVal);
                        break;
                    }
                    case -11: {
                        this.setGUID(value);
                        break;
                    }
                    default: {
                        new SQLException("Unsupported parameter Type: " + par.type);
                    }
                }
            }
            catch (SQLValidationException ex) {
                ex.parName = par.name;
                try {
                    bue.setException(ex, false, cnt);
                    this.setUndefined();
                }
                catch (BatchUpdateException batchUpdateException) {}
            }
        }
        par.outBuffer = this;
    }

    void setParameter(Parameter par, int cnt, boolean fi) throws SQLException {
        Object value = null;
        try {
            value = par.values.get(cnt);
            if (value == null) {
                if (fi) {
                    if (par.nullable == 0) {
                        throw new SQLValidationException("[SQLCODE: <-108>:<Required field missing; INSERT not allowed> <Field '", "is required", 108, false);
                    }
                    this.setFINull();
                } else {
                    this.setNull();
                }
                return;
            }
            switch (par.type) {
                case -15: 
                case -9: 
                case 0: 
                case 1: 
                case 12: {
                    if (value instanceof byte[]) {
                        this.setBinary(value, par.precision, fi ? par.truncate : 2);
                        break;
                    }
                    this.setString(value, par.precision, (Long)par.minVal, fi ? par.truncate : 2);
                    break;
                }
                case -3: {
                    this.setBinary(value, par.precision, fi ? par.truncate : 2);
                    break;
                }
                case 4: {
                    this.setInt(value, (Long)par.minVal, (Long)par.maxVal);
                    break;
                }
                case 6: 
                case 8: {
                    this.setDouble(value, (Double)par.minVal, (Double)par.maxVal);
                    break;
                }
                case 91: {
                    if (!fi) {
                        this.setOldTemporalParameter(value, null);
                        break;
                    }
                }
                case 1091: {
                    this.setDateH(value, null, (Long)par.minVal, (Long)par.maxVal);
                    break;
                }
                case 92: {
                    if (!fi) {
                        this.setOldTemporalParameter(value, par.whatever.size() == 0 ? null : (Calendar)par.whatever.get(cnt));
                        break;
                    }
                }
                case 1092: {
                    this.setTimeH(value, par.whatever.size() == 0 ? null : (Calendar)par.whatever.get(cnt), (BigDecimal)par.minVal, (BigDecimal)par.maxVal, par.scale);
                    break;
                }
                case 93: {
                    this.setTimestamp(value, par.whatever.size() == 0 ? null : (Calendar)par.whatever.get(cnt), (Timestamp)par.minVal, (Timestamp)par.maxVal, par.truncate);
                    break;
                }
                case 1093: {
                    this.setPosix(value, par.whatever.size() == 0 ? null : (Calendar)par.whatever.get(cnt), (Long)par.minVal, (Long)par.maxVal, fi ? par.truncate : 2);
                    break;
                }
                case -5: {
                    this.setLong(value, (Long)par.minVal, (Long)par.maxVal);
                    break;
                }
                case 2: 
                case 7: {
                    this.setBigDecimal(value, par.whatever.size() == 0 ? null : (Integer)par.whatever.get(cnt), (BigDecimal)par.minVal, (BigDecimal)par.maxVal, par.scale);
                    break;
                }
                case -7: {
                    this.setBit(value);
                    break;
                }
                case -6: {
                    this.setByte(value, (Long)par.minVal, (Long)par.maxVal);
                    break;
                }
                case 5: {
                    this.setShort(value, (Long)par.minVal, (Long)par.maxVal);
                    break;
                }
                case -11: {
                    this.setGUID(value);
                    break;
                }
                case -4: 
                case -1: {
                    this.setObject(value);
                    break;
                }
                default: {
                    new SQLException("Unsupported parameter Type: " + par.type);
                    break;
                }
            }
        }
        catch (SQLValidationException ex) {
            if (fi) {
                ex.parName = par.name;
                throw ex;
            }
            this.setObject(value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOldTemporalParameter(Object value, Object object2) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        } else if (value instanceof Date) {
            this.set((Date)value, (Calendar)object2);
            return;
        } else if (value instanceof Time) {
            this.set((Time)value, (Calendar)object2);
            return;
        } else if (value instanceof Timestamp) {
            this.set((Timestamp)value, (Calendar)object2);
            return;
        } else if (value instanceof LocalDate) {
            this.set(Date.valueOf((LocalDate)value), (Calendar)object2);
            return;
        } else if (value instanceof LocalTime) {
            this.set(Time.valueOf((LocalTime)value), (Calendar)object2);
            return;
        } else if (value instanceof LocalDateTime) {
            this.set(Timestamp.valueOf((LocalDateTime)value), (Calendar)object2);
            return;
        } else if (object2 == null & value instanceof String) {
            this.set((String)value);
            return;
        } else {
            if (!(object2 instanceof Integer)) throw new SQLValidationException("Type out of range " + value.getClass().getName() + " " + (object2 == null ? "" : object2.getClass().getName()), "S1003", 104);
            if (value instanceof Number) {
                this.set(new BigDecimal(value.toString()).setScale((int)((Integer)object2), RoundingMode.DOWN));
                return;
            } else {
                if (!(value instanceof String)) throw new SQLValidationException("Type out of range " + value.getClass().getName() + " " + (object2 == null ? "" : object2.getClass().getName()), "S1003", 104);
                this.set(new BigDecimal(value.toString()).setScale((int)((Integer)object2), RoundingMode.DOWN));
            }
        }
    }

    public void setSQLText(String sqlText) throws SQLException {
        int chunksize = 31904;
        int len = sqlText.length();
        if (len == 0) {
            this.set(sqlText);
            return;
        }
        int bindex = 0;
        int chunknum = len % chunksize != 0 ? len / chunksize + 1 : len / chunksize;
        this.set(chunknum);
        for (int i = 1; i <= chunknum; ++i) {
            int eindex = bindex + chunksize;
            eindex = eindex > len ? len : eindex;
            this.set(sqlText.substring(bindex, eindex));
            bindex = eindex;
        }
    }

    void setMaxFieldSize(int max) {
        this.maxFieldSize = max;
    }

    int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    void writeBatchCount(int count) {
        if (count == -1) {
            this.m_iOffset += 4;
        }
        this.stuffRawInt(14, count, 4);
    }

    int getBufferOffset() {
        return this.m_iOffset;
    }

    void setBufferOffset(int offset) {
        this.m_iOffset = offset;
    }

    void reserveHeader() {
        if (this.m_iOffset < 14) {
            this.checkBufferSize(14);
        }
        this.m_aData[0] = 0;
        this.m_aData[1] = 0;
        this.m_aData[2] = 0;
        this.m_aData[3] = 0;
        this.m_aData[4] = 0;
        this.m_aData[5] = 0;
        this.m_aData[6] = 0;
        this.m_aData[7] = 0;
        this.m_aData[8] = 0;
        this.m_aData[9] = 0;
        this.m_aData[10] = 0;
        this.m_aData[11] = 0;
        this.m_aData[12] = 0;
        this.m_aData[13] = 0;
        this.m_iOffset = 14;
    }

    public void resetHeader() {
        this.m_iOffset = 14;
    }

    void writeContinuationHeader(int statementID, byte[] type, boolean setContinuation) {
        MessageHeader.setMessageLength(this.m_aData, this.m_iOffset - 14);
        if (setContinuation) {
            MessageHeader.setStatementID(this.m_aData, statementID | Integer.MIN_VALUE);
        } else {
            MessageHeader.setStatementID(this.m_aData, statementID);
        }
        MessageHeader.setMsgType(this.m_aData, type);
    }

    public static int writeStream(InputStream in, int streamType, int sqlType, byte[] data, int len, int offset, int lengthOffset, String serverLocale) throws IOException {
        int bytesWritten;
        int charsRead = 0;
        if (streamType == 0) {
            int maxlen = data.length - offset - 1;
            byte[] buffer = new byte[32768];
            while (len > charsRead) {
                int charsread = len > 32768 ? 32768 : len - charsRead;
                if ((charsread = in.read(buffer, 0, charsread)) != -1) {
                    boolean resizeRequired = false;
                    for (int i = 0; i < charsread; ++i) {
                        int utf8bytes = ListUtil.getUTF8FromAscii(buffer, i, data, offset + bytesWritten, maxlen - bytesWritten, serverLocale);
                        if (utf8bytes == 0) {
                            resizeRequired = true;
                            break;
                        }
                        ++charsRead;
                        bytesWritten += utf8bytes;
                    }
                    if (!resizeRequired) continue;
                }
                break;
            }
        } else if (streamType == 1) {
            int bytes;
            for (bytesWritten = 0; len > bytesWritten && (bytes = in.read(data, offset + bytesWritten, len - bytesWritten)) != -1; bytesWritten += bytes) {
            }
            charsRead = bytesWritten;
        } else {
            throw new IOException("Unsupported Stream type: " + streamType);
        }
        if (lengthOffset >= 0) {
            DBList.stuffRawInt(data, lengthOffset, charsRead, 4);
        }
        return bytesWritten;
    }

    public void writeInputStream(InputStream in, int len, int streamType, int sqlType) throws SQLException {
        try {
            int originalOffset = this.m_iOffset;
            int needed = streamType == 0 ? len * 2 : len;
            this.checkBufferSize(needed);
            String locale = this.m_isUnicodeServer ? null : this.getLocale();
            this.m_iOffset += 4;
            int bytes = BufferWrite.writeStream(in, streamType, sqlType, this.m_aData, len, this.m_iOffset, originalOffset, locale);
            this.m_iOffset += bytes;
        }
        catch (IOException e) {
            throw new SQLException("Error writing stream: " + e.getMessage());
        }
    }

    void writeReader(Reader reader, int len) throws SQLException {
        int startOffset = this.m_iOffset;
        this.m_iOffset += 4;
        try {
            int chars = 0;
            int needed = this.m_isUnicodeServer ? len * 3 : len * 2;
            this.checkBufferSize(needed);
            char[] buffer = new char[32768];
            while (len > 0) {
                int charsread = len > 32768 ? 32768 : len;
                if ((charsread = reader.read(buffer, 0, charsread)) == -1) break;
                chars += charsread;
                len -= charsread;
                for (int i = 0; i < charsread; ++i) {
                    char c = buffer[i];
                    int n = ListUtil.getUTFBytes(c, this.m_aData, this.m_iOffset, this.m_aData.length - this.m_iOffset);
                    this.m_iOffset += n;
                    if (n > 0) continue;
                    throw new SQLException("Buffer length is not enough", "S1000");
                }
            }
            DBList.stuffRawInt(this.m_aData, startOffset, chars, 4);
        }
        catch (IOException e) {
            throw new SQLException("Error writing stream: " + e.getMessage());
        }
    }

    @Override
    public String toString() {
        byte[] buffer = new byte[this.m_iOffset - 14];
        System.arraycopy(this.m_aData, 14, buffer, 0, this.m_iOffset - 14);
        return "Header +" + DBList.toString(this.m_aData, this.m_iOffset, null);
    }

    public void writeHeaderSYSIO(int statementID, long type) {
        ByteBuffer shiftedType = ByteBuffer.allocate(2);
        shiftedType.order(ByteOrder.LITTLE_ENDIAN);
        shiftedType.putShort((short)(type + 49728L));
        this.writeHeader(statementID, shiftedType.array());
    }

    public void writeHeaderSYSIO(long type) {
        this.writeHeaderSYSIO(0, type);
    }
}

