/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.IRISWrapper;
import com.intersystems.jdbc.LogFileStream;
import java.io.PrintWriter;
import java.sql.SQLException;

class ConnectInput
extends IRISWrapper {
    String host = "127.0.0.1";
    protected LogFileStream logFile = null;
    int port = 1972;
    String namespace = "USER";
    String username = "";
    String password = "";
    String accesstoken = null;
    String eventClass = "";
    boolean nodelay = true;
    int securityLevel = 0;
    boolean valid = false;
    boolean useSharedMemory = true;

    ConnectInput() {
    }

    ConnectInput(String url) throws SQLException {
        try {
            this.setURL(url);
            this.valid = true;
        }
        catch (SQLException sqlEx) {
            this.closeLogFile();
            this.valid = false;
        }
    }

    void closeLogFile() {
        if (this.logFile != null) {
            this.logFile.close();
        }
    }

    public String getURL() {
        return String.format("jdbc:IRIS://%s:%d/%s/%s:%s:%s:%s", this.getServerName(), this.port, this.namespace, this.getLogFileName(), this.eventClass, this.nodelay, this.securityLevel == 10 ? "true" : "");
    }

    public void setURL(String u) throws SQLException {
        int pos;
        if (u == null || u.isEmpty() || !u.startsWith("jdbc:IRIS://")) {
            throw new SQLException("Invalid URL: " + u, "S1000");
        }
        String temp = u.substring(12);
        if (temp.isEmpty()) {
            throw new SQLException("Invalid URL: " + u, "S1000");
        }
        boolean hasPort = false;
        if ((temp = this.parseCredentials(temp)).startsWith("[")) {
            pos = temp.indexOf("]");
            if (pos == -1) {
                throw new SQLException("Invalid URL: " + u, "S1000");
            }
            this.setHost(temp.substring(1, pos));
            temp = temp.substring(pos + 1);
            if (temp.isEmpty()) {
                return;
            }
            hasPort = temp.startsWith(":");
            if (!hasPort && !temp.startsWith("/")) {
                throw new SQLException("Invalid URL: " + u, "S1000");
            }
            temp = temp.substring(1);
        } else {
            pos = temp.indexOf(":");
            if (pos == -1) {
                pos = temp.indexOf(47);
            } else {
                hasPort = true;
            }
            if (pos == -1) {
                this.setHost(temp.substring(0));
            } else {
                this.setHost(temp.substring(0, pos));
            }
            if (pos == -1) {
                return;
            }
            temp = temp.substring(pos + 1);
        }
        if (hasPort) {
            pos = temp.indexOf("/");
            try {
                if (pos == -1) {
                    this.port = Integer.parseInt(temp);
                    return;
                }
                this.port = Integer.parseInt(temp.substring(0, pos));
            }
            catch (NumberFormatException ex) {
                throw new SQLException("Invalid URL: " + u, "S1000");
            }
            temp = temp.substring(pos + 1);
        }
        if ((pos = temp.indexOf("/")) == 0) {
            throw new SQLException("Invalid URL: " + u, "S1000");
        }
        if (pos == -1) {
            if (temp.isEmpty()) {
                return;
            }
            this.namespace = temp;
            return;
        }
        this.namespace = temp.substring(0, pos);
        if ((pos = (temp = temp.substring(pos + 1)).indexOf(":")) == -1) {
            this.setLogFileNoThrow(temp);
            return;
        }
        if (pos > 0 && pos + 1 < temp.length() && (temp.charAt(pos + 1) == '\\' || temp.charAt(pos + 1) == '/')) {
            pos = temp.indexOf(":", pos + 1) != -1 ? temp.indexOf(":", pos + 1) : temp.length();
        }
        this.setLogFileNoThrow(temp.substring(0, pos));
        if (pos == temp.length()) {
            return;
        }
        this.parseExtension(temp.substring(pos + 1), u);
    }

    private void parseExtension(String ext, String url) throws SQLException {
        int pos = ext.indexOf(":");
        if (pos == -1) {
            this.eventClass = ext;
        } else {
            this.eventClass = ext.substring(0, pos);
            if ((pos = (ext = ext.substring(pos + 1)).indexOf(":")) == -1) {
                if (ext.equalsIgnoreCase("false")) {
                    this.nodelay = false;
                }
            } else {
                if (ext.substring(0, pos).equalsIgnoreCase("false")) {
                    this.nodelay = false;
                }
                if ((ext = ext.substring(pos + 1)).indexOf(58) != -1) {
                    throw new SQLException("Invalid URL: " + url, "S1000");
                }
                if (ext.equalsIgnoreCase("true")) {
                    this.securityLevel = 10;
                }
            }
        }
    }

    private String parseCredentials(String str) {
        int idx;
        int pos1 = str.indexOf("?");
        if (pos1 == -1) {
            return str;
        }
        String cred = str.substring(pos1 + 1);
        while ((idx = cred.indexOf(61)) != -1) {
            String param = cred.substring(0, idx);
            cred = cred.substring(idx + 1);
            idx = cred.indexOf(38);
            if (param.equals("username")) {
                if (idx == -1) {
                    this.username = cred;
                    return str.substring(0, pos1);
                }
                this.username = cred.substring(0, idx);
            } else if (param.equals("password")) {
                if (idx == -1) {
                    this.password = cred;
                    return str.substring(0, pos1);
                }
                this.password = cred.substring(0, idx);
            }
            cred = cred.substring(idx + 1);
        }
        return str.substring(0, pos1);
    }

    void writeToLog(String msg) {
        if (this.logFile == null) {
            return;
        }
        this.logFile.logApi(msg);
    }

    public String getUser() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAccessToken() {
        return this.accesstoken;
    }

    public String getServerName() {
        return this.useSharedMemory ? "SHM|||||" : this.host;
    }

    void setHost(String host) {
        this.host = host;
        this.useSharedMemory = host.startsWith("SHM|") || this.useSharedMemory && (host.equalsIgnoreCase("localhost") || host.contains("127.0.0.1"));
    }

    public int getPortNumber() {
        return this.port;
    }

    public String getDatabaseName() {
        return this.namespace;
    }

    public String getEventClass() {
        return this.eventClass;
    }

    public boolean getNodelay() {
        return this.nodelay;
    }

    public int getConnectionSecurityLevel() {
        return this.securityLevel;
    }

    public Boolean getSharedMemory() {
        return this.useSharedMemory;
    }

    public LogFileStream getLogFile() {
        if (this.logFile == null) {
            return null;
        }
        return this.logFile;
    }

    public void setLogFile(String fileName) throws SQLException {
        if (fileName == null || fileName.isEmpty()) {
            this.logFile = null;
        } else {
            try {
                if (this.logFile != null) {
                    if (this.logFile.getLogFileName().equalsIgnoreCase(fileName)) {
                        return;
                    }
                    this.logFile.close();
                }
                this.logFile = new LogFileStream(fileName);
            }
            catch (Exception e) {
                throw new SQLException("Invalid log file name: " + fileName, "S1000");
            }
        }
    }

    protected void setLogFileNoThrow(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            this.logFile = null;
        } else {
            try {
                if (this.logFile != null) {
                    if (this.logFile.getLogFileName().equalsIgnoreCase(fileName)) {
                        return;
                    }
                    this.logFile.close();
                }
                this.logFile = new LogFileStream(fileName);
            }
            catch (Exception e) {
                this.logFile = null;
            }
        }
    }

    public void setLogFile(LogFileStream lf) {
        this.closeLogFile();
        this.logFile = lf;
    }

    public PrintWriter getLogWriter() {
        if (this.logFile == null) {
            return null;
        }
        return this.logFile.getPrintWriter();
    }

    public void setLogWriter(PrintWriter pw) {
        if (pw == null) {
            this.logFile = null;
        } else {
            if (this.logFile != null) {
                if (this.logFile.getPrintWriter() == pw) {
                    return;
                }
                this.logFile.close();
            }
            this.logFile = new LogFileStream(pw);
        }
    }

    public String getLogFileName() {
        if (this.logFile != null) {
            return this.logFile.getLogFileName();
        }
        return "";
    }

    void writeLogFileHeader() {
        if (this.logFile == null) {
            return;
        }
        this.logFile.dumpHeader();
    }
}

