/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import java.sql.SQLException;

public final class ConnectionInformation
implements Cloneable {
    public boolean isUnicodeServer = true;
    public int protocolVersion = 69;
    public String serverLocale = "ISO8859_1";
    public String srvJobNumber = "-1";
    public boolean compactDoubleEnabled = false;
    int delimitedIds = 0;
    String serverVersion = null;
    int serverMajorVersion = 0;
    int serverMinorVersion = 0;
    public String irisInstallDir = null;
    int sqlEmptyString = 0;
    int supportedIsolationLevels = 0;

    void parseServerVersion(String svrVersion) throws SQLException {
        String tmp = this.serverVersion = svrVersion;
        try {
            tmp = tmp.substring(tmp.indexOf("Version") + 8);
            String[] versions = tmp.split("\\x2E");
            this.serverMajorVersion = Integer.parseInt(versions[0]);
            this.serverMinorVersion = Integer.parseInt(versions[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setServerLocale(String locale) {
        this.serverLocale = ConnectionInformation.getServerLocale(locale);
    }

    public static String getServerLocale(String locale) {
        if (locale.equalsIgnoreCase("UNICODE") || locale.equalsIgnoreCase("LATIN1")) {
            return "ISO8859_1";
        }
        if (locale.equalsIgnoreCase("LATIN7")) {
            return "ISO8859_13";
        }
        if (locale.equalsIgnoreCase("LATIN9")) {
            return "Latin9";
        }
        if (locale.equalsIgnoreCase("LATINA")) {
            return "ISO8859_6";
        }
        if (locale.equalsIgnoreCase("LATINT")) {
            return "ISO8859_11";
        }
        if (locale.equalsIgnoreCase("LATIN2")) {
            return "ISO8859_2";
        }
        if (locale.equalsIgnoreCase("LATIN3")) {
            return "ISO8859_3";
        }
        if (locale.equalsIgnoreCase("LATINC")) {
            return "ISO8859_5";
        }
        if (locale.equalsIgnoreCase("LATING")) {
            return "ISO8859_7";
        }
        if (locale.equalsIgnoreCase("LATINH")) {
            return "ISO8859_8";
        }
        if (locale.equalsIgnoreCase("CP866")) {
            return "Cp866";
        }
        if (locale.equalsIgnoreCase("CP874")) {
            return "Cp874";
        }
        if (locale.equalsIgnoreCase("CP1250")) {
            return "Cp1250";
        }
        if (locale.equalsIgnoreCase("CP1251")) {
            return "Cp1251";
        }
        if (locale.equalsIgnoreCase("CP1252")) {
            return "Cp1252";
        }
        if (locale.equalsIgnoreCase("CP1253")) {
            return "Cp1253";
        }
        if (locale.equalsIgnoreCase("CP1255")) {
            return "Cp1255";
        }
        if (locale.equalsIgnoreCase("CP1256")) {
            return "Cp1256";
        }
        if (locale.equalsIgnoreCase("CP1257")) {
            return "Cp1257";
        }
        return locale;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

