/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.ConnectInput;
import com.intersystems.jdbc.IRISDriverProperties;
import com.intersystems.jdbc.IRISPooledConnection;
import com.intersystems.shm.SharedMemorySocket;
import com.intersystems.util.MachineInfo;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;

public class ConnectionParameters
extends ConnectInput
implements Cloneable {
    protected String principalName = null;
    protected String sSLConfigName = null;
    protected String keyRecoveryPassword = null;
    protected int isolationLevel = 1;
    protected int sqlDialect = 0;
    int connectionTimeout = DriverManager.getLoginTimeout();
    int featureOption = 59;
    int preparseCacheSize = 50;
    int maxStatementCacheSize = 500;
    boolean keepAlive = true;
    int soRcvBuf = 32768;
    int soSndBuf = 32768;
    int streamPrefetchSize = 0;
    SSLContext sslctx = null;
    int queryPrefetchSize = 32768;
    int networkTimeout = 0;
    int commitTimeout = 10000;
    boolean addToPool = false;
    IRISPooledConnection pooled = null;
    boolean ping = true;
    int connectionLifetime = 0;
    public boolean autobalance = true;
    public boolean isPiped = false;
    int loaderPoolSize = 0;
    static HashMap<String, IRISDriverProperties> hash = IRISDriverProperties.getPropertiesHashMap();

    ConnectionParameters() {
    }

    public ConnectionParameters(String url, Properties props) throws SQLException {
        super(url);
        if (!this.valid) {
            return;
        }
        try {
            this.applyProperties(props);
            this.reconcileURLandProps();
        }
        catch (SQLException ex) {
            this.closeLogFile();
            throw ex;
        }
    }

    public void updateConParams(String h, int p, String n, String u, String pass, String log, Properties props) throws SQLException {
        this.host = h;
        this.port = p;
        this.namespace = n;
        this.username = u;
        this.password = pass;
        this.setLogFileNoThrow(log);
        try {
            this.applyProperties(props);
            this.reconcileURLandProps();
        }
        catch (SQLException ex) {
            this.closeLogFile();
            throw ex;
        }
    }

    /*
     * Unable to fully structure code
     */
    void applyProperties(Properties props) throws SQLException {
        if (props != null) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                idp = ConnectionParameters.hash.get(entry.getKey());
                if (idp == null) continue;
                obj = entry.getValue();
                try {
                    var6_6 = idp.dpi.field.getType().toString();
                    var7_9 = -1;
                    switch (var6_6.hashCode()) {
                        case 673016845: {
                            if (!var6_6.equals("class java.lang.String")) break;
                            var7_9 = 0;
                            break;
                        }
                        case 64711720: {
                            if (!var6_6.equals("boolean")) break;
                            var7_9 = 1;
                            break;
                        }
                        case 104431: {
                            if (!var6_6.equals("int")) break;
                            var7_9 = 2;
                            break;
                        }
                        case -315660930: {
                            if (!var6_6.equals("class com.intersystems.jdbc.LogFileStream")) break;
                            var7_9 = 3;
                            break;
                        }
                        case -925897802: {
                            if (!var6_6.equals("class javax.net.ssl.SSLContext")) break;
                            var7_9 = 4;
                        }
                    }
                    switch (var7_9) {
                        case 0: {
                            idp.dpi.field.set(this, obj);
                            break;
                        }
                        case 1: {
                            if (obj instanceof String) {
                                idp.dpi.field.set(this, Boolean.parseBoolean((String)obj));
                                break;
                            }
                            idp.dpi.field.set(this, (boolean)((Boolean)obj));
                            break;
                        }
                        case 2: {
                            value = -1;
                            if (obj instanceof String) {
                                try {
                                    value = Integer.parseInt((String)obj);
                                }
                                catch (Exception ex) {
                                    if (idp.name().equalsIgnoreCase("TRANSACTION_ISOLATION_LEVEL")) {
                                        for (i = 0; i < idp.dpi.choices.length; ++i) {
                                            if (!idp.dpi.choices[i].equalsIgnoreCase((String)obj)) continue;
                                            value = i + 1;
                                        }
                                    }
                                    if (idp.name().equalsIgnoreCase("DIALECT")) {
                                        for (i = 0; i < idp.dpi.choices.length; ++i) {
                                            if (!idp.dpi.choices[i].equalsIgnoreCase((String)obj)) continue;
                                            value = i;
                                        }
                                    }
                                    if (idp.name().equalsIgnoreCase("FEATURE_OPTION")) {
                                        for (i = 0; i < idp.dpi.choices.length; ++i) {
                                            if (!idp.dpi.choices[i].equalsIgnoreCase((String)obj)) continue;
                                            value = i;
                                        }
                                    }
                                    if (idp.name().equalsIgnoreCase("NETWORKTIMEOUT")) {
                                        for (i = 0; i < idp.dpi.choices.length; ++i) {
                                            if (!idp.dpi.choices[i].equalsIgnoreCase((String)obj)) continue;
                                            value = i;
                                        }
                                    }
                                    if (!idp.name().equalsIgnoreCase("COMMITTIMEOUT")) ** GOTO lbl77
                                    for (i = 0; i < idp.dpi.choices.length; ++i) {
                                        if (!idp.dpi.choices[i].equalsIgnoreCase((String)obj)) continue;
                                        value = i;
                                    }
                                }
                            } else {
                                value = (Integer)obj;
                            }
lbl77:
                            // 13 sources

                            if (value == -1) {
                                throw new SQLException("Invalid Value for Property Key: '" + entry.getKey() + "' or Value: '" + entry.getValue() + "'");
                            }
                            if (idp.name().equalsIgnoreCase("CONNECTION_SECURITY_LEVEL")) {
                                this.setConnectionSecurityLevel(value);
                                break;
                            }
                            if (idp.name().equalsIgnoreCase("FEATURE_OPTION")) {
                                if (obj instanceof String) {
                                    this.setFeatureOption((String)obj);
                                    break;
                                }
                                this.setFeatureOption(value);
                                break;
                            }
                            if (idp.name().equalsIgnoreCase("DIALECT")) {
                                this.setSQLDialect(value);
                                break;
                            }
                            if (idp.name().equalsIgnoreCase("TRANSACTION_ISOLATION_LEVEL")) {
                                this.setTransactionIsolationLevel(value);
                                break;
                            }
                            idp.dpi.field.set(this, value);
                            break;
                        }
                        case 3: {
                            this.setLogFileNoThrow((String)obj);
                            break;
                        }
                        case 4: {
                            idp.dpi.field.set(this, (SSLContext)obj);
                            break;
                        }
                        default: {
                            idp.dpi.field.set(this, obj);
                            break;
                        }
                    }
                }
                catch (SQLException sqlex) {
                    throw sqlex;
                }
                catch (Exception e) {
                    throw new SQLException("Invalid Property Key: '" + entry.getKey() + "' or Value: '" + entry.getValue() + "'", e);
                }
            }
        }
    }

    void reconcileURLandProps() throws SQLException {
        if (this.securityLevel > 0 && this.securityLevel < 4 && this.principalName == null) {
            throw new SQLException("No Service Principal Name: Connection Security Level is: " + this.securityLevel);
        }
        if (this.isPooled() && this.accesstoken != null) {
            throw new SQLException("OAuth2 AccessToken cannot be used in a pooled connection!");
        }
        if (this.securityLevel != 0 || this.sslctx != null) {
            this.useSharedMemory = false;
        }
        if (this.useSharedMemory) {
            boolean isWindows = MachineInfo.getOSName().contains("WINDOWS");
            boolean isMac = MachineInfo.getOSName().contains("MAC OS X");
            boolean isLinux = MachineInfo.getOSName().contains("LINUX");
            boolean bl = this.useSharedMemory = this.useSharedMemory && this.securityLevel == 0 && (isWindows || isMac || isLinux);
        }
        if (this.host.startsWith("SHM|")) {
            this.host = this.useSharedMemory ? SharedMemorySocket.ValidateHostString(this.host) : "127.0.0.1";
        } else if (this.useSharedMemory) {
            if (this.host.equalsIgnoreCase("localhost") || this.host.contains("127.0.0.1")) {
                this.host = "SHM|||||" + (this.connectionTimeout == 0 ? 1 : this.connectionTimeout);
            } else {
                this.useSharedMemory = false;
            }
        }
    }

    public String getHash() {
        String base = this.host.toUpperCase() + ":" + Integer.toString(this.port) + "/" + this.namespace.toUpperCase() + "/:" + (this.eventClass != null ? this.eventClass : "") + ":" + Integer.toString(this.featureOption) + ":" + Integer.toString(this.securityLevel) + ":" + Integer.toString(this.networkTimeout) + "?";
        switch (this.securityLevel) {
            case 0: {
                return base + this.username + Integer.toString(this.password.hashCode());
            }
            case 1: 
            case 2: 
            case 3: {
                return base + this.principalName;
            }
            case 10: {
                return base + this.sSLConfigName;
            }
        }
        return base;
    }

    protected Object clone() throws CloneNotSupportedException {
        ConnectionParameters cp = (ConnectionParameters)super.clone();
        if (cp.logFile != null) {
            cp.logFile.ref();
        }
        cp.pooled = null;
        try {
            cp.reconcileURLandProps();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return cp;
    }

    public ConnectionParameters copy() throws CloneNotSupportedException {
        ConnectionParameters cp = (ConnectionParameters)super.clone();
        cp.pooled = null;
        return cp;
    }

    public int getFeatureOption() {
        return this.featureOption;
    }

    public void setFeatureOption(int feature) throws SQLException {
        if ((feature & 0xFFFFFFC0) != 0) {
            throw new SQLException("Invalid Feature Option request: " + feature);
        }
        this.featureOption = feature;
    }

    public void setFeatureOption(String sfeature) throws SQLException {
        int add = 0;
        int feature = Math.abs(Integer.parseInt(sfeature));
        if ((feature & 0xFFFFFFC0) != 0) {
            throw new SQLException("Invalid Feature Option request: " + feature);
        }
        if (sfeature.startsWith("+")) {
            add = 1;
        } else if (sfeature.startsWith("-")) {
            add = -1;
        }
        switch (add) {
            case 0: {
                this.featureOption = feature;
                break;
            }
            case 1: {
                this.featureOption |= feature;
                break;
            }
            case -1: {
                this.featureOption &= ~feature;
            }
        }
    }

    protected void setConnectionSecurityLevel(int level) throws SQLException {
        if (level >= 0 && level < 4 || level == 10) {
            this.securityLevel = level;
            return;
        }
        throw new SQLException("Invalid Connection Security Level request: " + level);
    }

    public int getSQLDialect() {
        return this.sqlDialect;
    }

    public void setSQLDialect(int dialect) throws SQLException {
        if (dialect >= 0 && dialect < 3) {
            this.sqlDialect = dialect;
            return;
        }
        throw new SQLException("Invalid SQLDialect request: " + dialect);
    }

    public int getTransactionIsolationLevel() {
        return this.isolationLevel;
    }

    public void setTransactionIsolationLevel(int level) throws SQLException {
        if (level > 0 && level < 3 || level == 32) {
            this.isolationLevel = level;
            return;
        }
        throw new SQLException("Invalid TransactionIsolationLevel request: " + level);
    }

    public void setServerName(String s) {
        this.setHost(s);
    }

    public void setPortNumber(int p) {
        this.port = p;
    }

    public void setDatabaseName(String d) {
        this.namespace = d;
    }

    public void setSharedMemory(boolean sharedMemory) {
        if (this.host.startsWith("SHM|") && !sharedMemory) {
            throw new IllegalStateException("Shared Memory cannot be false if hostname is " + this.host);
        }
        this.useSharedMemory = sharedMemory;
    }

    public boolean isPooled() {
        return this.addToPool || this.pooled != null;
    }

    public void addToPool(boolean addToPool) {
        this.addToPool = addToPool;
    }
}

