/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.ConnectionParameters;
import com.intersystems.jdbc.IRISConnectionPoolDataSource;
import com.intersystems.jdbc.IRISPool;
import com.intersystems.jdbc.IRISPooledConnection;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public final class ConnectionPoolManager
implements ConnectionEventListener {
    static ConcurrentHashMap<String, IRISPool> poolsHashMap = new ConcurrentHashMap();

    ConnectionPoolManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PooledConnection getConnection(ConnectionParameters cp) throws SQLException, InterruptedException {
        String dsHash = cp.getHash();
        IRISPool pool = null;
        IRISPooledConnection pc = null;
        ConcurrentHashMap<String, IRISPool> concurrentHashMap = poolsHashMap;
        synchronized (concurrentHashMap) {
            if (poolsHashMap.containsKey(dsHash)) {
                pool = poolsHashMap.get(dsHash);
                if (cp instanceof IRISConnectionPoolDataSource) {
                    pool.update((IRISConnectionPoolDataSource)cp);
                }
            } else {
                pool = new IRISPool(cp);
                poolsHashMap.put(dsHash, pool);
            }
        }
        try {
            pc = pool.getPooledConnection(cp);
        }
        catch (SQLException ex) {
            if (pool.IsEmpty()) {
                poolsHashMap.remove(dsHash);
            }
            throw ex;
        }
        if (pc == null) {
            return pc;
        }
        pc.dsHash = dsHash;
        pc.addConnectionEventListener(this);
        return pc;
    }

    public static IRISPool getPool(ConnectionParameters cp) {
        return poolsHashMap.get(cp.getHash());
    }

    public static void removeAllPools() {
        for (IRISPool pool : poolsHashMap.values()) {
            pool.removeIdleConnections();
            pool.removeInuseConnections();
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        IRISPooledConnection pc = (IRISPooledConnection)event.getSource();
        IRISPool pool = null;
        if (poolsHashMap.containsKey(pc.dsHash)) {
            pool = poolsHashMap.get(pc.dsHash);
            pool.releaseConnection(pc.device);
        } else {
            pc.device.close();
        }
        pc.device = null;
        pc.logicalConnection.device = null;
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        try {
            pc.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

