/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.IRISOREF;
import com.intersystems.jdbc.ListItem;
import com.intersystems.jdbc.SQLValidationException;
import com.intersystems.jdbc.TLSimpleDateFormat;
import com.intersystems.jdbc.ValidateNFormat;
import com.intersystems.util.ListUtil;
import com.intersystems.util.ParseUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;

public class DBList {
    public static final byte ITEM_UNDEF = -1;
    public static final byte ITEM_PLACEHOLDER = 0;
    public static final byte ITEM_ASCII = 1;
    public static final byte ITEM_UNICODE = 2;
    public static final byte ITEM_XUNICODE = 3;
    public static final byte ITEM_POSINT = 4;
    public static final byte ITEM_NEGINT = 5;
    public static final byte ITEM_POSNUM = 6;
    public static final byte ITEM_NEGNUM = 7;
    public static final byte ITEM_DOUBLE = 8;
    public static final byte ITEM_COMPACT_DOUBLE = 9;
    public static final byte ITEM_OREF_ASCII = 25;
    public static final byte ITEM_OREF_UNICODE = 26;
    public static final byte ITEM_OREF_ASCII_58 = -5;
    public static final byte ITEM_OREF_UNICODE_58 = -4;
    private static boolean EMPTY_STRING_IS_ZERO;
    private static boolean SLOPPY_PARSING;
    private static double[] scale;

    private static boolean getProperty(String property, boolean defaultValue) {
        String p = System.getProperty(property);
        if (p == null) {
            p = System.getenv(property);
        }
        if (p == null) {
            p = System.getenv(property.replace('.', '_'));
        }
        if (p == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(p);
    }

    public static boolean isOREF(byte type) {
        return type == 25 || type == 26 || type == -5 || type == -4;
    }

    public static int getListElement(int iOffsetLE, ListItem it) {
        if (iOffsetLE == -1) {
            it.nextOffset = 0;
            return 0;
        }
        byte[] buffer = it.buffer;
        switch (buffer[iOffsetLE]) {
            case 0: {
                int dataLength = buffer[iOffsetLE + 1] & 0xFF | (buffer[iOffsetLE + 2] & 0xFF) << 8;
                iOffsetLE += 3;
                if (dataLength == 0) {
                    dataLength = buffer[iOffsetLE] & 0xFF | (buffer[iOffsetLE + 1] & 0xFF) << 8 | (buffer[iOffsetLE + 2] & 0xFF) << 16 | (buffer[iOffsetLE + 3] & 0xFF) << 24;
                    iOffsetLE += 4;
                }
                --dataLength;
                it.type = buffer[iOffsetLE++];
                if (it.type >= 32 && it.type < 64) {
                    it.type = (byte)(it.type - 32);
                    it.byRef = true;
                }
                it.isNull = false;
                it.dataOffset = iOffsetLE;
                it.dataLength = dataLength;
                it.nextOffset = it.dataOffset + it.dataLength;
                return it.nextOffset;
            }
            case 1: {
                it.dataLength = 0;
                it.isNull = true;
                it.dataOffset = iOffsetLE++;
                it.type = (byte)-1;
                it.nextOffset = iOffsetLE;
                return it.nextOffset;
            }
        }
        int dataLength = (buffer[iOffsetLE++] & 0xFF) - 2;
        it.type = buffer[iOffsetLE++];
        if (it.type >= 32 && it.type < 64) {
            it.type = (byte)(it.type - 32);
            it.byRef = true;
        }
        it.isNull = it.type == 0 || 0 == dataLength && it.type == 1;
        it.dataLength = dataLength;
        it.dataOffset = iOffsetLE;
        it.nextOffset = it.dataLength + it.dataOffset;
        return it.nextOffset;
    }

    public static int Next(byte[] buffer, int iOffsetLE) {
        int dataLength = 0;
        byte type = 0;
        switch (buffer[iOffsetLE]) {
            case 0: {
                dataLength = buffer[iOffsetLE + 1] & 0xFF | (buffer[iOffsetLE + 2] & 0xFF) << 8;
                iOffsetLE += 3;
                if (dataLength == 0) {
                    dataLength = buffer[iOffsetLE] & 0xFF | (buffer[iOffsetLE + 1] & 0xFF) << 8 | (buffer[iOffsetLE + 2] & 0xFF) << 16 | (buffer[iOffsetLE + 3] & 0xFF) << 24;
                    iOffsetLE += 4;
                }
                if (dataLength == 0) {
                    return -1;
                }
                type = buffer[iOffsetLE++];
                --dataLength;
                break;
            }
            case 1: {
                type = buffer[iOffsetLE];
                ++iOffsetLE;
                break;
            }
            default: {
                dataLength = (buffer[iOffsetLE++] & 0xFF) - 2;
                type = buffer[iOffsetLE];
                ++iOffsetLE;
            }
        }
        if (dataLength > 0 && (type < 1 || type > 9)) {
            return -1;
        }
        if (iOffsetLE + dataLength > buffer.length) {
            return -1;
        }
        return iOffsetLE + dataLength;
    }

    protected static void getDataLengthAndOffset(byte[] buffer, int startingOffset, int[] dataLengthAndOffset) {
        switch (buffer[startingOffset]) {
            case 0: {
                int offset = startingOffset;
                int dataLength = buffer[offset + 1] & 0xFF | (buffer[offset + 2] & 0xFF) << 8;
                offset += 3;
                if (dataLength == 0) {
                    dataLength = buffer[offset] & 0xFF | (buffer[offset + 1] & 0xFF) << 8 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 3] & 0xFF) << 24;
                    offset += 4;
                }
                dataLengthAndOffset[0] = dataLength - 1;
                dataLengthAndOffset[1] = offset - startingOffset + 1;
                return;
            }
            case 1: {
                dataLengthAndOffset[0] = 0;
                dataLengthAndOffset[1] = 0;
                return;
            }
        }
        dataLengthAndOffset[0] = (buffer[startingOffset] & 0xFF) - 2;
        dataLengthAndOffset[1] = 2;
    }

    public static int count(byte[] buffer, int length) throws SQLException {
        int i = 0;
        int offset = 0;
        while (offset < length) {
            if ((offset = DBList.Next(buffer, offset)) < 0) {
                return -1;
            }
            ++i;
        }
        if (offset != length) {
            return -1;
        }
        return i;
    }

    public static String getString(ListItem it, String locale) throws SQLException {
        if (it.isNull) {
            return null;
        }
        switch (it.type) {
            case -5: 
            case 1: 
            case 25: {
                if (it.dataLength == 1 && it.buffer[it.dataOffset] == 0) {
                    return "";
                }
                try {
                    if (locale == null) {
                        return DBList.grabLatin1String(it.buffer, it.dataOffset, it.dataLength);
                    }
                    return new String(it.buffer, it.dataOffset, it.dataLength, locale);
                }
                catch (UnsupportedEncodingException e) {
                    throw new SQLException("Cannot convert using server locale: unsupported Encoding:" + locale, "S2208");
                }
            }
            case -4: 
            case 2: 
            case 26: {
                return DBList.grabUnicodeString(it.buffer, it.dataOffset, it.dataLength);
            }
            case 4: {
                return Long.toString(DBList.grabPosLong(it.buffer, it.dataOffset, it.dataLength));
            }
            case 5: {
                return Long.toString(DBList.grabNegLong(it.buffer, it.dataOffset, it.dataLength));
            }
            case 6: {
                return DBList.grabBigDecimal(it.buffer, it.dataOffset + 1, it.dataLength - 1, it.buffer[it.dataOffset], false).toPlainString();
            }
            case 7: {
                return DBList.grabBigDecimal(it.buffer, it.dataOffset + 1, it.dataLength - 1, it.buffer[it.dataOffset], true).toPlainString();
            }
            case 8: {
                if (it.dataLength == 8) {
                    return Double.toString(DBList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength));
                }
                return Float.toString(DBList.grabCompactIEEEFloat(it.buffer, it.dataOffset, it.dataLength));
            }
            case 9: {
                return Double.toString(DBList.grabCompactIEEEDouble(it.buffer, it.dataOffset, it.dataLength));
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1003");
    }

    public static String getString(ListItem it, String locale, int length) throws SQLException {
        if (it.isNull) {
            return null;
        }
        if (it.dataLength < length) {
            length = it.dataLength;
        }
        switch (it.type) {
            case -5: 
            case 1: 
            case 25: {
                if (it.dataLength == 1 && it.buffer[it.dataOffset] == 0) {
                    return "";
                }
                try {
                    if (locale == null) {
                        return DBList.grabLatin1String(it.buffer, it.dataOffset, length);
                    }
                    return new String(it.buffer, it.dataOffset, length, locale);
                }
                catch (UnsupportedEncodingException e) {
                    throw new SQLException("Cannot convert using server locale: unsupported Encoding:" + locale, "S2208");
                }
            }
            case -4: 
            case 2: 
            case 26: {
                return DBList.grabUnicodeString(it.buffer, it.dataOffset, length);
            }
            case 4: {
                return Long.toString(DBList.grabPosLong(it.buffer, it.dataOffset, it.dataLength));
            }
            case 5: {
                return Long.toString(DBList.grabNegLong(it.buffer, it.dataOffset, it.dataLength));
            }
            case 6: {
                return DBList.grabBigDecimal(it.buffer, it.dataOffset + 1, it.dataLength - 1, it.buffer[it.dataOffset], false).toPlainString();
            }
            case 7: {
                return DBList.grabBigDecimal(it.buffer, it.dataOffset + 1, it.dataLength - 1, it.buffer[it.dataOffset], true).toPlainString();
            }
            case 8: {
                if (it.dataLength == 8) {
                    return Double.toString(DBList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength));
                }
                return Float.toString(DBList.grabCompactIEEEFloat(it.buffer, it.dataOffset, it.dataLength));
            }
            case 9: {
                return Double.toString(DBList.grabCompactIEEEDouble(it.buffer, it.dataOffset, it.dataLength));
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1003");
    }

    public static Object getObject(ListItem it, String locale, boolean acceptOREF) throws SQLException {
        if (it.isNull) {
            return null;
        }
        switch (it.type) {
            case 1: {
                if (it.dataLength == 1 && it.buffer[it.dataOffset] == 0) {
                    return "";
                }
                try {
                    if (locale == null) {
                        return DBList.grabLatin1String(it.buffer, it.dataOffset, it.dataLength);
                    }
                    return new String(it.buffer, it.dataOffset, it.dataLength, locale);
                }
                catch (UnsupportedEncodingException e) {
                    throw new SQLException("Cannot convert using server locale: unsupported Encoding:" + locale, "S2208");
                }
            }
            case 2: {
                return DBList.grabUnicodeString(it.buffer, it.dataOffset, it.dataLength);
            }
            case 4: {
                return DBList.grabPosLong(it.buffer, it.dataOffset, it.dataLength);
            }
            case 5: {
                return DBList.grabNegLong(it.buffer, it.dataOffset, it.dataLength);
            }
            case 6: {
                return DBList.getBigDecimal(it);
            }
            case 7: {
                return DBList.getBigDecimal(it);
            }
            case 8: {
                if (it.dataLength == 8) {
                    return DBList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
                }
                return Float.valueOf(DBList.grabCompactIEEEFloat(it.buffer, it.dataOffset, it.dataLength));
            }
            case 9: {
                return DBList.grabCompactIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
            }
            case -5: 
            case -4: 
            case 25: 
            case 26: {
                if (acceptOREF) {
                    return new IRISOREF(DBList.getString(it, locale));
                }
                throw new SQLException("Incorrect list format, unsupported OREF type", "S1003");
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1003");
    }

    public static Object getObjectWithAsciiZero(ListItem it, String locale, boolean acceptOREF) throws SQLException {
        if (it.isNull) {
            return null;
        }
        if (it.type == 1 && it.dataLength == 1 && it.buffer[it.dataOffset] == 0) {
            return "\u0000";
        }
        return DBList.getObject(it, locale, acceptOREF);
    }

    public static double getDouble(ListItem it) throws SQLException {
        if (it.isNull) {
            return 0.0;
        }
        switch (it.type) {
            case 8: {
                if (it.dataLength == 8) {
                    return DBList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
                }
                return DBList.grabCompactIEEEFloat(it.buffer, it.dataOffset, it.dataLength);
            }
            case 9: {
                return DBList.grabCompactIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
            }
            case 4: {
                return DBList.grabPosLong(it.buffer, it.dataOffset, it.dataLength);
            }
            case 5: {
                return DBList.grabNegLong(it.buffer, it.dataOffset, it.dataLength);
            }
            case 6: {
                return ListUtil.dbl2dbl(it.buffer[it.dataOffset], DBList.grabPosLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 7: {
                return ListUtil.dbl2dbl(it.buffer[it.dataOffset], DBList.grabNegLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case -5: 
            case 1: 
            case 25: {
                return DBList.parseNumber(Double.class, it.buffer, it.dataOffset, it.dataLength);
            }
            case -4: 
            case 2: 
            case 26: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1000");
    }

    public static float getFloat(ListItem it) throws SQLException {
        if (it.isNull) {
            return 0.0f;
        }
        switch (it.type) {
            case 6: {
                return DBList.grabPosFloat(it.buffer, it.dataOffset, it.dataLength);
            }
            case 7: {
                return DBList.grabNegFloat(it.buffer, it.dataOffset, it.dataLength);
            }
            case 8: {
                if (it.dataLength == 8) {
                    return (float)DBList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
                }
                return DBList.grabCompactIEEEFloat(it.buffer, it.dataOffset, it.dataLength);
            }
            case 9: {
                return (float)DBList.grabCompactIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
            }
            case 4: {
                return DBList.grabPosLong(it.buffer, it.dataOffset, it.dataLength);
            }
            case 5: {
                return DBList.grabNegLong(it.buffer, it.dataOffset, it.dataLength);
            }
            case -5: 
            case 1: 
            case 25: {
                return DBList.parseNumber(Float.class, it.buffer, it.dataOffset, it.dataLength).floatValue();
            }
            case -4: 
            case 2: 
            case 26: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1000");
    }

    public static int getInt(ListItem it) throws SQLException {
        if (it.isNull) {
            return 0;
        }
        switch (it.type) {
            case 4: {
                return DBList.grabPosInt(it.buffer, it.dataOffset, it.dataLength);
            }
            case 5: {
                return DBList.grabNegInt(it.buffer, it.dataOffset, it.dataLength);
            }
            case 6: {
                return ListUtil.dblint(it.buffer[it.dataOffset], DBList.grabPosLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 7: {
                return ListUtil.dblint(it.buffer[it.dataOffset], DBList.grabNegLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 8: {
                if (it.dataLength == 8) {
                    return (int)DBList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
                }
                return (int)DBList.grabCompactIEEEFloat(it.buffer, it.dataOffset, it.dataLength);
            }
            case 9: {
                return (int)DBList.grabCompactIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
            }
            case -5: 
            case 1: 
            case 25: {
                long[] num = new long[1];
                int scale = DBList.parsenumbIfValid(it.buffer, it.dataOffset, it.dataLength, num);
                return ListUtil.dblint(scale, num[0]);
            }
            case -4: 
            case 2: 
            case 26: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1000");
    }

    public static short getShort(ListItem it) throws SQLException {
        if (it.isNull) {
            return 0;
        }
        switch (it.type) {
            case 4: {
                return DBList.grabPosShort(it.buffer, it.dataOffset, it.dataLength);
            }
            case 5: {
                return DBList.grabNegShort(it.buffer, it.dataOffset, it.dataLength);
            }
            case 6: {
                return ListUtil.dblshort(it.buffer[it.dataOffset], DBList.grabPosLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 7: {
                return ListUtil.dblshort(it.buffer[it.dataOffset], DBList.grabNegLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 8: {
                if (it.dataLength == 8) {
                    return (short)DBList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
                }
                return (short)DBList.grabCompactIEEEFloat(it.buffer, it.dataOffset, it.dataLength);
            }
            case 9: {
                return (short)DBList.grabCompactIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
            }
            case -5: 
            case 1: 
            case 25: {
                long[] num = new long[1];
                int scale = DBList.parsenumbIfValid(it.buffer, it.dataOffset, it.dataLength, num);
                return ListUtil.dblshort(scale, num[0]);
            }
            case -4: 
            case 2: 
            case 26: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1000");
    }

    public static long getLong(ListItem it) throws SQLException {
        if (it.isNull) {
            return 0L;
        }
        switch (it.type) {
            case 4: {
                return DBList.grabPosLong(it.buffer, it.dataOffset, it.dataLength);
            }
            case 5: {
                return DBList.grabNegLong(it.buffer, it.dataOffset, it.dataLength);
            }
            case 6: {
                return ListUtil.dbllong(it.buffer[it.dataOffset], DBList.grabPosLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 7: {
                return ListUtil.dbllong(it.buffer[it.dataOffset], DBList.grabNegLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 8: {
                if (it.dataLength == 8) {
                    return (long)DBList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
                }
                return (long)DBList.grabCompactIEEEFloat(it.buffer, it.dataOffset, it.dataLength);
            }
            case 9: {
                return (long)DBList.grabCompactIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
            }
            case -5: 
            case 1: 
            case 25: {
                long[] num = new long[1];
                int scale = DBList.parsenumbIfValid(it.buffer, it.dataOffset, it.dataLength, num);
                return ListUtil.dbllong(scale, num[0]);
            }
            case -4: 
            case 2: 
            case 26: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1000");
    }

    public static BigDecimal getBigDecimal(ListItem it) throws SQLException {
        if (it.isNull) {
            return null;
        }
        switch (it.type) {
            case 6: {
                return DBList.grabBigDecimal(it.buffer, it.dataOffset + 1, it.dataLength - 1, it.buffer[it.dataOffset], false);
            }
            case 7: {
                return DBList.grabBigDecimal(it.buffer, it.dataOffset + 1, it.dataLength - 1, it.buffer[it.dataOffset], true);
            }
            case 8: {
                if (it.dataLength == 8) {
                    return new BigDecimal(DBList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength));
                }
                return new BigDecimal(DBList.grabCompactIEEEFloat(it.buffer, it.dataOffset, it.dataLength));
            }
            case 9: {
                return new BigDecimal(DBList.grabCompactIEEEDouble(it.buffer, it.dataOffset, it.dataLength));
            }
            case 4: {
                return DBList.grabBigDecimal(it.buffer, it.dataOffset, it.dataLength, 0, false);
            }
            case 5: {
                return DBList.grabBigDecimal(it.buffer, it.dataOffset, it.dataLength, 0, true);
            }
            case -5: 
            case 1: 
            case 25: {
                return ListUtil.parsedecb(it.buffer, it.dataOffset, it.dataLength);
            }
            case -4: 
            case 2: 
            case 26: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1000");
    }

    public static BigDecimal getBigDecimal(ListItem it, int scale) throws SQLException {
        if (it.isNull) {
            return null;
        }
        BigDecimal bd = null;
        switch (it.type) {
            case 6: {
                bd = DBList.grabBigDecimal(it.buffer, it.dataOffset + 1, it.dataLength - 1, it.buffer[it.dataOffset], false);
                break;
            }
            case 7: {
                bd = DBList.grabBigDecimal(it.buffer, it.dataOffset + 1, it.dataLength - 1, it.buffer[it.dataOffset], true);
                break;
            }
            case 8: {
                if (it.dataLength == 8) {
                    bd = new BigDecimal(DBList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength));
                    break;
                }
                bd = new BigDecimal(DBList.grabCompactIEEEFloat(it.buffer, it.dataOffset, it.dataLength));
                break;
            }
            case 9: {
                bd = new BigDecimal(DBList.grabCompactIEEEDouble(it.buffer, it.dataOffset, it.dataLength));
                break;
            }
            case 4: {
                bd = DBList.grabBigDecimal(it.buffer, it.dataOffset, it.dataLength, 0, false);
                break;
            }
            case 5: {
                bd = DBList.grabBigDecimal(it.buffer, it.dataOffset, it.dataLength, 0, true);
                break;
            }
            case -5: 
            case 1: 
            case 25: {
                bd = ListUtil.parsedecb(it.buffer, it.dataOffset, it.dataLength);
                break;
            }
            case -4: 
            case 2: 
            case 26: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        if (bd != null) {
            return bd.setScale(scale, RoundingMode.HALF_UP);
        }
        return bd;
    }

    public static BigInteger getBigInteger(ListItem it) throws SQLException {
        if (it.isNull) {
            return null;
        }
        switch (it.type) {
            case 4: {
                return DBList.grabBigInteger(it.buffer, it.dataOffset, it.dataLength, false);
            }
            case 5: {
                return DBList.grabBigInteger(it.buffer, it.dataOffset, it.dataLength, true);
            }
            case 6: 
            case 7: {
                BigDecimal bd = DBList.getBigDecimal(it);
                return bd.toBigInteger();
            }
        }
        throw new SQLException("Element cannot be read as BigInteger", "S1000");
    }

    public static boolean getBoolean(ListItem it) throws SQLException {
        if (it.isNull) {
            return false;
        }
        switch (it.type) {
            case 4: {
                if (it.dataLength == 0) {
                    return false;
                }
            }
            case 5: 
            case 7: {
                return true;
            }
            case 6: {
                return DBList.grabPosLong(it.buffer, it.dataOffset, it.dataLength) != 0L;
            }
            case 8: 
            case 9: {
                throw new SQLException("Invalid boolean: item = IEEE DOUBLE", "22008", 22008);
            }
            case -5: 
            case 1: 
            case 25: {
                long[] num = new long[1];
                ListUtil.parsenumb(it.buffer, it.dataOffset, it.dataLength, num);
                return num[0] != 0L;
            }
            case -4: 
            case 2: 
            case 26: {
                throw new SQLException("Invalid boolean: item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1000");
    }

    public static byte getOneByte(ListItem it) throws SQLException {
        if (it.isNull) {
            return 0;
        }
        switch (it.type) {
            case -5: 
            case 1: 
            case 25: {
                long[] num = new long[1];
                ListUtil.parsenumb(it.buffer, it.dataOffset, it.dataLength, num);
                return ListUtil.dblbyte(0, num[0]);
            }
            case 4: {
                return ListUtil.dblbyte(0, DBList.grabPosLong(it.buffer, it.dataOffset, it.dataLength));
            }
            case 5: {
                return ListUtil.dblbyte(0, DBList.grabNegLong(it.buffer, it.dataOffset, it.dataLength));
            }
            case 6: {
                return ListUtil.dblbyte(it.buffer[it.dataOffset], DBList.grabPosLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 7: {
                return ListUtil.dblbyte(it.buffer[it.dataOffset], DBList.grabNegLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 8: {
                if (it.dataLength == 8) {
                    return (byte)DBList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
                }
                return (byte)DBList.grabCompactIEEEFloat(it.buffer, it.dataOffset, it.dataLength);
            }
            case 9: {
                return (byte)DBList.grabCompactIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
            }
            case -4: 
            case 2: 
            case 26: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1000");
    }

    public static byte[] getByteArray(ListItem it) {
        if (it.isNull) {
            return null;
        }
        if (it.dataLength < 0) {
            return null;
        }
        byte[] NewArray = new byte[it.dataLength];
        System.arraycopy(it.buffer, it.dataOffset, NewArray, 0, it.dataLength);
        return NewArray;
    }

    public static byte getByte(ListItem it) {
        if (it.isNull) {
            return 0;
        }
        if (0 == it.dataLength) {
            return 0;
        }
        return it.buffer[it.dataOffset];
    }

    public static byte[] getBytes(ListItem it, int len) throws SQLException {
        byte[] b;
        if (it.isNull) {
            return null;
        }
        if (len == 0 || it.dataLength < len) {
            len = it.dataLength;
        }
        switch (it.type) {
            case -5: 
            case 1: 
            case 25: {
                b = new byte[it.dataLength];
                System.arraycopy(it.buffer, it.dataOffset, b, 0, it.dataLength);
                break;
            }
            case -4: 
            case 2: 
            case 26: {
                return ListUtil.getUTF8Bytes(it.buffer, it.dataOffset, it.dataLength, len);
            }
            case 4: {
                return Long.toString(DBList.grabPosLong(it.buffer, it.dataOffset, it.dataLength)).getBytes();
            }
            case 5: {
                return Long.toString(DBList.grabNegLong(it.buffer, it.dataOffset, it.dataLength)).getBytes();
            }
            default: {
                throw new SQLException("Element cannot be read as byte[]", "S1000");
            }
        }
        return b;
    }

    public static Date getDate(ListItem it, Calendar cal) throws SQLException {
        if (it.isNull) {
            return null;
        }
        switch (it.type) {
            case 4: 
            case 5: {
                if (it.dataLength > 3) {
                    long time = DBList.getLong(it);
                    if (time >= 0x1000000000000000L || time < -1152921504606846976L) {
                        return ValidateNFormat.DateFromPosix(time, cal);
                    }
                } else {
                    int time = DBList.getInt(it);
                    return ValidateNFormat.DateFromHorolog(time, null);
                }
            }
            case 6: 
            case 7: {
                int time = DBList.getInt(it);
                return ValidateNFormat.DateFromHorolog(time, null);
            }
            case 1: {
                String s = DBList.getString(it, null).trim();
                try {
                    Long time;
                    if (s.length() <= 7 || s.indexOf(",") > 0) {
                        int time2 = DBList.getInt(it);
                        return ValidateNFormat.DateFromHorolog(time2, cal);
                    }
                    if ('-' != s.charAt(4) && ((time = Long.valueOf(Long.parseLong(s))) >= 0x1000000000000000L || time < -1152921504606846976L)) {
                        return ValidateNFormat.DateFromPosix(time, cal);
                    }
                    if (s.length() < 10) {
                        throw new SQLException("Invalid Date", "22008", 22008);
                    }
                    if (cal == null && s.length() >= 10) {
                        return Date.valueOf(s.substring(0, 10));
                    }
                    int[] dt = new int[3];
                    int[] tm = new int[4];
                    ListUtil.readTimestampb(it.buffer, it.dataOffset, it.dataLength, dt, tm);
                    Calendar mycal = (Calendar)cal.clone();
                    mycal.set(dt[0], dt[1] - 1 + 0, dt[2], tm[0], tm[1], tm[2]);
                    Timestamp myts = new Timestamp(mycal.getTime().getTime());
                    myts.setNanos(tm[3]);
                    if (myts.getTime() < -62135596800000L) {
                        long lt = ValidateNFormat.EpochFromString(s) / 1000L;
                        Instant inst = Instant.ofEpochSecond(lt, 0L);
                        TLSimpleDateFormat dateFormat = new TLSimpleDateFormat("yyyy-MM-dd");
                        try {
                            java.util.Date ddt = dateFormat.parse(inst.toString());
                            return new Date(ddt.getTime());
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex.getMessage());
                        }
                    }
                    return new Date(myts.getTime());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        throw new SQLException("Invalid Date", "22008", 22008);
    }

    public static Time getTime(ListItem it, Calendar cal) throws SQLException {
        if (it.isNull) {
            return null;
        }
        try {
            switch (it.type) {
                case 6: {
                    return ValidateNFormat.TimeFromHorolog(DBList.getBigDecimal(it), cal);
                }
                case 4: 
                case 5: {
                    if (it.dataLength > 3) {
                        return ValidateNFormat.TimeFromPosix(DBList.getLong(it), cal);
                    }
                    return ValidateNFormat.TimeFromHorolog(DBList.getInt(it), cal);
                }
                case 1: {
                    Long time;
                    String s = DBList.getString(it, null).trim();
                    if (s.length() >= 19 && '-' != s.charAt(4) && ((time = Long.valueOf(Long.parseLong(s))) >= 0x1000000000000000L || time < -1152921504606846976L)) {
                        return ValidateNFormat.TimeFromPosix(time, cal);
                    }
                    return ValidateNFormat.parseTimeStringToTime(s, cal);
                }
            }
            throw new SQLException("Invalid Time", "22008", 22008);
        }
        catch (Exception e) {
            throw new SQLException("Invalid Time", "22008", 22008);
        }
    }

    public static Timestamp getTimestamp(ListItem it, Calendar cal) throws SQLException {
        if (it.isNull) {
            return null;
        }
        switch (it.type) {
            case 4: 
            case 5: {
                long time = DBList.getLong(it);
                if (time >= 0x1000000000000000L || time < -1152921504606846976L) {
                    return ValidateNFormat.TimestampFromPosix(time, cal);
                }
            }
            case 1: {
                String s = DBList.getString(it, null).trim();
                try {
                    Long time;
                    if (s.length() >= 19 && '-' != s.charAt(4) && ((time = Long.valueOf(Long.parseLong(s))) >= 0x1000000000000000L || time < -1152921504606846976L)) {
                        return ValidateNFormat.TimestampFromPosix(time, null);
                    }
                    if (cal == null) {
                        if (s.length() <= 10) {
                            if (s.length() == 10) {
                                s = s.concat(" 00:00:00.0");
                            } else {
                                throw new SQLException("Invalid Timestamp", "22008", 22008);
                            }
                        }
                        return Timestamp.valueOf(s);
                    }
                    int[] dt = new int[3];
                    int[] tm = new int[4];
                    if (it.dataLength >= 19) {
                        ListUtil.readTimestampb(it.buffer, it.dataOffset, it.dataLength, dt, tm);
                        Calendar mycal = (Calendar)cal.clone();
                        mycal.set(dt[0], dt[1] - 1 + 0, dt[2], tm[0], tm[1], tm[2]);
                        Timestamp myts = new Timestamp(mycal.getTime().getTime());
                        myts.setNanos(tm[3]);
                        return myts;
                    }
                    if (it.dataLength >= 10) {
                        ListUtil.readDateb(it.buffer, it.dataOffset, it.dataLength, dt);
                        Calendar mycal = (Calendar)cal.clone();
                        mycal.set(dt[0], dt[1] - 1 + 0, dt[2], 0, 0, 0);
                        Timestamp myts = new Timestamp(mycal.getTime().getTime());
                        myts.setNanos(0);
                        return myts;
                    }
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        throw new SQLException("Invalid Timestamp", "22008", 22008);
    }

    private static BigDecimal grabBigDecimal(byte[] buffer, int offset, int len, int scale, boolean sign) {
        return new BigDecimal(DBList.grabBigInteger(buffer, offset, len, sign), -scale);
    }

    private static BigInteger grabBigInteger(byte[] buffer, int offset, int length, boolean sign) {
        byte[] b;
        if (length == 0 || sign ^ buffer[offset + length - 1] < 0) {
            b = new byte[length + 1];
            b[0] = sign ? -1 : 0;
            for (int i = length; i > 0; --i) {
                b[i] = buffer[offset++];
            }
        } else {
            b = new byte[length];
            for (int i = length - 1; i >= 0; --i) {
                b[i] = buffer[offset++];
            }
        }
        return new BigInteger(b);
    }

    private static double grabIEEEDouble(byte[] buffer, int pos, int len) throws SQLException {
        if (8 != len) {
            throw new SQLException("Numeric value out of range", "22003", 22003);
        }
        ByteBuffer ba = ByteBuffer.wrap(buffer);
        ba.order(ByteOrder.LITTLE_ENDIAN);
        return ba.getDouble(pos);
    }

    private static double grabCompactIEEEDouble(byte[] buffer, int pos, int len) throws SQLException {
        if (len == 0) {
            return 0.0;
        }
        if (len == 8) {
            ByteBuffer ba = ByteBuffer.wrap(buffer);
            ba.order(ByteOrder.LITTLE_ENDIAN);
            return ba.getDouble(pos);
        }
        long raw = 0L;
        int p = pos + len;
        switch (len) {
            case 7: {
                raw |= (long)(buffer[--p] & 0xFF) << 48;
            }
            case 6: {
                raw |= (long)(buffer[--p] & 0xFF) << 40;
            }
            case 5: {
                raw |= (long)(buffer[--p] & 0xFF) << 32;
            }
            case 4: {
                raw |= (long)(buffer[--p] & 0xFF) << 24;
            }
            case 3: {
                raw |= (long)(buffer[--p] & 0xFF) << 16;
            }
            case 2: {
                raw |= (long)(buffer[--p] & 0xFF) << 8;
            }
            case 1: {
                raw |= (long)(buffer[--p] & 0xFF);
                break;
            }
            default: {
                throw new SQLException("Numeric value out of range", "22003", 22003);
            }
        }
        return Double.longBitsToDouble(raw <<= (8 - len) * 8);
    }

    private static float grabCompactIEEEFloat(byte[] buffer, int pos, int len) throws SQLException {
        if (len == 0) {
            return 0.0f;
        }
        if (len == 4) {
            ByteBuffer ba = ByteBuffer.wrap(buffer);
            ba.order(ByteOrder.LITTLE_ENDIAN);
            return ba.getFloat(pos);
        }
        int raw = 0;
        int p = pos + len;
        switch (len) {
            case 3: {
                raw |= (buffer[--p] & 0xFF) << 16;
            }
            case 2: {
                raw |= (buffer[--p] & 0xFF) << 8;
            }
            case 1: {
                raw |= buffer[--p] & 0xFF;
                break;
            }
            default: {
                throw new SQLException("Numeric value out of range", "22003", 22003);
            }
        }
        return Float.intBitsToFloat(raw <<= (4 - len) * 8);
    }

    public static String grabLatin1String(byte[] buffer, int offset, int length) throws UnsupportedEncodingException {
        char[] chArray = new char[length];
        for (int i = 0; i < length; ++i) {
            chArray[i] = (char)(buffer[offset++] & 0xFF);
        }
        return new String(chArray);
    }

    public static String grabNumericString(byte[] buffer, int offset, int length) throws UnsupportedEncodingException {
        String str = DBList.grabLatin1String(buffer, offset, length);
        int lastChar = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9' || '.' == c) {
                ++lastChar;
                continue;
            }
            if (0 != i || '-' != c) break;
            ++lastChar;
        }
        return str.substring(0, lastChar);
    }

    private static float grabNegFloat(byte[] buffer, int pos, int len) throws SQLException {
        double d = scale[buffer[pos++] & 0xFF];
        return (float)((double)DBList.grabNegLong(buffer, pos, len - 1) * d);
    }

    private static int grabNegInt(byte[] buffer, int offset, int length) throws SQLException {
        switch (length) {
            case 0: {
                return -1;
            }
            case 1: {
                return buffer[offset] & 0xFF | 0xFFFFFF00;
            }
            case 2: {
                return (buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF | 0xFFFF0000;
            }
            case 3: {
                return (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF | 0xFF000000;
            }
            case 4: {
                return (buffer[offset + 3] & 0xFF) << 24 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF;
            }
        }
        throw new SQLException("Numeric value out of range", "22003", 22003);
    }

    private static long grabNegLong(byte[] buffer, int offset, int length) throws SQLException {
        switch (length) {
            case 0: {
                return -1L;
            }
            case 4: {
                if (buffer[offset + length - 1] >= 0) {
                    length = -1;
                    break;
                }
            }
            case 1: 
            case 2: 
            case 3: {
                return DBList.grabNegInt(buffer, offset, length);
            }
            case 8: {
                length = buffer[offset + 7] << 24 | (buffer[offset + 6] & 0xFF) << 16 | (buffer[offset + 5] & 0xFF) << 8 | buffer[offset + 4] & 0xFF;
                if (length < 0) break;
                throw new SQLException("Numeric value out of range", "22003", 22003);
            }
            case 7: {
                length = 0xFF000000 | (buffer[offset + 6] & 0xFF) << 16 | (buffer[offset + 5] & 0xFF) << 8 | buffer[offset + 4] & 0xFF;
                break;
            }
            case 6: {
                length = 0xFFFF0000 | (buffer[offset + 5] & 0xFF) << 8 | buffer[offset + 4] & 0xFF;
                break;
            }
            case 5: {
                length = 0xFFFFFF00 | buffer[offset + 4] & 0xFF;
                break;
            }
            default: {
                throw new SQLException("Numeric value out of range", "22003", 22003);
            }
        }
        offset = (buffer[offset + 3] & 0xFF) << 24 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF;
        return (long)length << 32 | (long)offset & 0xFFFFFFFFL;
    }

    private static short grabNegShort(byte[] buffer, int offset, int length) throws SQLException {
        switch (length) {
            case 0: {
                return -1;
            }
            case 1: {
                return (short)(buffer[offset] & 0xFF | 0xFF00);
            }
            case 2: {
                return (short)((buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF);
            }
        }
        throw new SQLException("Numeric value out of range", "22003", 22003);
    }

    private static float grabPosFloat(byte[] buffer, int pos, int len) throws SQLException {
        double d = scale[buffer[pos++] & 0xFF];
        return (float)((double)DBList.grabPosLong(buffer, pos, len - 1) * d);
    }

    private static int grabPosInt(byte[] buffer, int offset, int length) throws SQLException {
        switch (length) {
            case 0: {
                return 0;
            }
            case 1: {
                return buffer[offset] & 0xFF;
            }
            case 2: {
                return (buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF;
            }
            case 3: {
                return (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF;
            }
            case 4: {
                return ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).getInt(offset);
            }
        }
        throw new SQLException("Numeric value out of range", "22003", 22003);
    }

    private static long grabPosLong(byte[] buffer, int offset, int length) throws SQLException {
        long num = 0L;
        switch (length) {
            case 0: {
                return 0L;
            }
            case 1: {
                return buffer[offset] & 0xFF;
            }
            case 7: {
                num |= ((long)buffer[offset + 6] & 0xFFL) << 48;
            }
            case 6: {
                num |= ((long)buffer[offset + 5] & 0xFFL) << 40;
            }
            case 5: {
                num |= ((long)buffer[offset + 4] & 0xFFL) << 32;
            }
            case 4: {
                num |= ((long)buffer[offset + 3] & 0xFFL) << 24;
            }
            case 3: {
                num |= (long)((buffer[offset + 2] & 0xFF) << 16);
            }
            case 2: {
                return num |= (long)((buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF);
            }
            case 8: {
                return ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).getLong(offset);
            }
        }
        throw new SQLException("Numeric value out of range", "22003", 22003);
    }

    private static short grabPosShort(byte[] buffer, int offset, int length) throws SQLException {
        switch (length) {
            case 2: {
                return (short)((buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF);
            }
            case 1: {
                return (short)(buffer[offset] & 0xFF);
            }
            case 0: {
                return 0;
            }
        }
        throw new SQLException("Numeric value out of range", "22003", 22003);
    }

    private static String grabString(byte[] buffer, int offset, int length, String locale) throws UnsupportedEncodingException {
        return new String(buffer, offset, length, locale);
    }

    private static String grabUnicodeString(byte[] buffer, int offset, int length) {
        char[] chArray = new char[length >>>= 1];
        for (int i = 0; i < length; ++i) {
            byte b2;
            int ch = buffer[offset++] & 0xFF;
            chArray[i] = (char)((b2 = buffer[offset++]) == 0 ? ch : ch | b2 << 8);
        }
        return new String(chArray);
    }

    public static int setString(byte[] buffer, int offset, String s, String locale, boolean bUnicode) {
        if (null == s) {
            return DBList.stuffNull(buffer, offset);
        }
        if (s.length() == 0) {
            return DBList.stuffEmptyString(buffer, offset);
        }
        int saveOffset = offset;
        if (-1 == (offset = DBList.stuff8BitAscii(buffer, offset, s, s.length()))) {
            offset = bUnicode ? DBList.stuffUNICODE(buffer, saveOffset, s, s.length()) : DBList.stuffMultibyte(buffer, saveOffset, s, locale);
        }
        return offset;
    }

    public static int setString(byte[] buffer, int offset, String s, int length, String locale, boolean bUnicodeServer) {
        if (null == s) {
            return DBList.stuffNull(buffer, offset);
        }
        if (length == 0) {
            return DBList.stuffEmptyString(buffer, offset);
        }
        int saveOffset = offset;
        if (-1 == (offset = DBList.stuff8BitAscii(buffer, offset, s, length))) {
            offset = bUnicodeServer ? DBList.stuffUNICODE(buffer, saveOffset, s, length) : DBList.stuffMultibyte(buffer, saveOffset, s, locale);
        }
        return offset;
    }

    public static int setOref(byte[] buffer, int offset, String s, String locale, boolean isUnicodeServer) {
        int length = s.length();
        int saveOffset = offset;
        if (-1 == (offset = DBList.stuffOREF8BitAscii(buffer, offset, s, length))) {
            offset = isUnicodeServer ? DBList.stuffOREFUNICODE(buffer, saveOffset, s, length) : DBList.stuffOREFMultibyte(buffer, saveOffset, s, locale);
        }
        return offset;
    }

    public static int setByteArray(byte[] buffer, int offset, byte[] source) {
        return DBList.setByteArray(buffer, offset, source, source.length);
    }

    public static int setByteArray(byte[] buffer, int offset, byte[] source, int length) {
        offset = DBList.addListLengthAndType(buffer, offset, length, (byte)1);
        System.arraycopy(source, 0, buffer, offset, length);
        return offset + length;
    }

    static int setByteArray(byte[] buffer, int offset, byte[] source, int sourceOffset, int length) {
        offset = DBList.addListLengthAndType(buffer, offset, length, (byte)1);
        System.arraycopy(source, sourceOffset, buffer, offset, length);
        return offset + length;
    }

    static int appendByteArray(byte[] buffer, int offset, byte[] source, int sourceOffset, int length) {
        System.arraycopy(source, sourceOffset, buffer, offset, length);
        return offset + length;
    }

    @Deprecated
    public static int setDouble(byte[] buffer, int offset, double d, boolean st_IEEEDouble) {
        if (st_IEEEDouble) {
            return DBList.setDouble(buffer, offset, d);
        }
        return DBList.setString(buffer, offset, String.valueOf(d), null, false);
    }

    public static int setDouble(byte[] buffer, int offset, double d) {
        long bits = Double.doubleToRawLongBits(d);
        offset = DBList.addListLengthAndType(buffer, offset, 8, (byte)8);
        offset = DBList.stuffRawLong(buffer, offset, bits, 8);
        return offset;
    }

    public static int setCompactDouble(byte[] buffer, int offset, double d) {
        int i;
        byte type;
        long bits;
        if (d == 0.0 && Math.copySign(1.0, d) > 0.0) {
            return DBList.addListLengthAndType(buffer, offset, 0, (byte)8);
        }
        if ((double)((float)d) == d) {
            bits = (long)Float.floatToRawIntBits((float)d) & 0xFFFFFFFFL;
            type = 8;
            i = 4;
        } else {
            bits = Double.doubleToRawLongBits(d);
            type = 9;
            i = 0;
        }
        while ((bits & 0xFFL) == 0L) {
            bits >>>= 8;
            i = (byte)(i + 1);
        }
        offset = DBList.addListLengthAndType(buffer, offset, 8 - i, type);
        return DBList.stuffRawLong(buffer, offset, bits, 8 - i);
    }

    public static int setCompactFloat(byte[] buffer, int offset, float f) {
        if (f == 0.0f) {
            return DBList.addListLengthAndType(buffer, offset, 0, (byte)8);
        }
        int bits = Float.floatToRawIntBits(f);
        int i = 4;
        while ((bits & 0xFF) == 0) {
            bits >>>= 8;
            ++i;
        }
        offset = DBList.addListLengthAndType(buffer, offset, 8 - i, (byte)8);
        return DBList.stuffRawInt(buffer, offset, bits, 8 - i);
    }

    public static int setLong(byte[] buffer, int offset, long value) throws SQLException {
        int length;
        if (value < 0L) {
            length = value < -4294967296L ? (value < -281474976710656L ? (value < -72057594037927936L ? 8 : 7) : (value < -1099511627776L ? 6 : 5)) : (value < -65536L ? (value < -16777216L ? 4 : 3) : (value < -256L ? 2 : (value < -1L ? 1 : 0)));
            offset = DBList.addListLengthAndType(buffer, offset, length, (byte)5);
        } else {
            length = value > 0xFFFFFFFFL ? (value > 0xFFFFFFFFFFFFL ? (value > 0xFFFFFFFFFFFFFFL ? 8 : 7) : (value > 0xFFFFFFFFFFL ? 6 : 5)) : (value > 65535L ? (value > 0xFFFFFFL ? 4 : 3) : (value > 255L ? 2 : (value > 0L ? 1 : 0)));
            offset = DBList.addListLengthAndType(buffer, offset, length, (byte)4);
        }
        offset = DBList.stuffRawLong(buffer, offset, value, length);
        return offset;
    }

    public static int setInt(byte[] buffer, int offset, int value) throws SQLException {
        int length;
        if (value < 0) {
            length = value < -65536 ? (value < -16777216 ? 4 : 3) : (value < -256 ? 2 : (value < -1 ? 1 : 0));
            offset = DBList.addListLengthAndType(buffer, offset, length, (byte)5);
        } else {
            length = value > 65535 ? (value > 0xFFFFFF ? 4 : 3) : (value > 255 ? 2 : (value > 0 ? 1 : 0));
            offset = DBList.addListLengthAndType(buffer, offset, length, (byte)4);
        }
        offset = DBList.stuffRawInt(buffer, offset, value, length);
        return offset;
    }

    public static int setShort(byte[] buffer, int offset, short value) throws SQLException {
        return DBList.setInt(buffer, offset, value);
    }

    public static int setBigInteger(byte[] buffer, int offset, BigInteger value) throws SQLException {
        if (null == value) {
            return DBList.stuffNull(buffer, offset);
        }
        if (value.compareTo(BigInteger.ZERO) == 0) {
            return DBList.stuffZero(buffer, offset);
        }
        long outLong = value.longValue();
        BigInteger bi = new BigInteger(Long.valueOf(outLong).toString());
        if (bi.compareTo(value) == 0) {
            return DBList.setLong(buffer, offset, outLong);
        }
        return DBList.setNumeric(buffer, offset, new BigDecimal(value));
    }

    public static int setBigDecimal(byte[] buffer, int offset, BigDecimal value) throws SQLException {
        long longValue;
        if (null == value) {
            return DBList.stuffNull(buffer, offset);
        }
        if (value.scale() == 0 && value.compareTo(new BigDecimal(longValue = value.longValue())) == 0) {
            return DBList.setLong(buffer, offset, longValue);
        }
        return DBList.setNumeric(buffer, offset, value);
    }

    private static int setNumeric(byte[] buffer, int offset, BigDecimal bd) throws SQLException {
        int scale = bd.scale();
        BigInteger n = bd.unscaledValue();
        int len = n.bitLength();
        if (len > 63) {
            BigDecimal bdRnd = bd.round(new MathContext(19, RoundingMode.HALF_UP));
            n = bdRnd.unscaledValue();
            if (n.bitLength() >= 64 && (n = (bdRnd = bd.round(new MathContext(18, RoundingMode.HALF_UP))).unscaledValue()).compareTo(new BigInteger("922337203685477581")) < 0 && n.compareTo(new BigInteger("-922337203685477581")) > 0) {
                bdRnd = bdRnd.setScale(bdRnd.scale() + 1, RoundingMode.UNNECESSARY);
                n = bdRnd.unscaledValue();
            }
            scale = bdRnd.scale();
        }
        if (scale < -127 || scale > 128) {
            int precAdj = scale > 128 ? -scale + 128 : -scale - 127;
            BigDecimal bdTemp = new BigDecimal(n);
            bd = bdTemp.scaleByPowerOfTen(precAdj).setScale(0, RoundingMode.HALF_UP);
            n = bd.unscaledValue();
            scale += precAdj;
            if (n == BigInteger.ZERO) {
                scale = 0;
            }
            if (n.bitLength() > 63) {
                throw new SQLValidationException("(BigDecimal: " + bd + ") is out of range for IRIS Numeric SQLType");
            }
        }
        if (scale < 129 && scale > -128) {
            byte type;
            int off;
            byte[] b = n.toByteArray();
            int l = b.length <= 8 ? b.length : 8;
            int n2 = off = b[0] == 0 || b[0] == -1 ? 1 : 0;
            if (scale == 0) {
                type = b[0] >= 0 ? (byte)4 : 5;
                offset = DBList.addListLengthAndType(buffer, offset, b.length - off, type);
            } else {
                type = b[0] >= 0 ? (byte)6 : 7;
                offset = DBList.addListLengthAndType(buffer, offset, b.length - off + 1, type);
                buffer[offset++] = (byte)(-scale);
            }
            while (l > off) {
                buffer[offset++] = b[--l];
            }
            return offset;
        }
        throw new SQLValidationException("(BigDecimal: " + bd + ") is out of range for IRIS Numeric SQLType");
    }

    public static int setBoolean(byte[] buffer, int offset, boolean value) throws SQLException {
        if (value) {
            return DBList.setInt(buffer, offset, 1);
        }
        return DBList.setInt(buffer, offset, 0);
    }

    public static int setUndefined(byte[] buffer, int offset) {
        buffer[offset++] = 1;
        return offset;
    }

    static int addListLengthAndType(byte[] buffer, int off, int len, byte type) {
        if (++len < 255) {
            buffer[off] = (byte)(++len);
            buffer[off + 1] = type;
            return off + 2;
        }
        if (len <= 65535) {
            buffer[off] = 0;
            buffer[off + 1] = (byte)len;
            buffer[off + 2] = (byte)(len >> 8);
            buffer[off + 3] = type;
            return off + 4;
        }
        buffer[off] = 0;
        buffer[off + 1] = 0;
        buffer[off + 2] = 0;
        buffer[off + 3] = (byte)len;
        buffer[off + 4] = (byte)(len >> 8);
        buffer[off + 5] = (byte)(len >> 16);
        buffer[off + 6] = 0;
        buffer[off + 7] = type;
        return off + 8;
    }

    static int stuffEmptyString(byte[] buffer, int offset) {
        buffer[offset++] = 3;
        buffer[offset++] = 1;
        buffer[offset++] = 0;
        return offset;
    }

    private static int stuffNull(byte[] buffer, int offset) {
        buffer[offset++] = 2;
        buffer[offset++] = 1;
        return offset;
    }

    private static int stuffZero(byte[] buffer, int offset) {
        buffer[offset++] = 2;
        buffer[offset++] = 4;
        return offset;
    }

    static int stuffUNICODE(byte[] buffer, int offset, String s, int length) {
        int l = length * 2;
        offset = DBList.addListLengthAndType(buffer, offset, l, (byte)2);
        int j = 0;
        while (j < length) {
            char c = s.charAt(j);
            buffer[offset] = (byte)c;
            buffer[offset + 1] = (byte)(c >> 8);
            ++j;
            offset += 2;
        }
        return offset;
    }

    static int stuffOREFUNICODE(byte[] buffer, int offset, String s, int length) {
        int l = length * 2;
        offset = DBList.addListLengthAndType(buffer, offset, l, (byte)26);
        int j = 0;
        while (j < length) {
            char c = s.charAt(j);
            buffer[offset] = (byte)c;
            buffer[offset + 1] = (byte)(c >> 8);
            ++j;
            offset += 2;
        }
        return offset;
    }

    static int stuffMultibyte(byte[] buffer, int offset, String s, String st_serverLocale) {
        byte[] ascii;
        try {
            if (st_serverLocale == null) {
                if (-1 == (offset = DBList.stuff8BitAscii(buffer, offset, s, s.length()))) {
                    throw new IllegalStateException("Null locale");
                }
                return offset;
            }
            ascii = s.getBytes(st_serverLocale);
        }
        catch (UnsupportedEncodingException e) {
            ascii = s.getBytes();
        }
        int length = ascii.length;
        offset = DBList.addListLengthAndType(buffer, offset, length, (byte)1);
        System.arraycopy(ascii, 0, buffer, offset, length);
        return offset + length;
    }

    static int stuffOREFMultibyte(byte[] buffer, int offset, String s, String st_serverLocale) {
        byte[] ascii;
        try {
            if (st_serverLocale == null) {
                if (-1 == (offset = DBList.stuffOREF8BitAscii(buffer, offset, s, s.length()))) {
                    throw new IllegalStateException("Null locale");
                }
                return offset;
            }
            ascii = s.getBytes(st_serverLocale);
        }
        catch (UnsupportedEncodingException e) {
            ascii = s.getBytes();
        }
        int length = ascii.length;
        offset = DBList.addListLengthAndType(buffer, offset, length, (byte)25);
        System.arraycopy(ascii, 0, buffer, offset, length);
        return offset + length;
    }

    static int stuff8BitAscii(byte[] buffer, int offset, String s, int length) {
        int l = length;
        offset = DBList.addListLengthAndType(buffer, offset, l, (byte)1);
        for (int j = 0; j < l; ++j) {
            char c = s.charAt(j);
            if (c > '\u00ff') {
                return -1;
            }
            buffer[offset++] = (byte)c;
        }
        return offset;
    }

    static int stuffOREF8BitAscii(byte[] buffer, int offset, String s, int length) {
        int l = length;
        offset = DBList.addListLengthAndType(buffer, offset, l, (byte)25);
        for (int j = 0; j < l; ++j) {
            char c = s.charAt(j);
            if (c > '\u00ff') {
                return -1;
            }
            buffer[offset++] = (byte)c;
        }
        return offset;
    }

    static int stuffRawLong(byte[] buffer, int offset, long value, int len) {
        switch (len) {
            case 8: {
                buffer[offset + 7] = (byte)(value >> 56);
            }
            case 7: {
                buffer[offset + 6] = (byte)(value >> 48);
            }
            case 6: {
                buffer[offset + 5] = (byte)(value >> 40);
            }
            case 5: {
                buffer[offset + 4] = (byte)(value >> 32);
            }
            case 4: {
                buffer[offset + 3] = (byte)(value >> 24);
            }
            case 3: {
                buffer[offset + 2] = (byte)(value >> 16);
            }
            case 2: {
                buffer[offset + 1] = (byte)(value >> 8);
            }
            case 1: {
                buffer[offset] = (byte)value;
            }
        }
        return offset + len;
    }

    static int stuffRawInt(byte[] buffer, int offset, int value, int len) {
        switch (len) {
            case 4: {
                buffer[offset + 3] = (byte)(value >> 24);
            }
            case 3: {
                buffer[offset + 2] = (byte)(value >> 16);
            }
            case 2: {
                buffer[offset + 1] = (byte)(value >> 8);
            }
            case 1: {
                buffer[offset + 0] = (byte)value;
            }
        }
        return offset + len;
    }

    static int read4ByteInt(byte[] ba, int offset) {
        int val = ba[offset] & 0xFF;
        val |= (ba[offset + 1] & 0xFF) << 8;
        val |= (ba[offset + 2] & 0xFF) << 16;
        return val |= (ba[offset + 3] & 0xFF) << 24;
    }

    public static String toString(byte[] buffer, int length, String serverLocale) {
        StringBuffer sb = new StringBuffer();
        sb.append("$lb(");
        if (0 == length) {
            sb.append(")");
            return sb.toString();
        }
        try {
            int iOffset = 0;
            boolean bFirst = true;
            while (length > iOffset) {
                if (!bFirst) {
                    bFirst = false;
                    sb.append(',');
                }
                iOffset = DBList.toStringHelper(sb, buffer, length, iOffset, serverLocale);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        sb.append(")");
        return sb.toString();
    }

    private static int toStringHelper(StringBuffer sb, byte[] buffer, int length, int iOffset, String serverLocale) throws SQLException {
        ListItem it = new ListItem(buffer);
        boolean firstTime = true;
        if (iOffset >= length) {
            return -1;
        }
        block9: while (iOffset < length) {
            if (sb.length() > 2000) {
                sb.append("...");
                iOffset = length;
                break;
            }
            if ((iOffset = DBList.getListElement(iOffset, it)) > length) {
                return -1;
            }
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(",");
            }
            if (it.isNull) {
                if (-1 == it.type) {
                    sb.append("null");
                } else {
                    sb.append("empty");
                }
                iOffset = it.nextOffset;
                continue;
            }
            switch (it.type) {
                case 1: 
                case 25: {
                    try {
                        if (1 == buffer[it.nextOffset]) {
                            sb.append(DBList.getString(it, serverLocale));
                            iOffset = it.nextOffset;
                            continue block9;
                        }
                        StringBuffer sb1 = new StringBuffer();
                        sb1.append("$lb(");
                        iOffset = DBList.toStringHelper(sb1, buffer, it.dataOffset + it.dataLength, it.dataOffset, serverLocale);
                        if (-1 == iOffset) {
                            sb.append(DBList.getString(it, serverLocale));
                            iOffset = it.nextOffset;
                            continue block9;
                        }
                        sb.append(sb1);
                        sb.append(')');
                    }
                    catch (Exception ex) {
                        sb.append(DBList.getString(it, serverLocale));
                        iOffset = it.nextOffset;
                    }
                    continue block9;
                }
                case 2: 
                case 26: {
                    sb.append(DBList.getString(it, serverLocale));
                    iOffset = it.nextOffset;
                    continue block9;
                }
                case 4: 
                case 5: {
                    sb.append((Object)DBList.getLong(it));
                    iOffset = it.nextOffset;
                    continue block9;
                }
                case 6: 
                case 7: {
                    sb.append(DBList.getBigDecimal(it).toPlainString());
                    iOffset = it.nextOffset;
                    continue block9;
                }
                case 8: 
                case 9: {
                    sb.append((Object)DBList.getDouble(it));
                    iOffset = it.nextOffset;
                    continue block9;
                }
            }
            throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1003");
        }
        return iOffset;
    }

    public static void dump(byte[] buffer, int iOffset, int iLength) {
        int total;
        if (iLength <= 0) {
            iLength = 2800;
        }
        if (iLength > (total = buffer.length - iOffset)) {
            iLength = total;
        }
        int iDelta = 14;
        for (int i = iOffset; i < iLength; i += iDelta) {
            System.out.print("\n");
            String x = Integer.toHexString(i);
            int len = x.length();
            while (len++ < 4) {
                System.out.print("0");
            }
            System.out.print(x.toUpperCase() + ": ");
            int j = 0;
            for (j = 0; j < iDelta && i + j < iLength; ++j) {
                x = Integer.toHexString(buffer[i + j]).toUpperCase();
                len = x.length();
                if (1 == len) {
                    x = "0" + x;
                }
                if (len > 2) {
                    x = x.substring(len - 2, len);
                }
                if ((x = x + " ").length() == 2) {
                    System.out.print("  ");
                } else if (x.length() == 3) {
                    System.out.print(" ");
                }
                System.out.print(x);
            }
            for (int k = j + 1; k < iDelta; ++k) {
                System.out.print("    ");
            }
            System.out.print("\t");
            for (j = 0; j < iDelta && i + j < iLength; ++j) {
                byte val = buffer[i + j];
                if (val >= 32 && val < 127) {
                    System.out.print((char)val);
                    continue;
                }
                System.out.print(".");
            }
        }
        System.out.print("\n");
    }

    public static <T extends Number> T parseNumber(Class<T> cls, byte[] buffer, int offset, int length) throws SQLException {
        try {
            String str = DBList.grabLatin1String(buffer, offset, length);
            if (EMPTY_STRING_IS_ZERO && str.isEmpty()) {
                str = null;
            }
            return DBList.parse(cls, str);
        }
        catch (Exception e) {
            if (!SLOPPY_PARSING) {
                String v = new String(buffer, offset, length);
                throw new SQLException("Numeric value out of range: '" + v + "'", "22003", 22003);
            }
            try {
                String str = DBList.grabNumericString(buffer, offset, length);
                if (str.isEmpty()) {
                    str = null;
                }
                return DBList.parse(cls, str);
            }
            catch (Exception e1) {
                throw new SQLException(e1.getMessage());
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T extends Number> T parse(Class<T> cls, String x) {
        void var2_13;
        Object var2_2 = null;
        if (cls.equals(Double.class) || Double.class.isAssignableFrom(cls)) {
            if (x == null) {
                Double d = 0.0;
                return var2_13;
            } else {
                try {
                    Double d = Double.parseDouble(x);
                    return var2_13;
                }
                catch (NumberFormatException nfe) {
                    void var2_10;
                    if (x.toUpperCase().startsWith("-INF")) {
                        Double d = Double.NEGATIVE_INFINITY;
                    }
                    if (x.toUpperCase().startsWith("INF") || x.toUpperCase().startsWith("-INF")) {
                        Double d = Double.POSITIVE_INFINITY;
                    }
                    if (x.toUpperCase().startsWith("NAN")) {
                        Double d = Double.NaN;
                    }
                    if (var2_10 != null) return var2_13;
                    throw nfe;
                }
            }
        } else {
            if (!cls.equals(Float.class) && !Float.class.isAssignableFrom(cls)) throw new IllegalArgumentException(cls.toString());
            if (x == null) {
                Float f = Float.valueOf(0.0f);
                return var2_13;
            } else {
                Float f = Float.valueOf(Float.parseFloat(x));
            }
        }
        return var2_13;
    }

    public static int parsenumbIfValid(byte[] dat, int off, int len, long[] retnum) throws SQLException {
        return ParseUtils.parsenumb(dat, off, len, retnum, true, EMPTY_STRING_IS_ZERO, SLOPPY_PARSING);
    }

    public static void setTypeAsPassByReference(byte[] buffer, int offset) {
        switch (buffer[offset]) {
            case 0: {
                buffer[offset += 3] = (byte)(buffer[offset] + 32);
                break;
            }
            case 1: {
                break;
            }
            default: {
                buffer[++offset] = (byte)(buffer[offset] + 32);
            }
        }
    }

    public static void setTypeAsLegacyOref(byte[] buffer, int offset) {
        switch (buffer[offset]) {
            case 0: {
                if (buffer[offset += 3] == 25) {
                    buffer[offset] = -5;
                }
                if (buffer[offset] != 26) break;
                buffer[offset] = -4;
                break;
            }
            case 1: {
                break;
            }
            default: {
                if (buffer[++offset] == 25) {
                    buffer[offset] = -5;
                }
                if (buffer[offset] != 26) break;
                buffer[offset] = -4;
            }
        }
    }

    public static String getListTypeFamily(ListItem it) throws SQLException {
        if (it.isNull) {
            return null;
        }
        switch (it.type) {
            case 4: 
            case 5: {
                return "%long";
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return "%double";
            }
            case 1: 
            case 2: {
                return "%string";
            }
            case -5: 
            case -4: 
            case 25: 
            case 26: {
                return "%oref";
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1000");
    }

    static {
        SLOPPY_PARSING = DBList.getProperty("com.intersystems.jdbc.DBList.SLOPPY_PARSING", true);
        EMPTY_STRING_IS_ZERO = DBList.getProperty("com.intersystems.jdbc.DBList.EMPTY_STRING_IS_ZERO", true);
        scale = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22, 1.0E23, 1.0E24, 1.0E25, 1.0E26, 1.0E27, 1.0E28, 1.0E29, 1.0E30, 1.0E31, 1.0E32, 1.0E33, 1.0E34, 1.0E35, 1.0E36, 1.0E37, 1.0E38, 1.0E39, 1.0E40, 1.0E41, 1.0E42, 1.0E43, 1.0E44, 1.0E45, 1.0E46, 1.0E47, 1.0E48, 1.0E49, 1.0E50, 1.0E51, 1.0E52, 1.0E53, 1.0E54, 1.0E55, 1.0E56, 1.0E57, 1.0E58, 1.0E59, 1.0E60, 1.0E61, 1.0E62, 1.0E63, 1.0E64, 1.0E65, 1.0E66, 1.0E67, 1.0E68, 1.0E69, 1.0E70, 1.0E71, 1.0E72, 1.0E73, 1.0E74, 1.0E75, 1.0E76, 1.0E77, 1.0E78, 1.0E79, 1.0E80, 1.0E81, 1.0E82, 1.0E83, 1.0E84, 1.0E85, 1.0E86, 1.0E87, 1.0E88, 1.0E89, 1.0E90, 1.0E91, 1.0E92, 1.0E93, 1.0E94, 1.0E95, 1.0E96, 1.0E97, 1.0E98, 1.0E99, 1.0E100, 1.0E101, 1.0E102, 1.0E103, 1.0E104, 1.0E105, 1.0E106, 1.0E107, 1.0E108, 1.0E109, 1.0E110, 1.0E111, 1.0E112, 1.0E113, 1.0E114, 1.0E115, 1.0E116, 1.0E117, 1.0E118, 1.0E119, 1.0E120, 1.0E121, 1.0E122, 1.0E123, 1.0E124, 1.0E125, 1.0E126, 1.0E127, 1.0E-128, 1.0E-127, 1.0E-126, 1.0E-125, 1.0E-124, 1.0E-123, 1.0E-122, 1.0E-121, 1.0E-120, 1.0E-119, 1.0E-118, 1.0E-117, 1.0E-116, 1.0E-115, 1.0E-114, 1.0E-113, 1.0E-112, 1.0E-111, 1.0E-110, 1.0E-109, 1.0E-108, 1.0E-107, 1.0E-106, 1.0E-105, 1.0E-104, 1.0E-103, 1.0E-102, 1.0E-101, 1.0E-100, 1.0E-99, 1.0E-98, 1.0E-97, 1.0E-96, 1.0E-95, 1.0E-94, 1.0E-93, 1.0E-92, 1.0E-91, 1.0E-90, 1.0E-89, 1.0E-88, 1.0E-87, 1.0E-86, 1.0E-85, 1.0E-84, 1.0E-83, 1.0E-82, 1.0E-81, 1.0E-80, 1.0E-79, 1.0E-78, 1.0E-77, 1.0E-76, 1.0E-75, 1.0E-74, 1.0E-73, 1.0E-72, 1.0E-71, 1.0E-70, 1.0E-69, 1.0E-68, 1.0E-67, 1.0E-66, 1.0E-65, 1.0E-64, 1.0E-63, 1.0E-62, 1.0E-61, 1.0E-60, 1.0E-59, 1.0E-58, 1.0E-57, 1.0E-56, 1.0E-55, 1.0E-54, 1.0E-53, 1.0E-52, 1.0E-51, 1.0E-50, 1.0E-49, 1.0E-48, 1.0E-47, 1.0E-46, 1.0E-45, 1.0E-44, 1.0E-43, 1.0E-42, 1.0E-41, 1.0E-40, 1.0E-39, 1.0E-38, 1.0E-37, 1.0E-36, 1.0E-35, 1.0E-34, 1.0E-33, 1.0E-32, 1.0E-31, 1.0E-30, 1.0E-29, 1.0E-28, 1.0E-27, 1.0E-26, 1.0E-25, 1.0E-24, 1.0E-23, 1.0E-22, 1.0E-21, 1.0E-20, 1.0E-19, 1.0E-18, 1.0E-17, 1.0E-16, 1.0E-15, 1.0E-14, 1.0E-13, 1.0E-12, 1.0E-11, 1.0E-10, 1.0E-9, 1.0E-8, 1.0E-7, 1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1};
    }
}

