/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.ConnectionInformation;
import com.intersystems.jdbc.ConnectionParameters;
import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.LogFileStream;
import com.intersystems.jdbc.MessageHeader;
import com.intersystems.jgss.GSSSocket;
import com.intersystems.jsse.SSLSocketFactory;
import com.intersystems.shm.SharedMemorySocket;
import com.intersystems.shm.SharedMemoryType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Device {
    private long startTime;
    InputStream inStream;
    OutputStream outStream;
    ConnectionInformation conInfo;
    ConnectionParameters conParams;
    boolean markedToClose = false;
    boolean needsReset = false;
    Socket socket = null;
    static byte[] resetConnBuffer = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 82, 78, 3, 4, 1, 2, 4};
    static MessageHeader dcHeader = new MessageHeader();
    static MessageHeader pingHeader;
    static MessageHeader recvHeader;

    Device(IRISConnection conn) throws Exception {
        this.conInfo = conn.connectionInfo;
        this.conParams = conn.conParams;
        this.startTime = System.currentTimeMillis() / 1000L;
        this.establishSocket();
        this.outStream = this.socket.getOutputStream();
        this.inStream = this.socket.getInputStream();
        conn.device = this;
    }

    public Device(IRISConnection conn, Socket sock) throws Exception {
        this.conInfo = conn.connectionInfo;
        this.conParams = conn.conParams;
        this.startTime = System.currentTimeMillis() / 1000L;
        this.socket = sock;
        this.outStream = this.socket.getOutputStream();
        this.inStream = this.socket.getInputStream();
        conn.device = this;
    }

    void establishSocket() throws Exception {
        this.conParams.writeLogFileHeader();
        if (this.conParams.securityLevel == 0) {
            this.socket = new Socket();
            this.socket.setSoTimeout(this.conParams.connectionTimeout * 1000);
            this.socket.setTcpNoDelay(this.conParams.nodelay);
            this.socket.setSendBufferSize(this.conParams.soSndBuf);
            this.socket.setReceiveBufferSize(this.conParams.soRcvBuf);
            this.socket.setKeepAlive(this.conParams.keepAlive);
            InetSocketAddress sa = this.conParams.useSharedMemory ? new InetSocketAddress("127.0.0.1", this.conParams.port) : new InetSocketAddress(this.conParams.host, this.conParams.port);
            this.socket.connect(sa, this.conParams.connectionTimeout * 1000);
        } else if (this.conParams.securityLevel > 0 && this.conParams.securityLevel < 4) {
            this.socket = new GSSSocket(this.conParams.host, this.conParams.port, this.conParams.principalName, this.conParams.securityLevel, this.conParams.username, this.conParams.password);
        } else if (this.conParams.securityLevel == 10) {
            if (this.conParams.sslctx != null) {
                this.socket = this.conParams.sslctx.getSocketFactory().createSocket(this.conParams.host, this.conParams.port);
            } else {
                SSLSocketFactory sf = new SSLSocketFactory(this.conParams.sSLConfigName, this.conParams.keyRecoveryPassword);
                this.socket = sf.createSocket(this.conParams.host, this.conParams.port);
            }
        }
    }

    public void establishSHMSocket() {
        SharedMemorySocket shmSocket = null;
        try {
            if (this.conInfo.irisInstallDir == null) {
                Pattern pattern = Pattern.compile("^(.*?)\\|(.*)$");
                Matcher matcher = pattern.matcher(this.conInfo.serverVersion);
                boolean matches = matcher.find();
                this.conInfo.serverVersion = matches ? matcher.group(1) : this.conInfo.serverVersion;
                this.conInfo.irisInstallDir = matches ? matcher.group(2) : "";
            }
            shmSocket = new SharedMemorySocket(this.conParams.host, this.conParams.namespace, this.conInfo.irisInstallDir, SharedMemoryType.JNI);
            this.conParams.writeToLog("Attempting to connect over shared memory");
            shmSocket.connect(this.conInfo.srvJobNumber, this.conParams.connectionTimeout);
            this.socket.close();
            this.socket = shmSocket;
            this.inStream = shmSocket.getInputStream();
            this.outStream = shmSocket.getOutputStream();
        }
        catch (Exception ex) {
            shmSocket = null;
            this.conParams.writeToLog(ex.getMessage());
            this.conParams.useSharedMemory = false;
            this.conParams.host = "localhost";
        }
        catch (Error er) {
            shmSocket = null;
            this.conParams.writeToLog(er.getMessage());
            this.conParams.useSharedMemory = false;
            this.conParams.host = "localhost";
        }
        this.conParams.writeToLog(shmSocket == null ? "Error connecting over shared memory, continuing over TCP/IP" : "Successfully connected over shared memory");
    }

    void close() {
        this.close(false);
    }

    void close(boolean skipDC) {
        try {
            if (!skipDC && this.socket != null && this.socket.isConnected()) {
                this.outStream.write(Device.dcHeader.hBuffer, 0, 14);
                if (this.conParams.getLogFile() != null) {
                    this.conParams.getLogFile().dump(dcHeader, 1, this.conInfo.srvJobNumber, this.hashCode());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
        this.conParams = null;
    }

    boolean isSHMSocket() {
        return this.socket instanceof SharedMemorySocket;
    }

    boolean ping() throws SQLException {
        try {
            int len;
            LogFileStream lf = this.conParams.getLogFile();
            this.outStream.write(Device.pingHeader.hBuffer, 0, 14);
            if (lf != null) {
                lf.dump(pingHeader, 1, this.conInfo.srvJobNumber, this.hashCode());
            }
            if ((len = this.inStream.read(Device.recvHeader.hBuffer)) < 14 || recvHeader.getError() != 0) {
                return false;
            }
            if (lf != null) {
                lf.dump(recvHeader, 0, this.conInfo.srvJobNumber, this.hashCode());
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    boolean resetConnection() throws SQLException {
        if (!this.needsReset) {
            return false;
        }
        try {
            this.outStream.write(resetConnBuffer, 0, 19);
            LogFileStream lf = this.conParams.getLogFile();
            if (lf != null) {
                lf.dump(resetConnBuffer, 0, 19, 1, null, this.conInfo.srvJobNumber, this.hashCode());
            }
            this.setSoTimeout(this.conParams.networkTimeout);
        }
        catch (IOException e) {
            return false;
        }
        this.needsReset = false;
        return true;
    }

    boolean hasElapsed(int time) {
        return System.currentTimeMillis() / 1000L - this.startTime > (long)time;
    }

    String getLicenseIP() throws IOException {
        return this.socket.getLocalAddress().getHostAddress();
    }

    void setSoTimeout(int milliseconds) throws SQLException {
        try {
            if (this.socket != null) {
                this.socket.setSoTimeout(milliseconds);
            }
        }
        catch (SocketException e) {
            throw new SQLException("Communication link failure: " + e.getMessage(), "08S01", 461);
        }
    }

    public int getSoTimeout() throws SQLException {
        try {
            return this.socket.getSoTimeout();
        }
        catch (SocketException e) {
            throw new SQLException("Communication link failure: " + e.getMessage(), "08S01", 461);
        }
    }

    boolean isActive() throws IOException {
        throw new IOException("Not Implemented");
    }

    public InputStream getInputStream() {
        return this.inStream;
    }

    public OutputStream getOutputStream() {
        return this.outStream;
    }

    static {
        MessageHeader.setMsgType(Device.dcHeader.hBuffer, IRISConnection.DISCONNECT);
        pingHeader = new MessageHeader();
        MessageHeader.setMsgType(Device.pingHeader.hBuffer, IRISConnection.PING);
        recvHeader = new MessageHeader();
    }
}

