/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.Stream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

class FakeStream
extends Stream {
    Object data;
    int dataOffset;

    FakeStream(Object dt, int st, int qt, int mx) throws SQLException {
        super(st, qt, mx);
        if (dt == null) {
            this.size = -1;
            this.available = -1;
            return;
        }
        if (dt instanceof byte[]) {
            this.size = ((byte[])dt).length;
            this.data = new byte[this.size];
        } else if (dt instanceof char[]) {
            this.size = ((char[])dt).length;
            this.data = new char[this.size];
        }
        try {
            System.arraycopy(dt, 0, this.data, 0, this.size);
        }
        catch (Exception e) {
            throw new SQLException("error reading stream data " + e.getMessage(), "S1000");
        }
        this.available = this.size;
        this.dataOffset = 0;
    }

    @Override
    synchronized int fetchStream(Object b, int streamType, int off, int len) throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        if (this.available <= 0 || this.maxStreamSize == 0) {
            return -1;
        }
        if (len > this.available) {
            len = this.available;
        }
        if (this.maxStreamSize > 0 && len > this.maxStreamSize) {
            len = this.maxStreamSize;
        }
        System.arraycopy(this.data, this.dataOffset, b, off, len);
        this.dataOffset += len;
        if (this.maxStreamSize != 0) {
            this.maxStreamSize -= len;
        }
        this.available -= len;
        return len;
    }

    @Override
    boolean isNull() {
        return this.size == -1;
    }

    @Override
    synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.size = 0;
        this.data = null;
        this.dataOffset = 0;
        this.available = 0;
        this.closed = true;
    }

    static Object sendStream(Object x, int length, int streamType) throws IOException {
        int consumed;
        int pos = 0;
        if (streamType == 4) {
            int consumed2;
            Reader r = (Reader)x;
            char[] temp = new char[length];
            while (length > 0 && (consumed2 = r.read(temp, pos, length)) != -1) {
                pos += consumed2;
                length -= consumed2;
            }
            return temp;
        }
        InputStream s = (InputStream)x;
        byte[] temp = new byte[length];
        while (length > 0 && (consumed = s.read(temp, pos, length)) != -1) {
            pos += consumed;
            length -= consumed;
        }
        return temp;
    }
}

