/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.BufferWrite;
import com.intersystems.jdbc.DBList;
import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.IRISIterator;
import com.intersystems.jdbc.IRISList;
import com.intersystems.jdbc.IRISOREF;
import com.intersystems.jdbc.IRISObject;
import com.intersystems.jdbc.IRISReference;
import com.intersystems.jdbc.InStream;
import com.intersystems.jdbc.ListItem;
import com.intersystems.jdbc.ListReader;
import com.intersystems.jdbc.ListWriter;
import com.intersystems.jdbc.OutStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class IRIS {
    private IRISConnection connection;
    private InStream iris_inMessage;
    private OutStream iris_outMessage;
    private InStream Y9_inMessage;
    private OutStream Y9_outMessage;
    private static final long SYSIO_STOP = 0L;
    private static final long GET_NODE = 1L;
    private static final long SET_NODE = 2L;
    private static final long KILL_NODE = 3L;
    private static final long ORDER = 5L;
    private static final long INCREMENT = 6L;
    private static final long VALUE_FUNCTION = 8L;
    private static final long DATA = 9L;
    private static final long GET_SUBNODES = 10L;
    private static final long VALUE_CLASSMETHOD = 11L;
    private static final long VOID_CLASSMETHOD = 12L;
    private static final long LOCK = 14L;
    private static final long UNLOCK = 15L;
    private static final long UNLOCK_ALL = 16L;
    private static final long TSTART = 17L;
    private static final long TCOMMIT = 18L;
    private static final long TROLLBACK = 19L;
    private static final long TROLLBACK_ONE = 20L;
    private static final long GET_TLEVEL = 21L;
    private static final long VOID_PROCEDURE = 26L;
    private static final long VALUE_METHOD = 27L;
    private static final long VOID_METHOD = 28L;
    private static final long GET_PROPERTY = 29L;
    private static final long SET_PROPERTY = 30L;
    private static final int FLAG_EMPTY = 0;
    private static final int FLAG_VALUE = 1;
    private static final int FLAG_SUBSCRIPT = 2;
    private static final int FLAG_REVERSE = 4;
    private static final int ERROR_UNDEFINED = 1009;
    private static final byte EXT_TYPE_OBJECT = 0;
    private static final byte EXT_TYPE_BYTES = 1;
    private static final byte EXT_TYPE_SHORT = 2;
    private static final byte EXT_TYPE_INT = 3;
    private static final byte EXT_TYPE_LONG = 4;
    private static final byte EXT_TYPE_SINGLE = 5;
    private static final byte EXT_TYPE_DOUBLE = 6;
    private static final byte EXT_TYPE_BOOL = 7;
    private static final byte EXT_TYPE_DECIMAL = 8;
    private static final byte EXT_TYPE_STR = 9;
    private static final byte EXT_TYPE_VOID = 10;
    private static final byte EXT_TYPE_FLOAT = 11;
    public String xepGlobalName;
    public int xepIndexOpt;
    private BufferWrite xepBuffer;
    long xepElapsedTime;

    private IRIS(IRISConnection conn) {
        this.connection = conn;
        try {
            this.iris_inMessage = new InStream(this.connection);
            this.iris_outMessage = new OutStream(this.connection);
            this.Y9_inMessage = new InStream(this.connection);
            this.Y9_outMessage = new OutStream(this.connection);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static IRIS createIRIS(IRISConnection conn) throws SQLException {
        if (null == conn) {
            throw new RuntimeException("Can not create IRIS from NULL Connection");
        }
        return new IRIS(conn);
    }

    public final void close() throws Exception {
    }

    private int sendRequest() throws IOException, SQLException {
        int messageCount = this.connection.messageCount.getCount();
        this.iris_outMessage.send(messageCount);
        return messageCount;
    }

    public static String getProductVersion() {
        return IRIS.class.getPackage().getImplementationVersion();
    }

    public static final String getAPIVersion() {
        return "1.0.0";
    }

    public final String getServerVersion() {
        return this.classMethodString("%SYSTEM.Version", "GetVersion", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object genericGet(byte returnType, String globalName, Object ... subscripts) {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.iris_outMessage.wire.writeHeaderSYSIO(1L);
                this.setGlobalReference(globalName, subscripts);
                this.writeToLog(" <<Sending genericGet (opcode GET_NODE) request : " + globalName + ">>");
                int msgid = this.sendRequest();
                ArrayList<Integer> allowUndefinedError = new ArrayList<Integer>();
                allowUndefinedError.add(1009);
                int errCode = this.iris_inMessage.readHeaderSYSIO(msgid, allowUndefinedError);
                Object returnValue = null;
                if (errCode == 0) {
                    ListItem listitem = this.iris_inMessage.readBodySingleNodeSYSIO();
                    switch (returnType) {
                        case 7: {
                            returnValue = listitem.isNull ? false : DBList.getBoolean(listitem);
                            break;
                        }
                        case 1: {
                            returnValue = listitem.isNull ? new byte[]{} : DBList.getByteArray(listitem);
                            break;
                        }
                        case 2: {
                            returnValue = listitem.isNull ? (short)0 : DBList.getShort(listitem);
                            break;
                        }
                        case 3: {
                            returnValue = listitem.isNull ? 0 : DBList.getInt(listitem);
                            break;
                        }
                        case 4: {
                            returnValue = listitem.isNull ? 0L : DBList.getLong(listitem);
                            break;
                        }
                        case 11: {
                            returnValue = Float.valueOf(listitem.isNull ? 0.0f : DBList.getFloat(listitem));
                            break;
                        }
                        case 6: {
                            returnValue = listitem.isNull ? 0.0 : DBList.getDouble(listitem);
                            break;
                        }
                        case 8: {
                            returnValue = listitem.isNull ? BigDecimal.ZERO : DBList.getBigDecimal(listitem);
                            break;
                        }
                        case 9: {
                            if (listitem.isNull) {
                                returnValue = "";
                                break;
                            }
                            if (listitem.type == 1 && listitem.dataLength == 1 && listitem.buffer[listitem.dataOffset] == 0) {
                                returnValue = "\u0000";
                                break;
                            }
                            returnValue = DBList.getString(listitem, this.connection.getServerLocale());
                            break;
                        }
                        case 0: {
                            returnValue = this.decodeObject(listitem);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid returnType for genericGet");
                        }
                    }
                }
                return returnValue;
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final Boolean getBoolean(String globalName, Object ... subscripts) {
        return (Boolean)this.genericGet((byte)7, globalName, subscripts);
    }

    public final byte[] getBytes(String globalName, Object ... subscripts) {
        return (byte[])this.genericGet((byte)1, globalName, subscripts);
    }

    public final Integer getInteger(String globalName, Object ... subscripts) {
        return (Integer)this.genericGet((byte)3, globalName, subscripts);
    }

    public final Short getShort(String globalName, Object ... subscripts) {
        return (Short)this.genericGet((byte)2, globalName, subscripts);
    }

    public final Long getLong(String globalName, Object ... subscripts) {
        return (Long)this.genericGet((byte)4, globalName, subscripts);
    }

    public final BigDecimal getBigDecimal(String globalName, Object ... subscripts) {
        return (BigDecimal)this.genericGet((byte)8, globalName, subscripts);
    }

    public final Object getObject(String globalName, Object ... subscripts) {
        return this.genericGet((byte)0, globalName, subscripts);
    }

    public IRISList getIRISList(String globalName, Object ... subscripts) {
        Object list = null;
        byte[] bytes = (byte[])this.genericGet((byte)1, globalName, subscripts);
        if (null == bytes) {
            return null;
        }
        return new IRISList(bytes, bytes.length, this.connection.connectionInfo.serverLocale, this.connection.connectionInfo.compactDoubleEnabled);
    }

    final Object decodeObject(ListItem it) throws SQLException {
        if (it.isNull) {
            if (-1 == it.type) {
                return null;
            }
            return new byte[0];
        }
        if (it.type == 1) {
            if (it.dataLength == 1 && it.buffer[it.dataOffset] == 0) {
                return new byte[1];
            }
            return DBList.getByteArray(it);
        }
        return DBList.getObject(it, this.connection.getServerLocale(), false);
    }

    public final String getString(String globalName, Object ... subscripts) {
        return (String)this.genericGet((byte)9, globalName, subscripts);
    }

    public final Float getFloat(String globalName, Object ... subscripts) {
        return (Float)this.genericGet((byte)11, globalName, subscripts);
    }

    public final Double getDouble(String globalName, Object ... subscripts) {
        return (Double)this.genericGet((byte)6, globalName, subscripts);
    }

    public final Timestamp getTimestamp(String globalName, Object ... subscripts) {
        String str = this.getString(globalName, subscripts);
        return str == null || str.length() == 0 ? null : Timestamp.valueOf(str);
    }

    public final Time getTime(String globalName, Object ... subscripts) {
        String str = this.getString(globalName, subscripts);
        return str == null || str.length() == 0 ? null : Time.valueOf(str);
    }

    public final Date getDate(String globalName, Object ... subscripts) {
        String str = this.getString(globalName, subscripts);
        return str == null || str.length() == 0 ? null : Date.valueOf(str);
    }

    public final InputStream getInputStream(String globalName, Object ... subscripts) {
        byte[] byteArray = this.getBytes(globalName, subscripts);
        if (byteArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byteArray);
    }

    public final Reader getReader(String globalName, Object ... subscripts) {
        String strVal = this.getString(globalName, subscripts);
        if (strVal == null) {
            return null;
        }
        return new CharArrayReader(strVal.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genericSet(Object value, String globalName, Object ... subscripts) {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.iris_outMessage.wire.writeHeaderSYSIO(2L);
                this.setGlobalReference(globalName, subscripts);
                if (value == null) {
                    this.iris_outMessage.wire.setNull();
                } else if (value instanceof byte[]) {
                    this.iris_outMessage.wire.set((byte[])value);
                } else if (value instanceof Short) {
                    this.iris_outMessage.wire.set((Short)value);
                } else if (value instanceof Integer) {
                    this.iris_outMessage.wire.set((Integer)value);
                } else if (value instanceof Long) {
                    this.iris_outMessage.wire.set((Long)value);
                } else if (value instanceof Float) {
                    this.iris_outMessage.wire.set((Float)value);
                } else if (value instanceof Double) {
                    this.iris_outMessage.wire.set((Double)value);
                } else if (value instanceof Boolean) {
                    this.iris_outMessage.wire.set((Boolean)value);
                } else if (value instanceof String) {
                    this.iris_outMessage.wire.set((String)value);
                } else if (value instanceof BigDecimal) {
                    this.iris_outMessage.wire.set((BigDecimal)value);
                } else if (value instanceof IRISList) {
                    this.iris_outMessage.wire.set(((IRISList)value).getBuffer(), ((IRISList)value).size());
                } else {
                    throw new RuntimeException("Invalid value type for generiSGet");
                }
                this.writeToLog(" <<Sending genericSet (opcode SET_NODE) request>>");
                int msgid = this.sendRequest();
                this.iris_inMessage.readHeaderSYSIO(msgid);
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final void set(Integer value, String globalName, Object ... subscripts) {
        this.genericSet(value, globalName, subscripts);
    }

    public final void set(Boolean value, String globalName, Object ... subscripts) {
        this.genericSet(value, globalName, subscripts);
    }

    public final void set(Short value, String globalName, Object ... subscripts) {
        this.genericSet(value, globalName, subscripts);
    }

    public final void set(Long value, String globalName, Object ... subscripts) {
        this.genericSet(value, globalName, subscripts);
    }

    public final void set(Double value, String globalName, Object ... subscripts) {
        this.genericSet(value, globalName, subscripts);
    }

    public final void set(Float value, String globalName, Object ... subscripts) {
        this.genericSet(value, globalName, subscripts);
    }

    public final void set(Date value, String globalName, Object ... subscripts) {
        if (value == null) {
            this.set((String)null, globalName, subscripts);
        } else {
            this.set(value.toString(), globalName, subscripts);
        }
    }

    public final void set(Time value, String globalName, Object ... subscripts) {
        if (value == null) {
            this.set((String)null, globalName, subscripts);
        } else {
            this.set(value.toString(), globalName, subscripts);
        }
    }

    public final void set(Timestamp value, String globalName, Object ... subscripts) {
        if (value == null) {
            this.set((String)null, globalName, subscripts);
        } else {
            this.set(value.toString(), globalName, subscripts);
        }
    }

    public final void set(String value, String globalName, Object ... subscripts) {
        if (value != null && value.length() == 0) {
            value = null;
        }
        this.genericSet(value, globalName, subscripts);
    }

    public final void set(byte[] value, String globalName, Object ... subscripts) {
        if (value != null && value.length == 0) {
            value = null;
        }
        this.genericSet(value, globalName, subscripts);
    }

    public final void set(InputStream value, String globalName, Object ... subscripts) {
        try {
            byte[] byteArr = IRIS.convertInputStreamToByteArray(value);
            this.set(byteArr, globalName, subscripts);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static byte[] convertInputStreamToByteArray(InputStream stream) throws IOException {
        byte[] byteArray;
        int lengthRead;
        if (stream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        while ((lengthRead = stream.read(byteArray = new byte[65536])) > 0) {
            byteArrayStream.write(byteArray, 0, lengthRead);
        }
        return byteArrayStream.toByteArray();
    }

    public final void set(Reader value, String globalName, Object ... subscripts) {
        try {
            String string = IRIS.convertReaderToString(value);
            this.set(string, globalName, subscripts);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static String convertReaderToString(Reader reader) throws IOException {
        char[] charArray;
        int lengthRead;
        if (reader == null) {
            return null;
        }
        CharArrayWriter charArrayStream = new CharArrayWriter();
        while ((lengthRead = reader.read(charArray = new char[65536])) > 0) {
            charArrayStream.write(charArray, 0, lengthRead);
        }
        return charArrayStream.toString();
    }

    public final <T extends Serializable> void set(T value, String globalName, Object ... subscripts) {
        try {
            byte[] byteArr = IRIS.convertSerializableToByteArray(value);
            this.set(byteArr, globalName, subscripts);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static byte[] convertSerializableToByteArray(Serializable serializable) throws IOException {
        if (serializable == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(serializable);
        out.flush();
        byte[] byteArr = bos.toByteArray();
        bos.close();
        return byteArr;
    }

    public final void set(BigDecimal value, String globalName, Object ... subscripts) {
        this.genericSet(value, globalName, subscripts);
    }

    public final void set(IRISList value, String globalName, Object ... subscripts) {
        if (value.isCompactDoubleEnabled() && !this.connection.connectionInfo.compactDoubleEnabled) {
            throw new IllegalArgumentException("Cannot store an IRISList with Compact Double enabled on a server with Compact Double disabled");
        }
        this.genericSet(value, globalName, subscripts);
    }

    public final void set(Object value, String globalName, Object ... subscripts) {
        if (value == null) {
            this.set((String)null, globalName, subscripts);
            return;
        }
        if (value instanceof Integer) {
            this.set((Integer)value, globalName, subscripts);
            return;
        }
        if (value instanceof Short) {
            this.set((Short)value, globalName, subscripts);
            return;
        }
        if (value instanceof Boolean) {
            this.set((Boolean)value, globalName, subscripts);
            return;
        }
        if (value instanceof Long) {
            this.set((Long)value, globalName, subscripts);
            return;
        }
        if (value instanceof Float) {
            this.set((Float)value, globalName, subscripts);
            return;
        }
        if (value instanceof Double) {
            this.set((Double)value, globalName, subscripts);
            return;
        }
        if (value instanceof String) {
            this.set((String)value, globalName, subscripts);
            return;
        }
        if (value instanceof byte[]) {
            this.set((byte[])value, globalName, subscripts);
            return;
        }
        if (value instanceof Date) {
            this.set((Date)value, globalName, subscripts);
            return;
        }
        if (value instanceof Time) {
            this.set((Time)value, globalName, subscripts);
            return;
        }
        if (value instanceof Timestamp) {
            this.set((Timestamp)value, globalName, subscripts);
            return;
        }
        if (value instanceof Serializable) {
            this.set((Serializable)value, globalName, subscripts);
            return;
        }
        if (value instanceof Reader) {
            this.set((Reader)value, globalName, subscripts);
            return;
        }
        if (value instanceof InputStream) {
            this.set((InputStream)value, globalName, subscripts);
            return;
        }
        if (value instanceof IRISList) {
            this.set((IRISList)value, globalName, subscripts);
            return;
        }
        throw new RuntimeException("Invalid type: " + value.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void kill(String globalName, Object ... subscripts) {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.iris_outMessage.wire.writeHeaderSYSIO(3L);
                this.setGlobalReference(globalName, subscripts);
                this.writeToLog(" <<Sending kill (opcode KILL_NODE) request : " + globalName + ">>");
                int msgid = this.sendRequest();
                this.iris_inMessage.readHeaderSYSIO(msgid);
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long increment(Integer value, String globalName, Object ... subscripts) {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.iris_outMessage.wire.writeHeaderSYSIO(6L);
                this.setGlobalReference(globalName, subscripts);
                this.iris_outMessage.wire.set(value);
                this.writeToLog(" <<Sending increment (opcode INCREMENT) request : " + globalName + ">>");
                int msgid = this.sendRequest();
                this.iris_inMessage.readHeaderSYSIO(msgid);
                ListItem it = this.iris_inMessage.readBodySingleNodeSYSIO();
                return DBList.getLong(it);
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int isDefined(String globalName, Object ... subscripts) {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.iris_outMessage.wire.writeHeaderSYSIO(9L);
                this.setGlobalReference(globalName, subscripts);
                this.iris_outMessage.wire.set(0);
                this.writeToLog(" <<Sending isDefined (opcode DATA) request : " + globalName + ">>");
                int msgid = this.sendRequest();
                this.iris_inMessage.readHeaderSYSIO(msgid);
                ListItem it = this.iris_inMessage.readBodySingleNodeSYSIO();
                return DBList.getInt(it);
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<ListReader> getNodes(String globalName, Object ... subscripts) {
        try {
            ArrayList<ListReader> listReaders = new ArrayList<ListReader>();
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.iris_outMessage.wire.writeHeaderSYSIO(10L);
                this.setGlobalReference(globalName, subscripts);
                this.iris_outMessage.wire.set(1);
                this.writeToLog(" <<Sending getRows (opcode GET_SUBNODES) request : " + globalName + ">>");
                int msgid = this.sendRequest();
                ArrayList<Integer> allowUndefinedError = new ArrayList<Integer>();
                allowUndefinedError.add(1009);
                int errCode = this.iris_inMessage.readHeaderSYSIO(msgid, allowUndefinedError);
                if (errCode != 0) {
                    return null;
                }
                this.iris_inMessage.readBodyManyNodesSYSIO(listReaders);
            }
            return listReaders;
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ListItem[] getNextNode(Boolean walkBackwards, String globalName, Object ... subscripts) {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.iris_outMessage.wire.writeHeaderSYSIO(5L);
                this.setGlobalReference(globalName, subscripts);
                this.iris_outMessage.wire.set(3 + (walkBackwards != false ? 4 : 0));
                this.writeToLog(" <<Sending getNextNode (opcode ORDER) request : " + globalName + ">>");
                int msgid = this.sendRequest();
                this.iris_inMessage.readHeaderSYSIO(msgid);
                ListItem subscript = this.iris_inMessage.readBodySingleNodeSYSIO();
                ListItem value = this.iris_inMessage.readBodySingleNodeSYSIO();
                return new ListItem[]{subscript, value};
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object nextSubscript(Boolean reverse, String globalName, Object ... subscripts) {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.iris_outMessage.wire.writeHeaderSYSIO(5L);
                this.setGlobalReference(globalName, subscripts);
                this.iris_outMessage.wire.set(2 + (reverse != false ? 4 : 0));
                this.writeToLog(" <<Sending getNextSubscript (opcode ORDER) request : " + globalName + ">>");
                int msgid = this.sendRequest();
                this.iris_inMessage.readHeaderSYSIO(msgid);
                ListItem subscript = this.iris_inMessage.readBodySingleNodeSYSIO();
                return this.decodeObject(subscript);
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final IRISIterator getIRISIterator(String globalName, Object ... subscripts) {
        return new IRISIterator(this, globalName, subscripts);
    }

    public final IRISIterator getIRISIterator(int prefetchSizeHint, String globalName, Object ... subscripts) {
        return new IRISIterator(this, prefetchSizeHint, globalName, subscripts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean lock(String lockMode, Integer timeout, String globalName, Object ... subscripts) {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.iris_outMessage.wire.writeHeaderSYSIO(14L);
                this.setGlobalReference(globalName, subscripts);
                if ("".equals(lockMode)) {
                    this.iris_outMessage.wire.setNull();
                } else {
                    this.iris_outMessage.wire.set(lockMode);
                }
                this.iris_outMessage.wire.set(timeout);
                this.writeToLog(" <<Sending lock (opcode LOCK) request : " + globalName + ">>");
                int msgid = this.sendRequest();
                this.iris_inMessage.readHeaderSYSIO(msgid);
                return true;
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unlock(String lockMode, String globalName, Object ... subscripts) {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.iris_outMessage.wire.writeHeaderSYSIO(15L);
                this.setGlobalReference(globalName, subscripts);
                if ("".equals(lockMode)) {
                    this.iris_outMessage.wire.setNull();
                } else {
                    this.iris_outMessage.wire.set(lockMode);
                }
                this.writeToLog(" <<Sending unlock (opcode UNLOCK) request : " + globalName + ">>");
                int msgid = this.sendRequest();
                this.iris_inMessage.readHeaderSYSIO(msgid);
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseAllLocks() {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.iris_outMessage.wire.writeHeaderSYSIO(16L);
                this.writeToLog(" <<Sending releaseAllLocks (opcode UNLOCK_ALL) request>>");
                int msgid = this.sendRequest();
                this.iris_inMessage.readHeaderSYSIO(msgid);
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tStart() {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.iris_outMessage.wire.writeHeaderSYSIO(17L);
                this.writeToLog(" <<Sending tStart (opcode TSTART) request>>");
                int msgid = this.sendRequest();
                this.iris_inMessage.readHeaderSYSIO(msgid);
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tCommit() {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.iris_outMessage.wire.writeHeaderSYSIO(18L);
                this.writeToLog(" <<Sending tCommit (opcode TCOMMIT) request>>");
                int msgid = this.sendRequest();
                this.iris_inMessage.readHeaderSYSIO(msgid);
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tRollback() {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.iris_outMessage.wire.writeHeaderSYSIO(19L);
                this.writeToLog(" <<Sending tRollback (opcode TROLLBACK) request>>");
                int msgid = this.sendRequest();
                this.iris_inMessage.readHeaderSYSIO(msgid);
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tRollbackOne() {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.iris_outMessage.wire.writeHeaderSYSIO(20L);
                this.writeToLog(" <<Sending tRollbackOne (opcode TROLLBACK_ONE) request>>");
                int msgid = this.sendRequest();
                this.iris_inMessage.readHeaderSYSIO(msgid);
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Integer getTLevel() {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.iris_outMessage.wire.writeHeaderSYSIO(21L);
                this.writeToLog(" <<Sending getTLevel (opcode GET_TLEVEL) request>>");
                int msgid = this.sendRequest();
                this.iris_inMessage.readHeaderSYSIO(msgid);
                ListItem it = this.iris_inMessage.readBodySingleNodeSYSIO();
                return it.isNull ? null : Integer.valueOf(DBList.getInt(it));
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xepSSND(byte[] value, String globalName, int indexOpt) {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.iris_outMessage.wire.writeHeaderSYSIO(448L);
                this.iris_outMessage.wire.set(globalName);
                this.iris_outMessage.wire.set(indexOpt);
                this.iris_outMessage.wire.set(value);
                this.writeToLogTime(" <<Sending SSND (opcode 448) request>>");
                int n = this.sendRequest();
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final void xepSSNDStart(String globalName, int indexOpt, int bufferSize) {
        this.xepGlobalName = globalName;
        this.xepIndexOpt = indexOpt;
        if (this.xepBuffer == null) {
            this.xepBuffer = new BufferWrite(bufferSize, this.connection.connectionInfo.serverLocale);
        }
        this.xepSSNDWriteHeader();
        this.xepElapsedTime = 0L;
    }

    private final void xepSSNDWriteHeader() {
        try {
            this.xepBuffer.writeHeaderSYSIO(448L);
            this.xepBuffer.set(this.xepGlobalName);
            this.xepBuffer.set(this.xepIndexOpt);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final void xepSSNDBufferObject(ListWriter vList) throws SQLException {
        if (this.xepBuffer.m_iOffset + vList.getLength() > this.xepBuffer.m_aData.length) {
            this.xepSSNDFlush();
            this.xepSSNDWriteHeader();
        }
        this.xepBuffer.set(vList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xepSSNDFlush() {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.writeToLogTime(" <<Sending SSND (opcode 448) buffered request>>");
                int n = this.xepSendRequest();
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final void xepSSNDFinish(int count) {
        if (count > 0) {
            this.xepSSNDFlush();
        }
        this.xepBuffer = null;
        this.xepGlobalName = null;
        this.xepIndexOpt = 0;
    }

    private int xepSendRequest() throws IOException, SQLException {
        long start = new java.util.Date(System.currentTimeMillis()).getTime();
        int messageCount = this.connection.messageCount.getCount();
        try {
            this.xepBuffer.dumpData(this.connection.outMessage.outputStream, messageCount, this.connection.getLogFile(), this.connection.connectionInfo.srvJobNumber, this.connection.device.hashCode());
        }
        catch (IOException e) {
            throw new SQLException("Communication link failure: " + e.getMessage(), "08S01", 461);
        }
        this.xepElapsedTime += new java.util.Date(System.currentTimeMillis()).getTime() - start;
        return messageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSYSIO() {
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            try {
                this.iris_outMessage.wire.writeHeaderSYSIO(0L);
                this.writeToLog(" <<Sending stopSYSIO (opcode SYSIO_STOP) request>>");
                this.sendRequest();
            }
            catch (IOException | SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object classMethodCommon(String className, String methodName, byte returnType, Object ... args) {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                if (10 == returnType) {
                    this.iris_outMessage.wire.writeHeaderSYSIO(12L);
                    this.writeToLog(" <<Sending opcode VOID_CLASSMETHOD request : " + className + "." + methodName + ">>");
                } else {
                    this.iris_outMessage.wire.writeHeaderSYSIO(11L);
                    this.writeToLog(" <<Sending opcode VALUE_CLASSMETHOD request : " + className + "." + methodName + ">>");
                }
                this.setClassMethodReference(className, methodName, args);
                int msgid = this.sendRequest();
                this.iris_inMessage.readHeaderSYSIO(msgid);
                Object returnValue = null;
                if (this.iris_inMessage.wire.Header.getMessageLength() > 0) {
                    ListItem listitem = this.iris_inMessage.readBodySingleNodeSYSIO();
                    switch (returnType) {
                        case 1: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue = listitem.isNull ? null : DBList.getByteArray(listitem);
                            break;
                        }
                        case 4: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue = listitem.isNull ? null : Long.valueOf(DBList.getLong(listitem));
                            break;
                        }
                        case 6: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue = listitem.isNull ? null : Double.valueOf(DBList.getDouble(listitem));
                            break;
                        }
                        case 7: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue = listitem.isNull ? null : Boolean.valueOf(DBList.getBoolean(listitem));
                            break;
                        }
                        case 8: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue = listitem.isNull ? null : DBList.getBigDecimal(listitem);
                            break;
                        }
                        case 9: {
                            this.connection.closeUnusedIrisObject(listitem);
                            if (listitem.isNull) {
                                returnValue = null;
                                break;
                            }
                            if (listitem.type == 1 && listitem.dataLength == 1 && listitem.buffer[listitem.dataOffset] == 0) {
                                returnValue = "\u0000";
                                break;
                            }
                            returnValue = DBList.getString(listitem, this.connection.getServerLocale());
                            break;
                        }
                        case 0: {
                            returnValue = DBList.getObjectWithAsciiZero(listitem, this.connection.connectionInfo.serverLocale, true);
                            if (!(returnValue instanceof IRISOREF)) break;
                            returnValue = this.connection.registry_map_oref_to_object(((IRISOREF)returnValue).oref);
                            break;
                        }
                        case 10: {
                            listitem.nextOffset = 0;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid returnType for classMethodCommon");
                        }
                    }
                    this.processPassByReference(listitem, args);
                }
                this.releaseClosedIrisObjects();
                return returnValue;
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final byte[] classMethodBytes(String className, String methodName, Object ... args) {
        return (byte[])this.classMethodCommon(className, methodName, (byte)1, args);
    }

    public final Long classMethodLong(String className, String methodName, Object ... args) {
        return (Long)this.classMethodCommon(className, methodName, (byte)4, args);
    }

    public final Double classMethodDouble(String className, String methodName, Object ... args) {
        return (Double)this.classMethodCommon(className, methodName, (byte)6, args);
    }

    public final Boolean classMethodBoolean(String className, String methodName, Object ... args) {
        return (Boolean)this.classMethodCommon(className, methodName, (byte)7, args);
    }

    public final BigDecimal classMethodBigDecimal(String className, String methodName, Object ... args) {
        return (BigDecimal)this.classMethodCommon(className, methodName, (byte)8, args);
    }

    public final String classMethodString(String className, String methodName, Object ... args) {
        return (String)this.classMethodCommon(className, methodName, (byte)9, args);
    }

    public final Object classMethodObject(String className, String methodName, Object ... args) {
        return this.classMethodCommon(className, methodName, (byte)0, args);
    }

    public final IRISList classMethodIRISList(String className, String methodName, Object ... args) {
        byte[] bytes = this.classMethodBytes(className, methodName, args);
        if (null == bytes) {
            return null;
        }
        return new IRISList(bytes, bytes.length, this.connection.connectionInfo.serverLocale, this.connection.connectionInfo.compactDoubleEnabled);
    }

    public final void classMethodStatusCode(String className, String methodName, Object ... args) {
        byte[] status = this.classMethodBytes(className, methodName, args);
        if (status[0] == 1) {
            return;
        }
        throw new RuntimeException(this.classMethodString("%SYSTEM.Status", "GetErrorText", new Object[]{status}));
    }

    public final void classMethodVoid(String className, String methodName, Object ... args) {
        this.classMethodCommon(className, methodName, (byte)10, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object routineCommon(String labelName, String routineName, byte returnType, Object ... args) {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                if (10 == returnType) {
                    this.iris_outMessage.wire.writeHeaderSYSIO(26L);
                    this.writeToLog(" <<Sending opcode VOID_PROCEDURE request : " + labelName + "^" + routineName + ">>");
                } else {
                    this.iris_outMessage.wire.writeHeaderSYSIO(8L);
                    this.writeToLog(" <<Sending opcode VALUE_FUNCTION request : " + labelName + "^" + routineName + ">>");
                }
                this.setRoutineReference(labelName, routineName, args);
                int msgid = this.sendRequest();
                this.iris_inMessage.readHeaderSYSIO(msgid);
                Object returnValue = null;
                if (this.iris_inMessage.wire.Header.getMessageLength() > 0) {
                    ListItem listitem = this.iris_inMessage.readBodySingleNodeSYSIO();
                    switch (returnType) {
                        case 1: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue = listitem.isNull ? null : DBList.getByteArray(listitem);
                            break;
                        }
                        case 4: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue = listitem.isNull ? null : Long.valueOf(DBList.getLong(listitem));
                            break;
                        }
                        case 6: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue = listitem.isNull ? null : Double.valueOf(DBList.getDouble(listitem));
                            break;
                        }
                        case 7: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue = listitem.isNull ? null : Boolean.valueOf(DBList.getBoolean(listitem));
                            break;
                        }
                        case 8: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue = listitem.isNull ? null : DBList.getBigDecimal(listitem);
                            break;
                        }
                        case 9: {
                            this.connection.closeUnusedIrisObject(listitem);
                            if (listitem.isNull) {
                                returnValue = null;
                                break;
                            }
                            if (listitem.type == 1 && listitem.dataLength == 1 && listitem.buffer[listitem.dataOffset] == 0) {
                                returnValue = "\u0000";
                                break;
                            }
                            returnValue = DBList.getString(listitem, this.connection.getServerLocale());
                            break;
                        }
                        case 0: {
                            returnValue = DBList.getObjectWithAsciiZero(listitem, this.connection.connectionInfo.serverLocale, true);
                            if (!(returnValue instanceof IRISOREF)) break;
                            returnValue = this.connection.registry_map_oref_to_object(((IRISOREF)returnValue).oref);
                            break;
                        }
                        case 10: {
                            listitem.nextOffset = 0;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid returnType for routineCommon");
                        }
                    }
                    this.processPassByReference(listitem, args);
                }
                this.releaseClosedIrisObjects();
                return returnValue;
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final byte[] functionBytes(String functionName, String routineName, Object ... args) {
        return (byte[])this.routineCommon(functionName, routineName, (byte)1, args);
    }

    public final Long functionLong(String functionName, String routineName, Object ... args) {
        return (Long)this.routineCommon(functionName, routineName, (byte)4, args);
    }

    public final Double functionDouble(String functionName, String routineName, Object ... args) {
        return (Double)this.routineCommon(functionName, routineName, (byte)6, args);
    }

    public final Boolean functionBoolean(String functionName, String routineName, Object ... args) {
        return (Boolean)this.routineCommon(functionName, routineName, (byte)7, args);
    }

    public final BigDecimal functionBigDecimal(String functionName, String routineName, Object ... args) {
        return (BigDecimal)this.routineCommon(functionName, routineName, (byte)8, args);
    }

    public final String functionString(String functionName, String routineName, Object ... args) {
        return (String)this.routineCommon(functionName, routineName, (byte)9, args);
    }

    public final Object functionObject(String functionName, String routineName, Object ... args) {
        return this.routineCommon(functionName, routineName, (byte)0, args);
    }

    public final IRISList functionIRISList(String functionName, String routineName, Object ... args) {
        byte[] bytes = this.functionBytes(functionName, routineName, args);
        if (null == bytes) {
            return null;
        }
        return new IRISList(bytes, bytes.length, this.connection.connectionInfo.serverLocale, this.connection.connectionInfo.compactDoubleEnabled);
    }

    public final void procedure(String procedureName, String routineName, Object ... args) {
        this.routineCommon(procedureName, routineName, (byte)10, args);
    }

    private void setGlobalReference(String globalName, Object ... subscripts) throws SQLException, IOException {
        this.setReference(globalName, null, true, false, true, subscripts);
    }

    private void setClassMethodReference(String className, String methodName, Object ... arguments) throws SQLException, IOException {
        this.setReference(className, methodName, false, true, true, arguments);
    }

    private void setRoutineReference(String labelName, String routineName, Object ... arguments) throws SQLException, IOException {
        this.setReference(labelName, routineName, false, true, true, arguments);
    }

    private void setInstanceMethodReference(IRISObject instance, String method_or_property, Object ... arguments) throws SQLException, IOException {
        this.setReference(instance, method_or_property, false, true, true, arguments);
    }

    private void setInstancePropertyReference(IRISObject instance, String method_or_property, Object ... arguments) throws SQLException, IOException {
        this.setReference(instance, method_or_property, false, false, false, arguments);
    }

    private void setReference(Object topRef1, String topRef2, boolean globalMode, boolean honorByReference, boolean includeArgumentCount, Object ... subRefs) throws SQLException, IOException {
        if (topRef1 instanceof IRISObject) {
            this.iris_outMessage.wire.setOref(((IRISObject)topRef1).oref);
        } else {
            this.iris_outMessage.wire.set((String)topRef1);
        }
        if (topRef2 != null) {
            this.iris_outMessage.wire.set(topRef2);
        }
        if (subRefs == null) {
            subRefs = new Object[]{null};
        }
        if (includeArgumentCount) {
            this.iris_outMessage.wire.set(subRefs.length);
        }
        for (int ctr = 0; ctr < subRefs.length; ++ctr) {
            boolean isByReference = false;
            Object subRef = subRefs[ctr];
            if (honorByReference && subRef instanceof IRISReference) {
                if (this.connection.connectionInfo.protocolVersion < 61) {
                    throw new RuntimeException("Pass-by-reference is not supported with the current connection");
                }
                subRef = ((IRISReference)subRef).value;
                isByReference = true;
            }
            if (isByReference || this.connection.connectionInfo.protocolVersion < 61) {
                this.iris_outMessage.wire.saveCurrentOffset();
            }
            if (subRef == null) {
                this.iris_outMessage.wire.setNull();
            } else if (subRef instanceof Short) {
                this.iris_outMessage.wire.set((Short)subRef);
            } else if (subRef instanceof Integer) {
                this.iris_outMessage.wire.set((Integer)subRef);
            } else if (subRef instanceof Long) {
                this.iris_outMessage.wire.set((Long)subRef);
            } else if (subRef instanceof Float) {
                this.iris_outMessage.wire.set((Float)subRef);
            } else if (subRef instanceof Double) {
                this.iris_outMessage.wire.set((Double)subRef);
            } else if (subRef instanceof byte[] && ((byte[])subRef).length <= 3641144) {
                if (((byte[])subRef).length == 0) {
                    this.iris_outMessage.wire.set((String)null);
                } else {
                    this.iris_outMessage.wire.set((byte[])subRef);
                }
            } else if (subRef instanceof Boolean) {
                this.iris_outMessage.wire.set((Boolean)subRef);
            } else if (subRef instanceof BigDecimal) {
                this.iris_outMessage.wire.set((BigDecimal)subRef);
            } else if (subRef instanceof String) {
                if (((String)subRef).length() == 0) {
                    this.iris_outMessage.wire.set((String)null);
                } else {
                    this.iris_outMessage.wire.set((String)subRef);
                }
            } else if (subRef instanceof Time) {
                this.iris_outMessage.wire.set(subRef.toString());
            } else if (subRef instanceof Date) {
                this.iris_outMessage.wire.set(subRef.toString());
            } else if (subRef instanceof Timestamp) {
                this.iris_outMessage.wire.set(subRef.toString());
            } else if (subRef instanceof IRISList) {
                if (((IRISList)subRef).isCompactDoubleEnabled() && !this.connection.connectionInfo.compactDoubleEnabled) {
                    throw new IllegalArgumentException("Cannot store an IRISList with Compact Double enabled on a server with Compact Double disabled");
                }
                this.iris_outMessage.wire.set(((IRISList)subRef).getBuffer(), ((IRISList)subRef).size());
            } else if (globalMode && subRef instanceof InputStream) {
                this.iris_outMessage.wire.set(IRIS.convertInputStreamToByteArray((InputStream)subRef));
            } else if (globalMode && subRef instanceof Reader) {
                this.iris_outMessage.wire.set(IRIS.convertReaderToString((Reader)subRef));
            } else if (globalMode && subRef instanceof Serializable) {
                this.iris_outMessage.wire.set(IRIS.convertSerializableToByteArray((Serializable)subRef));
            } else {
                if (globalMode) {
                    throw new IllegalArgumentException("Unsupported type as global subscript: " + subRef.getClass().getCanonicalName());
                }
                String oref = this.connection.registry_NetRemoteObject_IRISObject_get_oref_from_object(subRef);
                if (oref == null) {
                    if (this.connection.connectionInfo.protocolVersion < 58) {
                        throw new IllegalArgumentException("Unsupported type: " + subRef.getClass().getCanonicalName());
                    }
                    if (this.connection.connectionInfo.protocolVersion < 61 && !this.connection.isGateway) {
                        throw new IllegalArgumentException("Unsupported type: " + subRef.getClass().getCanonicalName());
                    }
                    oref = this.connection.registry_map_object_to_oref(this.Y9_inMessage, this.Y9_outMessage, subRef);
                }
                if (oref != null) {
                    this.iris_outMessage.wire.setOref(oref);
                    if (this.connection.connectionInfo.protocolVersion < 61) {
                        this.iris_outMessage.wire.setSavedOffsetTypeAsLegacyOref();
                    }
                } else {
                    throw new IllegalArgumentException("Unable to map object: " + subRef);
                }
            }
            if (!isByReference) continue;
            this.iris_outMessage.wire.setSavedOffsetTypeAsPassByReference();
        }
    }

    private void processPassByReference(ListItem listitem, Object ... arguments) throws SQLException {
        if (arguments != null) {
            for (int ctr = 0; ctr < arguments.length; ++ctr) {
                Object arg = arguments[ctr];
                if (!(arg instanceof IRISReference)) continue;
                DBList.getListElement(listitem.nextOffset, listitem);
                Object javaObject = DBList.getObjectWithAsciiZero(listitem, this.connection.connectionInfo.serverLocale, true);
                if (javaObject instanceof IRISOREF) {
                    javaObject = this.connection.registry_map_oref_to_object(((IRISOREF)javaObject).oref);
                }
                ((IRISReference)arg).value = javaObject;
                ((IRISReference)arg).setLocale(this.connection.connectionInfo.serverLocale);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object instanceMethodCommon(IRISObject instance, String methodName, byte returnType, Object ... args) {
        try {
            if (instance.closed) {
                throw new RuntimeException("IRISObject '" + instance.oref + "' already closed");
            }
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                if (10 == returnType) {
                    this.iris_outMessage.wire.writeHeaderSYSIO(28L);
                    this.writeToLog(" <<Sending opcode VOID_METHOD request : " + instance.oref + "." + methodName + ">>");
                } else {
                    this.iris_outMessage.wire.writeHeaderSYSIO(27L);
                    this.writeToLog(" <<Sending opcode VALUE_METHOD request : " + instance.oref + "." + methodName + ">>");
                }
                this.setInstanceMethodReference(instance, methodName, args);
                int msgid = this.sendRequest();
                this.iris_inMessage.readHeaderSYSIO(msgid);
                Object returnValue = null;
                if (this.iris_inMessage.wire.Header.getMessageLength() > 0) {
                    ListItem listitem = this.iris_inMessage.readBodySingleNodeSYSIO();
                    switch (returnType) {
                        case 1: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue = listitem.isNull ? null : DBList.getByteArray(listitem);
                            break;
                        }
                        case 4: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue = listitem.isNull ? null : Long.valueOf(DBList.getLong(listitem));
                            break;
                        }
                        case 6: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue = listitem.isNull ? null : Double.valueOf(DBList.getDouble(listitem));
                            break;
                        }
                        case 7: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue = listitem.isNull ? null : Boolean.valueOf(DBList.getBoolean(listitem));
                            break;
                        }
                        case 8: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue = listitem.isNull ? null : DBList.getBigDecimal(listitem);
                            break;
                        }
                        case 9: {
                            this.connection.closeUnusedIrisObject(listitem);
                            if (listitem.isNull) {
                                returnValue = null;
                                break;
                            }
                            if (listitem.type == 1 && listitem.dataLength == 1 && listitem.buffer[listitem.dataOffset] == 0) {
                                returnValue = "\u0000";
                                break;
                            }
                            returnValue = DBList.getString(listitem, this.connection.getServerLocale());
                            break;
                        }
                        case 0: {
                            returnValue = DBList.getObjectWithAsciiZero(listitem, this.connection.connectionInfo.serverLocale, true);
                            if (!(returnValue instanceof IRISOREF)) break;
                            returnValue = this.connection.registry_map_oref_to_object(((IRISOREF)returnValue).oref);
                            break;
                        }
                        case 10: {
                            listitem.nextOffset = 0;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid returnType for routineCommon");
                        }
                    }
                    this.processPassByReference(listitem, args);
                }
                this.releaseClosedIrisObjects();
                return returnValue;
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    final byte[] instanceMethodBytes(IRISObject instance, String methodName, Object ... args) {
        return (byte[])this.instanceMethodCommon(instance, methodName, (byte)1, args);
    }

    final Long instanceMethodLong(IRISObject instance, String methodName, Object ... args) {
        return (Long)this.instanceMethodCommon(instance, methodName, (byte)4, args);
    }

    final Double instanceMethodDouble(IRISObject instance, String methodName, Object ... args) {
        return (Double)this.instanceMethodCommon(instance, methodName, (byte)6, args);
    }

    final Boolean instanceMethodBoolean(IRISObject instance, String methodName, Object ... args) {
        return (Boolean)this.instanceMethodCommon(instance, methodName, (byte)7, args);
    }

    final BigDecimal instanceMethodBigDecimal(IRISObject instance, String methodName, Object ... args) {
        return (BigDecimal)this.instanceMethodCommon(instance, methodName, (byte)8, args);
    }

    final String instanceMethodString(IRISObject instance, String methodName, Object ... args) {
        return (String)this.instanceMethodCommon(instance, methodName, (byte)9, args);
    }

    final Object instanceMethodObject(IRISObject instance, String methodName, Object ... args) {
        return this.instanceMethodCommon(instance, methodName, (byte)0, args);
    }

    final IRISList instanceMethodIRISList(IRISObject instance, String methodName, Object ... args) {
        byte[] bytes = this.instanceMethodBytes(instance, methodName, args);
        if (null == bytes) {
            return null;
        }
        return new IRISList(bytes, bytes.length, this.connection.connectionInfo.serverLocale, this.connection.connectionInfo.compactDoubleEnabled);
    }

    final void instanceMethodStatusCode(IRISObject instance, String methodName, Object ... args) {
        byte[] status = this.instanceMethodBytes(instance, methodName, args);
        if (status[0] == 1) {
            return;
        }
        throw new RuntimeException(this.classMethodString("%SYSTEM.Status", "GetErrorText", new Object[]{status}));
    }

    final void instanceMethodVoid(IRISObject instance, String methodName, Object ... args) {
        this.instanceMethodCommon(instance, methodName, (byte)10, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object instancePropertyCommon(IRISObject instance, String propertyName, byte returnType, Object value) {
        try {
            Object returnValue;
            if (instance.closed) {
                throw new RuntimeException("IRISObject '" + instance.oref + "' already closed");
            }
            if (instance.useCachedValues && returnType != 10 && (returnValue = instance.getFromCache(propertyName, returnType)) != null) {
                return returnValue;
            }
            returnValue = this.connection.messageCount;
            synchronized (returnValue) {
                if (10 == returnType) {
                    this.iris_outMessage.wire.writeHeaderSYSIO(30L);
                    this.writeToLog(" <<Sending opcode SET_PROPERTY request : " + instance.oref + "." + propertyName + ">>");
                    this.setInstancePropertyReference(instance, propertyName, value);
                } else {
                    this.iris_outMessage.wire.writeHeaderSYSIO(29L);
                    this.writeToLog(" <<Sending opcode GET_PROPERTY request : " + instance.oref + "." + propertyName + ">>");
                    this.setInstancePropertyReference(instance, propertyName, new Object[0]);
                }
                int msgid = this.sendRequest();
                this.iris_inMessage.readHeaderSYSIO(msgid);
                Object returnValue2 = null;
                if (this.iris_inMessage.wire.Header.getMessageLength() > 0) {
                    ListItem listitem = this.iris_inMessage.readBodySingleNodeSYSIO();
                    switch (returnType) {
                        case 1: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue2 = listitem.isNull ? null : DBList.getByteArray(listitem);
                            break;
                        }
                        case 4: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue2 = listitem.isNull ? null : Long.valueOf(DBList.getLong(listitem));
                            break;
                        }
                        case 6: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue2 = listitem.isNull ? null : Double.valueOf(DBList.getDouble(listitem));
                            break;
                        }
                        case 7: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue2 = listitem.isNull ? null : Boolean.valueOf(DBList.getBoolean(listitem));
                            break;
                        }
                        case 8: {
                            this.connection.closeUnusedIrisObject(listitem);
                            returnValue2 = listitem.isNull ? null : DBList.getBigDecimal(listitem);
                            break;
                        }
                        case 9: {
                            this.connection.closeUnusedIrisObject(listitem);
                            if (listitem.isNull) {
                                returnValue2 = null;
                                break;
                            }
                            if (listitem.type == 1 && listitem.dataLength == 1 && listitem.buffer[listitem.dataOffset] == 0) {
                                returnValue2 = "\u0000";
                                break;
                            }
                            returnValue2 = DBList.getString(listitem, this.connection.getServerLocale());
                            break;
                        }
                        case 0: {
                            returnValue2 = DBList.getObjectWithAsciiZero(listitem, this.connection.connectionInfo.serverLocale, true);
                            if (!(returnValue2 instanceof IRISOREF)) break;
                            returnValue2 = this.connection.registry_map_oref_to_object(((IRISOREF)returnValue2).oref);
                            break;
                        }
                        case 10: {
                            listitem.nextOffset = 0;
                            if (!instance.useCachedValues) break;
                            instance.updateCache(propertyName, value);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid returnType for routineCommon");
                        }
                    }
                }
                if (instance.useCachedValues && returnType == 10) {
                    instance.updateCache(propertyName, value);
                }
                this.releaseClosedIrisObjects();
                return returnValue2;
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    void writeToLog(String msg) {
        this.connection.writeToLog(msg);
    }

    void writeToLogTime(String msg) {
        if (this.connection.isLog()) {
            this.connection.conParams.getLogFile().logApiTime(msg, "", 0);
        }
    }

    final byte[] instancePropertyGetBytes(IRISObject instance, String propertyName) {
        return (byte[])this.instancePropertyCommon(instance, propertyName, (byte)1, null);
    }

    final Long instancePropertyGetLong(IRISObject instance, String propertyName) {
        return (Long)this.instancePropertyCommon(instance, propertyName, (byte)4, null);
    }

    final Double instancePropertyGetDouble(IRISObject instance, String propertyName) {
        return (Double)this.instancePropertyCommon(instance, propertyName, (byte)6, null);
    }

    final Boolean instancePropertyGetBoolean(IRISObject instance, String propertyName) {
        return (Boolean)this.instancePropertyCommon(instance, propertyName, (byte)7, null);
    }

    final BigDecimal instancePropertyGetBigDecimal(IRISObject instance, String propertyName) {
        return (BigDecimal)this.instancePropertyCommon(instance, propertyName, (byte)8, null);
    }

    final String instancePropertyGetString(IRISObject instance, String propertyName) {
        return (String)this.instancePropertyCommon(instance, propertyName, (byte)9, null);
    }

    final Object instancePropertyGetObject(IRISObject instance, String propertyName) {
        return this.instancePropertyCommon(instance, propertyName, (byte)0, null);
    }

    final IRISList instancePropertyGetIRISList(IRISObject instance, String propertyName) {
        byte[] bytes = this.instancePropertyGetBytes(instance, propertyName);
        if (null == bytes) {
            return null;
        }
        return new IRISList(bytes, bytes.length, this.connection.connectionInfo.serverLocale, this.connection.connectionInfo.compactDoubleEnabled);
    }

    final void instancePropertySet(IRISObject instance, String propertyName, Object value) {
        this.instancePropertyCommon(instance, propertyName, (byte)10, value);
    }

    public final void releaseClosedIrisObjects() {
        this.releaseClosedIrisObjects(false);
    }

    public final void releaseClosedIrisObjects(boolean force) {
        if (this.connection.registry_closed_IRISObject.size() == 0) {
            return;
        }
        if (!force && this.connection.registry_closed_IRISObject.size() <= IRISConnection.CLOSED_PROXY_UPDATE_THRESHOLD) {
            return;
        }
        try {
            String closedOrefList = (String)this.classMethodCommon("%Net.Remote.Gateway", "%ReleaseObjects", (byte)9, this.connection.getClosedIrisObjects());
            if (closedOrefList != null) {
                String[] closedOrefArray = closedOrefList.split(",");
                for (int i = 0; i < closedOrefArray.length; ++i) {
                    String oref = closedOrefArray[i];
                    if (this.connection.onDestructRegistry != null && this.connection.onDestructRegistry.size() > 0) {
                        Object obj = this.connection.registry_NetRemoteObject_get_object_from_oref(oref);
                        Method method = this.connection.onDestructRegistry.get(obj);
                        method.invoke(obj, (Object[])null);
                    }
                    this.connection.registry_NetRemoteObject_remove_by_oref(oref);
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }
}

