/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.IRISInputStream;
import com.intersystems.jdbc.IRISOutputStream;
import com.intersystems.jdbc.RealStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class IRISBlob
extends RealStream
implements Blob {
    IRISBlob(IRISConnection conn, byte[] oref, int scn, int streamType, int sqlType) throws SQLException {
        super(conn, oref, scn, streamType, sqlType, 0);
        this.getStreamSize();
    }

    IRISBlob(IRISConnection conn, byte[] h, int scn) throws SQLException {
        super(conn, h, scn, 1, -4, 0);
        this.getStreamSize();
    }

    @Override
    public long length() throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        return this.size;
    }

    @Override
    public synchronized byte[] getBytes(long pos, int len) throws SQLException {
        return this.getByteStream(pos, len);
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        return new IRISInputStream(this);
    }

    @Override
    public synchronized long position(byte[] pattern, long start) throws SQLException {
        return this.getPosition(pattern, start);
    }

    @Override
    public synchronized long position(Blob pattern, long start) throws SQLException {
        return this.getPosition(pattern.getBytes(0L, (int)pattern.length()), start);
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        return new IRISOutputStream(this, pos);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        int count = this.sendBytes(pos, bytes, offset, len);
        this.getStreamSize();
        return count;
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.truncateStream(len);
        this.getStreamSize();
    }

    @Override
    public void free() throws SQLException {
        try {
            this.close();
        }
        catch (Exception e) {
            throw new SQLException("Error freeing blob " + e.getMessage(), "S1000");
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        return new IRISInputStream(this.getBytes(pos, (int)length), 1, this.sqlType, 0);
    }
}

