/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.IRISBlob;
import com.intersystems.jdbc.IRISClob;
import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.IRISInputStream;
import com.intersystems.jdbc.IRISNClob;
import com.intersystems.jdbc.IRISPreparedStatement;
import com.intersystems.jdbc.IRISReader;
import com.intersystems.jdbc.IRISResultSet;
import com.intersystems.jdbc.IRISStatement;
import com.intersystems.jdbc.Parameter;
import com.intersystems.jdbc.ParameterCollection;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

public final class IRISCallableStatement
extends IRISPreparedStatement
implements CallableStatement {
    static final int RESULT_SET_TYPE = -51;

    IRISCallableStatement(IRISConnection conn, String sql) throws SQLException {
        super(conn, 1003, 1007, sql, null);
    }

    IRISCallableStatement(IRISConnection conn, String sql, int statementType, long paramCount) throws SQLException {
        super(conn, 1003, sql, statementType, paramCount);
    }

    IRISCallableStatement(IRISConnection conn) throws SQLException {
        super(conn);
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        if (this.execParams != null) {
            this.setExecParamMode(parameterIndex, -1);
            return;
        }
        this.setParameterMode(this.parameters.getUserParameterIndex(parameterIndex));
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        if (this.execParams != null) {
            this.setExecParamMode(parameterIndex, scale);
            return;
        }
        this.setParameterModeAndScale(this.parameters.getUserParameterIndex(parameterIndex), scale);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.outputParameterList.isNull();
    }

    @Override
    public boolean getBoolean(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getBoolean(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getBoolean(this.parameters.getUserListOffset(i));
    }

    @Override
    public byte getByte(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getByte(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getOneByte(this.parameters.getUserListOffset(i));
    }

    @Override
    public short getShort(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getShort(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getShort(this.parameters.getUserListOffset(i));
    }

    @Override
    public int getInt(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getInt(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getInt(this.parameters.getUserListOffset(i));
    }

    @Override
    public long getLong(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getLong(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getLong(this.parameters.getUserListOffset(i));
    }

    @Override
    public float getFloat(int i) throws SQLException {
        return (float)this.getDouble(i);
    }

    @Override
    public double getDouble(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getDouble(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getDouble(this.parameters.getUserListOffset(i));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int i, int scale) throws SQLException {
        if (this.execParams != null) {
            return this.getBigDecimal(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getBigDecimal(this.parameters.getUserListOffset(i), scale);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getString(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getString(this.getExecParam((int)i).name);
        }
        Parameter param = this.parameters.getUserParameter(i);
        switch (param.type) {
            case 2: 
            case 3: 
            case 6: {
                BigDecimal bd = this.outputParameterList.getBigDecimalScale(this.parameters.getUserListOffset(i), param.scale, param.precision, true);
                if (bd != null) return bd.toPlainString();
                return null;
            }
            case 8: {
                double dbl = this.getDouble(i);
                if (!this.outputParameterList.isNull()) return String.valueOf(dbl);
                return null;
            }
            case -4: {
                try (IRISInputStream x = new IRISInputStream(this.connection, this.outputParameterList.getString(this.parameters.getUserListOffset(i)).getBytes(), this.serverCursorNumber, 1);){
                    if (x.isNull()) {
                        String string = null;
                        return string;
                    }
                    String string = x.toUnicodeString();
                    return string;
                }
                catch (Exception ex) {
                    throw new SQLException(ex.getMessage());
                }
            }
            case -1: {
                try (IRISReader x = new IRISReader(this.connection, this.outputParameterList.getString(this.parameters.getUserListOffset(i)).getBytes(), this.serverCursorNumber);){
                    if (x.isNull()) {
                        String string = null;
                        return string;
                    }
                    String string = x.toUnicodeString();
                    return string;
                }
                catch (Exception ex) {
                    throw new SQLException(ex.getMessage());
                }
            }
        }
        return this.outputParameterList.getString(this.parameters.getUserListOffset(i));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getBytes(int i) throws SQLException {
        String oid;
        if (this.execParams != null) {
            return this.outputParameterList.getByteArray(this.parameters.getListOffset(this.getExecParam((int)i).name));
        }
        int jdbcType = this.getUserParameterType(i);
        if (jdbcType != -1) {
            if (jdbcType != -4) return this.outputParameterList.getByteArray(this.parameters.getUserListOffset(i));
        }
        if ((oid = this.outputParameterList.getString(this.parameters.getUserListOffset(i))) == null) {
            return null;
        }
        try (IRISInputStream x = new IRISInputStream(this.connection, oid.getBytes(), this.serverCursorNumber, 1);){
            if (x.isNull()) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = x.getByteFromStream();
            return byArray;
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage());
        }
    }

    @Override
    public Date getDate(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getDate(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getDate(this.parameters.getUserListOffset(i));
    }

    @Override
    public Time getTime(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getTime(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getTime(this.parameters.getUserListOffset(i));
    }

    @Override
    public Timestamp getTimestamp(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getTimestamp(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getTimestamp(this.parameters.getUserListOffset(i));
    }

    @Override
    public synchronized Object getObject(int i) throws SQLException {
        Object obj;
        int index = this.parameters.getUserParameterIndex(i);
        Parameter desc = this.parameters.get(index);
        int offset = this.parameters.getListOffset(index);
        switch (desc.type) {
            case 12: {
                obj = this.outputParameterList.getString(offset);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                obj = this.outputParameterList.getInt(offset);
                break;
            }
            case 8: {
                obj = this.outputParameterList.getDouble(offset);
                break;
            }
            case 2: {
                obj = this.outputParameterList.getBigDecimal(offset, desc.scale);
                break;
            }
            case -7: {
                obj = this.outputParameterList.getBoolean(offset);
                break;
            }
            case 91: {
                obj = this.outputParameterList.getDate(offset);
                break;
            }
            case 92: {
                obj = this.outputParameterList.getTime(offset);
                break;
            }
            case 93: {
                obj = this.outputParameterList.getTimestamp(offset);
                break;
            }
            case -3: 
            case -2: {
                obj = this.outputParameterList.getByteArray(offset);
                break;
            }
            case -5: {
                obj = this.outputParameterList.getLong(offset);
                break;
            }
            case -1: {
                obj = this.getCharacterStream(i);
                break;
            }
            case -4: {
                obj = this.getBinaryStream(i);
                break;
            }
            case -51: {
                obj = this.getResultSet(this.outputParameterList.getString(offset));
                break;
            }
            case 2002: {
                throw new SQLException("java.sql.Types.STRUCT not supported.", "IM001");
            }
            default: {
                obj = this.outputParameterList.getString(offset);
            }
        }
        if (this.outputParameterList.isNull()) {
            return null;
        }
        return obj;
    }

    @Override
    final synchronized void prepare(String sql, IRISStatement.StatementType statementType, long paramCount) throws SQLException {
        this.preparse(sql, statementType, paramCount);
        if (this.getSQLDialect() != 0) {
            this.prepareDialect();
            return;
        }
        if (!this.getCachedInfo(this.sqlText)) {
            this.prepareStoredProcedure();
        }
    }

    @Override
    final synchronized void prepare(String sql) throws SQLException {
        this.preparse(sql);
        if (this.getSQLDialect() != 0) {
            this.prepareDialect();
            return;
        }
        if (!this.getCachedInfo(this.sqlText)) {
            this.prepareStoredProcedure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ResultSet getResultSet(String oref) throws SQLException {
        if (oref == null) {
            return null;
        }
        IRISStatement statement = new IRISStatement(this.connection, 1003, 1007, null);
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            statement.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.GET_RESULT_SET_OBJECT);
            statement.output.wire.set(oref);
            statement.output.wire.set(0);
            statement.output.send(this.connection.messageCount.getCount());
            int error = statement.input.readMessage(this, 0, 100);
            if (error == 100) {
                statement.fetchDone = true;
            }
            statement.columnInfo(statement.input.wire);
        }
        IRISResultSet crs = new IRISResultSet(statement, oref);
        if (!statement.fetchDone) {
            crs.requestFetch(this.connection.messageCount.getCount());
            statement.weakResultSetReference = new WeakReference<IRISResultSet>(crs);
        }
        return crs;
    }

    @Override
    public BigDecimal getBigDecimal(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getBigDecimal(this.getExecParam((int)i).name);
        }
        int index = this.parameters.getUserParameterIndex(i);
        Parameter p = this.parameters.get(index);
        switch (p.type) {
            case 2: 
            case 3: 
            case 6: {
                return this.outputParameterList.getBigDecimalScale(this.parameters.getListOffset(index), p.scale, p.precision, true);
            }
        }
        return this.outputParameterList.getBigDecimalScale(this.parameters.getListOffset(index), p.scale, p.precision, false);
    }

    @Override
    public Date getDate(int i, Calendar cal) throws SQLException {
        if (this.execParams != null) {
            return this.getDate(this.getExecParam((int)i).name, cal);
        }
        return this.outputParameterList.getDate(this.parameters.getUserListOffset(i), cal);
    }

    @Override
    public Time getTime(int i, Calendar cal) throws SQLException {
        if (this.execParams != null) {
            return this.getTime(this.getExecParam((int)i).name, cal);
        }
        return this.outputParameterList.getTime(this.parameters.getUserListOffset(i), cal);
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        if (this.execParams != null) {
            return this.getTimestamp(this.getExecParam((int)i).name, cal);
        }
        return this.outputParameterList.getTimestamp(this.parameters.getUserListOffset(i), cal);
    }

    @Override
    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        if (this.execParams != null) {
            this.setExecParamMode(paramIndex, -1);
            return;
        }
        if (sqlType == 2002 || sqlType == 2001 || sqlType == 2000 || sqlType == 2006) {
            throw new SQLException("Type not supported: " + sqlType, "IM001");
        }
        this.registerOutParameter(paramIndex, sqlType);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getBlob(this.getExecParam((int)i).name);
        }
        if (this.getUserParameterType(i) != -4) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        String str = this.outputParameterList.getString(this.parameters.getUserListOffset(i));
        if (str == null) {
            return null;
        }
        IRISBlob blob = new IRISBlob(this.connection, str.getBytes(), this.serverCursorNumber);
        if (blob.isNull()) {
            return null;
        }
        return blob;
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getClob(this.getExecParam((int)i).name);
        }
        if (this.getUserParameterType(i) != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        String str = this.outputParameterList.getString(this.parameters.getUserListOffset(i));
        if (str == null) {
            return null;
        }
        IRISClob clob = new IRISClob(this.connection, str.getBytes(), this.serverCursorNumber);
        if (clob.isNull()) {
            return null;
        }
        return clob;
    }

    private void setExecParamMode(int parameterIndex, int scale) throws SQLException {
        Parameter execParameter = this.getExecParam(parameterIndex);
        if (execParameter.mode == Parameter.ParameterMode.UNKNOWN || execParameter.mode == Parameter.ParameterMode.OUTPUT) {
            execParameter.mode = Parameter.ParameterMode.OUTPUT;
        }
        execParameter.bound = true;
        execParameter.scale = scale;
    }

    private void setExecParamMode(String parameterName, int scale) throws SQLException {
        Parameter execParameter = this.getExecParamByName(parameterName);
        execParameter.mode = Parameter.ParameterMode.INPUT_OUTPUT;
        execParameter.bound = true;
        execParameter.scale = scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNamedGeneric(String parameterName, Object obj, Object whatever) throws SQLException {
        if (this.execParams != null) {
            Parameter execParameter = this.getExecParamByName(parameterName);
            execParameter.value = obj;
            execParameter.bound = true;
            return;
        }
        ParameterCollection parameterCollection = this.parameters;
        synchronized (parameterCollection) {
            Parameter par = this.parameters.get(parameterName);
            if (!(par.type != -1 && par.type != -4 || obj instanceof IRISStatement.StreamWrapper)) {
                this.setObject(this.parameters.getUserParameterNumber(parameterName), obj);
            } else {
                if (obj instanceof ArrayList) {
                    this.parameters.arrayBound = true;
                }
                par.bind(obj, whatever, this.parameterSets);
            }
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        if (this.execParams != null) {
            this.setExecParamMode(parameterName, -1);
            return;
        }
        this.setParameterMode(this.parameters.getParameterIndex(parameterName));
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        if (this.execParams != null) {
            this.setExecParamMode(parameterName, scale);
            return;
        }
        this.setParameterModeAndScale(this.parameters.getParameterIndex(parameterName), scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        if (this.execParams != null) {
            this.setExecParamMode(parameterName, -1);
            return;
        }
        this.setParameterMode(this.parameters.getParameterIndex(parameterName));
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNamedGeneric(parameterName, null, null);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setNamedGeneric(parameterName, null, null);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.setNamedGeneric(parameterName, Float.valueOf(x), null);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        if (x.markSupported()) {
            x.mark(0);
        }
        this.setNamedGeneric(parameterName, new IRISStatement.StreamWrapper(x, 0, length), null);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        if (this.parameters.get((String)parameterName).type == -1) {
            throw new SQLException("Unsupported type conversion: (binary) InputStream to java.sql.Types.LONGVARCHAR.", "S1000");
        }
        if (x.markSupported()) {
            x.mark(0);
        }
        this.setNamedGeneric(parameterName, new IRISStatement.StreamWrapper(x, 1, length), null);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        if (x == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        if (targetSqlType == 2 || targetSqlType == 3) {
            this.setNamedGeneric(parameterName, x, scale);
        } else {
            this.setNamedGeneric(parameterName, x, null);
        }
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        if (reader == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        this.setNamedGeneric(parameterName, new IRISStatement.StreamWrapper(reader, 4, length), null);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setNamedGeneric(parameterName, x, cal);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setNamedGeneric(parameterName, x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setNamedGeneric(parameterName, x, cal);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getString(String parameterName) throws SQLException {
        int index = this.parameters.getParameterIndex(parameterName);
        String str = this.outputParameterList.getString(this.parameters.getListOffset(index));
        if (str == null) {
            return null;
        }
        int jdbcType = this.parameters.get((int)index).type;
        if (jdbcType == -4) {
            try (IRISInputStream x = new IRISInputStream(this.connection, str.getBytes(), this.serverCursorNumber, 1);){
                if (x.isNull()) {
                    String string = null;
                    return string;
                }
                String string = x.toUnicodeString();
                return string;
            }
            catch (Exception ex) {
                throw new SQLException(ex.getMessage());
            }
        }
        if (jdbcType != -1) return str;
        try (IRISReader x = new IRISReader(this.connection, str.getBytes(), this.serverCursorNumber);){
            if (x.isNull()) {
                String string = null;
                return string;
            }
            String string = x.toUnicodeString();
            return string;
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage());
        }
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return this.outputParameterList.getBoolean(this.parameters.getListOffset(parameterName));
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return this.outputParameterList.getOneByte(this.parameters.getListOffset(parameterName));
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return this.outputParameterList.getShort(this.parameters.getListOffset(parameterName));
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return this.outputParameterList.getInt(this.parameters.getListOffset(parameterName));
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return this.outputParameterList.getLong(this.parameters.getListOffset(parameterName));
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return this.outputParameterList.getFloat(this.parameters.getListOffset(parameterName));
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return this.outputParameterList.getDouble(this.parameters.getListOffset(parameterName));
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        if (this.execParams != null) {
            return this.outputParameterList.getByteArray(this.parameters.getListOffset(parameterName));
        }
        return this.getBytes(this.parameters.getUserParameterNumber(parameterName));
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return this.outputParameterList.getDate(this.parameters.getListOffset(parameterName));
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return this.outputParameterList.getTime(this.parameters.getListOffset(parameterName));
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.outputParameterList.getTimestamp(this.parameters.getListOffset(parameterName));
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        return this.getObject(this.parameters.getUserParameterNumber(parameterName));
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        int index = this.parameters.getParameterIndex(parameterName);
        int scale = this.parameters.get((int)index).scale;
        return this.outputParameterList.getBigDecimal(this.parameters.getListOffset(index), scale);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.outputParameterList.getDate(this.parameters.getListOffset(parameterName), cal);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.outputParameterList.getTime(this.parameters.getListOffset(parameterName), cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.outputParameterList.getTimestamp(this.parameters.getListOffset(parameterName), cal);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        int index = this.parameters.getParameterIndex(parameterName);
        if (this.parameters.get((int)index).type != -4) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        String str = this.outputParameterList.getString(this.parameters.getListOffset(index));
        if (str == null) {
            return null;
        }
        IRISBlob blob = new IRISBlob(this.connection, str.getBytes(), this.serverCursorNumber);
        if (blob.isNull()) {
            return null;
        }
        return blob;
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        int index = this.parameters.getParameterIndex(parameterName);
        if (this.parameters.get((int)index).type != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        String str = this.outputParameterList.getString(this.parameters.getListOffset(index));
        if (str == null) {
            return null;
        }
        IRISClob clob = new IRISClob(this.connection, str.getBytes(), this.serverCursorNumber);
        if (clob.isNull()) {
            return null;
        }
        return clob;
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public URL getURL(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public synchronized InputStream getBinaryStream(int i) throws SQLException {
        IRISInputStream stream;
        if (this.execParams != null) {
            return this.getBinaryStream(this.getExecParam((int)i).name);
        }
        String str = this.outputParameterList.getString(this.parameters.getUserListOffset(i));
        if (str == null) {
            return null;
        }
        int type = this.getUserParameterType(i);
        switch (type) {
            case -4: 
            case -1: {
                stream = new IRISInputStream(this.connection, str.getBytes(), this.serverCursorNumber, 1);
                break;
            }
            case -3: {
                stream = new IRISInputStream(this.getBytes(i), 1, type, this.getMaxFieldSize());
                break;
            }
            default: {
                throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
            }
        }
        if (stream.isNull()) {
            return null;
        }
        return stream;
    }

    public synchronized InputStream getBinaryStream(String parameterName) throws SQLException {
        IRISInputStream stream;
        int index = this.parameters.getParameterIndex(parameterName);
        String str = this.outputParameterList.getString(this.parameters.getListOffset(index));
        if (str == null) {
            return null;
        }
        int type = this.parameters.get((int)index).type;
        switch (type) {
            case -4: 
            case -1: {
                stream = new IRISInputStream(this.connection, str.getBytes(), this.serverCursorNumber, 1);
                break;
            }
            case -3: {
                byte[] by = this.outputParameterList.getByteArray(this.parameters.getListOffset(parameterName));
                stream = new IRISInputStream(by, 1, type, this.getMaxFieldSize());
                break;
            }
            default: {
                throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
            }
        }
        if (stream.isNull()) {
            return null;
        }
        return stream;
    }

    @Override
    public synchronized Reader getCharacterStream(int i) throws SQLException {
        IRISReader reader;
        if (this.execParams != null) {
            return this.getCharacterStream(this.getExecParam((int)i).name);
        }
        String str = this.outputParameterList.getString(this.parameters.getUserListOffset(i));
        if (str == null) {
            return null;
        }
        switch (this.getUserParameterType(i)) {
            case -4: 
            case -1: {
                reader = new IRISReader(this.connection, str.getBytes(), this.serverCursorNumber);
                break;
            }
            case -3: 
            case 12: {
                reader = new IRISReader(str);
                break;
            }
            default: {
                throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
            }
        }
        if (reader.isNull()) {
            return null;
        }
        return reader;
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        if (reader == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        int index = this.parameters.getParameterIndex(parameterName);
        if (this.parameters.get((int)index).type != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void setBlob(String parameterName, InputStream x, long length) throws SQLException {
        if (x == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        int index = this.parameters.getParameterIndex(parameterName);
        if (this.parameters.get((int)index).type != -4) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setBinaryStream(parameterName, x, length);
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        IRISReader reader;
        int index = this.parameters.getParameterIndex(parameterName);
        String str = this.outputParameterList.getString(this.parameters.getListOffset(index));
        if (str == null) {
            return null;
        }
        switch (this.parameters.get((int)index).type) {
            case -4: 
            case -1: {
                reader = new IRISReader(this.connection, str.getBytes(), this.serverCursorNumber);
                break;
            }
            case -3: 
            case 12: {
                reader = new IRISReader(str);
                break;
            }
            default: {
                throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
            }
        }
        if (reader.isNull()) {
            return null;
        }
        return reader;
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        if (x == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        int index = this.parameters.getParameterIndex(parameterName);
        if (this.parameters.get((int)index).type != -4) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setBinaryStream(parameterName, x.getBinaryStream(), (int)x.length());
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        if (x == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        int index = this.parameters.getParameterIndex(parameterName);
        if (this.parameters.get((int)index).type != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setCharacterStream(parameterName, x.getCharacterStream(), (int)x.length());
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            int available = 0;
            try {
                available = x.available();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (available == 0 || available > Integer.MAX_VALUE) {
                throw new SQLException("Stream too long: " + length);
            }
            length = available;
        }
        this.setAsciiStream(parameterName, x, (int)length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            int available = 0;
            try {
                available = x.available();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (available == 0 || available > Integer.MAX_VALUE) {
                throw new SQLException("Stream too long: " + length);
            }
            length = available;
        }
        this.setBinaryStream(parameterName, x, (int)length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("Stream too long: " + length);
        }
        this.setCharacterStream(parameterName, reader, (int)length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        if (x == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        if (x.markSupported()) {
            x.mark(0);
        }
        this.setNamedGeneric(parameterName, new IRISStatement.StreamWrapper(x, 0, -1), null);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        if (x == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        int index = this.parameters.getParameterIndex(parameterName);
        if (this.parameters.get((int)index).type == -1) {
            throw new SQLException("Unsupported type conversion: (binary) InputStream to java.sql.Types.LONGVARCHAR.", "S1000");
        }
        if (x.markSupported()) {
            x.mark(0);
        }
        this.setNamedGeneric(parameterName, new IRISStatement.StreamWrapper(x, 1, -1), null);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        if (reader == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        this.setNamedGeneric(parameterName, new IRISStatement.StreamWrapper(reader, 4, -1), null);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        if (reader == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        int index = this.parameters.getParameterIndex(parameterName);
        if (this.parameters.get((int)index).type != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setCharacterStream(parameterName, reader);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        int index = this.parameters.getParameterIndex(parameterName);
        if (this.parameters.get((int)index).type != -4) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setBinaryStream(parameterName, inputStream);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.setString(parameterName, value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.setCharacterStream(parameterName, value, length);
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        this.throwIfNotUnicodeServer();
        return this.getString(parameterIndex);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        this.throwIfNotUnicodeServer();
        return this.getString(parameterName);
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        this.throwIfNotUnicodeServer();
        return this.getCharacterStream(parameterIndex);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.setCharacterStream(parameterName, value);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.setClob(parameterName, reader, length);
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        this.throwIfNotUnicodeServer();
        return this.getCharacterStream(parameterName);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.setClob(parameterName, reader);
    }

    @Override
    public RowId getRowId(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.setClob(parameterName, (Clob)value);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        this.throwIfNotUnicodeServer();
        if (this.execParams != null) {
            return this.getNClob(this.getExecParam((int)parameterIndex).name);
        }
        if (this.getUserParameterType(parameterIndex) != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        String str = this.outputParameterList.getString(this.parameters.getUserListOffset(parameterIndex));
        if (str == null) {
            return null;
        }
        IRISNClob nClob = new IRISNClob(this.connection, str.getBytes(), this.serverCursorNumber);
        if (nClob.isNull()) {
            return null;
        }
        return nClob;
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        this.throwIfNotUnicodeServer();
        int index = this.parameters.getParameterIndex(parameterName);
        if (this.parameters.get((int)index).type != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        String str = this.outputParameterList.getString(this.parameters.getListOffset(index));
        if (str == null) {
            return null;
        }
        IRISNClob nClob = new IRISNClob(this.connection, str.getBytes(), this.serverCursorNumber);
        if (nClob.isNull()) {
            return null;
        }
        return nClob;
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        String sType = type.getName();
        Object obj = null;
        if (this.execParams != null) {
            throw new SQLFeatureNotSupportedException();
        }
        int index = this.parameters.getUserParameterIndex(parameterIndex);
        Parameter desc = this.parameters.get(index);
        int offset = this.parameters.getListOffset(index);
        switch (sType) {
            case "java.lang.String": {
                obj = this.outputParameterList.getString(offset);
                break;
            }
            case "java.sql.Date": {
                obj = this.outputParameterList.getDate(offset);
                break;
            }
            case "java.sql.Time": {
                obj = this.outputParameterList.getTime(offset);
                break;
            }
            case "java.sql.Timestamp": {
                obj = this.outputParameterList.getTimestamp(offset);
                break;
            }
            case "java.time.LocalDate": {
                obj = this.outputParameterList.getLocalDate(offset);
                break;
            }
            case "java.time.LocalTime": {
                obj = this.outputParameterList.getLocalTime(offset);
                break;
            }
            case "java.time.LocalDateTime": {
                obj = this.outputParameterList.getLocalDateTime(offset);
                break;
            }
            case "java.lang.Byte": {
                obj = this.outputParameterList.getOneByte(offset);
                break;
            }
            case "java.lang.Short": {
                obj = this.outputParameterList.getShort(offset);
                break;
            }
            case "java.lang.Integer": {
                obj = this.outputParameterList.getInt(offset);
                break;
            }
            case "java.lang.Long": {
                obj = this.outputParameterList.getLong(offset);
                break;
            }
            case "java.lang.Double": {
                obj = this.outputParameterList.getDouble(offset);
                break;
            }
            case "java.lang.Float": {
                obj = Float.valueOf(this.outputParameterList.getFloat(offset));
                break;
            }
            case "java.lang.Boolean": {
                obj = this.outputParameterList.getBoolean(offset);
                break;
            }
            case "java.math.BigInteger": {
                obj = this.outputParameterList.getBigInteger(offset);
                break;
            }
            case "java.math.BigDecimal": {
                obj = this.outputParameterList.getBigDecimal(offset, desc.scale);
                break;
            }
            case "[B": {
                obj = this.outputParameterList.getByteArray(offset);
                break;
            }
            case "java.io.InputStream": {
                obj = this.getBinaryStream(parameterIndex);
                break;
            }
            case "java.sql.Blob": {
                obj = this.getBlob(parameterIndex);
                break;
            }
            case "java.io.Reader": {
                obj = this.getCharacterStream(parameterIndex);
                break;
            }
            case "java.sql.Clob": {
                obj = this.getClob(parameterIndex);
                break;
            }
            case "java.sql.NClob": {
                obj = this.getNClob(parameterIndex);
                break;
            }
            case "java.lang.Character": {
                String tempVal = this.outputParameterList.getString(offset);
                obj = tempVal != null ? Character.valueOf(tempVal.charAt(0)) : null;
                break;
            }
            case "[C": {
                String tempVal1 = this.outputParameterList.getString(offset);
                obj = tempVal1 != null ? tempVal1.toCharArray() : null;
                break;
            }
            default: {
                try {
                    obj = this.outputParameterList.getString(offset);
                    break;
                }
                catch (SQLException sqlex) {
                    throw sqlex;
                }
                catch (Exception e) {
                    throw new SQLException("Failed to convert to Type: " + sType);
                }
            }
        }
        return (T)obj;
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return this.getObject(this.parameters.getUserParameterNumber(parameterName), type);
    }
}

