/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.IRISInputStream;
import com.intersystems.jdbc.IRISOutputStream;
import com.intersystems.jdbc.IRISReader;
import com.intersystems.jdbc.IRISWriter;
import com.intersystems.jdbc.RealStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class IRISClob
extends RealStream
implements Clob {
    IRISClob(IRISConnection conn, byte[] oref, int scn, int streamType, int sqlType) throws SQLException {
        super(conn, oref, scn, streamType, sqlType, 0);
        this.getStreamSize();
    }

    IRISClob(IRISConnection conn, byte[] h, int scn) throws SQLException {
        super(conn, h, scn, 0, -1, 0);
        this.getStreamSize();
    }

    @Override
    public long length() throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        return this.size;
    }

    @Override
    public synchronized String getSubString(long pos, int len) throws SQLException {
        try {
            byte[] byteStream = this.getByteStream(pos, len);
            if (byteStream == null) {
                return null;
            }
            return new String(byteStream, "UTF-8");
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage());
        }
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        return new IRISReader(this);
    }

    @Override
    public synchronized InputStream getAsciiStream() throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        return new IRISInputStream(this);
    }

    @Override
    public synchronized long position(String pattern, long start) throws SQLException {
        return this.getPosition(pattern.getBytes(), start);
    }

    @Override
    public synchronized long position(Clob pattern, long start) throws SQLException {
        return this.getPosition(pattern.getSubString(0L, (int)pattern.length()).getBytes(), start);
    }

    @Override
    public int setString(long pos, String bytes) throws SQLException {
        return this.setString(pos, bytes, 0, bytes.length());
    }

    @Override
    public int setString(long pos, String bytes, int offset, int len) throws SQLException {
        int count = this.sendBytes(pos, bytes.getBytes(), offset, len);
        this.getStreamSize();
        return count;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        return new IRISOutputStream(this, pos);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        return new IRISWriter(this, pos);
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.truncateStream(len);
        this.getStreamSize();
    }

    @Override
    public void free() throws SQLException {
        try {
            this.close();
        }
        catch (Exception e) {
            throw new SQLException("Error freeing clob " + e.getMessage(), "S1000");
        }
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        return new IRISReader(this.getSubString(pos, (int)length));
    }
}

