/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.gateway.JavaGateway;
import com.intersystems.jdbc.BufferWrite;
import com.intersystems.jdbc.ConnectionInformation;
import com.intersystems.jdbc.ConnectionParameters;
import com.intersystems.jdbc.DBList;
import com.intersystems.jdbc.Device;
import com.intersystems.jdbc.IRIS;
import com.intersystems.jdbc.IRISCallableStatement;
import com.intersystems.jdbc.IRISDatabaseMetaData;
import com.intersystems.jdbc.IRISObject;
import com.intersystems.jdbc.IRISPooledConnection;
import com.intersystems.jdbc.IRISPreparedShardedStatement;
import com.intersystems.jdbc.IRISPreparedStatement;
import com.intersystems.jdbc.IRISResultSet;
import com.intersystems.jdbc.IRISSavepoint;
import com.intersystems.jdbc.IRISStatement;
import com.intersystems.jdbc.IRISWrapper;
import com.intersystems.jdbc.InStream;
import com.intersystems.jdbc.ListItem;
import com.intersystems.jdbc.ListReader;
import com.intersystems.jdbc.ListWriter;
import com.intersystems.jdbc.LogFileStream;
import com.intersystems.jdbc.OutStream;
import com.intersystems.jdbc.ParameterCollection;
import com.intersystems.jdbc.PrepareCollection;
import com.intersystems.sqf.Address;
import com.intersystems.sqf.Master;
import com.intersystems.util.MachineInfo;
import com.intersystems.util.VersionInfo;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.Socket;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;

public class IRISConnection
extends IRISWrapper
implements Connection {
    public ConnectionParameters conParams;
    public ConnectionInformation connectionInfo;
    PrepareCollection cachedPrepares = null;
    int nextServerCursorNumber = 0;
    int recycledServerCursorNumber = -1;
    public InStream inMessage = null;
    public OutStream outMessage = null;
    IRISStatement activeFetchStatement;
    public MessageCount messageCount;
    Map<String, CachedSQL> prePreparseCache;
    public Device device = null;
    boolean closed = true;
    private int autoCommit = 1;
    private boolean isReadOnly = false;
    private SQLWarning warnings = null;
    private Map<String, Savepoint> savepoints;
    private int savepointId = 0;
    private Properties clientInfo;
    private static ListWriter trackerInfo = IRISConnection.setTrackerInfo();
    public boolean isGateway = false;
    public boolean initializationRequiredForXDBC = false;
    public boolean skipDC = false;
    private ThreadLocal<JavaGateway> gateways = new ThreadLocal<JavaGateway>(){

        @Override
        protected JavaGateway initialValue() {
            return null;
        }
    };
    public boolean disableOutputRedirect = true;
    public Map<Object, Method> onDestructRegistry;
    private final ConcurrentLinkedQueue<ListWriter> listWriterQueue = new ConcurrentLinkedQueue();
    public static final int PROTOCOL_VERSION = 69;
    static final byte[] HANDSHAKE = new byte[]{72, 83};
    static final byte[] CONNECT = new byte[]{67, 78};
    static final byte[] DISCONNECT = new byte[]{68, 67};
    static final byte[] PREPARE = new byte[]{80, 80};
    static final byte[] DIRECT_UPDATE = new byte[]{68, 85};
    static final byte[] DIRECT_QUERY = new byte[]{68, 81};
    static final byte[] DIRECT_STORED_PROCEDURE = new byte[]{68, 83};
    static final byte[] PREPARE_DIALECT = new byte[]{80, 68};
    static final byte[] DIRECT_EXECUTE_DIALECT = new byte[]{68, 68};
    static final byte[] PREPARED_UPDATE_EXECUTE = new byte[]{80, 85};
    static final byte[] PREPARED_QUERY_EXECUTE = new byte[]{80, 81};
    static final byte[] FETCH_DATA = new byte[]{70, 68};
    static final byte[] CLOSE_CURSOR = new byte[]{67, 67};
    static final byte[] PREPARE_STORED_PROCEDURE = new byte[]{83, 80};
    static final byte[] STORED_PROCEDURE_UPDATE_EXECUTE = new byte[]{83, 85};
    static final byte[] STORED_PROCEDURE_QUERY_EXECUTE = new byte[]{83, 81};
    static final byte[] STORED_PROCEDURE_FETCH_DATA = new byte[]{83, 70};
    static final byte[] EXECUTE_MULTIPLE_RESULT_SETS = new byte[]{77, 83};
    static final byte[] MULTIPLE_RESULT_SETS_FETCH_DATA = new byte[]{77, 68};
    static final byte[] GET_MORE_RESULTS = new byte[]{77, 82};
    static final byte[] GET_STREAM_SIZE = new byte[]{83, 83};
    static final byte[] READ_STREAM = new byte[]{74, 83};
    static final byte[] STORE_BINARY_STREAM = new byte[]{83, 66};
    static final byte[] STORE_CHARACTER_STREAM = new byte[]{83, 77};
    static final byte[] STREAM_GET_BYTES = new byte[]{71, 66};
    static final byte[] STREAM_SET_BYTES = new byte[]{83, 90};
    static final byte[] STREAM_TRUNCATE = new byte[]{83, 88};
    static final byte[] STREAM_GET_POSITION = new byte[]{71, 80};
    static final byte[] CLOSE_STREAM = new byte[]{67, 83};
    static final byte[] STREAM_RELEASE_READ_LOCK = new byte[]{83, 82};
    static final byte[] STREAM_SET_PREFETCH_SIZE = new byte[]{83, 78};
    static final byte[] GET_RESULT_SET_OBJECT = new byte[]{70, 82};
    static final byte[] COMMIT = new byte[]{84, 67};
    static final byte[] ROLLBACK = new byte[]{84, 82};
    static final byte[] ISOLATION_LEVEL = new byte[]{73, 76};
    static final byte[] AUTOCOMMIT_OFF = new byte[]{65, 70};
    static final byte[] AUTOCOMMIT_ON = new byte[]{65, 78};
    static final byte[] GET_AUTO_GENERATED_KEYS = new byte[]{71, 71};
    static final byte[] IN_TRANSACTION = new byte[]{73, 84};
    static final byte[] JDBC_BESTROWID = new byte[]{66, 82};
    static final byte[] JDBC_CATALOGS = new byte[]{67, 65};
    static final byte[] JDBC_COLUMNPRIV = new byte[]{67, 80};
    static final byte[] JDBC_COLUMNS = new byte[]{67, 79};
    static final byte[] JDBC_CROSSREFERENCE = new byte[]{67, 82};
    static final byte[] JDBC_EXPORTEDKEYS = new byte[]{69, 75};
    static final byte[] JDBC_IMPORTEDKEYS = new byte[]{73, 75};
    static final byte[] JDBC_INDEXINFO = new byte[]{73, 73};
    static final byte[] JDBC_PRIMARYKEYS = new byte[]{80, 75};
    static final byte[] JDBC_PROCEDURECOL = new byte[]{80, 67};
    static final byte[] JDBC_PROCEDURES = new byte[]{80, 82};
    static final byte[] JDBC_SCHEMAS = new byte[]{83, 67};
    static final byte[] JDBC_TABLEPRIV = new byte[]{84, 80};
    static final byte[] JDBC_TABLES = new byte[]{84, 65};
    static final byte[] JDBC_TABLETYPES = new byte[]{84, 84};
    static final byte[] JDBC_TYPEINFO = new byte[]{84, 73};
    static final byte[] JDBC_VERSIONCOL = new byte[]{86, 67};
    static final byte[] JDBC_UDTS = new byte[]{85, 84};
    static final byte[] JDBC_SUPER_TYPES = new byte[]{83, 89};
    static final byte[] JDBC_SUPER_TABLES = new byte[]{83, 76};
    static final byte[] JDBC_GET_ATTRIBUTES = new byte[]{65, 84};
    static final byte[] JDBC_GET_FUNCTION_COLUMNS = new byte[]{70, 67};
    static final byte[] JDBC_GET_FUNCTIONS = new byte[]{70, 78};
    static final byte[] JDBC_CLIENT_INFO_PROPERTIES = new byte[]{67, 70};
    static final byte[] SET_CLIENT_INFO_PROPERTIES = new byte[]{67, 71};
    static final byte[] JDBC_PSEUDO_COLUMNS = new byte[]{67, 72};
    static final byte[] GET_SCHEMA = new byte[]{71, 83};
    static final byte[] EXECUTE_STATIC_CURSOR = new byte[]{69, 88};
    static final byte[] DIRECT_STATIC_CURSOR = new byte[]{68, 88};
    static final byte[] FETCH_STATIC_CURSOR = new byte[]{70, 88};
    static final byte[] UPDATE_CACHE = new byte[]{85, 67};
    static final byte[] GET_SERVER_ERROR = new byte[]{79, 69};
    static final byte[] EXECUTE_STATEMENT_BATCH = new byte[]{69, 66};
    static final byte[] SET_QUERY_PREFETCH_SIZE = new byte[]{80, 66};
    static final byte[] EXTERNAL_INTERUPT = new byte[]{69, 73};
    static final byte[] GET_IRIS_INFO = new byte[]{67, 73};
    static final byte[] PING = new byte[]{80, 71};
    static final byte[] PING_TWO = new byte[]{80, 50};
    static final byte[] SEND_TWO_FACTOR_TOKEN = new byte[]{50, 70};
    static final byte[] IS_TWO_FACTOR_ENABLED = new byte[]{50, 69};
    static final byte[] GATEWAY_INIT = new byte[]{71, 73};
    static final int ALLOW_ERROR_0 = 0;
    static final int ALLOW_ERROR_100 = 100;
    static final int ALLOW_ERROR_403 = 403;
    static final int ALLOW_ERROR_404 = 404;
    static final int ALLOW_ERROR_417 = 417;
    static final int ALLOW_ERRORS_100_AND_404 = 504;
    static final int SQL_DIALECT_DEFAULT = 0;
    static final int SQL_DIALECT_MSSQL = 1;
    static final int SQL_DIALECT_SYBASE = 2;
    public static final int TRANSACTION_READ_VERIFIED = 32;
    private Master master = null;
    public Method outputRedirectHandler = null;
    private Map<String, Object> registry_oref_to_object = new HashMap<String, Object>();
    private Map<String, Type> registry_oref_to_type = new HashMap<String, Type>();
    private ConcurrentMap<String, WeakReference<IRISObject>> registry_oref_to_irisobject;
    public ArrayList<String> registry_closed_IRISObject;
    public static int CLOSED_PROXY_UPDATE_THRESHOLD = 100;
    static final byte[] MESSAGE_JAVA_OBJECT_CREATED = new byte[]{89, 57};

    public IRISConnection() {
        this.init();
    }

    IRISConnection(ConnectionParameters cp) throws SQLException {
        this.init(cp);
        if (this.conParams.pooled == null) {
            this.connect();
        }
    }

    IRISConnection(Device dev) throws SQLException {
        this.init(dev.conParams);
        this.device = dev;
        try {
            this.outMessage = new OutStream(this);
            this.inMessage = new InStream(this);
            this.connectionInfo.delimitedIds = dev.conInfo.delimitedIds;
        }
        catch (Exception e) {
            try {
                this.device.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SQLException("[InterSystems IRIS JDBC] Communication link failure from Connection Pool: " + e.getMessage(), "08S01", 461, e);
        }
        this.closed = false;
    }

    public static IRISConnection internalPipedConnection(Address a, ConnectionParameters cp, String l) throws SQLException {
        ConnectionParameters cParams = null;
        try {
            cParams = cp.copy();
        }
        catch (CloneNotSupportedException e) {
            cParams = cp;
        }
        cParams.updateConParams(a.host, a.port, a.namespace, a.hasCredentials() ? a.user : null, a.hasCredentials() ? a.password : null, l, null);
        cParams.isPiped = true;
        return new IRISConnection(cParams);
    }

    public static IRISConnection internalShardedConnection(Address a, Properties props) throws SQLException {
        ConnectionParameters cParams = new ConnectionParameters();
        cParams.updateConParams(a.host, a.port, a.namespace, a.hasCredentials() ? a.user : null, a.hasCredentials() ? a.password : null, a.logFile, props);
        return new IRISConnection(cParams);
    }

    boolean isFastOption() {
        return this.isFastSelectOption() || this.isFastInsertOption();
    }

    boolean isFastSelectOption() {
        return Feature.isFastSelectOption(this.conParams.featureOption);
    }

    boolean isFastInsertOption() {
        return Feature.isFastInsertOption(this.conParams.featureOption);
    }

    public int getFeatureOption() {
        return this.conParams.featureOption;
    }

    void addPrePreparseCache(String sql, IRISStatement stmt) {
        if (this.prePreparseCache.size() < this.conParams.preparseCacheSize && stmt.execParams == null) {
            this.prePreparseCache.put(sql, new CachedSQL(stmt));
        }
    }

    private void init() {
        this.init(null);
    }

    private void init(ConnectionParameters cp) {
        this.connectionInfo = new ConnectionInformation();
        this.conParams = cp != null ? cp : new ConnectionParameters();
        this.cachedPrepares = new PrepareCollection();
        this.messageCount = new MessageCount();
        this.prePreparseCache = new ConcurrentHashMap<String, CachedSQL>();
        this.clientInfo = new Properties();
        this.isGateway = false;
        this.skipDC = false;
        this.registry_oref_to_irisobject = new ConcurrentHashMap<String, WeakReference<IRISObject>>();
        this.registry_closed_IRISObject = new ArrayList();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public String nativeSQL(String query) throws SQLException {
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoCommit(boolean enableAutoCommit) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            int n = this.autoCommit = enableAutoCommit ? 1 : 2;
            if (this.autoCommit == 1) {
                this.outMessage.wire.writeHeader(AUTOCOMMIT_ON);
            } else {
                this.outMessage.wire.writeHeader(AUTOCOMMIT_OFF);
            }
            this.outMessage.send(this.messageCount.getCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            return this.autoCommit == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            try {
                this.device.setSoTimeout(this.conParams.commitTimeout);
                this.outMessage.wire.writeHeader(COMMIT);
                this.outMessage.send(this.messageCount.getCount());
                this.inMessage.readMessage(0, 0, 0);
                this.device.setSoTimeout(this.conParams.networkTimeout);
            }
            catch (Exception ex) {
                if (!this.isClosed() && this.device != null) {
                    this.device.setSoTimeout(this.conParams.networkTimeout);
                }
                throw new SQLException("Commit Failure: " + ex.getLocalizedMessage() + " , CommitTimeout=" + this.conParams.commitTimeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(ROLLBACK);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readMessage(0, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.conParams.pooled != null) {
            IRISPooledConnection pc = this.conParams.pooled;
            this.conParams.pooled = null;
            pc.release();
        } else {
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                if (this.device != null) {
                    this.device.close(this.skipDC);
                }
            }
        }
        if (!this.isGateway && this.isLog()) {
            this.setLogFile((LogFileStream)null);
        }
        this.gateways.remove();
        this.closed = true;
        this.cachedPrepares.clear();
        this.outMessage = null;
        this.inMessage = null;
        this.clientInfo = null;
        this.registry_oref_to_object = null;
        this.registry_oref_to_type = null;
        this.registry_oref_to_irisobject = null;
        this.registry_closed_IRISObject = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return new IRISDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        this.isReadOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.isReadOnly;
    }

    @Override
    public void setCatalog(String Catalog) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        if ((this.connectionInfo.supportedIsolationLevels & level) != level) {
            throw new SQLException("Unsupported isolation level " + level, "S1000", 460);
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(ISOLATION_LEVEL);
            this.outMessage.wire.set(level);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readMessage(0, 0, 0);
            if (level != this.inMessage.wire.getInt()) {
                throw new SQLException("Server Rejected isolation level: " + level, "S1000", 460);
            }
            this.conParams.isolationLevel = level;
        }
    }

    static ListWriter setTrackerInfo() {
        BufferWrite ftInfo = new BufferWrite("");
        try {
            ftInfo.set("JDBC");
            ftInfo.set(VersionInfo.getJarFileName());
            ftInfo.set(VersionInfo.getClientVersion());
            ftInfo.set(System.getProperty("os.name") + "\\" + System.getProperty("os.version"));
            ftInfo.set(System.getProperty("java.vm.name") + "\\" + System.getProperty("java.runtime.version"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return ftInfo.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionIsolation() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(ISOLATION_LEVEL);
            this.outMessage.wire.set(0);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readMessage(0, 0, 0);
            return this.inMessage.wire.getInt();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        this.warnings = null;
    }

    private byte[] encode(int len, byte[] inp) {
        int i = 0;
        byte[] out = new byte[len];
        while (len > 0) {
            int tint = ((inp[i] ^ 0xA7) & 0xFF) + --len & 0xFF;
            out[len] = (byte)(tint << 5 | tint >> 3);
            ++i;
        }
        return out;
    }

    private String encodew(String s) {
        int len = s.length();
        int i = 0;
        char[] inChar = s.toCharArray();
        char[] outChar = new char[len];
        while (len > 0) {
            char tint2 = inChar[i];
            int tint = ((inChar[i] ^ 0xA7) & 0xFF) + --len & 0xFF;
            outChar[len] = (char)(tint2 & 0xFF00 | (tint << 5 | tint >> 3) & 0xFF);
            ++i;
        }
        if (i == 0) {
            return null;
        }
        return new String(outChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect() throws SQLException {
        try {
            this.device = new Device(this);
            this.outMessage = new OutStream(this);
            this.inMessage = new InStream(this);
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(HANDSHAKE);
                this.outMessage.wire.set2ByteInt(this.connectionInfo.protocolVersion);
                this.outMessage.send(this.messageCount.getCount());
                if (this.inMessage.readMessage(0, 0, 417) == 417) {
                    throw new SQLException(this.inMessage.wire.getString(), "08S01", 461);
                }
                this.connectionInfo.protocolVersion = this.inMessage.wire.getRaw2ByteInt();
                if (this.connectionInfo.protocolVersion < 57) {
                    throw new SQLException("InterSystems IRIS JDBC driver is not compatible with Cache xDBC server", "08S01", 461);
                }
                int flags = this.inMessage.wire.getRaw2ByteInt();
                this.connectionInfo.isUnicodeServer = (flags & 1) > 0;
                this.connectionInfo.compactDoubleEnabled = this.connectionInfo.protocolVersion >= 65 && (flags & 2) > 0;
                this.connectionInfo.setServerLocale(this.inMessage.wire.getString());
                this.inMessage.setLocale(this.connectionInfo);
                this.outMessage.wire.setConnectionInfo(this.connectionInfo);
                this.outMessage.wire.writeHeader(CONNECT);
                this.outMessage.wire.set(this.conParams.namespace);
                if (this.conParams.username.length() == 0 || this.conParams.accesstoken != null) {
                    this.outMessage.wire.setNull();
                } else if (this.connectionInfo.isUnicodeServer) {
                    this.outMessage.wire.set(this.encodew(this.conParams.username));
                } else {
                    byte[] userBytes = this.conParams.username.getBytes(this.connectionInfo.serverLocale);
                    this.outMessage.wire.set(this.encode(userBytes.length, userBytes));
                }
                if (this.connectionInfo.isUnicodeServer) {
                    if (this.conParams.accesstoken == null) {
                        if (this.conParams.password.length() == 0) {
                            this.outMessage.wire.setNull();
                        } else {
                            this.outMessage.wire.set(this.encodew(this.conParams.password));
                        }
                    } else {
                        this.outMessage.wire.set(this.encodew(this.conParams.accesstoken));
                    }
                } else if (this.conParams.accesstoken == null) {
                    if (this.conParams.password.length() == 0) {
                        this.outMessage.wire.setNull();
                    } else {
                        byte[] passwordBytes = this.conParams.password.getBytes(this.connectionInfo.serverLocale);
                        this.outMessage.wire.set(this.encode(passwordBytes.length, passwordBytes));
                    }
                } else {
                    byte[] tokenBytes = this.conParams.accesstoken.getBytes(this.connectionInfo.serverLocale);
                    this.outMessage.wire.set(this.encode(tokenBytes.length, tokenBytes));
                }
                String userName = MachineInfo.getUserName();
                String machineName = MachineInfo.getMachineName();
                String applicationName = MachineInfo.getExeName();
                String hostIP = this.device.getLicenseIP();
                this.clientInfo.put("ApplicationName", applicationName);
                this.clientInfo.put("ClientHostname", hostIP);
                this.clientInfo.put("ClientUser", userName);
                this.clientInfo.put("MachineName", machineName);
                this.outMessage.wire.set(userName);
                this.outMessage.wire.set(machineName);
                this.outMessage.wire.set(applicationName);
                this.outMessage.wire.set(trackerInfo, true);
                if (this.conParams.useSharedMemory) {
                    this.outMessage.wire.set(this.conParams.host);
                } else {
                    this.outMessage.wire.set(hostIP);
                }
                this.outMessage.wire.set(this.conParams.eventClass);
                if (this.autoCommit == 1) {
                    this.outMessage.wire.set(1);
                } else {
                    this.outMessage.wire.set(2);
                }
                this.outMessage.wire.set(this.conParams.isolationLevel);
                this.outMessage.wire.set(this.conParams.featureOption);
                this.outMessage.send(this.messageCount.getCount());
                if (this.inMessage.readMessage(0, 0, 417) == 417) {
                    throw new SQLException(this.inMessage.wire.getString(), "08S01", 461);
                }
                this.connectionInfo.parseServerVersion(this.inMessage.wire.getString());
                this.connectionInfo.delimitedIds = this.inMessage.wire.getInt();
                this.inMessage.wire.getInt();
                this.connectionInfo.supportedIsolationLevels = this.inMessage.wire.getInt();
                this.connectionInfo.srvJobNumber = this.inMessage.wire.getString();
                this.connectionInfo.sqlEmptyString = this.inMessage.wire.getInt();
                this.conParams.featureOption = this.inMessage.wire.getInt();
            }
            this.closed = false;
            if (this.conParams.useSharedMemory) {
                this.device.establishSHMSocket();
                this.outMessage.setDevOutStream(this.device.getOutputStream());
                this.inMessage.setDevInStream(this.device.getInputStream());
            }
            this.device.setSoTimeout(this.conParams.networkTimeout);
        }
        catch (Exception e2) {
            SQLException e2;
            try {
                if (e2.getMessage().contains("Invalid Message")) {
                    e2 = new SQLException("Connection attempt might not be to an IRIS Superserver!");
                }
                this.device.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SQLException("[InterSystems IRIS JDBC] Communication link failure: " + e2.getMessage(), "08S01", 461, e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initXDBCforGateway() throws SQLException {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(GATEWAY_INIT);
            this.outMessage.wire.set(this.autoCommit);
            this.outMessage.wire.set(this.conParams.isolationLevel);
            this.outMessage.wire.set(this.conParams.featureOption);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readMessage(0, 0, 0);
            this.connectionInfo.parseServerVersion(this.inMessage.wire.getString());
            this.connectionInfo.delimitedIds = this.inMessage.wire.getInt();
            this.connectionInfo.supportedIsolationLevels = this.inMessage.wire.getInt();
            this.connectionInfo.srvJobNumber = this.inMessage.wire.getString();
            this.connectionInfo.sqlEmptyString = this.inMessage.wire.getInt();
            this.conParams.featureOption = this.inMessage.wire.getInt();
        }
    }

    public boolean isUsingSharedMemory() {
        return this.device.isSHMSocket();
    }

    public boolean isServerUnicode() {
        return this.connectionInfo.isUnicodeServer;
    }

    public String getServerLocale() {
        return this.connectionInfo.serverLocale;
    }

    public boolean isCompactDoubleEnabled() {
        return this.connectionInfo.compactDoubleEnabled;
    }

    public ConnectionInformation getConnectionInfo() {
        return (ConnectionInformation)this.connectionInfo.clone();
    }

    public void setConnectionInfo(ConnectionInformation info) {
        this.connectionInfo = info;
    }

    void addCachedPrepare(IRISStatement stmt, boolean setOwner) throws SQLException {
        this.cachedPrepares.put(stmt.serverCursorNumber, new CachedPrepare(stmt, setOwner));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCache() throws SQLException {
        if (this.cachedPrepares.getUnownedCount() <= this.conParams.maxStatementCacheSize) {
            return;
        }
        int[] x = new int[this.cachedPrepares.cachedStatementsToRemove];
        int n = 0;
        int i = 1;
        try {
            this.cachedPrepares.writeLock();
            TreeMap<Integer, CachedPrepare> treeMap = new TreeMap<Integer, CachedPrepare>(this.cachedPrepares);
            Set<Integer> keys = treeMap.keySet();
            Iterator<Integer> iter = keys.iterator();
            this.cachedPrepares.releaseWriteLock();
            Integer key = iter.next();
            while (true) {
                CachedPrepare element = treeMap.get(key);
                if (element.ownedBy == null) {
                    if (element.refCount == i) {
                        x[n] = key;
                        this.cachedPrepares.remove(x[n++]);
                    }
                    if (n == this.cachedPrepares.cachedStatementsToRemove || i > 10) break;
                }
                if (!iter.hasNext()) {
                    ++i;
                    iter = keys.iterator();
                }
                key = iter.next();
            }
        }
        catch (Exception ex) {
            this.cachedPrepares.releaseWriteLock();
        }
        if (n == 0) {
            return;
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(UPDATE_CACHE);
            this.outMessage.wire.set(n);
            for (int j = 0; j < n; ++j) {
                this.outMessage.wire.set(x[j]);
            }
            this.outMessage.send(this.messageCount.getCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelStatement(IRISStatement cs) throws SQLException {
        try (IRISConnection newConn = new IRISConnection(this.conParams);){
            MessageCount messageCount = newConn.messageCount;
            synchronized (messageCount) {
                newConn.outMessage.wire.writeHeader(0, EXTERNAL_INTERUPT);
                newConn.outMessage.wire.set(Integer.parseInt(cs.connection.connectionInfo.srvJobNumber));
                newConn.outMessage.wire.set(cs.serverCursorNumber);
                newConn.outMessage.send(newConn.messageCount.getCount());
                int err = newConn.inMessage.readMessage(0, 0, 0);
                if (err != 0) {
                    throw new SQLException("InterSystems IRIS Cancel failure", "HY018");
                }
            }
            newConn.close();
        }
        catch (SQLException ex) {
            throw new SQLException("InterSystems IRIS Cancel failure: " + ex.getMessage(), "HY018");
        }
    }

    public void checkOutStandingFetches() throws SQLException {
        if (this.activeFetchStatement != null && this.activeFetchStatement.outstandingReads > 0 && this.activeFetchStatement.weakResultSetReference != null && !this.activeFetchStatement.fetchDone) {
            ((IRISResultSet)this.activeFetchStatement.weakResultSetReference.get()).readOOBFetch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache(boolean send) throws SQLException {
        int size = this.cachedPrepares.size();
        if (size == 0) {
            return;
        }
        Iterator iter = this.cachedPrepares.keySet().iterator();
        if (send) {
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(UPDATE_CACHE);
                this.cachedPrepares.clear();
                this.outMessage.wire.set(0);
                this.outMessage.send(this.messageCount.getCount());
                return;
            }
        }
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    void getServerError(int rc) throws SQLException {
        String state = IRISConnection.getSQLState(rc);
        if (this.closed) {
            switch (rc) {
                case 469: {
                    throw new SQLException("Driver not capable", state, rc);
                }
                case 464: {
                    throw new SQLException("Function sequence error", state, rc);
                }
                case 462: {
                    throw new SQLException("Memory allocation failure", state, rc);
                }
                case 461: {
                    throw new SQLException("Communication link failure", state, rc);
                }
                case 460: {
                    throw new SQLException("General error", state, rc);
                }
                case 453: {
                    throw new SQLException("Error in User Initialization Code", state, rc);
                }
                case 452: {
                    throw new SQLException("Message sequencing error", state, rc);
                }
                case 451: {
                    throw new SQLException("Unable to receive server message", state, rc);
                }
                case 450: {
                    throw new SQLException("Unable to send client message", state, rc);
                }
                case 410: {
                    throw new SQLException("Invalid Directory", state, rc);
                }
                case 409: {
                    throw new SQLException("Invalid server function", state, rc);
                }
                case 408: {
                    throw new SQLException("Unable to start server", state, rc);
                }
                case 407: {
                    throw new SQLException("Unable to Write to Server Master", state, rc);
                }
                case 406: {
                    throw new SQLException("Unable to Write to Server", state, rc);
                }
                case 405: {
                    throw new SQLException("Unable to read from communication device", state, rc);
                }
                case 402: {
                    throw new SQLException("Invalid Username/Password", state, rc);
                }
                case 401: {
                    throw new SQLException("Fatal Connection error", state, rc);
                }
                case 400: {
                    throw new SQLException("Fatal error occurred", state, rc);
                }
                case 112: {
                    throw new SQLException("Access violation", state, rc);
                }
                case 99: {
                    throw new SQLException("Privilege Violation", state, rc);
                }
                case 98: {
                    throw new SQLException("License Violation", state, rc);
                }
            }
            throw new SQLException("General error", state, rc);
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(GET_SERVER_ERROR);
            this.outMessage.wire.set(rc);
            this.outMessage.send(this.messageCount.getCount());
            int err = this.inMessage.readMessage(0, 0, 0);
            if (err != 0) {
                throw new SQLException("General error", state, rc);
            }
            throw new SQLException(this.inMessage.wire.getString(), state, rc);
        }
    }

    static String getSQLState(int rc) {
        switch (rc) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 42: 
            case 51: 
            case 53: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                return "37000";
            }
            case 30: 
            case 33: 
            case 39: {
                return "S0002";
            }
            case 31: {
                return "S0022";
            }
            case 62: {
                return "21S01";
            }
            case 103: {
                return "34000";
            }
            case 104: 
            case 108: {
                return "23000";
            }
            case 1004: {
                return "01004";
            }
            case 1031: {
                return "42000";
            }
            case 7001: {
                return "07001";
            }
            case 7006: {
                return "07006";
            }
            case 22003: {
                return "22003";
            }
            case 22005: {
                return "22005";
            }
            case 22008: {
                return "22008";
            }
            case 24000: {
                return "24000";
            }
            case 402: {
                return "28000";
            }
            case 413: 
            case 452: 
            case 461: {
                return "08S01";
            }
            case 450: {
                return "S1T00";
            }
            case 462: {
                return "S1001";
            }
            case 463: {
                return "S1002";
            }
            case 464: {
                return "S1010";
            }
            case 465: {
                return "S1090";
            }
            case 466: {
                return "S1093";
            }
            case 467: {
                return "S1097";
            }
            case 468: {
                return "S1106";
            }
            case 469: {
                return "S1C00";
            }
            case 470: {
                return "01S02";
            }
            case 471: {
                return "3C000";
            }
        }
        return "S1000";
    }

    public String getIRISJobID() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.connectionInfo.srvJobNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetOnUse() throws SQLException {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.device.markedToClose = true;
            this.messageCount.count = -1;
            this.nextServerCursorNumber = 0;
            this.conParams.isolationLevel = 1;
            this.autoCommit = 1;
            this.cachedPrepares.clear();
        }
    }

    int processError(int error, int allowError) throws SQLException {
        if (error == 100 && (allowError == 100 || allowError == 504)) {
            return 100;
        }
        if (error == 403 && allowError == 403) {
            return 403;
        }
        if (error == 417 && allowError == 417) {
            return 417;
        }
        if (error == 404 && (allowError == 404 || allowError == 504)) {
            return 404;
        }
        if (allowError == -1) {
            return error;
        }
        this.getServerError(error);
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWarning(SQLWarning warning) {
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            SQLWarning sQLWarning = this.warnings;
            synchronized (sQLWarning) {
                this.warnings.setNextWarning(warning);
            }
        }
    }

    public Object getOutMessage() {
        return this.outMessage;
    }

    public Object getInMessage() {
        return this.inMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inTransaction() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(IN_TRANSACTION);
            this.outMessage.send(this.messageCount.getCount());
            int error = this.inMessage.readMessage(0, 0, -1);
            return error != 0;
        }
    }

    private PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, String agkc) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.getOrCreatePossiblyShardedIRISPreparedStatement(resultSetType, resultSetConcurrency, sql, agkc);
    }

    public int getProtocolVersion() {
        return this.connectionInfo.protocolVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getIRISResultSet(String oref) throws SQLException {
        IRISStatement statement = new IRISStatement(this, 1003, 1007, null);
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            statement.output.wire.writeHeader(0, GET_RESULT_SET_OBJECT);
            statement.output.wire.set(oref);
            statement.output.wire.set(0);
            statement.output.send(this.messageCount.getCount());
            int error = statement.input.readMessage(0, 0, 100);
            if (error == 100) {
                statement.fetchDone = true;
            }
            statement.columnInfo(statement.input.wire);
        }
        return new IRISResultSet(statement, oref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float ping(int times) throws SQLException {
        long start = System.currentTimeMillis();
        for (int i = 0; i < times; ++i) {
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(PING);
                this.outMessage.send(this.messageCount.getCount());
                this.inMessage.readMessage(0, 0, 0);
                continue;
            }
        }
        return (float)(System.currentTimeMillis() - start) / 1000.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float ping(int flavor, int itemSize, int itemCount, int itemType, int times, boolean nodelay, int reserved) throws SQLException {
        try {
            this.device.socket.setTcpNoDelay(nodelay);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String item = "";
        for (int j = 0; j < itemSize; ++j) {
            item = item + "x";
        }
        long start = System.currentTimeMillis();
        for (int i = 0; i < times; ++i) {
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(PING_TWO);
                this.outMessage.wire.set(flavor);
                this.outMessage.wire.set(reserved);
                this.outMessage.wire.set(itemType);
                if (itemType == 0) {
                    this.outMessage.wire.set(itemCount);
                    for (int k = 0; k < itemCount; ++k) {
                        this.outMessage.wire.set(item);
                    }
                } else {
                    this.outMessage.wire.set(itemSize);
                    this.outMessage.wire.set(item);
                }
                this.outMessage.send(this.messageCount.getCount());
                this.inMessage.readMessage(0, 0, 0);
                if (flavor == 3) {
                    int resItems = this.inMessage.wire.getInt();
                    if (itemType == 0) {
                        for (int j = 0; j < resItems; ++j) {
                            String string = this.inMessage.wire.getString();
                        }
                    }
                }
                continue;
            }
        }
        return (float)(System.currentTimeMillis() - start) / 1000.0f;
    }

    public static String[] getNamespaces(String host, int port, String username, String password, String logFileName) throws Exception {
        LogFileStream logFile = null;
        if (host.toUpperCase().startsWith("SHM|")) {
            host = "127.0.0.1";
        }
        Socket socket = new Socket(host, port);
        if (logFileName != null && !logFileName.equals("")) {
            logFile = new LogFileStream(logFileName);
        }
        OutStream output = new OutStream(socket.getOutputStream(), logFile);
        InStream input = new InStream(socket.getInputStream(), logFile);
        return IRISConnection.getNamespaces(input, output, username, password, socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getNamespaces(InStream input, OutStream output, String user, String passwd, Socket sock) throws Exception {
        try (IRISConnection conn = new IRISConnection();){
            conn.device = new Device(conn, sock);
            conn.closed = false;
            conn.conParams.username = user;
            conn.conParams.password = passwd;
            conn.inMessage = input;
            conn.outMessage = output;
            conn.inMessage.connection = conn;
            conn.outMessage.setConnection(conn);
            MessageCount messageCount = conn.messageCount;
            synchronized (messageCount) {
                conn.outMessage.wire.writeHeader(0, GET_IRIS_INFO);
                conn.outMessage.wire.set(conn.conParams.username);
                conn.outMessage.wire.set(conn.conParams.password);
                conn.outMessage.send(0);
                conn.inMessage.readMessage(0, 0, 100);
            }
            int namespaceCount = conn.inMessage.wire.getInt();
            String[] namespaces = new String[namespaceCount];
            for (int i = 0; i < namespaceCount; ++i) {
                namespaces[i] = conn.inMessage.wire.getString();
            }
            conn.closed = true;
            String[] stringArray = namespaces;
            return stringArray;
        }
        catch (SQLException ex) {
            throw new SQLException("getNamespaces failed: " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSetClientInfo(Properties info) throws SQLException {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(SET_CLIENT_INFO_PROPERTIES);
            this.outMessage.wire.set(info.size());
            if (info.containsKey("ApplicationName")) {
                this.outMessage.wire.set(13);
                this.outMessage.wire.set(info.getProperty("ApplicationName"));
            }
            if (info.containsKey("ClientHostname")) {
                this.outMessage.wire.set(12);
                this.outMessage.wire.set(info.getProperty("ClientHostname"));
            }
            if (info.containsKey("ClientUser")) {
                this.outMessage.wire.set(11);
                this.outMessage.wire.set(info.getProperty("ClientUser"));
            }
            if (info.containsKey("UserInfo")) {
                this.outMessage.wire.set(20);
                this.outMessage.wire.set(info.getProperty("UserInfo"));
            }
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readMessage(0, 0, 0);
        }
    }

    public void setSQLDialect(int dialect) {
        this.conParams.sqlDialect = dialect;
    }

    public int getSQLDialect() {
        return this.conParams.sqlDialect;
    }

    private void modifyClientInfo(String name, Properties properties, Properties info) {
        if (properties.containsKey(name)) {
            String value = properties.getProperty(name);
            if (value == null) {
                value = "";
            }
            if (!this.clientInfo.getProperty(name).equals(value)) {
                this.clientInfo.put(name, value);
                info.put(name, value);
            }
        }
    }

    int getMaxSendBuffSize() {
        if (this.conParams.securityLevel == 2 || this.conParams.securityLevel == 3) {
            return 50000;
        }
        return 10000000;
    }

    int getSendStreamImmeadiateSize() {
        if (this.conParams.securityLevel == 2 || this.conParams.securityLevel == 3) {
            return 50000;
        }
        return 100000;
    }

    synchronized int getServerCursorNumber() {
        if (this.recycledServerCursorNumber != -1) {
            int cursorNumber = this.recycledServerCursorNumber;
            this.recycledServerCursorNumber = -1;
            return cursorNumber;
        }
        ++this.nextServerCursorNumber;
        return this.nextServerCursorNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTwoFactorEnabled() throws Exception {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(IS_TWO_FACTOR_ENABLED);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readMessage(0, 0, 0);
            return this.inMessage.wire.getBoolean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTwoFactorToken(String tokenName) throws Exception {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(SEND_TWO_FACTOR_TOKEN);
            this.outMessage.wire.set(tokenName);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readMessage(0, 0, 0);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        if (resultSetType == 1005) {
            this.addWarning(new SQLWarning("createStatement called with TYPE_SCROLL_SENSITIVE which is not supported: TYPE_SCROLL_INSENSITIVE used instead", "IM001"));
            resultSetType = 1004;
        }
        return new IRISStatement(this, resultSetType, resultSetConcurrency, null);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        if (resultSetType == 1005) {
            this.addWarning(new SQLWarning("prepareStatement called with TYPE_SCROLL_SENSITIVE which is not supported: TYPE_SCROLL_INSENSITIVE used instead", "IM001"));
            resultSetType = 1004;
        }
        return this.getOrCreatePossiblyShardedIRISPreparedStatement(resultSetType, resultSetConcurrency, sql, null);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        if (this.conParams.sqlDialect != 0) {
            throw new SQLException("Non-InterSystems IRIS dialects only supported via Statement interface.");
        }
        if (resultSetType != 1003) {
            this.addWarning(new SQLWarning("prepareCall called with unsupported result set type: TYPE_FORWARD_ONLY used instead", "IM001"));
            resultSetType = 1003;
        }
        if (resultSetConcurrency != 1007) {
            this.addWarning(new SQLWarning("prepareCall called with CONCUR_UPDATABLE which is not supported: CONCUR_READ_ONLY used instead", "IM001"));
            resultSetConcurrency = 1007;
        }
        return new IRISCallableStatement(this, sql);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (holdability == 2) {
            throw new SQLException("Unsupported holdability.", "IM001");
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability == 2) {
            throw new SQLException("Unsupported holdability.", "IM001");
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability == 2) {
            throw new SQLException("Unsupported holdability.", "IM001");
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability == 2) {
            throw new SQLException("Unsupported holdability.", "IM001");
        }
        return this.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int generatedKeys) throws SQLException {
        if (generatedKeys == 1) {
            return this.prepareStatement(sql, 1003, 1007, "-1");
        }
        return this.prepareStatement(sql, 1003, 1007, null);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed.", "IM001");
        }
        return this.prepareStatement(sql, 1003, 1007, Integer.toString(columnIndexes[0]));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (columnNames.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed.", "IM001");
        }
        return this.prepareStatement(sql, 1003, 1007, columnNames[0]);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        for (String name : this.savepoints.keySet()) {
            if (savepoint != this.savepoints.get(name)) continue;
            this.savepoints.remove(name);
            ((IRISSavepoint)savepoint).release();
            return;
        }
        throw new SQLException("Savepoint does not exist/already released.");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLException("Cannot set savepoint when autocommit is on.");
        }
        if (this.savepoints == null) {
            this.savepoints = new HashMap<String, Savepoint>();
        }
        ++this.savepointId;
        String name = "SAV" + this.savepointId + "PT";
        if (this.savepoints.containsKey(name)) {
            throw new SQLException("Savepoint " + name + " already exists.");
        }
        IRISSavepoint savepoint = new IRISSavepoint(this, name, this.savepointId);
        this.savepoints.put(name, savepoint);
        return savepoint;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLException("Cannot set savepoint when autocommit is on.");
        }
        if (this.savepoints == null) {
            this.savepoints = new HashMap<String, Savepoint>();
        }
        if (this.savepoints.containsKey(name)) {
            throw new SQLException("Savepoint " + name + " already exists.");
        }
        IRISSavepoint savepoint = new IRISSavepoint(this, name, -1);
        this.savepoints.put(name, savepoint);
        return savepoint;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLException("Cannot rollback to savepoint when autocommit is on.");
        }
        if (!this.savepoints.containsValue(savepoint)) {
            throw new SQLException("Savepoint does not exist.");
        }
        ((IRISSavepoint)savepoint).rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Timeout cannot be negative.");
        }
        if (this.closed) {
            return false;
        }
        if (this.activeFetchStatement != null) {
            return true;
        }
        try {
            this.device.setSoTimeout(timeout * 1000);
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(PING);
                this.outMessage.send(this.messageCount.getCount());
                this.inMessage.readMessage(0, 0, 0);
            }
            this.device.setSoTimeout(this.conParams.networkTimeout);
        }
        catch (Exception e) {
            this.device.setSoTimeout(this.conParams.networkTimeout);
            return false;
        }
        return true;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open.", "08003");
        }
        return (String)this.clientInfo.get(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open.", "08003");
        }
        return this.clientInfo;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException("Connection not open.", null, (Throwable)new SQLException("Connection not open.", "08003"));
        }
        if (!this.clientInfo.containsKey(name)) {
            return;
        }
        if (value == null) {
            value = "";
        }
        if (this.clientInfo.getProperty(name).equals(value)) {
            return;
        }
        Properties info = new Properties();
        info.put(name, value);
        try {
            this.sendSetClientInfo(info);
        }
        catch (Exception e) {
            throw new SQLClientInfoException(e.getMessage(), null, (Throwable)e);
        }
        this.clientInfo.put(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException("Connection not open.", null, (Throwable)new SQLException("Connection not open.", "08003"));
        }
        if (properties.isEmpty()) {
            return;
        }
        Properties info = new Properties();
        this.modifyClientInfo("ApplicationName", properties, info);
        this.modifyClientInfo("ClientHostname", properties, info);
        this.modifyClientInfo("ClientUser", properties, info);
        this.modifyClientInfo("MachineName", properties, info);
        this.modifyClientInfo("UserInfo", properties, info);
        try {
            this.sendSetClientInfo(info);
        }
        catch (Exception e) {
            throw new SQLClientInfoException(e.getMessage(), null, (Throwable)e);
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public final String getHostAddress() {
        return this.device.socket.getLocalAddress().getHostAddress();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open.", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(GET_SCHEMA);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readMessage(0, 0, 0);
            return this.inMessage.wire.getString();
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open.", "08003");
        }
        this.conParams.networkTimeout = milliseconds;
        this.device.conParams.networkTimeout = milliseconds;
        this.device.setSoTimeout(milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open.", "08003");
        }
        return this.device.getSoTimeout();
    }

    public int getStatementMaxCacheSize() {
        return this.conParams.maxStatementCacheSize;
    }

    public void setStatementMaxCacheSize(int size) {
        if (this.conParams.maxStatementCacheSize == size) {
            return;
        }
        if (size < 5) {
            this.conParams.maxStatementCacheSize = 5;
            this.cachedPrepares.cachedStatementsToRemove = 1;
        } else {
            this.conParams.maxStatementCacheSize = size;
            this.cachedPrepares.cachedStatementsToRemove = this.conParams.maxStatementCacheSize / 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamPrefetchSize(int size) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open.", "08003");
        }
        if (size < 0) {
            throw new SQLException("Prefetch size cannot be negative.");
        }
        if (size != this.conParams.streamPrefetchSize) {
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(STREAM_SET_PREFETCH_SIZE);
                this.outMessage.wire.set(size);
                this.outMessage.send(this.messageCount.getCount());
                this.inMessage.readMessage(0, 0, 0);
            }
            this.conParams.streamPrefetchSize = size;
        }
    }

    public int getStreamPrefetchSize() {
        return this.conParams.streamPrefetchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueryPrefetchSize(int size) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open.", "08003");
        }
        if (size < 0) {
            throw new SQLException("Query prefetch size cannot be negative.");
        }
        if (size != this.conParams.queryPrefetchSize) {
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(SET_QUERY_PREFETCH_SIZE);
                this.outMessage.wire.set(size);
                this.outMessage.send(this.messageCount.getCount());
                this.inMessage.readMessage(0, 0, 0);
            }
            this.conParams.queryPrefetchSize = size;
        }
    }

    public int getQueryPrefetchSize() {
        return this.conParams.queryPrefetchSize;
    }

    public Master getMaster() throws SQLException {
        if (this.master == null) {
            this.master = new Master(this, this.conParams.host, this.conParams.port, this.conParams.namespace, this.conParams.username, this.conParams.password, this.conParams.getLogFileName());
        }
        return this.master;
    }

    private IRISPreparedStatement getOrCreatePossiblyShardedIRISPreparedStatement(int rst, int rsc, String sql, String agkc) throws SQLException {
        IRISPreparedStatement s = new IRISPreparedStatement(this, rst, rsc, sql, agkc);
        if (s.shardedInsert && !this.conParams.isPiped && s.parameters.userParametersSize() > 0) {
            s.close();
            s = new IRISPreparedShardedStatement(this.getMaster(), this, rst, rsc, sql, agkc);
        }
        return s;
    }

    public boolean isLog() {
        return this.conParams.getLogFile() != null;
    }

    public void writeToLog(String msg) {
        if (this.isLog()) {
            this.conParams.getLogFile().logApi(msg);
        }
    }

    public LogFileStream getLogFile() {
        return this.conParams.getLogFile();
    }

    public void setLogFile(String logFilePath) throws SQLException {
        this.conParams.setLogFile(logFilePath);
    }

    public void setLogFile(LogFileStream lf) throws SQLException {
        this.conParams.setLogFile(lf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int xepCallError(byte[] data, int length) throws Exception {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.outputStream.write(data, 0, length + 14);
            if (this.isLog()) {
                this.getLogFile().dump(data, 0, length, 1, null, this.connectionInfo.srvJobNumber, this.device.hashCode());
            }
            this.outMessage.outputStream.flush();
            return this.inMessage.readHeaderXEP(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ListReader xepCallReturn(byte[] data, int length) throws Exception {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.outputStream.write(data, 0, length + 14);
            if (this.isLog()) {
                this.getLogFile().dump(data, 0, length + 14, 1, null, this.connectionInfo.srvJobNumber, this.device.hashCode());
            }
            this.outMessage.outputStream.flush();
            byte[] array = this.inMessage.readBytesXEP();
            return new ListReader(array, array.length, this.connectionInfo.serverLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<byte[]> xepCallReturnListByteArrays(byte[] data, int length) throws Exception {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.outputStream.write(data, 0, length + 14);
            if (this.isLog()) {
                this.getLogFile().dump(data, 0, length, 1, null, this.connectionInfo.srvJobNumber, this.device.hashCode());
            }
            this.outMessage.outputStream.flush();
            return this.inMessage.readListofByteArraysXEP2();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] xepSendBytes(byte[] header, int headerLength, byte[] data, int dataLength) throws Exception {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.outputStream.write(header, 0, headerLength);
            this.outMessage.outputStream.write(data, 0, dataLength);
            if (this.isLog()) {
                this.getLogFile().dump(data, 0, dataLength, 1, header, this.connectionInfo.srvJobNumber, this.device.hashCode());
            }
            this.outMessage.outputStream.flush();
            return this.inMessage.readBytesXEP();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xepCall(byte[] data, int length) throws Exception {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.outputStream.write(data, 0, length + 14);
            if (this.isLog()) {
                this.getLogFile().dump(data, 0, length, 1, null, this.connectionInfo.srvJobNumber, this.device.hashCode());
            }
            this.outMessage.outputStream.flush();
        }
    }

    public final ListReader getListReader(byte[] byteArray) {
        return new ListReader(byteArray, byteArray.length, this.connectionInfo.serverLocale);
    }

    public final ListWriter getListWriter(byte[] byteArray) {
        ListWriter list = this.listWriterQueue.poll();
        if (list == null) {
            list = new ListWriter(100000, this.connectionInfo);
        }
        list.setList(byteArray);
        return list;
    }

    public final ListWriter getListWriter() {
        ListWriter list = this.listWriterQueue.poll();
        if (list == null) {
            list = new ListWriter(100000, this.connectionInfo);
        }
        return list;
    }

    public final void recycleListWriter(ListWriter idList) {
        idList.clearList();
        this.listWriterQueue.add(idList);
    }

    public void setGateway(JavaGateway gateway) {
        this.gateways.set(gateway);
        this.closed = false;
    }

    public JavaGateway getGateway() {
        JavaGateway gateway = this.gateways.get();
        if (gateway == null) {
            gateway = new JavaGateway(this);
            this.gateways.set(gateway);
        }
        return gateway;
    }

    public void releaseIRISObjects() throws SQLException {
        IRIS iris = IRIS.createIRIS(this);
        iris.releaseClosedIrisObjects(true);
    }

    public void setOutputRedirectHandler(String className, String methodName) throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        Class<?> clazz = this.getGateway().loadClass(className);
        this.outputRedirectHandler = clazz.getMethod(methodName, String.class);
    }

    public void registry_NetRemoteObject_insert(String oref, Object object, Type type) {
        this.registry_oref_to_object.put(oref, object);
        this.registry_oref_to_type.put(oref, type);
    }

    public void registry_NetRemoteObject_remove_by_oref(String oref) {
        this.registry_oref_to_object.remove(oref);
        this.registry_oref_to_type.remove(oref);
    }

    public void registry_IRISObject_insert(String oref, WeakReference<IRISObject> irisobject) {
        this.registry_oref_to_irisobject.put(oref, irisobject);
    }

    public void registry_IRISObject_remove_by_oref(String oref) {
        this.registry_oref_to_irisobject.remove(oref);
    }

    public Object registry_NetRemoteObject_get_object_from_oref(String oref) {
        return this.registry_oref_to_object.get(oref);
    }

    public Type registry_NetRemoteObject_get_type_from_oref(String oref) {
        return this.registry_oref_to_type.get(oref);
    }

    public String registry_NetRemoteObject_get_oref_from_object(Object javaObject) {
        for (String key : this.registry_oref_to_object.keySet()) {
            if (this.registry_oref_to_object.get(key) != javaObject) continue;
            return key;
        }
        return null;
    }

    public String registry_map_object_to_oref(InStream caller_inMessage, OutStream caller_outMessage, Object obj) throws SQLException {
        return this.registry_map_object_to_oref(caller_inMessage, caller_outMessage, "%Net.Remote.Object", obj, obj.getClass(), this.messageCount.getCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registry_map_object_to_oref(InStream caller_inMessage, OutStream caller_outMessage, String iris_classname, Object obj, Type type, int sequenceNumber) throws SQLException {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            caller_outMessage.wire.writeHeader(MESSAGE_JAVA_OBJECT_CREATED);
            caller_outMessage.wire.set(1);
            caller_outMessage.wire.set(iris_classname);
            caller_outMessage.send(sequenceNumber);
            caller_inMessage.readMessage(sequenceNumber);
            String oref = caller_inMessage.wire.getString();
            if (oref != null && oref.equals("error")) {
                throw new SQLException(caller_inMessage.wire.getString());
            }
            if (oref != null) {
                this.registry_NetRemoteObject_insert(oref, obj, type);
                ArrayList<String> arrayList = this.registry_closed_IRISObject;
                synchronized (arrayList) {
                    this.registry_closed_IRISObject.add(oref);
                }
            }
            return oref;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object registry_map_oref_to_object(String oref) throws SQLException {
        Object obj = null;
        if (this.registry_oref_to_object != null) {
            obj = this.registry_oref_to_object.get(oref);
        }
        boolean createdProxy = false;
        if (obj == null) {
            WeakReference objReference = (WeakReference)this.registry_oref_to_irisobject.get(oref);
            if (objReference != null) {
                obj = objReference.get();
            }
            if (obj == null) {
                try {
                    obj = new IRISObject(this, oref);
                }
                catch (SQLException ex) {
                    ArrayList<String> arrayList = this.registry_closed_IRISObject;
                    synchronized (arrayList) {
                        this.registry_closed_IRISObject.add(oref);
                    }
                    throw ex;
                }
                createdProxy = true;
            }
        }
        if (!createdProxy) {
            ArrayList<String> arrayList = this.registry_closed_IRISObject;
            synchronized (arrayList) {
                this.registry_closed_IRISObject.add(oref);
            }
        }
        return obj;
    }

    public String registry_NetRemoteObject_IRISObject_get_oref_from_object(Object javaObject) {
        return this.registry_NetRemoteObject_IRISObject_get_oref_from_object(javaObject, javaObject.getClass());
    }

    public String registry_NetRemoteObject_IRISObject_get_oref_from_object(Object javaObject, Type type) {
        if (this.registry_oref_to_object != null) {
            for (String key : this.registry_oref_to_object.keySet()) {
                if (this.registry_oref_to_object.get(key) != javaObject || this.registry_oref_to_type.get(key) != type) continue;
                return key;
            }
        }
        for (String key : this.registry_oref_to_irisobject.keySet()) {
            WeakReference objReference = (WeakReference)this.registry_oref_to_irisobject.get(key);
            if (objReference == null || objReference.get() != javaObject) continue;
            return key;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeUnusedIrisObject(ListItem it) throws SQLException {
        if (DBList.isOREF(it.type)) {
            String oref = DBList.getString(it, this.connectionInfo.serverLocale);
            ArrayList<String> arrayList = this.registry_closed_IRISObject;
            synchronized (arrayList) {
                this.registry_closed_IRISObject.add(oref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeUnusedIrisObject(ListReader reader) throws SQLException {
        String oref = reader.getNextOREF();
        if (oref != null) {
            ArrayList<String> arrayList = this.registry_closed_IRISObject;
            synchronized (arrayList) {
                this.registry_closed_IRISObject.add(oref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getClosedIrisObjects() {
        String returnValue = null;
        ArrayList<String> arrayList = this.registry_closed_IRISObject;
        synchronized (arrayList) {
            if (this.registry_closed_IRISObject.size() > 0) {
                StringBuilder sbString = new StringBuilder("");
                for (String oref : this.registry_closed_IRISObject) {
                    sbString.append(oref).append(",");
                }
                returnValue = sbString.toString();
                this.registry_closed_IRISObject.clear();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String dump_proxy_maps() {
        String result = "NetRemoteObjectMap:";
        boolean is_first = true;
        for (String key : this.registry_oref_to_object.keySet()) {
            String type = this.registry_NetRemoteObject_get_type_from_oref(key).getTypeName();
            String hex_string = "0x" + Integer.toHexString(this.registry_oref_to_object.get(key).hashCode());
            result = result + (is_first ? "" : ",") + key + " = " + hex_string + (type == "" ? "" : " as " + type);
            is_first = false;
        }
        ArrayList<String> arrayList = this.registry_closed_IRISObject;
        synchronized (arrayList) {
            result = result + "\nIRISObjectMap:";
            is_first = true;
            for (String key : this.registry_oref_to_irisobject.keySet()) {
                IRISObject irisobject = (IRISObject)((WeakReference)this.registry_oref_to_irisobject.get(key)).get();
                String hex_string = irisobject != null ? "0x" + Integer.toHexString(irisobject.hashCode()) : "(deleted)";
                result = result + (is_first ? "" : ",") + key + " = " + hex_string;
                is_first = false;
            }
            result = result + "\nPendingReleaseList:";
            is_first = true;
            for (String oref : this.registry_closed_IRISObject) {
                result = result + (is_first ? "" : ",") + oref;
                is_first = false;
            }
        }
        return result;
    }

    static class Feature {
        static final int optionNone = 0;
        static final int optionFastSelect = 1;
        static final int optionFastInsert = 2;
        static final int optionFastSelectAndInsert = 3;
        static final int optionDurableTransactions = 4;
        static final int optionNotNullable = 8;
        static final int optionColumnarFI = 16;
        static final int optionRedirectOutput = 32;
        static final int optionAllowedOptions = 63;
        static final int optionDefaultOptions = 59;

        Feature() {
        }

        static boolean isFastOption(int f) {
            return Feature.isFastSelectOption(f) || Feature.isFastInsertOption(f);
        }

        static boolean isFastSelectOption(int f) {
            return (f & 1) == 1;
        }

        static boolean isFastInsertOption(int f) {
            return (f & 2) == 2;
        }

        static boolean isFastColumnarOption(int f) {
            return (f & 0x10) == 16;
        }
    }

    static final class CachedPrepare
    extends CachedSQL {
        int serverCursorNumber;
        Statement ownedBy;
        List<IRISStatement.Column> columns;
        boolean hasStreamColumns;
        boolean hasStreamParameters;
        boolean multipleResultSets;
        int statementFeatureOption;
        int maxRowItemCount;
        int keyCount;
        boolean shardedInsert;
        boolean batchInsertErrorFormat = false;

        CachedPrepare(IRISStatement stmt, boolean setOwner) {
            super(stmt);
            this.serverCursorNumber = stmt.serverCursorNumber;
            this.ownedBy = setOwner ? stmt : null;
            if (stmt.columns != null) {
                this.columns = new ArrayList<IRISStatement.Column>(stmt.columns);
            }
            this.hasStreamColumns = stmt.hasStreamColumns;
            this.hasStreamParameters = stmt.hasStreamParameters;
            this.multipleResultSets = stmt.multipleResultSets;
            this.statementFeatureOption = stmt.statementFeatureOption;
            this.maxRowItemCount = stmt.maxRowItemCount;
            this.keyCount = stmt.keyCount;
            this.shardedInsert = stmt.shardedInsert;
            this.batchInsertErrorFormat = stmt.batchInsertErrorFormat;
        }
    }

    static class CachedSQL {
        int hasReturnValue;
        IRISStatement.StatementType statementType;
        String sqlText;
        ParameterCollection parameters;
        int resultSetConcurrency;
        ListWriter additionalParameterInfo;
        int refCount;

        CachedSQL(IRISStatement stmt) {
            this.hasReturnValue = stmt.hasReturnValue;
            this.statementType = stmt.statementType;
            this.sqlText = stmt.sqlText;
            this.resultSetConcurrency = stmt.resultSetConcurrency;
            this.parameters = new ParameterCollection(stmt.parameters, false);
            this.additionalParameterInfo = stmt.additionalParameterInfo;
            this.refCount = 1;
        }
    }

    public static final class MessageCount {
        int count = -1;

        public final synchronized int getCount() {
            this.count += 2;
            return this.count;
        }
    }
}

