/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.ConnectionPoolManager;
import com.intersystems.jdbc.IRISDataSource;
import com.intersystems.jdbc.IRISDriver;
import com.intersystems.jdbc.IRISPool;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class IRISConnectionPoolDataSource
extends IRISDataSource
implements ConnectionPoolDataSource {
    int maxPoolSize = 40;
    int minPoolSize = 0;
    int connectionWaitTimeout = 0;
    boolean first = true;

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        if (this.first) {
            this.reconcileURLandProps();
            this.first = false;
        }
        try {
            return IRISDriver.CPManager.getConnection(this);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public PooledConnection getPooledConnection(String usr, String pwd) throws SQLException {
        this.username = usr;
        this.password = pwd;
        if (this.first) {
            this.reconcileURLandProps();
            this.first = false;
        }
        return this.getPooledConnection();
    }

    public void restartConnectionPool() throws SQLException {
        IRISPool pool = ConnectionPoolManager.getPool(this);
        if (pool != null) {
            pool.restartConnectionPool();
        }
    }

    public int getPoolCount() {
        IRISPool pool = ConnectionPoolManager.getPool(this);
        if (pool != null) {
            return pool.getPoolCount();
        }
        return 0;
    }

    public int validatePoolCount() throws SQLException {
        IRISPool pool = ConnectionPoolManager.getPool(this);
        if (pool != null) {
            pool.cleanIdleConnectionPool(this);
            return pool.getPoolCount();
        }
        return 0;
    }

    public IRISPool getPool() {
        return ConnectionPoolManager.getPool(this);
    }

    @Override
    public void setAccessToken(String token) throws SQLException {
        throw new SQLException("OAuth2 AccessToken cannot be used in a pooled connection!");
    }

    public void setMaxPoolSize(int max) {
        this.maxPoolSize = max;
        IRISPool pool = ConnectionPoolManager.getPool(this);
        if (pool != null) {
            pool.setMaxPoolSize(max);
        }
    }

    public int getMaxPoolSize() {
        IRISPool pool = ConnectionPoolManager.getPool(this);
        if (pool != null) {
            return pool.getMaxPoolSize();
        }
        return this.maxPoolSize;
    }

    public void setMinPoolSize(int min) {
        this.minPoolSize = min;
        IRISPool pool = ConnectionPoolManager.getPool(this);
        if (pool != null) {
            pool.setMinPoolSize(min);
        }
    }

    public int getMinPoolSize() {
        IRISPool pool = ConnectionPoolManager.getPool(this);
        if (pool != null) {
            pool.getMinPoolSize();
        }
        return this.minPoolSize;
    }

    public void setConnectionWaitTimeout(int timeout) {
        this.connectionWaitTimeout = timeout;
        IRISPool pool = ConnectionPoolManager.getPool(this);
        if (pool != null) {
            pool.setConnectionWaitTimeout(timeout);
        }
    }

    public int getConnectionWaitTimeout() {
        IRISPool pool = ConnectionPoolManager.getPool(this);
        if (pool != null) {
            pool.getConnectionWaitTimeout();
        }
        return this.connectionWaitTimeout;
    }

    public void setConnectionLifetime(int conLifeTime) {
        this.connectionLifetime = conLifeTime;
    }

    public int getConnectionLifetime() {
        return this.connectionLifetime;
    }

    public void setValidateOnConnect(boolean p) {
        this.ping = p;
    }

    public boolean getValidateOnConnect() {
        return this.ping;
    }
}

