/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.ConnectionParameters;
import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.IRISConnectionPoolDataSource;
import com.intersystems.jdbc.IRISDriver;
import com.intersystems.jdbc.IRISPooledConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class IRISDataSource
extends ConnectionParameters
implements DataSource {
    static IRISDriver driver;
    String dataSource = null;
    String description = null;

    @Override
    public Connection getConnection() throws SQLException {
        if (this instanceof IRISConnectionPoolDataSource) {
            IRISPooledConnection pc = (IRISPooledConnection)((IRISConnectionPoolDataSource)this).getPooledConnection();
            if (pc != null) {
                return pc.getConnection();
            }
            return null;
        }
        try {
            if (this.addToPool) {
                try {
                    IRISPooledConnection pc = (IRISPooledConnection)IRISDriver.CPManager.getConnection((ConnectionParameters)this.clone());
                    if (pc != null) {
                        return pc.getConnection();
                    }
                }
                catch (Exception pc) {
                    // empty catch block
                }
            }
            return new IRISConnection((ConnectionParameters)this.clone());
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Connection getConnection(String usr, String pwd) throws SQLException {
        if (this instanceof IRISConnectionPoolDataSource) {
            this.username = usr;
            this.password = pwd;
            IRISPooledConnection pc = (IRISPooledConnection)((IRISConnectionPoolDataSource)this).getPooledConnection();
            if (pc != null) {
                return pc.getConnection();
            }
            return null;
        }
        ConnectionParameters cp = null;
        try {
            cp = (ConnectionParameters)this.clone();
            cp.username = usr;
            cp.password = pwd;
            return new IRISConnection(cp);
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void setUser(String user) {
        this.username = user;
        this.accesstoken = null;
    }

    public void setPassword(String pwd) {
        this.password = pwd;
        this.accesstoken = null;
    }

    public void setAccessToken(String token) throws SQLException {
        if (this.pooled != null) {
            throw new SQLException("OAuth2 AccessToken cannot be used in a pooled connection!");
        }
        this.accesstoken = token;
    }

    @Override
    public void setServerName(String serverName) {
        this.setHost(serverName);
    }

    @Override
    public void setPortNumber(int portNumber) {
        this.port = portNumber;
    }

    @Override
    public void setDatabaseName(String databaseName) {
        this.namespace = databaseName;
    }

    public void setEventClass(String eventClassName) {
        this.eventClass = this.eventClass == null ? "" : eventClassName;
    }

    public void setNetworkTimeout(int timeout) {
        this.networkTimeout = timeout;
    }

    public void setCommitTimeout(int timeout) {
        this.commitTimeout = timeout;
    }

    public void setNodelay(boolean noDelay) {
        this.nodelay = noDelay;
    }

    @Override
    public void setConnectionSecurityLevel(int level) throws SQLException {
        super.setConnectionSecurityLevel(level);
    }

    @Override
    public int getLoginTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.connectionTimeout = seconds;
    }

    public String getDataSourceName() {
        return this.dataSource;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSource = dataSourceName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getServicePrincipalName() {
        return this.principalName;
    }

    public void setServicePrincipalName(String name) {
        this.principalName = name;
    }

    public String getSSLConfigurationName() {
        return this.sSLConfigName;
    }

    public void setSSLConfigurationName(String name) {
        this.sSLConfigName = name;
    }

    public String getKeyRecoveryPassword() {
        return this.keyRecoveryPassword;
    }

    public void setKeyRecoveryPassword(String password) {
        this.keyRecoveryPassword = password;
    }

    public int getDefaultTransactionIsolation() {
        return this.isolationLevel;
    }

    public void setDefaultTransactionIsolation(int level) throws SQLException {
        this.setTransactionIsolationLevel(level);
    }

    public int getPreparseCacheSize() {
        return this.preparseCacheSize;
    }

    public void setPreparseCacheSize(int size) {
        this.preparseCacheSize = size;
    }

    public int getStreamPrefetchSize() {
        return this.streamPrefetchSize;
    }

    public void setStreamPrefetchSize(int size) {
        this.streamPrefetchSize = size;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not supported.");
    }

    static {
        try {
            driver = (IRISDriver)Class.forName("com.intersystems.jdbc.IRISDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

