/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.IRISCallableStatement;
import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.IRISWrapper;
import com.intersystems.util.VersionInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;

public final class IRISDatabaseMetaData
extends IRISWrapper
implements DatabaseMetaData {
    private IRISConnection connection;

    IRISDatabaseMetaData(IRISConnection conn) {
        this.connection = conn;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public synchronized String getURL() throws SQLException {
        return this.connection.conParams.getURL();
    }

    @Override
    public synchronized String getUserName() throws SQLException {
        return this.connection.conParams.username;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "InterSystems IRIS";
    }

    @Override
    public synchronized String getDatabaseProductVersion() throws SQLException {
        return this.connection.connectionInfo.serverVersion;
    }

    @Override
    public String getDriverName() throws SQLException {
        return "InterSystems IRIS JDBC";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return VersionInfo.getClientVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return VersionInfo.getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return VersionInfo.getMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public synchronized String getIdentifierQuoteString() throws SQLException {
        if (this.connection.connectionInfo.delimitedIds == 1) {
            return "\"";
        }
        return " ";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "%AFTERHAVING,%ALLINDEX,%ALPHAUP,%ALTER,%BEGTRANS,%CHECKPRIV,%CLASSPARAMETER,%DBUGFULL,%DELDATA,%DESCRIPTION,%EXACT,%EXTERNAL,%FILE,%FIRSTTABLE,%FLATTEN,%FOREACH,%FULL,%IDADDED,%IGNOREINDEX,%IGNOREINDICES,%INLIST,%INORDER,%INTERNAL,%INTEXT,%INTRANS,%INTRANSACTION,%MATCHES,%MCODE,%MERGE,%NOCHECK,%NODELDATA,%NOFLATTEN,%NOINDEX,%NOLOCK,%NOMERGE,%NOSVSO,%NOTOPOPT,%NOTRIGGER,%NOUNIONOROPT,%NUMROWS,%ODBCOUT,%PUBLICROWID,%ROUTINE,%ROWCOUNT,%STARTSWITH,%STARTTABLE,%STRING,%UPPER,BIT,BIT_LENGTH,ENDEXEC,EXCEPTION,HAVING,SQLERROR,STATISTICS,SYSDATE,TOP";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,CEILING,COS,COT,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "$EXTRACT,$FIND,$LENGTH,$PIECE,ASCII,CHAR,CHARACTER_LENGTH,CONCAT,INSTR,LCASE,LEFT,LENGTH,LTRIM,POSITION,REPEAT,REPLACE,REPLICATE,REVERSE,RIGHT,RPAD,RTRIM,SPACE,SUBSTR,SUBSTRING,STUFF,TRIM,UCASE";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "ABS,ACOS,ASCII,ASIN,ATAN,CEILING,CHAR,CONCAT,CONVERT,COS,COT,CURDATE,CURTIME,DATABASE,DAY,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,EXP,FLOOR,HOUR,IFNULL,LCASE,LEFT,LENGTH,LOG,LOG10,LTRIM,MINUTE,MOD,MONTH,MONTHNAME,NOW,PI,POWER,QUARTER,REPEAT,RIGHT,ROUND,RTRIM,SECOND,SIGN,SIN,SPACE,SQRT,SUBSTRING,TAN,TIMESTAMPADD,TIMESTAMPDIFF,TRUNCATE,UCASE,USER,WEEK,YEAR";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE,CURTIME,DATEADD,DATEDIFF,DATENAME,DATEPART,DAY,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,GETDATE,GETUTCDATE,HOUR,LAST_DAY,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,SYSDATE,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "%";
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "Schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "Stored Procedure";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public synchronized int getDefaultTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        switch (fromType) {
            case -7: 
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                return false;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return toType == 4 || toType == 12;
            }
            case 1: {
                return toType == 4 || toType == 12 || toType == 91 || toType == 92;
            }
            case 12: {
                return toType == 4 || toType == 12 || toType == 91 || toType == 92 || toType == 93;
            }
            case 91: {
                return toType == 4 || toType == 12 || toType == 91 || toType == 93;
            }
            case 92: {
                return toType == 4 || toType == 12 || toType == 92;
            }
            case 93: {
                return toType == 12 || toType == 91 || toType == 92;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return this.is20081plus();
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public synchronized boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        return level != 0 && (this.connection.connectionInfo.supportedIsolationLevels & level) == level;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (procedureNamePattern == null || procedureNamePattern.length() == 0) {
            procedureNamePattern = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_PROCEDURES, procedureNamePattern, schemaPattern, null, null);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (procedureNamePattern == null || procedureNamePattern.length() == 0) {
            procedureNamePattern = "%";
        }
        if (columnNamePattern == null || columnNamePattern.length() == 0) {
            columnNamePattern = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_PROCEDURECOL, procedureNamePattern, columnNamePattern, schemaPattern, null);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String type;
        if (types == null || types.length == 0) {
            type = "TABLE, VIEW, GLOBAL TEMPORARY, SYSTEM TABLE, SYSTEM VIEW";
        } else {
            type = types[0];
            for (int i = 1; i < types.length; ++i) {
                type = type + "," + types[i];
            }
        }
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (tableNamePattern == null || tableNamePattern.length() == 0) {
            tableNamePattern = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_TABLES, tableNamePattern, type, schemaPattern, null);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.executeCatalogQuery(IRISConnection.JDBC_SCHEMAS, "%", null, null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.executeCatalogQuery(IRISConnection.JDBC_CATALOGS, null, null, null, null);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return this.executeCatalogQuery(IRISConnection.JDBC_TABLETYPES, null, null, null, null);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (tableNamePattern == null || tableNamePattern.length() == 0) {
            tableNamePattern = "%";
        }
        if (columnNamePattern == null || columnNamePattern.length() == 0) {
            columnNamePattern = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_COLUMNS, tableNamePattern, columnNamePattern, schemaPattern, null);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        if (schema == null) {
            schema = "%";
        }
        if (table == null || table.length() == 0) {
            table = "%";
        }
        if (columnNamePattern == null || columnNamePattern.length() == 0) {
            columnNamePattern = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_COLUMNPRIV, table, columnNamePattern, schema, null);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (tableNamePattern == null || tableNamePattern.length() == 0) {
            tableNamePattern = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_TABLEPRIV, tableNamePattern, schemaPattern, null, null);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        if (schema == null) {
            schema = "%";
        }
        if (table == null || table.length() == 0) {
            table = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_BESTROWID, table, schema, null, null);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        if (table == null || table.length() == 0) {
            table = "%";
        }
        if (schema == null) {
            schema = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_VERSIONCOL, table, schema, null, null);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        if (schema == null) {
            schema = "%";
        }
        if (table == null || table.length() == 0) {
            table = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_PRIMARYKEYS, table, schema, null, null);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        if (schema == null) {
            schema = "%";
        }
        if (table == null || table.length() == 0) {
            table = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_IMPORTEDKEYS, table, schema, null, null);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        if (schema == null) {
            schema = "%";
        }
        if (table == null || table.length() == 0) {
            table = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_EXPORTEDKEYS, table, schema, null, null);
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        if (primarySchema == null) {
            primarySchema = "%";
        }
        if (foreignSchema == null) {
            foreignSchema = "%";
        }
        if (primaryTable == null || primaryTable.length() == 0) {
            primaryTable = "%";
        }
        if (foreignTable == null || foreignTable.length() == 0) {
            foreignTable = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_CROSSREFERENCE, primaryTable, foreignTable, primarySchema, foreignSchema);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return this.executeCatalogQuery(IRISConnection.JDBC_TYPEINFO, null, null, null, null);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (schema == null) {
            schema = "%";
        }
        if (table == null || table.length() == 0) {
            table = "%";
        }
        if (unique) {
            return this.executeCatalogQuery(IRISConnection.JDBC_INDEXINFO, table, schema, "0", null);
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_INDEXINFO, table, schema, "1", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ResultSet executeCatalogQuery(byte[] kind, String p1, String p2, String p3, String p4) throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            IRISCallableStatement cs = new IRISCallableStatement(this.connection);
            cs.serverCursorNumber = ++this.connection.nextServerCursorNumber;
            this.connection.outMessage.wire.writeHeader(cs.serverCursorNumber, kind);
            this.connection.outMessage.wire.set(1);
            if (p4 != null) {
                this.connection.outMessage.wire.set(4);
            } else if (p3 != null) {
                this.connection.outMessage.wire.set(3);
            } else if (p2 != null) {
                this.connection.outMessage.wire.set(2);
            } else if (p1 != null) {
                this.connection.outMessage.wire.set(1);
            } else {
                this.connection.outMessage.wire.set(0);
            }
            if (p1 != null) {
                this.connection.outMessage.wire.set(p1);
                if (p2 != null) {
                    this.connection.outMessage.wire.set(p2);
                    if (p3 != null) {
                        this.connection.outMessage.wire.set(p3);
                        if (p4 != null) {
                            this.connection.outMessage.wire.set(p4);
                        }
                    }
                }
            }
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (cs.input.readMessage(cs, 0, 100) == 100) {
                cs.fetchDone = true;
            }
            cs.input.wire.getInt();
            cs.columnInfo(cs.input.wire);
            cs.createResultSet();
            if (cs.input.readMessage(cs, 2, 100) == 100) {
                cs.fetchDone = true;
            }
            return cs.myResultSet;
        }
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type != 1005;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return type != 1005;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return type == 1004;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return this.executeCatalogQuery(IRISConnection.JDBC_UDTS, null, null, null, null);
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return this.is20081plus();
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        if (catalog == null) {
            catalog = "%";
        }
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (typeNamePattern == null || typeNamePattern.length() == 0) {
            typeNamePattern = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_SUPER_TYPES, catalog, schemaPattern, typeNamePattern, null);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        if (catalog == null) {
            catalog = "%";
        }
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (typeNamePattern == null || typeNamePattern.length() == 0) {
            typeNamePattern = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_SUPER_TABLES, catalog, schemaPattern, typeNamePattern, null);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        if (catalog == null) {
            catalog = "%";
        }
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (typeNamePattern == null || typeNamePattern.length() == 0) {
            typeNamePattern = "%";
        }
        if (attributeNamePattern == null || attributeNamePattern.length() == 0) {
            attributeNamePattern = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_GET_ATTRIBUTES, catalog, schemaPattern, typeNamePattern, attributeNamePattern);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.connection.connectionInfo.serverMajorVersion;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.connection.connectionInfo.serverMinorVersion;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return VersionInfo.getJDBCMajorVersion();
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return VersionInfo.getJDBCMinorVersion();
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 1;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (functionNamePattern == null || functionNamePattern.length() == 0) {
            functionNamePattern = "%";
        }
        if (columnNamePattern == null || columnNamePattern.length() == 0) {
            columnNamePattern = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_GET_FUNCTION_COLUMNS, functionNamePattern, columnNamePattern, schemaPattern, null);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (functionNamePattern == null || functionNamePattern.length() == 0) {
            functionNamePattern = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_GET_FUNCTIONS, functionNamePattern, schemaPattern, null, null);
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return this.executeCatalogQuery(IRISConnection.JDBC_CLIENT_INFO_PROPERTIES, null, null, null, null);
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_SCHEMAS, schemaPattern, null, null, null);
    }

    private boolean is20081plus() throws SQLException {
        return this.getDatabaseMajorVersion() >= 2008 && this.getDatabaseMinorVersion() >= 1;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_VALID_FOREVER;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (tableNamePattern == null || tableNamePattern.length() == 0) {
            tableNamePattern = "%";
        }
        if (columnNamePattern == null || columnNamePattern.length() == 0) {
            columnNamePattern = "%";
        }
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        return this.executeCatalogQuery(IRISConnection.JDBC_PSEUDO_COLUMNS, tableNamePattern, columnNamePattern, schemaPattern, null);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return true;
    }
}

