/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.ConnectInput;
import com.intersystems.jdbc.ConnectionParameters;
import com.intersystems.jdbc.ConnectionPoolManager;
import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.IRISDriverProperties;
import com.intersystems.jdbc.IRISPooledConnection;
import com.intersystems.util.VersionInfo;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class IRISDriver
implements Driver {
    static ConnectionPoolManager CPManager;
    private static DriverPropertyInfo[] driverPropertyInfo;

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return new ConnectInput((String)url).valid;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        ConnectionParameters cp = new ConnectionParameters(url, info);
        if (cp.valid) {
            if (cp.addToPool) {
                try {
                    IRISPooledConnection pc = (IRISPooledConnection)CPManager.getConnection(cp);
                    if (pc != null) {
                        return pc.getConnection();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new IRISConnection(cp);
        }
        return null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties Info) throws SQLException {
        return driverPropertyInfo;
    }

    @Override
    public int getMajorVersion() {
        return VersionInfo.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return VersionInfo.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not supported.");
    }

    static {
        try {
            IRISDriver d = new IRISDriver();
            CPManager = new ConnectionPoolManager();
            driverPropertyInfo = IRISDriverProperties.getDriverPropertyInfoArray();
            DriverManager.registerDriver(d);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

