/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.ConnectInput;
import com.intersystems.jdbc.ConnectionParameters;
import com.intersystems.jdbc.IRISDriverPropertyInfo;
import java.lang.reflect.Field;
import java.sql.DriverPropertyInfo;
import java.util.HashMap;

enum IRISDriverProperties {
    USER("user", "", "Username", true, null, ConnectInput.class, "username"),
    PASSWORD("password", "", "Password", true, null, ConnectInput.class, "password"),
    ACCESSTOKEN("AccessToken", "", "AccessToken", true, null, ConnectInput.class, "accesstoken"),
    TCP_NODELAY("TCP_NODELAY", "true", "TCP/IP NoDelay Flag", false, new String[]{"true", "false"}, ConnectInput.class, "nodelay"),
    SO_SNDBUF("SO_SNDBUF", null, "TCP/IP SO_SNDBUF value", false, null, ConnectionParameters.class, "soSndBuf"),
    SO_RCVBUF("SO_RCVBUF", null, "TCP/IP SO_RCVBUF value", false, null, ConnectionParameters.class, "soRcvBuf"),
    TRANSACTION_ISOLATION_LEVEL("TransactionIsolationLevel", null, "Transaction Isolation Level", false, new String[]{"TRANSACTION_READ_UNCOMMITTED", "TRANSACTION_READ_COMMITTED"}, ConnectionParameters.class, "isolationLevel"),
    SERVICE_PRINCIPAL_NAME("service principal name", null, "Service Principal Name", false, null, ConnectionParameters.class, "principalName"),
    CONNECTION_SECURITY_LEVEL("connection security level", null, "Connection Security Level", false, new String[]{"0", "1", "2", "3", "10"}, ConnectInput.class, "securityLevel"),
    SSL_CONFIGURATION_NAME("SSL configuration name", null, "SSL Configuration Name", false, null, ConnectionParameters.class, "sSLConfigName"),
    KEY_RECOVERY_PASSWORD("key recovery password", null, "Key Recovery Password", false, null, ConnectionParameters.class, "keyRecoveryPassword"),
    DIALECT("dialect", null, "SQL Dialect", false, new String[]{"default", "mssql", "sybase"}, ConnectionParameters.class, "sqlDialect"),
    AUTOBALANCE("autobalance", null, "Automatically balance insertions across the shards of the cluster if possible", false, new String[]{"true", "false"}, ConnectionParameters.class, "autobalance"),
    LOADERPOOLSIZE("LoaderPoolSize", null, "Sharded Loader Pool Size", false, null, ConnectionParameters.class, "loaderPoolSize"),
    PIPEJDBC("PipeJDBC", null, "Use IRISPreparedShardedStatement", false, new String[]{"true", "false"}, ConnectionParameters.class, "isPiped"),
    SHARED_MEMORY("SharedMemory", null, "Use shared memory on localhost", false, new String[]{"true", "false"}, ConnectInput.class, "useSharedMemory"),
    SSLContext("SSLContext", null, "SSLContext name", false, null, ConnectionParameters.class, "sslctx"),
    LOG("log", null, "Log File Name", false, null, ConnectInput.class, "logFile"),
    FEATURE_OPTION("FeatureOption", null, "Connection Feature Option", false, new String[]{"NoOption", "OptfastSelect", "OptfastInsert", "OptfastSelectAndInsert"}, ConnectionParameters.class, "featureOption"),
    POOL("pool", "", "ConnectionPooling", true, null, ConnectionParameters.class, "addToPool"),
    NETWORKTIMEOUT("NetworkTimeout", null, "Connection Network Timeout in milliseconds", false, null, ConnectionParameters.class, "networkTimeout"),
    COMMITTIMEOUT("CommitTimeout", null, "Connection Commit Timeout in milliseconds", false, null, ConnectionParameters.class, "commitTimeout");

    final IRISDriverPropertyInfo dpi;

    private IRISDriverProperties(String name, String defaultValue, String desc, boolean req, String[] choose, Class<?> clazz, String field) {
        Field f = null;
        try {
            f = clazz.getDeclaredField(field);
        }
        catch (NoSuchFieldException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        this.dpi = new IRISDriverPropertyInfo(name, defaultValue, desc, req, choose, f);
    }

    public String toString() {
        return this.dpi.name;
    }

    static HashMap<String, IRISDriverProperties> getPropertiesHashMap() {
        HashMap<String, IRISDriverProperties> propertiesHashMap = new HashMap<String, IRISDriverProperties>();
        for (IRISDriverProperties driverProp : IRISDriverProperties.values()) {
            propertiesHashMap.put(driverProp.toString(), driverProp);
        }
        return propertiesHashMap;
    }

    static DriverPropertyInfo[] getDriverPropertyInfoArray() {
        DriverPropertyInfo[] dp = new DriverPropertyInfo[IRISDriverProperties.values().length];
        int i = 0;
        for (IRISDriverProperties driverProp : IRISDriverProperties.values()) {
            dp[i++] = driverProp.dpi;
        }
        return dp;
    }
}

