/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.FakeStream;
import com.intersystems.jdbc.IRISBlob;
import com.intersystems.jdbc.IRISClob;
import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.RealStream;
import com.intersystems.jdbc.Stream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;

public class IRISInputStream
extends InputStream {
    Stream stream = null;
    private boolean closed = false;

    IRISInputStream(IRISConnection con, byte[] oref, int scn, int st, int qt, int mx) throws SQLException {
        this.stream = new RealStream(con, oref, scn, st, qt, mx);
        ((RealStream)this.stream).getStreamSize();
    }

    IRISInputStream(IRISConnection conn, byte[] h, int scn, int type) throws SQLException {
        this.init(conn, h, scn, type);
    }

    IRISInputStream(RealStream s) throws SQLException {
        this.stream = s;
        if (s instanceof IRISBlob) {
            this.stream.streamType = 1;
            this.stream.sqlType = -4;
        } else {
            this.stream.streamType = 0;
            this.stream.sqlType = -1;
        }
        if (this.stream.size > 0 && this.stream.size != this.stream.available) {
            ((RealStream)this.stream).getStreamSize();
        }
    }

    public IRISInputStream(IRISConnection conn, byte[] h, int type) throws SQLException {
        this.init(conn, h, 0, type);
    }

    IRISInputStream(byte[] b, int st, int qt, int mx) throws SQLException {
        this.stream = new FakeStream(b, st, qt, mx);
    }

    private void init(IRISConnection conn, byte[] oref, int scn, int type) throws SQLException {
        this.stream = type == 1 ? new RealStream(conn, oref, scn, 1, -4, 0) : new RealStream(conn, oref, scn, 0, -1, 0);
        ((RealStream)this.stream).getStreamSize();
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("This input stream object has been closed.");
        }
        return this.stream.available();
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) <= 0) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("This input stream object has been closed.");
        }
        if (len == 0) {
            return 0;
        }
        try {
            int l;
            int ret = 0;
            do {
                if ((l = this.stream.fetchStream(b, this.stream.streamType, off + ret, len - ret)) >= 0) continue;
                if (ret == 0) {
                    return l;
                }
                break;
            } while ((ret += l) < len);
            return ret;
        }
        catch (Exception e) {
            throw new IOException("Unable to read stream data: " + e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!(this.stream instanceof IRISBlob) && !(this.stream instanceof IRISClob)) {
            this.stream.close();
        } else {
            ((RealStream)this.stream).releaseReadLock();
        }
    }

    boolean isNull() {
        return this.stream.isNull();
    }

    final String toUnicodeString() throws SQLException {
        try {
            if (this.stream.size == 0) {
                return "";
            }
            InputStreamReader isr = new InputStreamReader((InputStream)this, "UTF-8");
            char[] cb = new char[this.stream.size];
            int i = isr.read(cb);
            return new String(cb, 0, i);
        }
        catch (Exception e) {
            throw new SQLException("Error read stream data " + e.getMessage(), "S1000");
        }
    }

    final byte[] toByte() throws SQLException {
        try {
            byte[] b = new byte[this.stream.size];
            this.stream.RawBytes = b;
            this.read(b, 0, this.stream.size);
            return b;
        }
        catch (Exception e) {
            throw new SQLException("Error reading stream data.", "S1000");
        }
    }

    final byte[] getByteFromStream() throws SQLException {
        try {
            return ((RealStream)this.stream).getByteStream(0L, this.stream.maxStreamSize);
        }
        catch (Exception e) {
            throw new SQLException("Error reading stream data.", "S1000");
        }
    }
}

