/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.IRIS;
import com.intersystems.jdbc.ListItem;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IRISIterator
implements Iterator {
    private final IRIS iris;
    private final String globalName;
    private final Object[] currentSubscriptList;
    private Object currentSubscript;
    private Object currentValue;
    private boolean nodeRemoved;
    private boolean inStartingPosition;

    IRISIterator(IRIS iris, String globalName, Object ... subscripts) {
        this(iris, 0, globalName, subscripts);
    }

    IRISIterator(IRIS iris, int prefetchSizeHint, String globalName, Object ... subscripts) {
        this.iris = iris;
        this.globalName = globalName;
        this.currentSubscriptList = new Object[subscripts.length + 1];
        if (subscripts.length > 0) {
            System.arraycopy(subscripts, 0, this.currentSubscriptList, 0, subscripts.length);
        }
        this.currentSubscriptList[this.currentSubscriptList.length - 1] = null;
        this.currentSubscript = null;
        this.currentValue = null;
        this.nodeRemoved = false;
        this.inStartingPosition = true;
    }

    public void startFrom(Object subscript) {
        this.currentSubscriptList[this.currentSubscriptList.length - 1] = subscript;
        this.currentSubscript = subscript;
        this.currentValue = null;
        this.nodeRemoved = false;
        this.inStartingPosition = true;
    }

    @Override
    public boolean hasNext() {
        try {
            ListItem[] result = this.iris.getNextNode(false, this.globalName, this.currentSubscriptList);
            Object nextSubscript = this.iris.decodeObject(result[0]);
            if (null == nextSubscript) {
                return false;
            }
            if (nextSubscript instanceof byte[] && 0 == ((byte[])nextSubscript).length) {
                return false;
            }
            return "" != nextSubscript;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String next() throws NoSuchElementException {
        Object nextValue;
        Object nextSubscript;
        try {
            ListItem[] result = this.iris.getNextNode(false, this.globalName, this.currentSubscriptList);
            Object nextSub = this.iris.decodeObject(result[0]);
            nextSubscript = null == nextSub ? null : (1 == result[0].type ? (0 == ((byte[])nextSub).length ? null : new String((byte[])nextSub)) : (String)nextSub);
            nextValue = this.iris.decodeObject(result[1]);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        if (nextSubscript == null) {
            throw new NoSuchElementException("There are no nodes after the current one.");
        }
        this.nodeRemoved = false;
        this.inStartingPosition = false;
        this.currentSubscript = nextSubscript;
        this.currentValue = nextValue;
        this.currentSubscriptList[this.currentSubscriptList.length - 1] = this.currentSubscript;
        return nextSubscript;
    }

    @Override
    public void remove() throws IllegalStateException {
        if (this.currentSubscriptList[this.currentSubscriptList.length - 1] == null || this.nodeRemoved || this.inStartingPosition) {
            throw new IllegalStateException("Call next() or previous() to move to an existing node before removing it.");
        }
        Object[] subscriptListToRemove = (Object[])this.currentSubscriptList.clone();
        Object savedCurrentSubscript = this.currentSubscript;
        Object savedCurrentValue = this.currentValue;
        Object savedSubscriptListEnd = this.currentSubscriptList[this.currentSubscriptList.length - 1];
        try {
            this.previous();
        }
        catch (NoSuchElementException ex) {
            this.currentSubscript = null;
            this.currentValue = null;
            this.currentSubscriptList[this.currentSubscriptList.length - 1] = this.currentSubscript;
        }
        this.nodeRemoved = true;
        try {
            this.iris.kill(this.globalName, subscriptListToRemove);
        }
        catch (RuntimeException ex) {
            this.currentSubscript = savedCurrentSubscript;
            this.currentValue = savedCurrentValue;
            this.currentSubscriptList[this.currentSubscriptList.length - 1] = savedSubscriptListEnd;
            this.nodeRemoved = false;
            throw ex;
        }
    }

    public String getSubscriptValue() throws IllegalStateException {
        if (this.nodeRemoved) {
            throw new IllegalStateException("The current node has been removed. Call next() or previous() to move to an existing node before accessing it.");
        }
        if (this.currentSubscript == null) {
            throw new IllegalStateException("Call next() to move to an existing node before accessing it.");
        }
        if (this.inStartingPosition) {
            throw new IllegalStateException("Call next() or previous() to move to an existing node before accessing it.");
        }
        if (null == this.currentSubscript) {
            return null;
        }
        if (this.currentSubscript instanceof byte[]) {
            return new String((byte[])this.currentSubscript);
        }
        return (String)this.currentSubscript;
    }

    public Object getValue() throws IllegalStateException {
        if (this.nodeRemoved) {
            throw new IllegalStateException("The current node has been removed. Call next() or previous() to move to an existing node before accessing it.");
        }
        if (this.currentSubscript == null) {
            throw new IllegalStateException("Call next() to move to an existing node before accessing it.");
        }
        if (this.inStartingPosition) {
            throw new IllegalStateException("Call next() or previous() to move to an existing node before accessing it.");
        }
        return this.currentValue;
    }

    public boolean hasPrevious() {
        try {
            if (this.nodeRemoved) {
                return this.currentSubscript != null;
            }
            ListItem[] result = this.iris.getNextNode(true, this.globalName, this.currentSubscriptList);
            Object previousSubscript = this.iris.decodeObject(result[0]);
            if (null == previousSubscript) {
                return false;
            }
            if (previousSubscript instanceof byte[] && 0 == ((byte[])previousSubscript).length) {
                return false;
            }
            return "" != previousSubscript;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String previous() throws NoSuchElementException {
        Object prevValue;
        Object prevSubscript;
        if (this.nodeRemoved) {
            if (this.currentSubscript == null) {
                throw new NoSuchElementException("There are no nodes before the current one.");
            }
            this.nodeRemoved = false;
            if (this.currentSubscript instanceof byte[]) {
                new String((byte[])this.currentSubscript);
            } else {
                return (String)this.currentSubscript;
            }
        }
        try {
            ListItem[] result = this.iris.getNextNode(true, this.globalName, this.currentSubscriptList);
            Object nextSub = this.iris.decodeObject(result[0]);
            prevSubscript = null == nextSub ? null : (1 == result[0].type ? (0 == ((byte[])nextSub).length ? null : new String((byte[])nextSub)) : (String)nextSub);
            prevValue = this.iris.decodeObject(result[1]);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        if (prevSubscript == null) {
            throw new NoSuchElementException("There are no nodes before the current one.");
        }
        this.inStartingPosition = false;
        this.currentSubscript = prevSubscript;
        this.currentValue = prevValue;
        this.currentSubscriptList[this.currentSubscriptList.length - 1] = this.currentSubscript;
        return prevSubscript;
    }
}

