/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.DBList;
import com.intersystems.jdbc.ListItem;
import com.intersystems.jdbc.ValidateNFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;

public class IRISList {
    private ListItem m_item;
    private int[] m_aOffset;
    private int m_allocatedSize = 100;
    private int m_BucketSize = 1024;
    private int m_listSize = 0;
    byte[] m_tempBuffer = null;
    private int m_lastIndex;
    private String m_locale;
    private boolean m_compactDoubleEnabled = false;
    private int m_currentIndex;

    public IRISList() {
        this.m_item = null;
        this.m_lastIndex = 0;
        this.m_currentIndex = 0;
        this.m_aOffset = new int[this.m_allocatedSize];
    }

    public IRISList(boolean enableCompactDouble) {
        this(null, enableCompactDouble);
    }

    public IRISList(String charSet, boolean enableCompactDouble) {
        this();
        this.m_locale = charSet;
        this.m_compactDoubleEnabled = enableCompactDouble;
    }

    public IRISList(IRISList list) {
        if (null != list.m_item) {
            byte[] buffer = new byte[list.m_listSize];
            System.arraycopy(list.m_item.buffer, 0, buffer, 0, list.m_listSize);
            this.m_item = new ListItem(buffer, list.m_listSize);
            this.m_listSize = list.m_listSize;
            this.m_item.listBufferEnd = 0;
        } else {
            this.m_item = null;
            this.m_listSize = 0;
        }
        this.m_locale = list.getCharSet();
        this.m_allocatedSize = list.m_allocatedSize;
        this.m_BucketSize = list.m_BucketSize;
        this.m_lastIndex = 0;
        this.m_currentIndex = 0;
        this.m_aOffset = new int[this.m_allocatedSize];
        this.m_compactDoubleEnabled = list.m_compactDoubleEnabled;
    }

    public IRISList(byte[] buffer, int length) {
        this.m_item = new ListItem(buffer, length);
        this.m_item.listBufferEnd = 0;
        this.m_lastIndex = 0;
        this.m_listSize = length;
        this.m_currentIndex = 0;
        this.m_aOffset = new int[this.m_allocatedSize];
    }

    public IRISList(byte[] buffer) {
        this(buffer, buffer.length);
    }

    public IRISList(byte[] buffer, int length, String charSet) {
        this.m_item = new ListItem(buffer, length);
        this.m_item.listBufferEnd = 0;
        this.m_lastIndex = 0;
        this.m_listSize = length;
        this.m_currentIndex = 0;
        this.m_aOffset = new int[this.m_allocatedSize];
        this.m_locale = charSet;
    }

    public IRISList(byte[] buffer, String charSet) {
        this(buffer, buffer.length, charSet);
    }

    public IRISList(byte[] buffer, int length, String charSet, boolean enableCompactDouble) {
        this(buffer, length, charSet);
        this.m_compactDoubleEnabled = enableCompactDouble;
    }

    public String getCharSet() {
        return this.m_locale;
    }

    public void setCharSet(String charSet) {
        this.m_locale = charSet;
    }

    public boolean isCompactDoubleEnabled() {
        return this.m_compactDoubleEnabled;
    }

    public void setCompactDoubleEnabled(boolean value) {
        this.m_compactDoubleEnabled = value;
    }

    public Object get(int index) {
        Object ret;
        this.m_currentIndex = this.getItem(index);
        if (this.m_item.isNull) {
            if (-1 == this.m_item.type) {
                return null;
            }
            return new byte[0];
        }
        if (this.m_item.dataLength < 0) {
            return null;
        }
        try {
            switch (this.m_item.type) {
                case 1: {
                    byte[] NewArray = new byte[this.m_item.dataLength];
                    System.arraycopy(this.m_item.buffer, this.m_item.dataOffset, NewArray, 0, this.m_item.dataLength);
                    ret = NewArray;
                    break;
                }
                case 2: {
                    ret = DBList.getString(this.m_item, this.m_locale);
                    break;
                }
                case 4: 
                case 5: {
                    long temp = DBList.getLong(this.m_item);
                    if (temp == (long)((int)temp)) {
                        ret = (int)temp;
                        break;
                    }
                    ret = temp;
                    break;
                }
                case 6: 
                case 7: {
                    ret = DBList.getBigDecimal(this.m_item);
                    break;
                }
                case 8: 
                case 9: {
                    ret = DBList.getDouble(this.m_item);
                    break;
                }
                default: {
                    throw new SQLException("Incorrect list format, unknown type: " + this.m_item.type, "S1000");
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public Boolean getBoolean(int index) {
        this.m_currentIndex = this.getItem(index);
        if (this.m_item.isNull) {
            if (-1 == this.m_item.type) {
                return null;
            }
            return false;
        }
        try {
            return DBList.getBoolean(this.m_item);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Double getDouble(int index) {
        this.m_currentIndex = this.getItem(index);
        if (this.m_item.isNull) {
            if (-1 == this.m_item.type) {
                return null;
            }
            return 0.0;
        }
        try {
            return DBList.getDouble(this.m_item);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Float getFloat(int index) {
        this.m_currentIndex = this.getItem(index);
        if (this.m_item.isNull) {
            if (-1 == this.m_item.type) {
                return null;
            }
            return Float.valueOf(0.0f);
        }
        try {
            return Float.valueOf(DBList.getFloat(this.m_item));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Integer getInteger(int index) {
        this.m_currentIndex = this.getItem(index);
        if (this.m_item.isNull) {
            if (-1 == this.m_item.type) {
                return null;
            }
            return 0;
        }
        try {
            return DBList.getInt(this.m_item);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Long getLong(int index) {
        this.m_currentIndex = this.getItem(index);
        if (this.m_item.isNull) {
            if (-1 == this.m_item.type) {
                return null;
            }
            return 0L;
        }
        try {
            return DBList.getLong(this.m_item);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Short getShort(int index) {
        this.m_currentIndex = this.getItem(index);
        if (this.m_item.isNull) {
            if (-1 == this.m_item.type) {
                return null;
            }
            return (short)0;
        }
        try {
            return DBList.getShort(this.m_item);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public BigInteger getBigInteger(int index) {
        this.m_currentIndex = this.getItem(index);
        if (this.m_item.isNull) {
            if (-1 == this.m_item.type) {
                return null;
            }
            return BigInteger.ZERO;
        }
        try {
            return DBList.getBigInteger(this.m_item);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public BigDecimal getBigDecimal(int index) {
        this.m_currentIndex = this.getItem(index);
        if (this.m_item.isNull) {
            if (-1 == this.m_item.type) {
                return null;
            }
            return BigDecimal.ZERO;
        }
        try {
            return DBList.getBigDecimal(this.m_item);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getString(int index) {
        this.m_currentIndex = this.getItem(index);
        if (this.m_item.isNull) {
            if (-1 == this.m_item.type) {
                return null;
            }
            return "";
        }
        try {
            return DBList.getString(this.m_item, this.m_locale);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getBytes(int index) {
        this.m_currentIndex = this.getItem(index);
        if (this.m_item.isNull) {
            if (-1 == this.m_item.type) {
                return null;
            }
            return new byte[0];
        }
        return DBList.getByteArray(this.m_item);
    }

    public IRISList getList(int index) {
        byte[] bytes = this.getBytes(index);
        if (null == bytes) {
            if (-1 == this.m_item.type) {
                return null;
            }
            return new IRISList(this.m_locale, this.m_compactDoubleEnabled);
        }
        return new IRISList(bytes, bytes.length, this.m_locale, this.m_compactDoubleEnabled);
    }

    public void addNull() {
        this.checkBufferSize(1);
        this.m_item.buffer[this.m_listSize++] = 1;
    }

    public void addEmpty() {
        this.checkBufferSize(2);
        this.m_item.buffer[this.m_listSize++] = 2;
        this.m_item.buffer[this.m_listSize++] = 1;
    }

    public void add(int value) {
        this.checkBufferSize(6);
        try {
            this.m_listSize = DBList.setInt(this.m_item.buffer, this.m_listSize, value);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void add(Integer value) {
        if (value == null) {
            this.addNull();
        } else {
            this.checkBufferSize(6);
            try {
                this.m_listSize = DBList.setInt(this.m_item.buffer, this.m_listSize, value);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void add(short value) {
        this.checkBufferSize(4);
        try {
            this.m_listSize = DBList.setShort(this.m_item.buffer, this.m_listSize, value);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void add(Short value) {
        if (value == null) {
            this.addNull();
        } else {
            this.checkBufferSize(4);
            try {
                this.m_listSize = DBList.setShort(this.m_item.buffer, this.m_listSize, value);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void add(String value) {
        if (value == null) {
            this.addNull();
        } else if (0 == value.length()) {
            this.addEmpty();
        } else {
            int length = value.length() * 2;
            this.checkBufferSize(length + this.getBytesForLength(length) + 1);
            this.m_listSize = DBList.setString(this.m_item.buffer, this.m_listSize, value, this.m_locale, true);
        }
    }

    public void add(long value) {
        this.checkBufferSize(10);
        try {
            this.m_listSize = DBList.setLong(this.m_item.buffer, this.m_listSize, value);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void add(Long value) {
        if (value == null) {
            this.addNull();
        } else {
            this.checkBufferSize(10);
            try {
                this.m_listSize = DBList.setLong(this.m_item.buffer, this.m_listSize, value);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void add(double value) {
        this.checkBufferSize(10);
        this.m_listSize = this.m_compactDoubleEnabled ? DBList.setCompactDouble(this.m_item.buffer, this.m_listSize, value) : DBList.setDouble(this.m_item.buffer, this.m_listSize, value);
    }

    public void add(Double value) {
        if (value == null) {
            this.addNull();
        } else {
            this.checkBufferSize(10);
            this.m_listSize = this.m_compactDoubleEnabled ? DBList.setCompactDouble(this.m_item.buffer, this.m_listSize, value) : DBList.setDouble(this.m_item.buffer, this.m_listSize, value);
        }
    }

    public void add(float value) {
        if (this.m_compactDoubleEnabled) {
            this.checkBufferSize(6);
            this.m_listSize = DBList.setCompactFloat(this.m_item.buffer, this.m_listSize, value);
        } else {
            double d = value;
            this.add(d);
        }
    }

    public void add(Float value) {
        if (this.m_compactDoubleEnabled) {
            this.checkBufferSize(6);
            this.m_listSize = DBList.setCompactFloat(this.m_item.buffer, this.m_listSize, value.floatValue());
        } else {
            double d = value.floatValue();
            this.add(d);
        }
    }

    public void add(byte[] value) {
        if (null == value) {
            this.addNull();
        } else {
            this.add(value, value.length);
        }
    }

    public void add(byte[] value, int length) {
        if (null == value) {
            this.addNull();
        } else if (0 == length) {
            this.addEmpty();
        } else {
            this.checkBufferSize(length + this.getBytesForLength(length) + 1);
            this.m_listSize = DBList.setByteArray(this.m_item.buffer, this.m_listSize, value, length);
        }
    }

    public void add(IRISList list) {
        if (!this.m_compactDoubleEnabled && list.m_compactDoubleEnabled) {
            throw new IllegalArgumentException("Cannot embed an IRISList with Compact Double enabled into an IRISList with Compact Double disabled");
        }
        if (null == list) {
            this.addNull();
        } else if (null == list.m_item) {
            this.addEmpty();
        } else {
            this.add(list.m_item.buffer, list.m_listSize);
        }
    }

    public void add(boolean value) {
        this.checkBufferSize(4);
        try {
            this.m_listSize = DBList.setBoolean(this.m_item.buffer, this.m_listSize, value);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void add(Boolean value) {
        if (value == null) {
            this.addNull();
        } else {
            this.checkBufferSize(4);
            try {
                this.m_listSize = DBList.setBoolean(this.m_item.buffer, this.m_listSize, value);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void add(BigInteger value) {
        if (value == null) {
            this.addNull();
        } else {
            this.checkBufferSize(11);
            try {
                this.m_listSize = DBList.setBigInteger(this.m_item.buffer, this.m_listSize, value);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void add(BigDecimal value) {
        if (value == null) {
            this.addNull();
        } else {
            this.checkBufferSize(11);
            try {
                this.m_listSize = DBList.setBigDecimal(this.m_item.buffer, this.m_listSize, value);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void add(Object value) {
        if (value == null) {
            this.addNull();
            return;
        }
        if (value instanceof String) {
            this.add((String)value);
        } else if (value instanceof Integer) {
            this.add((Integer)value);
        } else if (value instanceof Double) {
            this.add((Double)value);
        } else if (value instanceof Float) {
            this.add((Float)value);
        } else if (value instanceof byte[]) {
            this.add((byte[])value);
        } else if (value instanceof char[]) {
            this.add(new String((char[])value));
        } else if (value instanceof BigDecimal) {
            this.add((BigDecimal)value);
        } else if (value instanceof Long) {
            this.add((Long)value);
        } else if (value instanceof BigInteger) {
            this.add((BigInteger)value);
        } else if (value instanceof Short) {
            this.add((Short)value);
        } else if (value instanceof Character) {
            this.add(value.toString());
        } else if (value instanceof Boolean) {
            this.add((boolean)((Boolean)value));
        } else if (value instanceof IRISList) {
            this.add((IRISList)value);
        } else {
            throw new IllegalArgumentException("Type out of range: " + value.getClass().getName());
        }
    }

    public void add(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            this.add(array[i]);
        }
    }

    public void add(Collection collection) {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public void set(int index, Object value) {
        int extra = this.copyExtraForSet(index, true);
        this.add(value);
        this.applyExtra(extra);
    }

    public void set(int index, Object[] value) {
        if (null == value) {
            Object temp = null;
            this.set(index, (Object)temp);
            return;
        }
        if (value.length > 0) {
            int extra = this.copyExtraForSet(index, true);
            this.add(value);
            this.applyExtra(extra);
        }
    }

    public int size() {
        return this.m_listSize;
    }

    public int count() {
        int n = 0;
        if (this.m_listSize > 0 && this.moveTo(1)) {
            ++n;
            while (this.next()) {
                ++n;
            }
        }
        return n;
    }

    private boolean moveTo(int index) {
        try {
            this.m_currentIndex = this.getItem(index);
            if (this.m_currentIndex < index) {
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    private boolean next() {
        try {
            this.m_currentIndex = this.getItem(this.m_currentIndex + 1);
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public void clear() {
        this.m_listSize = 0;
        this.m_lastIndex = 0;
        this.m_currentIndex = 0;
        if (null != this.m_item) {
            this.m_item.nextOffset = 0;
        }
    }

    public boolean remove(int index) {
        if (0 == this.m_listSize) {
            return false;
        }
        try {
            int ind = this.getItem(index);
            int extra = this.copyExtraForSet(index, false);
            int oldOffset = this.m_item.nextOffset;
            if (1 == index) {
                this.m_currentIndex = 0;
                this.m_item.nextOffset = 0;
            } else {
                this.m_currentIndex = this.getItem(index - 1);
            }
            this.m_listSize -= oldOffset - this.m_item.nextOffset;
            this.applyExtra(extra);
            if (this.m_lastIndex > this.m_currentIndex) {
                this.m_lastIndex = this.m_currentIndex;
            }
            if (0 == extra && this.m_currentIndex < index - 1) {
                return false;
            }
        }
        catch (RuntimeException e) {
            this.m_lastIndex = 0;
            this.m_currentIndex = 0;
            return false;
        }
        return true;
    }

    public IRISList subList(int from, int to) {
        int fromOffset;
        if (from > to) {
            throw new IndexOutOfBoundsException();
        }
        if (from <= 1) {
            fromOffset = 0;
        } else {
            this.getItem(from - 1);
            fromOffset = this.m_item.nextOffset;
        }
        this.m_currentIndex = this.getItem(to);
        int toOffest = this.m_item.nextOffset;
        int len = toOffest - fromOffset;
        byte[] newList = new byte[len];
        System.arraycopy(this.m_item.buffer, fromOffset, newList, 0, len);
        return new IRISList(newList, len, this.m_locale, this.m_compactDoubleEnabled);
    }

    public Object[] toArray() {
        int n = this.count();
        if (0 == n) {
            return new Object[0];
        }
        Object[] a = new Object[n];
        for (int i = 1; i <= n; ++i) {
            a[i - 1] = this.get(i);
        }
        return a;
    }

    private void concatInternal(IRISList list) {
        if (list != null && list.m_listSize > 0) {
            this.checkBufferSize(list.m_listSize);
            System.arraycopy(list.m_item.buffer, 0, this.m_item.buffer, this.m_listSize, list.m_listSize);
            this.m_listSize += list.m_listSize;
        }
    }

    public IRISList concat(IRISList list) {
        if (!this.m_compactDoubleEnabled && list != null && list.m_compactDoubleEnabled) {
            throw new IllegalArgumentException("Cannot append an IRISList with Compact Double enabled to an IRISList with Compact Double disabled");
        }
        IRISList ret = new IRISList(this);
        ret.concatInternal(list);
        return ret;
    }

    public ArrayList<Object> toList() {
        ArrayList<Object> al = new ArrayList<Object>();
        if (null != this.m_item && this.m_listSize > 0) {
            int i = 1;
            while (true) {
                al.add(this.get(i));
                if (this.m_listSize <= this.m_item.nextOffset) break;
                ++i;
            }
        }
        return al;
    }

    public boolean equals(Object list) {
        if (list instanceof IRISList) {
            if (((IRISList)list).m_listSize != this.m_listSize) {
                return false;
            }
            if (0 == this.m_listSize) {
                return true;
            }
            if (null == this.m_item) {
                return null == ((IRISList)list).m_item;
            }
            return ByteBuffer.wrap(this.m_item.buffer, 0, this.m_listSize).equals(ByteBuffer.wrap(((IRISList)list).m_item.buffer, 0, this.m_listSize));
        }
        return false;
    }

    public int hashCode() {
        return this.m_listSize;
    }

    public static Timestamp PosixToTimestamp(long PosixValue, Calendar calendar) {
        return ValidateNFormat.TimestampFromPosix(PosixValue, calendar);
    }

    public static long TimestampToPosix(Timestamp Value, Calendar calendar) {
        return ValidateNFormat.PosixFromTimestamp(Value, calendar);
    }

    public static Date HorologToDate(int HorologValue, Calendar calendar) {
        return ValidateNFormat.DateFromHorolog(HorologValue, calendar);
    }

    public static int DateToHorolog(Date value, Calendar calendar) {
        return ValidateNFormat.HorologFromDate(value.getTime(), calendar, false);
    }

    public static Time HorologToTime(int HorologValue, Calendar calendar) {
        return ValidateNFormat.TimeFromHorolog(HorologValue, calendar);
    }

    public static int TimeToHorolog(Time value, Calendar calendar) {
        return ValidateNFormat.HorologFromTime(value.getTime(), calendar);
    }

    public String toString() {
        if (null == this.m_item) {
            return "$lb()";
        }
        return DBList.toString(this.m_item.buffer, this.m_listSize, null);
    }

    private int getItem(int index) {
        int k;
        if (index < 1 || null == this.m_item || 0 == this.m_listSize) {
            throw new IndexOutOfBoundsException();
        }
        this.InitOffsetArray(index);
        for (int i = k = this.m_lastIndex; i < index; ++i) {
            this.m_item.nextOffset = DBList.Next(this.m_item.buffer, this.m_item.nextOffset);
            if (this.m_item.nextOffset >= this.m_listSize) {
                throw new IndexOutOfBoundsException();
            }
            this.m_aOffset[i] = this.m_item.nextOffset;
            this.m_lastIndex = i + 1;
        }
        if (this.m_lastIndex < index) {
            throw new IndexOutOfBoundsException();
        }
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return index;
    }

    private void InitOffsetArray(int index) {
        if (index > this.m_allocatedSize) {
            int n = this.m_allocatedSize;
            this.m_allocatedSize = index * 2;
            int[] newArray = new int[this.m_allocatedSize];
            System.arraycopy(this.m_aOffset, 0, newArray, 0, n);
            this.m_aOffset = newArray;
        }
        if (null == this.m_item) {
            this.m_item = new ListItem(new byte[this.m_BucketSize], this.m_BucketSize);
        }
        if (0 == this.m_lastIndex) {
            this.m_lastIndex = 1;
            this.m_aOffset[0] = 0;
            this.m_item.nextOffset = 0;
        } else {
            this.m_item.nextOffset = index < this.m_lastIndex ? this.m_aOffset[index - 1] : this.m_aOffset[this.m_lastIndex - 1];
        }
    }

    private void checkBufferSize(int additional) {
        if (null == this.m_item) {
            this.m_item = new ListItem(new byte[this.m_BucketSize], this.m_BucketSize);
        }
        if (this.m_listSize + additional > this.m_item.buffer.length) {
            this.growBuffer(this.m_listSize + additional);
        }
    }

    private void growBuffer(int needed) {
        needed = needed + (needed >> 4) + this.m_BucketSize - 1 & ~(this.m_BucketSize - 1);
        this.m_BucketSize *= 2;
        if (needed < 0) {
            throw new RuntimeException("Exceeded maximum amount of memory that can be allocated for a given row.");
        }
        byte[] a = new byte[needed];
        System.arraycopy(this.m_item.buffer, 0, a, 0, this.m_listSize);
        this.m_item.buffer = a;
    }

    private int getBytesForLength(int len) {
        if (++len < 255) {
            return 1;
        }
        if (len < 65536) {
            return 3;
        }
        return 7;
    }

    private int copyExtraForSet(int index, boolean bAddNull) {
        int k;
        if (index < 1) {
            throw new IndexOutOfBoundsException();
        }
        if (index < this.m_lastIndex) {
            this.m_lastIndex = index - 1;
        }
        if (null == this.m_item) {
            this.m_item = new ListItem(new byte[this.m_BucketSize], this.m_BucketSize);
        }
        int tempSize = this.m_BucketSize;
        if (this.m_listSize > this.m_BucketSize) {
            tempSize = this.m_listSize;
        }
        if (null == this.m_tempBuffer || this.m_tempBuffer.length < tempSize) {
            this.m_tempBuffer = new byte[tempSize];
        }
        this.InitOffsetArray(index);
        for (int i = k = this.m_lastIndex; i < index; ++i) {
            if (this.m_listSize <= this.m_item.nextOffset) {
                if (!bAddNull) break;
                this.addNull();
                this.m_item.nextOffset = this.m_listSize;
            } else {
                this.m_item.nextOffset = DBList.Next(this.m_item.buffer, this.m_item.nextOffset);
            }
            this.m_aOffset[i] = this.m_item.nextOffset;
            this.m_lastIndex = i + 1;
        }
        int savedOffset = this.m_item.nextOffset;
        if (this.m_item.nextOffset < this.m_listSize) {
            this.m_item.nextOffset = DBList.Next(this.m_item.buffer, this.m_item.nextOffset);
        }
        int n = this.m_listSize - this.m_item.nextOffset;
        System.arraycopy(this.m_item.buffer, this.m_item.nextOffset, this.m_tempBuffer, 0, n);
        this.m_listSize = savedOffset;
        this.m_item.nextOffset = savedOffset;
        return n;
    }

    private void applyExtra(int extra) {
        if (extra > 0) {
            this.checkBufferSize(extra);
            System.arraycopy(this.m_tempBuffer, 0, this.m_item.buffer, this.m_listSize, extra);
            this.m_listSize += extra;
        }
    }

    public byte[] getBuffer() {
        if (null == this.m_item) {
            return null;
        }
        return this.m_item.buffer;
    }
}

