/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.IRIS;
import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.IRISList;
import com.intersystems.jdbc.ListReader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class IRISObject
implements AutoCloseable {
    private IRISConnection connection = null;
    public IRIS iris;
    String oref = null;
    boolean closed = false;
    public boolean useCachedValues = false;
    private Map<String, Object> cachedValues;
    private static ThreadLocal<HashMap<IRISConnection, IRIS>> threadLocalIrisMap = new ThreadLocal<HashMap<IRISConnection, IRIS>>(){

        @Override
        protected HashMap<IRISConnection, IRIS> initialValue() {
            return new HashMap<IRISConnection, IRIS>();
        }
    };

    IRISObject(IRISConnection connection, String oref) throws SQLException {
        this.connection = connection;
        this.oref = oref;
        HashMap<IRISConnection, IRIS> irisMap = threadLocalIrisMap.get();
        this.iris = irisMap.get(connection);
        if (this.iris == null) {
            this.iris = IRIS.createIRIS(connection);
            irisMap.put(connection, this.iris);
        }
        connection.registry_IRISObject_insert(oref, new WeakReference<IRISObject>(this));
    }

    public String getOREF() {
        return this.oref;
    }

    public Object invoke(String methodName, Object ... args) {
        return this.iris.instanceMethodObject(this, methodName, args);
    }

    public byte[] invokeBytes(String methodName, Object ... args) {
        return this.iris.instanceMethodBytes(this, methodName, args);
    }

    public Long invokeLong(String methodName, Object ... args) {
        return this.iris.instanceMethodLong(this, methodName, args);
    }

    public Double invokeDouble(String methodName, Object ... args) {
        return this.iris.instanceMethodDouble(this, methodName, args);
    }

    public Boolean invokeBoolean(String methodName, Object ... args) {
        return this.iris.instanceMethodBoolean(this, methodName, args);
    }

    public BigDecimal invokeBigDecimal(String methodName, Object ... args) {
        return this.iris.instanceMethodBigDecimal(this, methodName, args);
    }

    public String invokeString(String methodName, Object ... args) {
        return this.iris.instanceMethodString(this, methodName, args);
    }

    public Object invokeObject(String methodName, Object ... args) {
        return this.iris.instanceMethodObject(this, methodName, args);
    }

    public IRISList invokeIRISList(String methodName, Object ... args) {
        return this.iris.instanceMethodIRISList(this, methodName, args);
    }

    public void invokeStatusCode(String methodName, Object ... args) {
        this.iris.instanceMethodStatusCode(this, methodName, args);
    }

    public void invokeVoid(String methodName, Object ... args) {
        this.iris.instanceMethodVoid(this, methodName, args);
    }

    public Object get(String propertyName) {
        return this.iris.instancePropertyGetObject(this, propertyName);
    }

    public byte[] getBytes(String propertyName) {
        return this.iris.instancePropertyGetBytes(this, propertyName);
    }

    public Long getLong(String propertyName) {
        return this.iris.instancePropertyGetLong(this, propertyName);
    }

    public Double getDouble(String propertyName) {
        return this.iris.instancePropertyGetDouble(this, propertyName);
    }

    public Boolean getBoolean(String propertyName) {
        return this.iris.instancePropertyGetBoolean(this, propertyName);
    }

    public BigDecimal getBigDecimal(String propertyName) {
        return this.iris.instancePropertyGetBigDecimal(this, propertyName);
    }

    public String getString(String propertyName) {
        return this.iris.instancePropertyGetString(this, propertyName);
    }

    public Object getObject(String propertyName) {
        return this.iris.instancePropertyGetObject(this, propertyName);
    }

    public IRISList getIRISList(String propertyName) {
        return this.iris.instancePropertyGetIRISList(this, propertyName);
    }

    public void set(String propertyName, Object propertyValue) {
        this.iris.instancePropertySet(this, propertyName, propertyValue);
    }

    public IRISConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed) {
            ArrayList<String> arrayList = this.connection.registry_closed_IRISObject;
            synchronized (arrayList) {
                this.connection.registry_IRISObject_remove_by_oref(this.oref);
                this.connection.registry_closed_IRISObject.add(this.oref);
                this.closed = true;
            }
            this.cachedValues = null;
            threadLocalIrisMap.remove();
        }
    }

    public void finalize() {
        if (!this.closed) {
            this.close();
        }
    }

    public void populateCache() {
        this.populateCache(null);
    }

    public void populateCache(String className) {
        if (this.cachedValues == null) {
            this.cachedValues = new HashMap<String, Object>();
        }
        try {
            IRISList list = this.iris.classMethodIRISList("%DataModel.Serializer", "projectListFromRegistered", "", this);
            int count = list.count();
            for (int i = 1; i <= count; ++i) {
                IRISList element = list.getList(i);
                ListReader reader = new ListReader(element.getBuffer(), element.size(), element.getCharSet());
                String key = reader.getString();
                Object val = this.unpackValue(reader, key, className);
                this.cachedValues.put(key, val);
            }
            this.useCachedValues = true;
        }
        catch (Exception e) {
            this.cachedValues = null;
            this.useCachedValues = false;
        }
    }

    private Object unpackValue(ListReader reader, String key, String className) {
        try {
            Object val;
            String[] types = reader.peekListTypeFamilies(1);
            if (className != null && types[0] != null) {
                Method mtd;
                try {
                    mtd = Class.forName(className).getMethod("get" + key, new Class[0]);
                }
                catch (ReflectiveOperationException e) {
                    Object val2 = reader.getObject();
                    return val2;
                }
                Class<?> ret = mtd.getReturnType();
                switch (ret.getName()) {
                    case "java.lang.String": {
                        val = reader.getString();
                        break;
                    }
                    case "java.lang.Boolean": {
                        val = reader.getBoolean();
                        break;
                    }
                    case "java.lang.Double": {
                        val = reader.getDouble();
                        break;
                    }
                    case "java.sql.Date": 
                    case "java.sql.Time": {
                        val = reader.getLong();
                        break;
                    }
                    default: {
                        if (types[0].equals("%string")) {
                            val = null;
                            break;
                        }
                        val = reader.getObject();
                        break;
                    }
                }
            } else {
                val = reader.getObject();
            }
            return val;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void updateCache(String key, Object val) {
        if (this.cachedValues == null) {
            this.cachedValues = new HashMap<String, Object>();
        }
        this.cachedValues.put(key, val);
    }

    public Object getFromCache(String key, byte returnType) {
        Object val = this.cachedValues.get(key);
        try {
            switch (returnType) {
                case 0: {
                    return null;
                }
                case 1: {
                    byte[] bytes = (byte[])val;
                    return bytes;
                }
                case 4: {
                    if (val instanceof Integer) {
                        long longval = ((Integer)val).intValue();
                        return longval;
                    }
                    long longval = (Long)val;
                    return longval;
                }
                case 6: {
                    double doubval = (Double)val;
                    return doubval;
                }
                case 7: {
                    boolean boolval = (Boolean)val;
                    return boolval;
                }
                case 8: {
                    BigDecimal decval = (BigDecimal)val;
                    return decval;
                }
                case 9: {
                    String strval = (String)val;
                    return strval;
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

