/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.ConnectionParameters;
import com.intersystems.jdbc.Device;
import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.IRISConnectionPoolDataSource;
import com.intersystems.jdbc.IRISPooledConnection;
import java.sql.SQLException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.PooledConnection;

public class IRISPool {
    private int maxPoolSize = 40;
    private int minPoolSize = 0;
    private int connectionWaitTimeout = 0;
    LinkedBlockingQueue<Device> idlePool;
    LinkedBlockingQueue<Device> inUsePool;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    long maxActiveConnections;
    long hits = 0L;
    long misses = 0L;
    long timedConnectionHits = 0L;

    public IRISPool() {
        this.idlePool = new LinkedBlockingQueue();
    }

    IRISPool(ConnectionParameters cp) throws SQLException {
        this.initStats();
        if (cp instanceof IRISConnectionPoolDataSource) {
            IRISConnectionPoolDataSource ds = (IRISConnectionPoolDataSource)cp;
            this.maxPoolSize = ds.maxPoolSize;
            this.minPoolSize = ds.minPoolSize;
            this.connectionWaitTimeout = ds.connectionWaitTimeout;
        }
        this.inUsePool = new LinkedBlockingQueue();
        this.idlePool = new LinkedBlockingQueue();
        for (int i = 0; i < this.minPoolSize; ++i) {
            this.createNewIdlePooledConnection(cp);
        }
    }

    void update(IRISConnectionPoolDataSource ds) {
        this.maxPoolSize = ds.maxPoolSize;
        this.minPoolSize = ds.minPoolSize;
        this.connectionWaitTimeout = ds.connectionWaitTimeout;
    }

    void initStats() {
        this.hits = 0L;
        this.misses = 0L;
        this.maxActiveConnections = 0L;
        this.timedConnectionHits = 0L;
    }

    boolean createNewIdlePooledConnection(ConnectionParameters cp) throws SQLException {
        this.rwl.writeLock().lock();
        try {
            if (this.inUsePool.size() + this.idlePool.size() < this.maxPoolSize) {
                IRISConnection conn = new IRISConnection(cp);
                this.idlePool.add(conn.device);
                conn.closed = true;
                Object var2_2 = null;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    synchronized void createMinPooledConnections(ConnectionParameters cp) throws SQLException {
        while (this.idlePool.size() + this.inUsePool.size() < this.minPoolSize && this.createNewIdlePooledConnection(cp)) {
        }
    }

    IRISPooledConnection getPooledConnection(ConnectionParameters cp) throws SQLException, InterruptedException {
        IRISPooledConnection pc = this.checkoutConnection(cp);
        if (pc != null) {
            return pc;
        }
        pc = this.createNewPooledConnection(cp);
        if (pc != null) {
            return pc;
        }
        return this.checkoutTimedConnection(cp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recycleInUseConnections() {
        this.rwl.writeLock().lock();
        try {
            int loop = 0;
            while (loop < this.inUsePool.size()) {
                try {
                    Device dev = this.inUsePool.poll();
                    ++loop;
                    dev.markedToClose = true;
                }
                catch (Exception e) {
                    String string = e.getMessage();
                }
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseConnection(Device dev) {
        this.rwl.readLock().lock();
        try {
            if (dev.markedToClose || dev.conParams.connectionLifetime != 0 && dev.hasElapsed(dev.conParams.connectionLifetime)) {
                this.inUsePool.remove(dev);
                dev.close();
            } else if (this.idlePool.size() + this.inUsePool.size() <= this.maxPoolSize) {
                dev.resetConnection();
                dev.conParams = (ConnectionParameters)dev.conParams.clone();
                this.inUsePool.remove(dev);
                this.idlePool.add(dev);
            } else {
                this.inUsePool.remove(dev);
                dev.close();
            }
        }
        catch (Exception e) {
            String test = e.getMessage();
            dev.conParams.logFile = null;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRISPooledConnection checkoutConnection(ConnectionParameters cp) throws SQLException {
        Device dev = null;
        this.rwl.readLock().lock();
        try {
            dev = this.idlePool.poll();
            if (dev == null) {
                IRISPooledConnection iRISPooledConnection = null;
                return iRISPooledConnection;
            }
            IRISPooledConnection iRISPooledConnection = this.getPooledConnectionFromDevice(cp, dev);
            return iRISPooledConnection;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRISPooledConnection checkoutTimedConnection(ConnectionParameters cp) throws SQLException, InterruptedException {
        this.rwl.readLock().lock();
        try {
            IRISPooledConnection pc = null;
            Device dev = this.idlePool.poll(this.connectionWaitTimeout, TimeUnit.SECONDS);
            if (dev != null) {
                ++this.timedConnectionHits;
                pc = this.getPooledConnectionFromDevice(cp, dev);
                if (pc != null) {
                    IRISPooledConnection iRISPooledConnection = pc;
                    return iRISPooledConnection;
                }
            } else {
                throw new SQLException("maxPool size is reached and connection wait timeout was exceeded!");
            }
            IRISPooledConnection iRISPooledConnection = pc;
            return iRISPooledConnection;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRISPooledConnection createNewPooledConnection(ConnectionParameters cp) throws SQLException {
        this.rwl.writeLock().lock();
        try {
            if (this.maxPoolSize == 0 || this.inUsePool.size() + this.idlePool.size() < this.maxPoolSize) {
                IRISPooledConnection conn = new IRISPooledConnection(cp);
                this.inUsePool.add(conn.device);
                conn.device.needsReset = true;
                this.setMisses();
                this.setMaxPhysicalConnections();
                IRISPooledConnection iRISPooledConnection = conn;
                return iRISPooledConnection;
            }
            IRISPooledConnection iRISPooledConnection = null;
            return iRISPooledConnection;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    IRISPooledConnection getPooledConnectionFromDevice(ConnectionParameters cp, Device dev) throws SQLException {
        if (!cp.ping) {
            this.inUsePool.add(dev);
            dev.resetConnection();
            dev.needsReset = true;
            this.setHits();
            return new IRISPooledConnection(dev);
        }
        if (dev.resetConnection() || dev.ping()) {
            this.inUsePool.add(dev);
            dev.needsReset = true;
            this.setHits();
            return new IRISPooledConnection(dev);
        }
        dev.close();
        if (this.idlePool.size() == 0) {
            return null;
        }
        this.cleanIdleConnectionPool(cp);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanIdleConnectionPool(ConnectionParameters cp) throws SQLException {
        this.rwl.readLock().lock();
        try {
            Device dev = null;
            LinkedBlockingQueue<Device> tmpIdlePool = new LinkedBlockingQueue<Device>();
            while (this.idlePool.size() != 0) {
                dev = this.idlePool.poll();
                IRISPooledConnection pc = new IRISPooledConnection(dev);
                if (!dev.ping()) {
                    dev.close();
                    continue;
                }
                try {
                    tmpIdlePool.put(dev);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!dev.needsReset) continue;
                dev.resetConnection();
            }
            this.idlePool = tmpIdlePool;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    void removeIdleConnections() {
        while (this.idlePool.size() != 0) {
            try {
                this.idlePool.poll().close();
            }
            catch (Exception exception) {}
        }
    }

    void pruneIdleConnections(int remaining) {
        while (this.idlePool.size() != 0 && this.idlePool.size() + this.inUsePool.size() > remaining) {
            try {
                this.idlePool.poll().close();
            }
            catch (Exception exception) {}
        }
    }

    void removeInuseConnections() {
        while (this.inUsePool.size() != 0) {
            try {
                this.inUsePool.poll().close();
            }
            catch (Exception e) {
                String string = e.getMessage();
            }
        }
    }

    boolean IsEmpty() {
        this.rwl.readLock().lock();
        try {
            if (this.idlePool.size() + this.inUsePool.size() == 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    PooledConnection getPooledConnection() throws SQLException {
        Device dev = null;
        if (this.idlePool.size() > 0) {
            dev = this.idlePool.poll();
        }
        if (dev != null) {
            return new IRISPooledConnection(dev);
        }
        return null;
    }

    void restartIdleConnectionPool() throws SQLException {
        for (Device dev : this.idlePool) {
            dev.close();
        }
        this.idlePool.clear();
        this.initStats();
    }

    public void restartConnectionPool() throws SQLException {
        this.rwl.writeLock().lock();
        try {
            this.removeIdleConnections();
            this.removeInuseConnections();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public int getPoolCount() {
        return this.idlePool.size();
    }

    void setMaxPoolSize(int max) {
        this.maxPoolSize = max;
    }

    int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    int getConnectionWaitTimeout() {
        return this.connectionWaitTimeout;
    }

    void setConnectionWaitTimeout(int timeout) {
        this.connectionWaitTimeout = timeout;
    }

    void setMinPoolSize(int min) {
        this.minPoolSize = min;
    }

    int getMinPoolSize() {
        return this.minPoolSize;
    }

    public double getHitRatio() {
        if (this.hits + this.misses == 0L) {
            return 0.0;
        }
        return (double)this.hits / (double)(this.hits + this.misses);
    }

    public double getMissRatio() {
        return 1.0 - this.getHitRatio();
    }

    void setMaxPhysicalConnections() {
        long currentConn = this.getCurrentPhysicalConnections();
        if (currentConn > this.maxActiveConnections) {
            this.maxActiveConnections = currentConn;
        }
    }

    public long getMaxPhysicalConnections() {
        return this.maxActiveConnections;
    }

    long getCurrentPhysicalConnections() {
        return this.idlePool.size() + this.inUsePool.size();
    }

    public long getMissed() {
        return this.misses;
    }

    public long getHits() {
        return this.hits;
    }

    public long getTimedConnectionHits() {
        return this.timedConnectionHits;
    }

    synchronized void setHits() {
        ++this.hits;
    }

    synchronized void setMisses() {
        ++this.misses;
    }

    public void resetStats() {
        this.initStats();
    }
}

