/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.ConnectionParameters;
import com.intersystems.jdbc.Device;
import com.intersystems.jdbc.IRISConnection;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class IRISPooledConnection
implements PooledConnection,
AutoCloseable {
    private ConnectionEventListener connectionListener = null;
    private Object statementListener = null;
    Device device;
    IRISConnection logicalConnection;
    String dsHash = null;

    IRISPooledConnection(ConnectionParameters conParams) throws SQLException {
        try {
            this.logicalConnection = new IRISConnection((ConnectionParameters)conParams.clone());
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        this.logicalConnection.conParams.pooled = this;
        this.device = this.logicalConnection.device;
    }

    IRISPooledConnection(Device dev) throws SQLException {
        this.device = dev;
        this.logicalConnection = new IRISConnection(dev);
        this.logicalConnection.conParams.pooled = this;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.logicalConnection != null) {
            return this.logicalConnection;
        }
        if (this.device == null) {
            // empty if block
        }
        this.device.conParams.pooled = this;
        return new IRISConnection(this.device);
    }

    @Override
    public void close() throws SQLException {
        if (this.logicalConnection == null) {
            return;
        }
        this.logicalConnection.close();
        this.connectionListener = null;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener l) {
        this.connectionListener = l;
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener l) {
        this.connectionListener = null;
    }

    synchronized void release() {
        if (this.connectionListener == null) {
            return;
        }
        this.connectionListener.connectionClosed(new ConnectionEvent(this));
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        this.statementListener = listener;
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.statementListener = null;
    }
}

