/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.ConnectionParameters;
import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.IRISPreparedStatement;
import com.intersystems.sqf.Factor;
import com.intersystems.sqf.ISCRecord;
import com.intersystems.sqf.Master;
import com.intersystems.sqf.Pipe;
import com.intersystems.sqf.PipeJDBC;
import com.intersystems.sqf.Sharder;
import com.intersystems.sqf.Utilities;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public final class IRISPreparedShardedStatement
extends IRISPreparedStatement {
    int m_pending;
    final ISCRecord m_record;
    final Sharder m_sharder;
    final ExecutorService m_threads;
    final List<Pipe> m_pipes = new ArrayList<Pipe>(256);

    public IRISPreparedShardedStatement(Master m, IRISConnection c, int rst, int rsc, String sql, String agk) throws SQLException {
        super(c, rst, rsc, sql, agk);
        this.m_record = new ISCRecord(this.parameters.userParametersSize());
        this.m_sharder = m.getSharder(sql);
        for (Factor f : this.m_sharder.getFactors()) {
            this.m_pipes.add(this.pipe(f, c.conParams));
        }
        this.m_threads = this.pool(c.conParams.loaderPoolSize);
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        int count = 0;
        ArrayList<ISCRecord> records = this.getRecords();
        for (ISCRecord record : records) {
            int i = this.m_sharder.getFactor(record);
            int n = this.m_pipes.get(i).insert(record);
            count += n;
        }
        this.m_pending = 0;
        return count;
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        this.m_record.offset = this.m_pending;
        ArrayList<ISCRecord> records = this.getRecords();
        for (ISCRecord record : records) {
            int i = this.m_sharder.getFactor(record);
            this.m_pipes.get(i).sink(record);
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        final int[] r = new int[this.m_pending];
        if (this.m_pending > 0) {
            this.m_pending = 0;
            ArrayList<Future<Void>> fs = new ArrayList<Future<Void>>(this.m_pipes.size());
            for (final Pipe p : this.m_pipes) {
                fs.add(this.m_threads.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws SQLException {
                        p.flush(r);
                        return null;
                    }
                }));
            }
            Throwable e = null;
            for (Future future : fs) {
                try {
                    future.get();
                }
                catch (Exception x) {
                    e = x;
                }
            }
            if (e != null) {
                throw new BatchUpdateException(r, e.getCause());
            }
        }
        return r;
    }

    @Override
    public void close() throws SQLException {
        for (Pipe p : this.m_pipes) {
            p.close();
        }
        this.m_threads.shutdown();
        super.close();
    }

    @Override
    synchronized void setGeneric(int ordinal, Object value) throws SQLException {
        try {
            this.m_record.fields[ordinal - 1] = value;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new SQLException("Invalid column number: " + ordinal, "S1002", 463);
        }
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        this.executeUpdate();
        return false;
    }

    private ArrayList<ISCRecord> getRecords() {
        ArrayList<ISCRecord> records = new ArrayList<ISCRecord>();
        if (this.m_record.fields == null || this.m_record.fields.length == 0) {
            records.add(new ISCRecord(0));
        } else if (this.m_record.fields[0] instanceof ArrayList) {
            ArrayList col0 = (ArrayList)this.m_record.fields[0];
            for (int i = 0; i < col0.size(); ++i) {
                int len = this.m_record.fields.length;
                ISCRecord record = new ISCRecord(len);
                record.offset = this.m_pending;
                for (int j = 0; j < len; ++j) {
                    ArrayList col = (ArrayList)this.m_record.fields[j];
                    record.fields[j] = col.get(i);
                }
                records.add(record);
                ++this.m_pending;
            }
        } else {
            int len = this.m_record.fields.length;
            ISCRecord record = new ISCRecord(len);
            record.offset = this.m_record.offset;
            for (int i = 0; i < len; ++i) {
                record.fields[i] = this.m_record.fields[i];
            }
            records.add(record);
            ++this.m_pending;
        }
        return records;
    }

    Pipe pipe(Factor factor, ConnectionParameters conParams) throws SQLException {
        return new PipeJDBC(factor.address, factor.query, conParams);
    }

    ExecutorService pool(int loaderPoolSize) {
        int n = this.m_sharder.getFactors().size();
        int i = loaderPoolSize <= 0 ? n : loaderPoolSize;
        n = Utilities.clamp(1, i, n);
        Utilities.log("loader thread pool size = %d", n);
        ThreadFactory f = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        };
        return Executors.newFixedThreadPool(n, f);
    }
}

