/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.BatchUpdateStatus;
import com.intersystems.jdbc.BufferWrite;
import com.intersystems.jdbc.IRISCallableStatement;
import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.IRISParameterMetaData;
import com.intersystems.jdbc.IRISResultSetMetaData;
import com.intersystems.jdbc.IRISStatement;
import com.intersystems.jdbc.InternalParameterMetaData;
import com.intersystems.jdbc.ListReader;
import com.intersystems.jdbc.Parameter;
import com.intersystems.jdbc.ParameterCollection;
import com.intersystems.jdbc.SQLValidationException;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;

public class IRISPreparedStatement
extends IRISStatement
implements PreparedStatement {
    IRISPreparedStatement(IRISConnection conn, int rst, int rsc, String sql, String agk) throws SQLException {
        super(conn, rst, rsc, agk);
        this.LogMessage("IRISPreparedStatement", sql);
        this.prepare(sql);
    }

    IRISPreparedStatement(IRISConnection conn, int rst, String sql, int stmtType, long paramCount) throws SQLException {
        super(conn, rst, 1007, null);
        this.prepare(sql, IRISStatement.StatementType.values()[stmtType], paramCount);
    }

    IRISPreparedStatement(IRISConnection conn) throws SQLException {
        super(conn, 1003, 1007, null);
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open.", "08003");
        }
        this.genericExecuteCalled = false;
        this.Query();
        if (this.multipleResultSets && !this.mrsDone) {
            this.columnInfo(this.input.wire);
        }
        this.updateCnt = -1;
        return this.myResultSet;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new SQLException("executeQuery(String sql) form not allowed.", "S1000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void Query() throws SQLException {
        this.fetchDone = false;
        if (this.statementType != IRISStatement.StatementType.QUERY && this.statementType != IRISStatement.StatementType.PREPARED_CALL_QUERY && this.statementType != IRISStatement.StatementType.DIRECT_CALL_QUERY) {
            throw new SQLException("executeQuery called with a non-query.", "24000", 24000);
        }
        if (this.execParams != null) {
            this.bindExecParameters();
        }
        this.validateParameters();
        this.createResultSet();
        if (this instanceof IRISCallableStatement || this.statementType == IRISStatement.StatementType.PREPARED_CALL_QUERY) {
            this.storedProcedureQuery();
            return;
        }
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            if (this.resultSetType == 1004) {
                this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.EXECUTE_STATIC_CURSOR);
            } else {
                this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.PREPARED_QUERY_EXECUTE);
            }
            this.writeParameters(this.output.wire);
            this.output.wire.set(this.queryTimeout);
            this.output.wire.set(this.maxRows);
            this.output.send(this.connection.messageCount.getCount());
            this.handleError504(this.input.readMessage(this, 2, 504));
        }
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        if (this.multipleResultSets) {
            throw new SQLException("execute() must be used to retrieve multiple result sets.", "08003");
        }
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open.", "08003");
        }
        this.genericExecuteCalled = false;
        this.Update();
        if (!(this.parameterSets != 0 || this.multipleResultSets && this.getSQLDialect() != 0)) {
            this.updateCnt = this.input.wire.getInt();
        }
        if (this.statementType == IRISStatement.StatementType.STMT_USE) {
            this.connection.resetOnUse();
        }
        return this.updateCnt;
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        throw new SQLException("executeUpdate(String sql) form not allowed.", "S1000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void Update() throws SQLException {
        int messageCount;
        if (!this.runningBatch) {
            this.bus = null;
        }
        if (this.statementType == IRISStatement.StatementType.QUERY || this.statementType == IRISStatement.StatementType.PREPARED_CALL_QUERY) {
            throw new SQLException("executeUpdate called with a query.", "24000", 24000);
        }
        if (this.execParams != null) {
            this.bindExecParameters();
        }
        this.validateParameters();
        if (this instanceof IRISCallableStatement || this.statementType == IRISStatement.StatementType.PREPARED_CALL_UPDATE || this.statementType == IRISStatement.StatementType.DIRECT_CALL_UPDATE) {
            this.storedProcedureUpdate();
            return;
        }
        this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.PREPARED_UPDATE_EXECUTE);
        if (IRISConnection.Feature.isFastInsertOption(this.statementFeatureOption)) {
            try {
                messageCount = this.writeFastInsertParameters(this.output.wire);
            }
            catch (SQLException ex) {
                this.output.wire.clearList();
                this.connection.cachedPrepares.markAsNotBeingExecuted(this.serverCursorNumber, this);
                throw ex;
            }
        } else {
            messageCount = this.writePSUpdateParameters(this.output.wire);
        }
        IRISConnection.MessageCount messageCount2 = this.connection.messageCount;
        synchronized (messageCount2) {
            if (messageCount != -1) {
                this.output.send(messageCount);
            } else {
                this.output.send(this.connection.messageCount.getCount());
            }
            try {
                if (this.input.readMessage(this, 0, 504) == 404) {
                    if (this.bus != null) {
                        this.bus = new BatchUpdateStatus(this.parameterSets, 1);
                        this.statementFeatureOption = 0;
                    }
                    this.update404();
                    return;
                }
                if (this.statementType == IRISStatement.StatementType.STMT_USE) {
                    this.connection.resetOnUse();
                }
            }
            catch (Exception ex) {
                this.connection.cachedPrepares.markAsNotBeingExecuted(this.serverCursorNumber, this);
                throw ex;
            }
            if (this.autoGeneratedKeyColumn == null) {
                this.connection.cachedPrepares.markAsNotBeingExecuted(this.serverCursorNumber, this);
            } else {
                this.connection.cachedPrepares.markAsBeingExecuted(this.serverCursorNumber, this);
            }
        }
    }

    synchronized int writePSUpdateParameters(BufferWrite wire) throws SQLException {
        int sets = this.parameterSets;
        int messageCount = -1;
        if (this.parameterSets == 0) {
            sets = 1;
        }
        wire.set(this.autoGeneratedKeyColumn);
        wire.set(0);
        wire.set(sets);
        wire.set(this.parameters.size());
        for (int j = 0; j < sets; ++j) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                Parameter par = this.parameters.get(i);
                if (par.mode == Parameter.ParameterMode.REPLACED_LITERAL || par.values.size() < j + 1) {
                    wire.setParameter(par, 0, false);
                    continue;
                }
                if (par.mode == Parameter.ParameterMode.DEFAULT_PARAMETER) {
                    wire.setUndefined();
                    continue;
                }
                if (par.values.get(j) instanceof IRISStatement.StreamWrapper) {
                    wire.setObject(this.sendStream(i, (IRISStatement.StreamWrapper)par.values.get(j)));
                    continue;
                }
                wire.setParameter(par, j, false);
            }
        }
        return messageCount;
    }

    @Override
    public void setNull(int i, int jdbcType) throws SQLException {
        this.setGeneric(i, null);
    }

    @Override
    public void setBoolean(int i, boolean x) throws SQLException {
        this.setGeneric(i, x);
    }

    @Override
    public void setByte(int i, byte x) throws SQLException {
        this.setGeneric(i, x);
    }

    @Override
    public void setShort(int i, short x) throws SQLException {
        this.setGeneric(i, x);
    }

    @Override
    public void setInt(int i, int x) throws SQLException {
        this.setGeneric(i, x);
    }

    @Override
    public void setLong(int i, long x) throws SQLException {
        this.setGeneric(i, x);
    }

    @Override
    public void setFloat(int i, float x) throws SQLException {
        this.setGeneric(i, Float.valueOf(x));
    }

    @Override
    public void setDouble(int i, double x) throws SQLException {
        this.setGeneric(i, x);
    }

    @Override
    public void setBigDecimal(int i, BigDecimal x) throws SQLException {
        this.setGeneric(i, x);
    }

    @Override
    public void setString(int i, String x) throws SQLException {
        this.setGeneric(i, x);
    }

    @Override
    public void setBytes(int i, byte[] x) throws SQLException {
        if (this.getUserParameterType(i) == -1) {
            throw new SQLException("Unsupported type conversion: byte[] to java.sql.Types.LONGVARCHAR.", "S1000");
        }
        if (this.getUserParameterType(i) == -4) {
            if (x == null) {
                this.setGeneric(i, null);
                return;
            }
            if (x.length > 10000) {
                this.setBinaryStream(i, (InputStream)new ByteArrayInputStream(x), x.length);
                return;
            }
            this.setGeneric(i, x);
            return;
        }
        this.setGeneric(i, x);
    }

    @Override
    public void setDate(int i, Date x) throws SQLException {
        this.setGeneric(i, x);
    }

    @Override
    public void setTime(int i, Time x) throws SQLException {
        this.setGeneric(i, x);
    }

    @Override
    public void setTimestamp(int i, Timestamp x) throws SQLException {
        this.setGeneric(i, x);
    }

    @Override
    public void setAsciiStream(int i, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setGeneric(i, null);
            return;
        }
        if (x.markSupported()) {
            x.mark(0);
        }
        this.setGeneric(i, new IRISStatement.StreamWrapper(x, 0, length));
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int i, InputStream x, int length) throws SQLException {
        throw new SQLException("This api is no longer supported.", "S1000");
    }

    @Override
    public void setBinaryStream(int i, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setGeneric(i, null);
            return;
        }
        if (this.getUserParameterType(i) == -1) {
            throw new SQLException("Unsupported type conversion: (binary) InputStream to java.sql.Types.LONGVARCHAR.", "S1000");
        }
        if (x.markSupported()) {
            x.mark(0);
        }
        this.setGeneric(i, new IRISStatement.StreamWrapper(x, 1, length));
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        if (this.parameterSets < 1) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                this.unbindParameter(i);
            }
            this.parameterSets = 0;
        }
    }

    @Override
    public void setObject(int i, Object x, int targetJdbcType) throws SQLException {
        this.setObject(i, x);
    }

    @Override
    public void setObject(int i, Object x, int targetJdbcType, int scale) throws SQLException {
        if (x == null) {
            this.setGeneric(i, null);
            return;
        }
        if (targetJdbcType == 2 || targetJdbcType == 3) {
            this.setGeneric(i, x, scale);
        } else {
            this.setObject(i, x);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void setObject(int i, Object x) throws SQLException {
        if (x == null) {
            this.setGeneric(i, null);
            return;
        }
        if (x instanceof ArrayList) {
            this.setGeneric(i, x);
            return;
        }
        int jdbcType = this.getUserParameterType(i);
        if (jdbcType == -1 || jdbcType == -4) {
            if (x instanceof String) {
                if (((String)x).length() > 10000) {
                    this.setCharacterStream(i, (Reader)new StringReader((String)x), -1);
                    return;
                } else {
                    this.setGeneric(i, x);
                }
                return;
            } else if (x instanceof byte[]) {
                if (((byte[])x).length > 10000) {
                    this.setBinaryStream(i, (InputStream)new ByteArrayInputStream((byte[])x), ((byte[])x).length);
                    return;
                } else {
                    this.setGeneric(i, x);
                }
                return;
            } else if (x instanceof char[]) {
                if (((char[])x).length > 10000) {
                    this.setCharacterStream(i, (Reader)new CharArrayReader((char[])x), ((char[])x).length);
                    return;
                } else {
                    this.setGeneric(i, x);
                }
                return;
            } else if (x instanceof InputStream) {
                if (jdbcType == -1) {
                    this.setAsciiStream(i, (InputStream)x, -1);
                    return;
                } else {
                    this.setBinaryStream(i, (InputStream)x, -1);
                }
                return;
            } else if (x instanceof Reader && jdbcType == -1) {
                this.setCharacterStream(i, (Reader)x, -1);
                return;
            } else if (x instanceof Clob && jdbcType == -1) {
                this.setClob(i, (Clob)x);
                return;
            } else if (x instanceof Blob && jdbcType == -4) {
                this.setBlob(i, (Blob)x);
                return;
            } else if (x instanceof IRISStatement.StreamWrapper) {
                this.setGeneric(i, x);
                return;
            } else {
                if (jdbcType == -4) {
                    throw new SQLException("Unsupported type conversion: " + x.getClass().getName() + " to java.sql.Types.LONGVARBINARY.", "S1000");
                }
                if (!(x instanceof Integer) && !(x instanceof Long) && !(x instanceof Short) && !(x instanceof Float) && !(x instanceof Double) && !(x instanceof BigDecimal) && !(x instanceof Boolean) && !(x instanceof Date) && !(x instanceof Time) && !(x instanceof Timestamp) && !(x instanceof Byte)) throw new SQLException("Unsupported type conversion: " + x.getClass().getName() + " to java.sql.Types.LONGVARCHAR.", "S1000");
                this.setGeneric(i, x);
            }
            return;
        } else {
            if (jdbcType == 2002) {
                throw new SQLException("java.sql.Types.STRUCT not supported.", "IM001");
            }
            this.setGeneric(i, x);
        }
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open.", "08003");
        }
        this.genericExecuteCalled = true;
        if (this.multipleResultSets) {
            return this.executeMultipleResultSets(true);
        }
        if (this.statementType == IRISStatement.StatementType.QUERY || this.statementType == IRISStatement.StatementType.PREPARED_CALL_QUERY) {
            this.Query();
            this.updateCnt = -1;
            return true;
        }
        this.Update();
        if (!(this.parameterSets != 0 || this.multipleResultSets && this.getSQLDialect() != 0)) {
            this.updateCnt = this.input.wire.getInt();
        }
        if (this.statementType == IRISStatement.StatementType.STMT_USE) {
            this.connection.resetOnUse();
        }
        return false;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new SQLException("execute(String sql) form not allowed.", "S1000");
    }

    synchronized void prepare(String sql) throws SQLException {
        this.cleanUp();
        this.preparse(sql);
        this.prepareInternal();
    }

    synchronized void prepare(String sql, IRISStatement.StatementType statementType, long paramCount) throws SQLException {
        this.cleanUp();
        this.preparse(sql, statementType, paramCount);
        this.prepareInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void prepareInternal() throws SQLException {
        if (this.statementType == IRISStatement.StatementType.CALLWITHRESULT) {
            throw new SQLException("No output parameters allowed.");
        }
        if (this.getSQLDialect() != 0) {
            this.prepareDialect();
            return;
        }
        if (this.statementType == IRISStatement.StatementType.CALL) {
            if (!this.getCachedInfo(this.sqlText)) {
                this.prepareStoredProcedure();
            }
            return;
        }
        if (this.statementType != IRISStatement.StatementType.DDL_ALTER_DROP && this.statementType != IRISStatement.StatementType.DDL_OTHER && this.getCachedInfo(this.sqlText)) {
            return;
        }
        this.serverCursorNumber = this.connection.getServerCursorNumber();
        this.connection.updateCache();
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.PREPARE);
            this.output.wire.setSQLText(this.sqlText);
            this.output.wire.append(this.additionalParameterInfo);
            this.output.send(this.connection.messageCount.getCount());
            try {
                this.input.readMessage(this, 0, 0);
                if (this.connection.isFastOption()) {
                    this.checkStatementFeature(this.input.wire);
                }
                if (this.statementType == IRISStatement.StatementType.QUERY) {
                    this.columnInfo(this.input.wire);
                    this.parameterInfo(this.input.wire);
                } else {
                    this.parameterInfo(this.input.wire);
                }
            }
            catch (SQLException ex) {
                this.connection.recycledServerCursorNumber = this.serverCursorNumber;
                throw ex;
            }
        }
        if (this.addToServerCache) {
            this.connection.addCachedPrepare(this, this.statementType == IRISStatement.StatementType.QUERY);
        } else {
            this.connection.recycledServerCursorNumber = this.serverCursorNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void prepareDialect() throws SQLException {
        this.serverCursorNumber = this.connection.getServerCursorNumber();
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.PREPARE_DIALECT);
            this.output.wire.set(this.sqlDialect);
            this.output.wire.set(this.sqlText);
            this.output.send(this.connection.messageCount.getCount());
            this.input.readMessage(this, 0, 0);
            int parameterCount = this.input.wire.getInt();
            for (int i = 0; i < parameterCount; ++i) {
                this.parameters.add(new Parameter());
            }
            this.readParameterData(this.input.wire, parameterCount, false);
            this.mrsDone = false;
        }
    }

    synchronized void setGeneric(int i, Object obj) throws SQLException {
        if (this.execParams != null) {
            Parameter execParam = this.getExecParam(i);
            execParam.value = obj;
            execParam.mode = Parameter.ParameterMode.INPUT;
            execParam.bound = true;
            return;
        }
        this.setGeneric(i, obj, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setGeneric(int i, Object obj, Object whatever) throws SQLException {
        if (this.execParams != null) {
            Parameter execParam = this.getExecParam(i);
            execParam.value = obj;
            execParam.mode = Parameter.ParameterMode.INPUT;
            execParam.bound = true;
            return;
        }
        ParameterCollection parameterCollection = this.parameters;
        synchronized (parameterCollection) {
            if (obj instanceof ArrayList) {
                this.parameters.arrayBound = true;
            }
            this.parameters.getUserParameter(i).bind(obj, whatever, this.parameterSets);
        }
    }

    @Override
    void validateParameters() throws SQLException {
        int i = 0;
        if (IRISConnection.Feature.isFastColumnarOption(this.statementFeatureOption) && this.parameterSets > 1000000) {
            throw new SQLException("Batch size is limited to less than One Million for Columnar data!", "S1000");
        }
        if (this.hasReturnValue == 1 || this.hasReturnValue == 3) {
            i = 1;
        }
        while (i < this.parameters.size()) {
            Parameter parameter = this.parameters.get(i);
            if (Parameter.ParameterMode.UNKNOWN == parameter.mode) {
                if (this.parameters.hasNamedParameters()) {
                    parameter.mode = Parameter.ParameterMode.DEFAULT_PARAMETER;
                } else {
                    this.connection.cachedPrepares.markAsNotBeingExecuted(this.serverCursorNumber, this);
                    throw new SQLException("Not all parameters bound/registered.", "07001", 7001);
                }
            }
            if (IRISConnection.Feature.isFastColumnarOption(this.statementFeatureOption) && this.runningBatch && parameter.isVector()) {
                if (parameter.type == 12 && parameter.precision > 12) {
                    int maxRows = 15000000 / parameter.precision;
                    if (parameter.values.size() > maxRows) {
                        throw new SQLException("Batch size is limited to less than " + maxRows + " for this insert of Columnar data!", "S1000");
                    }
                }
                parameter.outBuffer = null;
                BufferWrite tmpBuffer = new BufferWrite(this.connection.getServerLocale());
                tmpBuffer.setVectorBuffer(parameter, this.bus);
            }
            ++i;
        }
    }

    public synchronized void setDefault(int i) throws SQLException {
        this.parameters.getUserParameter((int)i).mode = Parameter.ParameterMode.DEFAULT_PARAMETER;
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.parameters.arrayBound && this.parameters.size() > 0) {
            int cnt = 0;
            boolean first = true;
            for (int i = 1; i <= this.parameters.userParametersSize(); ++i) {
                cnt = this.parameters.getUserParameter((int)i).values.size();
                if (cnt <= 1) continue;
                if (first) {
                    this.parameterSets = cnt;
                    first = false;
                    continue;
                }
                if (this.parameterSets == cnt) continue;
                throw new SQLException("Unmatched columnwise parameter values: " + this.parameterSets + " rows expected, but found only " + cnt + " in " + i + " parameter!", "S1000");
            }
            if (this.parameterSets > 1) {
                return;
            }
        }
        ++this.parameterSets;
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter par = this.parameters.get(i);
            if (par.mode == Parameter.ParameterMode.REPLACED_LITERAL || par.values.size() == this.parameterSets) continue;
            if (this.parameterSets != 1 && par.values.size() + 1 == this.parameterSets) {
                par.whatever.add(par.whatever.get(par.values.size() - 1));
                par.values.add(par.values.get(par.values.size() - 1));
                continue;
            }
            this.connection.cachedPrepares.markAsNotBeingExecuted(this.serverCursorNumber, this);
            throw new SQLException("Not all parameters bound for this addBatch.", "S1000");
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("addBatch(String sql) form not allowed.", "S1000");
    }

    @Override
    public void setCharacterStream(int i, Reader reader, int length) throws SQLException {
        if (reader == null) {
            this.setGeneric(i, null);
            return;
        }
        this.setGeneric(i, new IRISStatement.StreamWrapper(reader, 4, length));
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        if (x == null) {
            this.setGeneric(i, null);
            return;
        }
        if (this.getUserParameterType(i) != -4) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setBinaryStream(i, x.getBinaryStream(), (int)x.length());
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        if (x == null) {
            this.setGeneric(i, null);
            return;
        }
        if (this.getUserParameterType(i) != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setCharacterStream(i, x.getCharacterStream(), (int)x.length());
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        return new IRISResultSetMetaData(this);
    }

    @Override
    public void setDate(int i, Date x, Calendar cal) throws SQLException {
        this.setGeneric(i, x, cal);
    }

    @Override
    public void setTime(int i, Time x, Calendar cal) throws SQLException {
        this.setGeneric(i, x, cal);
    }

    @Override
    public void setTimestamp(int i, Timestamp x, Calendar cal) throws SQLException {
        this.setGeneric(i, x, cal);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setGeneric(paramIndex, null);
    }

    @Override
    public void setURL(int i, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new IRISParameterMetaData(this.parameters);
    }

    public InternalParameterMetaData getInternalParameterMetaData() throws SQLException {
        return new InternalParameterMetaData(this.parameters);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setClob(int i, Reader reader, long length) throws SQLException {
        if (reader == null) {
            this.setGeneric(i, null);
            return;
        }
        if (this.getUserParameterType(i) != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setCharacterStream(i, reader, length);
    }

    @Override
    public void setBlob(int i, InputStream inputStream, long length) throws SQLException {
        if (inputStream == null) {
            this.setGeneric(i, null);
            return;
        }
        if (this.getUserParameterType(i) != -4) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setBinaryStream(i, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            int available = 0;
            try {
                available = x.available();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (available == 0 || available > Integer.MAX_VALUE) {
                throw new SQLException("Stream too long: " + length);
            }
            length = available;
        }
        this.setAsciiStream(parameterIndex, x, (int)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            int available = 0;
            try {
                available = x.available();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (available == 0 || available > Integer.MAX_VALUE) {
                throw new SQLException("Stream too long: " + length);
            }
            length = available;
        }
        this.setBinaryStream(parameterIndex, x, (int)length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("Stream too long: " + length);
        }
        this.setCharacterStream(parameterIndex, reader, (int)length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setAsciiStream(parameterIndex, x, -1);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x, -1);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, -1);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int i, Reader reader) throws SQLException {
        if (reader == null) {
            this.setGeneric(i, null);
            return;
        }
        if (this.getUserParameterType(i) != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setCharacterStream(i, reader);
    }

    @Override
    public void setBlob(int i, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setGeneric(i, null);
            return;
        }
        if (this.getUserParameterType(i) != -4) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setBinaryStream(i, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.setClob(parameterIndex, value);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    protected void throwIfNotUnicodeServer() throws SQLException {
        if (!this.connection.connectionInfo.isUnicodeServer) {
            throw new SQLException("Not connected to Unicode server.");
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        int i;
        block29: {
            this.runningBatch = true;
            if (this.closed) {
                throw new SQLException("This Statement object is closed.", "08003");
            }
            if (this.connection == null || this.connection.isClosed()) {
                throw new SQLException("Connection not open.", "08003");
            }
            if (this.parameterSets == 0) {
                return new int[0];
            }
            for (i = 0; i < this.parameters.size(); ++i) {
                if (!this.isOutParameter(i)) continue;
                throw new SQLException("INOUT/OUT parameters not permitted.", "S1000");
            }
            this.bus = new BatchUpdateStatus(this.parameterSets, 1);
            try {
                this.executeUpdate();
            }
            catch (SQLException sqlExc) {
                this.connection.cachedPrepares.remove(this.serverCursorNumber);
                this.connection.recycledServerCursorNumber = this.serverCursorNumber;
                if (this.bus == null || this.parameterSets <= this.bus.getErrors()) break block29;
                if (null != this.input.wire) {
                    this.bus.setException(sqlExc, this.input.wire.isEnd());
                }
                this.bus.setException(sqlExc, true);
            }
        }
        if (!this.batchInsertErrorFormat) {
            if (!IRISConnection.Feature.isFastInsertOption(this.statementFeatureOption)) {
                for (i = 0; i < this.parameterSets; ++i) {
                    this.bus.setServerUpdateCount(i, this.input.wire.getInt());
                }
            } else if (this.fiParamSetsSent > 1) {
                if (this.input.wire == null || this.input.wire.isEnd()) {
                    this.runningBatch = false;
                    throw this.bus;
                }
                int numErrors = this.input.wire.getInt();
                if (numErrors != 0) {
                    int SqlCode = this.input.wire.getInt();
                    String sqlState = null;
                    String errMsg = this.input.wire.getString();
                    int clientErrorCnt = 0;
                    int originalRow = 0;
                    int rowErrored = 0;
                    boolean fileFirstSvrError = true;
                    boolean clientError = this.bus.hadException();
                    for (int e = 0; e < numErrors; ++e) {
                        rowErrored = this.input.wire.getInt();
                        if (clientError) {
                            while (originalRow < rowErrored + clientErrorCnt) {
                                if (this.bus.updateCount[originalRow] == -3) {
                                    ++clientErrorCnt;
                                }
                                ++originalRow;
                            }
                        }
                        this.bus.updateCount[rowErrored + clientErrorCnt - 1] = -3;
                        if (!fileFirstSvrError) continue;
                        this.bus.setException(new SQLValidationException(errMsg, sqlState, SqlCode, true), false, rowErrored + clientErrorCnt - 1);
                        fileFirstSvrError = false;
                    }
                }
            }
        } else if (this.parameterSets > 1) {
            if (this.input.wire == null || this.input.wire.isEnd()) {
                this.runningBatch = false;
                throw this.bus;
            }
            int numErrors = this.input.wire.getInt();
            if (numErrors != 0) {
                int SqlCode = 0;
                String sqlState = null;
                String errMsg = "";
                int clientErrorCnt = 0;
                int originalRow = 0;
                int rowErrored = 0;
                boolean clientError = this.bus.hadException();
                for (int e = 0; e < numErrors; ++e) {
                    ListReader rowError = this.input.wire.getInnerList();
                    rowErrored = rowError.getInt();
                    while (!rowError.isEnd()) {
                        SqlCode = rowError.getInt();
                        errMsg = rowError.getString();
                    }
                    if (clientError) {
                        while (originalRow < rowErrored + clientErrorCnt) {
                            if (this.bus.updateCount[originalRow] == -3) {
                                ++clientErrorCnt;
                            }
                            ++originalRow;
                        }
                    }
                    this.bus.setException(new SQLValidationException(errMsg, sqlState, SqlCode, true), false, rowErrored + clientErrorCnt - 1);
                }
            }
        }
        if (this.bus.hadException()) {
            if (this.parameterSets == 1 && this.bus.updateCount[0] == (IRISConnection.Feature.isFastInsertOption(this.statementFeatureOption) ? 1 : 0)) {
                this.bus.updateCount[0] = -3;
            }
            this.parameterSets = 0;
            this.runningBatch = false;
            this.bus.throwException("Not all rows updated.");
        }
        this.clearBatch();
        return this.bus.updateCount;
    }
}

