/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.BufferRO;
import com.intersystems.jdbc.Descriptor;
import com.intersystems.jdbc.IRISBlob;
import com.intersystems.jdbc.IRISCallableStatement;
import com.intersystems.jdbc.IRISClob;
import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.IRISInputStream;
import com.intersystems.jdbc.IRISNClob;
import com.intersystems.jdbc.IRISReader;
import com.intersystems.jdbc.IRISResultSetMetaData;
import com.intersystems.jdbc.IRISRowId;
import com.intersystems.jdbc.IRISStatement;
import com.intersystems.jdbc.IRISUpdatableResultSet;
import com.intersystems.jdbc.IRISWrapper;
import com.intersystems.jdbc.ListReader;
import com.intersystems.jdbc.RealStream;
import com.intersystems.jdbc.ResultSetRow;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class IRISResultSet
extends IRISWrapper
implements ResultSet {
    static final int GET_RESULT_SET_OBJECT_INIT = 0;
    static final int GET_RESULT_SET_OBJECT_MORE_DATA = 1;
    static final int GET_RESULT_SET_OBJECT_CLOSE = 2;
    int rowID;
    int currentRow;
    boolean closed;
    boolean isAfterLast;
    IRISStatement statement;
    String cacheResultSetOref;
    List<RealStream> streamsFetchedAsLiterals;
    ResultSetRow rsRow;
    boolean newRow = false;

    IRISResultSet(IRISStatement stmt) throws SQLException {
        this.statement = stmt;
        this.currentRow = 0;
        this.closed = false;
        this.isAfterLast = false;
        this.cacheResultSetOref = null;
        this.streamsFetchedAsLiterals = new ArrayList<RealStream>();
        stmt.weakResultSetReference = new WeakReference<IRISResultSet>(this);
    }

    IRISResultSet(IRISStatement stmt, String crso) throws SQLException {
        this.statement = stmt;
        this.currentRow = 0;
        this.closed = false;
        this.isAfterLast = false;
        this.cacheResultSetOref = crso;
        this.streamsFetchedAsLiterals = new ArrayList<RealStream>();
    }

    @Override
    public synchronized boolean next() throws SQLException {
        this.throwIfClosed();
        if (this.isAfterLast || this.statement.getMaxRows() != 0 && this.currentRow == this.statement.getMaxRows()) {
            return false;
        }
        if (!this.streamsFetchedAsLiterals.isEmpty()) {
            this.closeLiteralStreams();
        }
        if (this.currentRow == 0) {
            this.rsRow = IRISConnection.Feature.isFastSelectOption(this.statement.statementFeatureOption) ? new ResultSetRow(this.statement.columns, this.statement.maxRowItemCount, this.statement.input.wire.getOffset()) : new ResultSetRow(this.statement.columns.size(), this.statement.input.wire.getOffset());
        }
        while (!this.rsRow.indexRow(this.statement.input.wire.getBuffer(), this.statement.input.wire.getEndLength())) {
            if (this.statement.fetchDone) {
                this.isAfterLast = true;
                if (this.statement.canceled) {
                    this.statement.canceled = false;
                    this.statement.close();
                    throw new SQLException("A severe error occurred on the current statement.  The results, if any, should be discarded.\r\nOperation cancelled by user.");
                }
                return false;
            }
            this.fetchMoreData(!this.rsRow.partialIndex);
            this.statement.input.wire.setOffset(0);
        }
        ++this.currentRow;
        this.newRow = true;
        return true;
    }

    public Object getWire() throws SQLException {
        int n = this.statement.columns.size();
        this.statement.input.wire.setOffset(this.rsRow.rowIndex[0]);
        return new BufferRO(this.statement.input.wire, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.statement == null) {
            return;
        }
        if (this.statement.connection == null || this.statement.connection.isClosed()) {
            return;
        }
        if (this.statement.weakResultSetReference == null || this == this.statement.weakResultSetReference.get()) {
            this.statement.cleanUpFetches();
        }
        this.currentRow = 0;
        if (this.cacheResultSetOref != null && !this.statement.fetchDone) {
            this.statement.output.wire.writeHeader(this.statement.serverCursorNumber, IRISConnection.GET_RESULT_SET_OBJECT);
            this.statement.output.wire.set(this.cacheResultSetOref);
            this.statement.output.wire.set(2);
            this.statement.output.send(this.statement.connection.messageCount.getCount());
            return;
        }
        if (this.statement.connection.cachedPrepares.isOwner(this.statement.serverCursorNumber, this.statement)) {
            if (this.statement.resultSetType != 1003 || this.statement.resultSetType == 1003 && !this.statement.fetchDone) {
                IRISConnection.MessageCount messageCount = this.statement.connection.messageCount;
                synchronized (messageCount) {
                    this.statement.output.wire.writeHeader(this.statement.serverCursorNumber, IRISConnection.CLOSE_CURSOR);
                    this.statement.output.send(this.statement.connection.messageCount.getCount());
                }
                if (!this.statement.hasStreamColumns) {
                    this.statement.connection.cachedPrepares.markAsNotBeingExecuted(this.statement.serverCursorNumber, this.statement);
                }
            }
            if (this.statement.autoGeneratedKeyColumn != null) {
                this.statement.connection.cachedPrepares.markAsNotBeingExecuted(this.statement.serverCursorNumber, this.statement);
            }
        }
        this.statement.myResultSet = null;
        this.closed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.statement.input.wire.isNull();
    }

    @Override
    public String getString(int i) throws SQLException {
        if (i < 0 || i > this.statement.columns.size() || i == 0 && !(this instanceof IRISUpdatableResultSet)) {
            throw new SQLException("Cursor out of range.", "S1000", 460);
        }
        Descriptor col = this.statement.columns.get(i - 1);
        switch (col.type) {
            case 2: 
            case 3: {
                BigDecimal bd = this.getBigDecimal(i);
                if (bd == null) {
                    return null;
                }
                return bd.toPlainString();
            }
            case 8: {
                double dbl = this.getDouble(i);
                if (this.statement.input.wire.isNull()) {
                    return null;
                }
                return String.valueOf(dbl);
            }
            case -4: {
                IRISInputStream x = (IRISInputStream)this.getStream(i, 1, col.type);
                if (x == null) {
                    return null;
                }
                if (x.stream instanceof RealStream) {
                    this.streamsFetchedAsLiterals.add((RealStream)x.stream);
                }
                return x.toUnicodeString();
            }
            case -1: {
                IRISReader reader = (IRISReader)this.getStream(i, 4, col.type);
                if (reader == null) {
                    return null;
                }
                if (reader.stream instanceof RealStream) {
                    this.streamsFetchedAsLiterals.add((RealStream)reader.stream);
                }
                return reader.toUnicodeString();
            }
            case 1091: {
                this.checkAndPosition(i);
                Date obj = this.statement.input.wire.getDate();
                if (null == obj) {
                    return null;
                }
                return ((Object)obj).toString();
            }
            case 1092: {
                this.checkAndPosition(i);
                String obj = this.statement.input.wire.getTimeAsString(col.scale);
                if (null == obj) {
                    return null;
                }
                return obj.toString();
            }
            case 1093: {
                this.checkAndPosition(i);
                Timestamp obj = this.statement.input.wire.getTimestamp();
                if (null == obj) {
                    return null;
                }
                return ((Object)obj).toString();
            }
        }
        this.checkAndPosition(i);
        if (this.statement.maxFieldSize > 0) {
            return this.statement.input.wire.getStringLen(this.statement.maxFieldSize);
        }
        return this.statement.input.wire.getString();
    }

    @Override
    public boolean getBoolean(int i) throws SQLException {
        if (i > 0 && this.statement.columns.size() >= i && this.statement.columns.get((int)(i - 1)).type == -1) {
            return Boolean.parseBoolean(this.getString(i));
        }
        this.checkAndPosition(i);
        return this.statement.input.wire.getBoolean();
    }

    @Override
    public byte getByte(int i) throws SQLException {
        if (i > 0 && this.statement.columns.size() >= i && this.statement.columns.get((int)(i - 1)).type == -1) {
            byte[] temp = this.getString(i).getBytes();
            return temp[0];
        }
        this.checkAndPosition(i);
        return this.statement.input.wire.getOneByte();
    }

    @Override
    public short getShort(int i) throws SQLException {
        if (i > 0 && this.statement.columns.size() >= i && this.statement.columns.get((int)(i - 1)).type == -1) {
            return Short.parseShort(this.getString(i));
        }
        this.checkAndPosition(i);
        return this.statement.input.wire.getShort();
    }

    @Override
    public int getInt(int i) throws SQLException {
        if (i > 0 && this.statement.columns.size() >= i && this.statement.columns.get((int)(i - 1)).type == -1) {
            return Integer.parseInt(this.getString(i));
        }
        this.checkAndPosition(i);
        return this.statement.input.wire.getInt();
    }

    @Override
    public long getLong(int i) throws SQLException {
        if (i > 0 && this.statement.columns.size() >= i && this.statement.columns.get((int)(i - 1)).type == -1) {
            return Long.parseLong(this.getString(i));
        }
        this.checkAndPosition(i);
        return this.statement.input.wire.getLong();
    }

    @Override
    public float getFloat(int i) throws SQLException {
        if (i > 0 && this.statement.columns.size() >= i && this.statement.columns.get((int)(i - 1)).type == -1) {
            return Float.parseFloat(this.getString(i));
        }
        this.checkAndPosition(i);
        return this.statement.input.wire.getFloat();
    }

    @Override
    public double getDouble(int i) throws SQLException {
        if (i > 0 && this.statement.columns.size() >= i && this.statement.columns.get((int)(i - 1)).type == -1) {
            return Double.parseDouble(this.getString(i));
        }
        this.checkAndPosition(i);
        return this.statement.input.wire.getDouble();
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int i, int scale) throws SQLException {
        this.checkAndPosition(i);
        return this.statement.input.wire.getBigDecimal(scale, true);
    }

    @Override
    public byte[] getBytes(int i) throws SQLException {
        if (i < 0 || i > this.statement.columns.size() || i == 0 && !(this instanceof IRISUpdatableResultSet)) {
            throw new SQLException("Cursor out of range.", "S1000", 460);
        }
        Descriptor col = this.statement.columns.get(i - 1);
        switch (col.type) {
            case -1: {
                throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
            }
            case -4: {
                IRISInputStream x = (IRISInputStream)this.getStream(i, 1, col.type);
                if (x == null) {
                    return null;
                }
                if (x.stream instanceof RealStream) {
                    this.streamsFetchedAsLiterals.add((RealStream)x.stream);
                }
                return x.toByte();
            }
        }
        this.checkAndPosition(i);
        int len = 0;
        if (this.statement.maxFieldSize > 0 && (col.type == -2 || col.type == -3 || col.type == -4 || col.type == 1 || col.type == 12 || col.type == -1)) {
            len = this.statement.maxFieldSize;
        }
        return this.statement.input.wire.getBytes(len);
    }

    @Override
    public Date getDate(int i) throws SQLException {
        int type = this.statement.columns.get((int)(i - 1)).type;
        if (i > 0 && this.statement.columns.size() >= i && type == -1) {
            return Date.valueOf(this.getString(i));
        }
        this.checkAndPosition(i);
        if (92 == type || 1092 == type) {
            throw new SQLException("Invalid column type", "17004", 17004);
        }
        return this.statement.input.wire.getDate();
    }

    @Override
    public Time getTime(int i) throws SQLException {
        int type = this.statement.columns.get((int)(i - 1)).type;
        if (i > 0 && this.statement.columns.size() >= i && type == -1) {
            return Time.valueOf(this.getString(i));
        }
        this.checkAndPosition(i);
        if (1091 == type || 91 == type) {
            throw new SQLException("Invalid column type", "17004", 17004);
        }
        return this.statement.input.wire.getTime();
    }

    @Override
    public Timestamp getTimestamp(int i) throws SQLException {
        if (i > 0 && this.statement.columns.size() >= i && this.statement.columns.get((int)(i - 1)).type == -1) {
            return Timestamp.valueOf(this.getString(i));
        }
        this.checkAndPosition(i);
        switch (this.statement.columns.get((int)(i - 1)).type) {
            case 91: 
            case 1091: {
                Date dt = this.statement.input.wire.getDate();
                if (dt == null) {
                    return null;
                }
                return new Timestamp(dt.getTime());
            }
            case 92: 
            case 1092: {
                Time tm = this.statement.input.wire.getTime();
                if (tm == null) {
                    return null;
                }
                return new Timestamp(tm.getTime());
            }
        }
        return this.statement.input.wire.getTimestamp();
    }

    @Override
    public InputStream getAsciiStream(int i) throws SQLException {
        if (i < 0 || i > this.statement.columns.size() || i == 0 && !(this instanceof IRISUpdatableResultSet)) {
            throw new SQLException("Cursor out of range.", "S1000", 460);
        }
        int type = this.statement.getColumnType(i);
        switch (type) {
            case -4: 
            case -1: {
                return (IRISInputStream)this.getStream(i, 0, type);
            }
            case -3: 
            case 12: {
                return new IRISInputStream(this.getBytes(i), 0, type, this.statement.getMaxFieldSize());
            }
        }
        throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int i) throws SQLException {
        throw new SQLException("This method is no longer supported.", "S1000");
    }

    @Override
    public InputStream getBinaryStream(int i) throws SQLException {
        if (i < 0 || i > this.statement.columns.size() || i == 0 && !(this instanceof IRISUpdatableResultSet)) {
            throw new SQLException("Cursor out of range.", "S1000", 460);
        }
        int type = this.statement.getColumnType(i);
        switch (type) {
            case -4: 
            case -1: {
                return (IRISInputStream)this.getStream(i, 1, type);
            }
            case -3: {
                byte[] b = this.getBytes(i);
                if (b == null) {
                    return null;
                }
                return new IRISInputStream(b, 1, type, this.statement.getMaxFieldSize());
            }
        }
        throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw new SQLException("This method is no longer supported.", "S1000");
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.throwIfClosed();
        return new IRISResultSetMetaData(this.statement);
    }

    @Override
    public Object getObject(int i) throws SQLException {
        Object obj;
        if (i < 0 || i > this.statement.columns.size() || i == 0 && !(this instanceof IRISUpdatableResultSet)) {
            throw new SQLException("Cursor out of range.", "S1000", 460);
        }
        Descriptor col = this.statement.columns.get(i - 1);
        if (col.type == -1) {
            return this.getAsciiStream(i);
        }
        if (col.type == -4) {
            return this.getBinaryStream(i);
        }
        this.checkAndPosition(i);
        switch (col.type) {
            case 12: {
                obj = this.statement.input.wire.getString();
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                obj = this.statement.input.wire.getInt();
                break;
            }
            case 8: {
                obj = this.statement.input.wire.getDouble();
                break;
            }
            case 91: 
            case 1091: {
                obj = this.statement.input.wire.getDate();
                break;
            }
            case 92: 
            case 1092: {
                obj = this.statement.input.wire.getTime();
                break;
            }
            case 93: 
            case 1093: {
                obj = this.statement.input.wire.getTimestamp();
                break;
            }
            case -7: {
                obj = this.statement.input.wire.getBoolean();
                break;
            }
            case 2: {
                obj = this.statement.input.wire.getBigDecimal(col.scale, true);
                break;
            }
            case -3: 
            case -2: {
                obj = this.statement.input.wire.getByteArray();
                break;
            }
            case -5: {
                obj = this.statement.input.wire.getLong();
                break;
            }
            default: {
                obj = this.statement.input.wire.getString();
            }
        }
        if (this.statement.input.wire.isNull()) {
            return null;
        }
        return obj;
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        for (int i = 1; i <= this.statement.columns.size(); ++i) {
            if (!columnName.equalsIgnoreCase(this.statement.getColumnName(i))) continue;
            return i;
        }
        throw new SQLException("Column does not exist: " + columnName, "S1002", 463);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    final void checkAndPosition(int i) throws SQLException {
        this.throwIfClosed();
        if (i < 0 || this.isAfterLast || this.currentRow == 0 || i == 0 && !(this instanceof IRISUpdatableResultSet)) {
            throw new SQLException("Cursor out of range.", "S1000", 460);
        }
        if (this instanceof IRISUpdatableResultSet && i != 0) {
            ((IRISUpdatableResultSet)this).rowID = this.getRowID();
            if (i > this.statement.columns.size()) {
                throw new SQLException("Invalid column number.", "S1002", 463);
            }
            ++i;
        } else if (i > this.statement.columns.size()) {
            throw new SQLException("Invalid column number.", "S1002", 463);
        }
        if (this.statement.input.wire.jump(this.rsRow.rowIndex[i - 1])) {
            this.fetchMoreData(true);
            if (this.rsRow.indexRow(this.statement.input.wire.getBuffer(), this.statement.input.wire.getOffset())) {
                throw new SQLException("Invalid column number, failed to index row", "S1000", 460);
            }
            this.statement.input.wire.jump(this.rsRow.rowIndex[i - 1]);
        }
    }

    final void checkAndPositionA(int i) throws SQLException {
        this.throwIfClosed();
        if (i < 0 || this.isAfterLast || this.currentRow == 0 || this.statement.columns.size() < i || i == 0 && !(this instanceof IRISUpdatableResultSet)) {
            throw new SQLException("Cursor out of range.", "S1000", 460);
        }
        if (this instanceof IRISUpdatableResultSet) {
            this.statement.input.wire.setOffset(this.rsRow.rowIndex[i]);
        } else {
            this.statement.input.wire.setOffset(this.rsRow.rowIndex[i - 1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void requestFetch(int Count) throws SQLException {
        IRISConnection.MessageCount messageCount = this.statement.connection.messageCount;
        synchronized (messageCount) {
            this.statement.outstandingReads = 1;
            this.statement.nextServerNumber = Count;
            this.statement.connection.activeFetchStatement = this.statement;
            if (this.statement instanceof IRISCallableStatement || this.statement.statementType == IRISStatement.StatementType.DIRECT_CALL_QUERY || this.statement.statementType == IRISStatement.StatementType.PREPARED_CALL_QUERY || this.statement.sqlDialect != 0) {
                if (this.statement.multipleResultSets) {
                    this.statement.output.wire.writeHeader(this.statement.serverCursorNumber, IRISConnection.MULTIPLE_RESULT_SETS_FETCH_DATA);
                } else {
                    this.statement.output.wire.writeHeader(this.statement.serverCursorNumber, IRISConnection.STORED_PROCEDURE_FETCH_DATA);
                }
            } else if (this.cacheResultSetOref == null) {
                this.statement.output.wire.writeHeader(this.statement.serverCursorNumber, IRISConnection.FETCH_DATA);
            } else {
                this.statement.output.wire.writeHeader(this.statement.serverCursorNumber, IRISConnection.GET_RESULT_SET_OBJECT);
                this.statement.output.wire.set(this.cacheResultSetOref);
                this.statement.output.wire.set(1);
            }
            this.statement.output.send(Count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean readFetch() throws SQLException {
        IRISConnection.MessageCount messageCount = this.statement.connection.messageCount;
        synchronized (messageCount) {
            int error;
            if (this.statement.input.messages != null && !this.statement.input.messages.isEmpty()) {
                if (this.statement.input.wire.NewRow) {
                    try {
                        this.statement.input.wire = this.statement.input.messages.take();
                    }
                    catch (InterruptedException e) {
                        throw new SQLException("Unable to fetch, Read Ahead buffer exception: " + e.getMessage());
                    }
                }
                try {
                    this.statement.input.wire = new BufferRO(this.statement.input.wire, this.statement.input.messages.take());
                }
                catch (InterruptedException e) {
                    throw new SQLException("Unable to fetch, Read Ahead buffer exception: " + e.getMessage());
                }
                error = this.statement.input.wire.Header.getError();
                if (error == 0 && this.statement.connection.activeFetchStatement != this.statement) {
                    this.statement.connection.checkOutStandingFetches();
                }
                if (error == 0) {
                    this.requestFetch(this.statement.connection.messageCount.getCount());
                }
            } else {
                error = this.statement.input.readMessage(this.statement, 2, 504);
            }
            if (error == 0) {
                this.rsRow.newBuffer = true;
                return true;
            }
            if (error == 404) {
                this.statement.connection.activeFetchStatement = null;
                throw new SQLException("Unable to fetch more data: query has been deleted.");
            }
            this.rsRow.newBuffer = true;
            return false;
        }
    }

    final boolean readOOBFetch() throws SQLException {
        boolean retval = false;
        int error = this.statement.input.readMessage(this.statement, 3, 504);
        if (error == 0) {
            retval = true;
        } else if (error == 404) {
            throw new SQLException("Unable to fetch more data: query has been deleted.");
        }
        this.statement.connection.activeFetchStatement = null;
        return retval;
    }

    final void fetchMoreData(boolean onNewRow) throws SQLException {
        if (this.statement.fetchDone) {
            return;
        }
        if (this.statement.connection == null || this.statement.connection.isClosed()) {
            throw new SQLException("Connection not open.", "08003");
        }
        this.statement.input.wire.NewRow = onNewRow;
        if (onNewRow) {
            this.statement.input.wire.setOffset(0);
        } else if (this.rsRow.rowIndex != null) {
            this.statement.input.wire.setOffset(this.rsRow.rowIndex[this.rsRow.rowIndex.length - 1]);
        }
        if (this.readFetch()) {
            return;
        }
        this.statement.handleError100(100);
    }

    int getRowID() throws SQLException {
        if (this.isAfterLast) {
            throw new SQLException("Cursor out of range.", "S1000", 460);
        }
        this.statement.input.wire.setOffset(this.rsRow.rowIndex[0]);
        int id = this.statement.input.wire.getInt();
        return id;
    }

    private Object getStream(int i, int streamType, int sqlType) throws SQLException {
        this.checkAndPosition(i);
        byte[] oref = this.statement.input.wire.getByteArray();
        if (oref == null) {
            return null;
        }
        if (this.statement.connection.getStreamPrefetchSize() != 0) {
            ListReader tempList = new ListReader();
            tempList.setList(oref);
            int listLength = tempList.count();
            if (listLength == 1 || listLength == 2 && tempList.getByteArray().length == 1) {
                Object obj = this.processStreamPrefetch(tempList, listLength, streamType, sqlType);
                if (obj == null) {
                    this.statement.input.wire.setNull();
                }
                return obj;
            }
        }
        if (streamType == 3) {
            IRISClob clob = new IRISClob(this.statement.connection, oref, this.statement.serverCursorNumber, streamType, sqlType);
            if (clob.isNull()) {
                return null;
            }
            return clob;
        }
        if (streamType == 2) {
            IRISBlob blob = new IRISBlob(this.statement.connection, oref, this.statement.serverCursorNumber, streamType, sqlType);
            if (blob.isNull()) {
                return null;
            }
            return blob;
        }
        if (streamType == 4) {
            IRISReader reader = new IRISReader(this.statement.connection, oref, this.statement.serverCursorNumber, sqlType, this.statement.getMaxFieldSize());
            if (reader.isNull()) {
                return null;
            }
            return reader;
        }
        IRISInputStream x = new IRISInputStream(this.statement.connection, oref, this.statement.serverCursorNumber, streamType, sqlType, this.statement.getMaxFieldSize());
        if (x.isNull()) {
            return null;
        }
        return x;
    }

    protected final synchronized void closeLiteralStreams() throws SQLException {
        for (RealStream stream : this.streamsFetchedAsLiterals) {
            try {
                stream.close();
            }
            catch (IOException ex) {
                throw new SQLException("Error attempting to close open streams.");
            }
        }
        this.streamsFetchedAsLiterals.clear();
    }

    @Override
    public Reader getCharacterStream(int i) throws SQLException {
        if (i < 0 || i > this.statement.columns.size() || i == 0 && !(this instanceof IRISUpdatableResultSet)) {
            throw new SQLException("Cursor out of range.", "S1000", 460);
        }
        int type = this.statement.getColumnType(i);
        switch (type) {
            case -4: 
            case -1: {
                return (IRISReader)this.getStream(i, 4, type);
            }
            case -3: 
            case 12: {
                return new IRISReader(this.getString(i));
            }
        }
        throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int i) throws SQLException {
        if (i > 0 && this.statement.columns.size() >= i && this.statement.columns.get((int)(i - 1)).type == -1) {
            return new BigDecimal(this.getString(i));
        }
        this.checkAndPosition(i);
        Descriptor desc = this.statement.columns.get(i - 1);
        switch (desc.type) {
            case 2: 
            case 3: 
            case 6: {
                return this.statement.input.wire.getBigDecimalScale(-1, desc.scale, desc.precision, true);
            }
        }
        return this.statement.input.wire.getBigDecimalScale(-1, desc.scale, desc.precision, false);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY.", "S1000");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY.", "S1000");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY.", "S1000");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY.", "S1000");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY.", "S1000");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY.", "S1000");
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY.", "S1000");
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY.", "S1000");
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY.", "S1000");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY.", "S1000");
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY.", "S1000");
    }

    void throwIfClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet closed.", "S1000", 460);
        }
    }

    @Override
    public int getRow() throws SQLException {
        return this.currentRow;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLException("Not supported.", "IM001");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public synchronized void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new SQLException("Invalid number of rows specified: " + rows, "S1000");
        }
        this.statement.fetchSize = rows;
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        return this.statement.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return this.statement.resultSetType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.statement.resultSetConcurrency;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public final Statement getStatement() throws SQLException {
        return this.statement;
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        if (this.statement.getColumnType(i) != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        return (IRISClob)this.getStream(i, 3, -1);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Date getDate(int i, Calendar cal) throws SQLException {
        int type = this.statement.columns.get((int)(i - 1)).type;
        this.checkAndPosition(i);
        if (92 == type || 1092 == type) {
            throw new SQLException("Invalid column type", "17004", 17004);
        }
        return this.statement.input.wire.getDate(cal);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public Time getTime(int i, Calendar cal) throws SQLException {
        int type = this.statement.columns.get((int)(i - 1)).type;
        this.checkAndPosition(i);
        if (1091 == type || 91 == type) {
            throw new SQLException("Invalid column type", "17004", 17004);
        }
        return this.statement.input.wire.getTime(cal);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        this.checkAndPosition(i);
        switch (this.statement.columns.get((int)(i - 1)).type) {
            case 91: 
            case 1091: {
                Date dt = this.statement.input.wire.getDate(cal);
                if (dt == null) {
                    return null;
                }
                return new Timestamp(dt.getTime());
            }
            case 92: 
            case 1092: {
                Time tm = this.statement.input.wire.getTime(cal);
                if (tm == null) {
                    return null;
                }
                return new Timestamp(tm.getTime());
            }
        }
        return this.statement.input.wire.getTimestamp(cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        if (this.statement.getColumnType(i) != -4) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        return (IRISBlob)this.getStream(i, 2, -4);
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        this.throwIfNotUnicodeServer();
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        this.throwIfNotUnicodeServer();
        return this.getString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.throwIfNotUnicodeServer();
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        this.throwIfNotUnicodeServer();
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        if (!this.statement.isRowId(columnIndex)) {
            throw new SQLException("Not a Row Id column.");
        }
        return new IRISRowId(this.getString(columnIndex));
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        this.throwIfNotUnicodeServer();
        if (this.statement.getColumnType(i) != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        return (IRISNClob)this.getStream(i, 3, -1);
    }

    @Override
    public NClob getNClob(String columnName) throws SQLException {
        return this.getNClob(this.findColumn(columnName));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY.", "S1000");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(int i, Class<T> type) throws SQLException {
        String sType = type.getName();
        Object obj = null;
        if (i < 0 || i > this.statement.columns.size() || i == 0 && !(this instanceof IRISUpdatableResultSet)) {
            throw new SQLException("Cursor out of range.", "S1000", 460);
        }
        Descriptor col = this.statement.columns.get(i - 1);
        this.checkAndPosition(i);
        switch (sType) {
            case "java.lang.String": {
                obj = this.statement.input.wire.getString();
                break;
            }
            case "java.sql.Date": {
                obj = this.statement.input.wire.getDate();
                break;
            }
            case "java.sql.Time": {
                obj = this.statement.input.wire.getTime();
                break;
            }
            case "java.sql.Timestamp": {
                obj = this.statement.input.wire.getTimestamp();
                break;
            }
            case "java.time.LocalDate": {
                obj = this.statement.input.wire.getLocalDate();
                break;
            }
            case "java.time.LocalTime": {
                obj = this.statement.input.wire.getLocalTime();
                break;
            }
            case "java.time.LocalDateTime": {
                obj = this.statement.input.wire.getLocalDateTime();
                break;
            }
            case "java.lang.Byte": {
                obj = this.statement.input.wire.getByte();
                break;
            }
            case "java.lang.Short": {
                obj = this.statement.input.wire.getShort();
                break;
            }
            case "java.lang.Integer": {
                obj = this.statement.input.wire.getInt();
                break;
            }
            case "java.lang.Long": {
                obj = this.statement.input.wire.getLong();
                break;
            }
            case "java.lang.Double": {
                obj = this.statement.input.wire.getDouble();
                break;
            }
            case "java.lang.Float": {
                obj = Float.valueOf(this.statement.input.wire.getFloat());
                break;
            }
            case "java.lang.Boolean": {
                obj = this.statement.input.wire.getBoolean();
                break;
            }
            case "java.math.BigInteger": {
                obj = this.statement.input.wire.getBigInteger();
                break;
            }
            case "java.math.BigDecimal": {
                obj = this.statement.input.wire.getBigDecimal(col.scale, true);
                break;
            }
            case "[B": {
                obj = this.statement.input.wire.getByteArray();
                break;
            }
            case "java.io.InputStream": {
                obj = this.getBinaryStream(i);
                break;
            }
            case "java.sql.Blob": {
                obj = this.getBlob(i);
                break;
            }
            case "java.io.Reader": {
                obj = this.getCharacterStream(i);
                break;
            }
            case "java.sql.Clob": {
                obj = this.getClob(i);
                break;
            }
            case "java.sql.NClob": {
                obj = this.getNClob(i);
                break;
            }
            case "java.lang.Character": {
                String tempVal = this.statement.input.wire.getString();
                obj = tempVal != null ? Character.valueOf(tempVal.charAt(0)) : null;
                break;
            }
            case "[C": {
                String tempVal1 = this.statement.input.wire.getString();
                obj = tempVal1 != null ? tempVal1.toCharArray() : null;
                break;
            }
            default: {
                try {
                    obj = this.statement.input.wire.getString();
                    break;
                }
                catch (SQLException sqlex) {
                    throw sqlex;
                }
                catch (Exception e) {
                    throw new SQLException("Failed to convert to Type: " + sType);
                }
            }
        }
        return (T)obj;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    private Object processStreamPrefetch(ListReader tempList, int listLength, int streamType, int sqlType) throws SQLException {
        if (listLength == 1) {
            byte[] data = new byte[]{};
            if (streamType == 4) {
                return new IRISReader(new String(data));
            }
            return new IRISInputStream(data, streamType, sqlType, 0);
        }
        int maxFieldSize = this.statement.getMaxFieldSize();
        if (streamType == 4 || streamType == 0) {
            String str = tempList.getString();
            if (str == null) {
                return null;
            }
            if (maxFieldSize > 0 && maxFieldSize < str.length()) {
                str = str.substring(0, maxFieldSize);
            }
            if (streamType == 4) {
                return new IRISReader(str);
            }
            try {
                if (str.equals("")) {
                    byte[] data = new byte[]{0};
                    return new IRISInputStream(data, streamType, sqlType, maxFieldSize);
                }
                return new IRISInputStream(str.getBytes("UTF-8"), streamType, sqlType, maxFieldSize);
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException(e.getMessage());
            }
        }
        if (streamType == 1) {
            byte[] data = tempList.getByteArray();
            if (data == null) {
                return null;
            }
            if (data.length == 0) {
                data = new byte[]{0};
            }
            return new IRISInputStream(data, streamType, sqlType, maxFieldSize);
        }
        throw new SQLException("The stream value has been prefetched, cannot use Blob/Clob type for stream access.");
    }

    void throwIfNotUnicodeServer() throws SQLException {
        if (!this.statement.connection.connectionInfo.isUnicodeServer) {
            throw new SQLException("Not connected to Unicode server.");
        }
    }
}

