/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.IRISStatement;
import com.intersystems.jdbc.IRISWrapper;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class IRISResultSetMetaData
extends IRISWrapper
implements ResultSetMetaData {
    private IRISStatement statement;

    IRISResultSetMetaData(IRISStatement stmt) throws SQLException {
        this.statement = stmt;
    }

    private void checkColumnRange(int column) throws SQLException {
        if (column <= 0 || column > this.statement.columns.size()) {
            throw new SQLException("Invalid column number.", "S1002", 463);
        }
    }

    @Override
    public synchronized int getColumnCount() throws SQLException {
        return this.statement.columns.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkColumnRange(column);
        return this.statement.isAutoIncrement(column);
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.checkColumnRange(column);
        return this.statement.isCaseSensitive(column);
    }

    @Override
    public synchronized boolean isCurrency(int column) throws SQLException {
        this.checkColumnRange(column);
        return this.statement.isCurrency(column);
    }

    @Override
    public synchronized int isNullable(int column) throws SQLException {
        this.checkColumnRange(column);
        return this.statement.getColumnNullable(column);
    }

    @Override
    public synchronized boolean isSigned(int column) throws SQLException {
        this.checkColumnRange(column);
        switch (this.statement.getColumnType(column)) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized int getColumnDisplaySize(int column) throws SQLException {
        this.checkColumnRange(column);
        int colType = this.statement.getColumnType(column);
        if (colType > 1000) {
            colType -= 1000;
        }
        switch (colType) {
            case -5: {
                return 20;
            }
            case 93: {
                return 19;
            }
            case 6: 
            case 8: {
                return 22;
            }
            case 91: {
                return 10;
            }
            case 4: {
                return 11;
            }
            case 92: {
                return 8;
            }
            case 7: {
                return 13;
            }
            case 5: {
                return 6;
            }
            case -6: {
                return 4;
            }
            case -7: {
                return 5;
            }
            case 2: 
            case 3: {
                return this.statement.getColumnPrecision(column) + 2;
            }
        }
        return this.statement.getColumnPrecision(column);
    }

    @Override
    public synchronized String getColumnLabel(int column) throws SQLException {
        this.checkColumnRange(column);
        return this.statement.getColumnLabel(column);
    }

    @Override
    public synchronized String getColumnName(int column) throws SQLException {
        this.checkColumnRange(column);
        return this.statement.getColumnName(column);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.checkColumnRange(column);
        return this.statement.getColumnSchemaName(column);
    }

    @Override
    public synchronized int getPrecision(int column) throws SQLException {
        this.checkColumnRange(column);
        return this.statement.getColumnPrecision(column);
    }

    @Override
    public synchronized int getScale(int column) throws SQLException {
        this.checkColumnRange(column);
        return this.statement.getColumnScale(column);
    }

    @Override
    public synchronized String getTableName(int column) throws SQLException {
        this.checkColumnRange(column);
        return this.statement.getColumnTableName(column);
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.checkColumnRange(column);
        return "";
    }

    @Override
    public synchronized int getColumnType(int column) throws SQLException {
        this.checkColumnRange(column);
        int colType = this.statement.getColumnType(column);
        if (colType > 1000) {
            colType -= 1000;
        }
        return colType;
    }

    @Override
    public synchronized String getColumnTypeName(int column) throws SQLException {
        this.checkColumnRange(column);
        int colType = this.statement.getColumnType(column);
        if (colType > 1000) {
            colType -= 1000;
        }
        switch (colType) {
            case -5: {
                return "BIGINT";
            }
            case -7: {
                return "BIT";
            }
            case -2: {
                return "BINARY";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 2: {
                return "NUMERIC";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
            case -11: {
                return "UNIQUEIDENTIFIER";
            }
        }
        return "UNKNOWN TYPE";
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.checkColumnRange(column);
        return this.statement.isReadOnly(column);
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.checkColumnRange(column);
        switch (this.statement.getColumnType(column)) {
            case -4: 
            case -1: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.checkColumnRange(column);
        return !this.statement.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.checkColumnRange(column);
        return !this.statement.isReadOnly(column);
    }

    @Override
    public synchronized String getColumnClassName(int column) throws SQLException {
        this.checkColumnRange(column);
        int colType = this.statement.getColumnType(column);
        if (colType > 1000) {
            colType -= 1000;
        }
        switch (colType) {
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case -7: {
                return "java.lang.Boolean";
            }
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 6: 
            case 8: {
                return "java.lang.Double";
            }
            case -4: 
            case -3: 
            case -2: {
                return "byte[]";
            }
            case 91: 
            case 1091: {
                return "java.sql.Date";
            }
            case 92: 
            case 1092: {
                return "java.sql.Time";
            }
            case 93: 
            case 1093: {
                return "java.sql.Timestamp";
            }
        }
        return "java.lang.String";
    }
}

