/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.IRISConnection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;

public class IRISSavepoint
implements Savepoint {
    private final String name;
    private final int id;
    private Statement statement;
    private boolean released;

    IRISSavepoint(IRISConnection conn, String sn, int sid) throws SQLException {
        this.name = sn;
        this.id = sid;
        this.released = false;
        this.statement = conn.createStatement();
        this.statement.executeUpdate("SAVEPOINT " + this.name);
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Savepoint object does not have a numeric identifier");
        }
        return this.id;
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (this.id != -1) {
            throw new SQLException("Savepoint object does not have a String identifier");
        }
        return this.name;
    }

    void rollback() throws SQLException {
        if (this.released) {
            throw new SQLException("Savepoint has already been relased");
        }
        this.statement.executeUpdate("ROLLBACK TO SAVEPOINT " + this.name);
    }

    void release() {
        this.released = true;
        this.statement = null;
    }
}

