/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.BatchUpdateStatus;
import com.intersystems.jdbc.BufferRO;
import com.intersystems.jdbc.BufferWrite;
import com.intersystems.jdbc.Descriptor;
import com.intersystems.jdbc.FakeStream;
import com.intersystems.jdbc.IRISCallableStatement;
import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.IRISPreparedStatement;
import com.intersystems.jdbc.IRISResultSet;
import com.intersystems.jdbc.IRISStaticResultSet;
import com.intersystems.jdbc.IRISUpdatableResultSet;
import com.intersystems.jdbc.IRISWrapper;
import com.intersystems.jdbc.InStream;
import com.intersystems.jdbc.ListReader;
import com.intersystems.jdbc.ListWriter;
import com.intersystems.jdbc.OutStream;
import com.intersystems.jdbc.Parameter;
import com.intersystems.jdbc.ParameterCollection;
import com.intersystems.jdbc.RealStream;
import com.intersystems.jdbc.SQLValidationException;
import com.intersystems.jdbc.preparser.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class IRISStatement
extends IRISWrapper
implements Statement {
    boolean shardedInsert = false;
    boolean addToServerCache = false;
    boolean batchInsertErrorFormat = false;
    int maxRows = 0;
    boolean genericExecuteCalled = false;
    IRISConnection connection;
    IRISResultSet myResultSet = null;
    List<Column> columns;
    ParameterCollection parameters;
    int statementFeatureOption = 0;
    int maxRowItemCount = 0;
    int keyCount = 0;
    boolean hasStreamParameters = false;
    boolean hasStreamColumns = false;
    public int serverCursorNumber = 0;
    StatementType statementType;
    boolean fetchDone = false;
    InStream input;
    OutStream output;
    String sqlText;
    String originalSqlText;
    int hasReturnValue;
    int resultSetType = 1003;
    int resultSetConcurrency;
    int fetchSize = 0;
    int parameterSets = 0;
    int fiParamSetsSent = 0;
    int batchCount = 0;
    boolean runningBatch = false;
    BufferWrite batchBuffer = null;
    ListWriter additionalParameterInfo;
    ListReader outputParameterList;
    String batchException = "none";
    boolean closed = false;
    boolean canceled = false;
    int updateCnt;
    String autoGeneratedKeyColumn = null;
    boolean multipleResultSets = false;
    boolean mrsDone = false;
    int queryTimeout = 0;
    String updatableRSTableName = null;
    String[] updatableRSColumnNames = null;
    ParameterCollection execParams = null;
    BatchUpdateStatus bus = null;
    static final int NO_RETURN_VALUE = 0;
    static final int IGNORE_RETURN_VALUE = 1;
    static final int HAS_RETURN_VALUE = 2;
    static final int NULL_RETURN_VALUE = 3;
    static final String BATCH_EXCEPTION_NONE = "none";
    static final String BATCH_EXCEPTION_QUERY = "query";
    static final String BATCH_EXCEPTION_SP = "stored procedure";
    int paramsSent = 0;
    int sqlDialect = 0;
    private boolean closeOnCompletion = false;
    WeakReference<IRISResultSet> weakResultSetReference = null;
    int outstandingReads = 0;
    int nextServerNumber = 0;
    int maxFieldSize = 0;
    static final int FLAG_STATEMENT_CACHED = 1;
    static final int FLAG_SHARDED_INSERT = 2;
    static final int FLAG_BATCH_INSERT_ERRORS = 4;

    IRISStatement(IRISConnection conn, int rst, int rsc, String agk) throws SQLException {
        this.connection = conn;
        this.sqlDialect = this.connection.getSQLDialect();
        this.parameters = new ParameterCollection();
        this.input = new InStream(this.connection);
        this.output = new OutStream(this.connection);
        this.resultSetType = rst;
        this.resultSetConcurrency = rsc;
        this.serverCursorNumber = 0;
        this.updateCnt = 0;
        this.autoGeneratedKeyColumn = agk;
        this.hasStreamColumns = false;
        this.paramsSent = 0;
    }

    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open.", "08003");
        }
        if (sql.equals("**getQuickStatement**")) {
            this.columns = new ArrayList<Column>();
            return this.createNewResultSet();
        }
        this.genericExecuteCalled = false;
        this.Query(sql);
        if (this.multipleResultSets && !this.mrsDone) {
            this.columnInfo(this.input.wire);
        }
        this.updateCnt = -1;
        return this.myResultSet;
    }

    void createResultSet() throws SQLException {
        if (this.myResultSet != null) {
            this.myResultSet.statement.cleanUpFetches();
            this.myResultSet.closed = true;
            this.myResultSet = null;
        }
        try {
            this.myResultSet = this.resultSetConcurrency == 1008 ? new IRISUpdatableResultSet(this) : (this.resultSetType == 1004 ? new IRISStaticResultSet(this) : new IRISResultSet(this));
        }
        catch (SQLException ex) {
            if (this.resultSetType == 1003) {
                this.input.readMessage(this, 0, -1);
            }
            throw ex;
        }
    }

    IRISResultSet createNewResultSet() throws SQLException {
        if (this.myResultSet != null) {
            this.myResultSet.statement.cleanUpFetches();
            this.myResultSet.closed = true;
            this.myResultSet = null;
        }
        this.myResultSet = new IRISResultSet(this);
        return this.myResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void Query(String sql) throws SQLException {
        this.LogMessage("Query", sql);
        if (!this.genericExecuteCalled) {
            this.cleanUp();
            this.preparse(sql);
        }
        this.fetchDone = false;
        if (this.statementType != StatementType.QUERY && this.statementType != StatementType.CALL && this.getSQLDialect() == 0) {
            throw new SQLException("executeQuery called with a non-query.", "24000", 24000);
        }
        if (this.getSQLDialect() != 0) {
            if (this.directExecuteDialect() && this.statementType == StatementType.DDL_OTHER) {
                this.statementType = StatementType.QUERY;
            }
            return;
        }
        if (this.execParams != null) {
            this.prepareStoredProcedure();
            this.bindExecParameters();
            if (this.statementType == StatementType.DIRECT_CALL_UPDATE || this.statementType == StatementType.PREPARED_CALL_UPDATE) {
                throw new SQLException("executeQuery called with a non-query.", "24000", 24000);
            }
            if (this.statementType == StatementType.DIRECT_CALL_QUERY || this.statementType == StatementType.PREPARED_CALL_QUERY) {
                this.storedProcedureQuery();
            }
            return;
        }
        this.validateParameters();
        if (this.statementType == StatementType.CALL) {
            this.executeStoredProcedure();
            if (this.statementType != StatementType.DIRECT_CALL_QUERY && this.statementType != StatementType.PREPARED_CALL_QUERY) {
                throw new SQLException("executeQuery called with a non-query.", "24000", 24000);
            }
            return;
        }
        if (this.getCachedInfo(this.sqlText)) {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                if (this.resultSetType == 1004) {
                    this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.EXECUTE_STATIC_CURSOR);
                } else {
                    this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.PREPARED_QUERY_EXECUTE);
                }
                this.writeParameters(this.output.wire);
                this.output.wire.set(this.queryTimeout);
                this.output.wire.set(this.maxRows);
                this.output.send(this.connection.messageCount.getCount());
                this.handleError504(this.input.readMessage(this, 2, 504));
            }
        } else {
            this.sendDirectQueryRequest();
        }
    }

    void handleError504(int err) throws SQLException {
        if (err == 404) {
            this.query404();
            return;
        }
        this.handleError100(err);
    }

    void bindExecParameters() throws SQLException {
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter parameter = this.parameters.get(i);
            Parameter execParam = this.getExecParamByName(parameter.name);
            if (execParam != null) {
                if (execParam.mode == Parameter.ParameterMode.UNKNOWN) continue;
                parameter.mode = execParam.mode;
                if (execParam.mode != Parameter.ParameterMode.OUTPUT) {
                    if (execParam.value instanceof ArrayList) {
                        this.parameters.arrayBound = true;
                    }
                    parameter.bind(execParam.value, null, this.parameterSets);
                    continue;
                }
                parameter.bound = execParam.bound;
                continue;
            }
            if (parameter.mode != Parameter.ParameterMode.UNKNOWN) continue;
            parameter.mode = Parameter.ParameterMode.DEFAULT_PARAMETER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void sendDirectQueryRequest() throws SQLException {
        int error;
        this.connection.updateCache();
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            if (this.resultSetType == 1004) {
                if (this.serverCursorNumber != this.connection.nextServerCursorNumber || this.serverCursorNumber < 1) {
                    this.serverCursorNumber = this.connection.getServerCursorNumber();
                }
                this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.DIRECT_STATIC_CURSOR);
            } else {
                this.serverCursorNumber = this.connection.getServerCursorNumber();
                this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.DIRECT_QUERY);
            }
            this.output.wire.setSQLText(this.sqlText);
            this.output.wire.append(this.additionalParameterInfo);
            this.writeParameters(this.output.wire);
            this.output.wire.set(this.queryTimeout);
            this.output.wire.set(this.maxRows);
            this.nextServerNumber = this.connection.messageCount.getCount();
            this.output.send(this.nextServerNumber);
            try {
                error = this.input.readMessage(this, 0, 100);
                if (this.connection.isFastSelectOption()) {
                    this.checkStatementFeature(this.input.wire);
                }
                this.columnInfo(this.input.wire);
                this.parameterInfo(this.input.wire);
                this.connection.addCachedPrepare(this, true);
                this.createResultSet();
                if (this.resultSetType != 1003) {
                    return;
                }
                error = this.input.readMessage(this, 2, 100);
            }
            catch (SQLException ex) {
                this.connection.cachedPrepares.remove(this.serverCursorNumber);
                this.connection.recycledServerCursorNumber = this.serverCursorNumber;
                throw ex;
            }
        }
        this.handleError504(error);
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open.", "08003");
        }
        this.genericExecuteCalled = false;
        this.Update(sql);
        if (!(this.parameterSets != 0 || this.multipleResultSets && this.getSQLDialect() != 0)) {
            this.updateCnt = this.input.wire.getInt();
        }
        if (this.statementType == StatementType.STMT_USE) {
            this.connection.resetOnUse();
        }
        return this.updateCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void Update(String sql) throws SQLException {
        this.LogMessage("Update", sql);
        if (!this.genericExecuteCalled) {
            this.cleanUp();
            this.preparse(sql);
        }
        if (this.statementType == StatementType.QUERY) {
            throw new SQLException("executeUpdate called with a query.", "24000", 24000);
        }
        if (this.getSQLDialect() != 0) {
            if (this.directExecuteDialect() && this.statementType == StatementType.DDL_OTHER) {
                this.statementType = StatementType.QUERY;
            }
            return;
        }
        if (this.execParams != null) {
            this.prepareStoredProcedure();
            this.bindExecParameters();
            if (this.statementType == StatementType.DIRECT_CALL_UPDATE || this.statementType == StatementType.PREPARED_CALL_UPDATE) {
                this.storedProcedureUpdate();
            } else if (this.statementType == StatementType.DIRECT_CALL_QUERY || this.statementType == StatementType.PREPARED_CALL_QUERY) {
                throw new SQLException("executeUpdate called with a query.", "24000", 24000);
            }
            return;
        }
        this.validateParameters();
        if (this.statementType == StatementType.CALL) {
            this.executeStoredProcedure();
            if (this.statementType == StatementType.DIRECT_CALL_QUERY) {
                throw new SQLException("executeUpdate called with a query.", "24000", 24000);
            }
            return;
        }
        if (this.statementType != StatementType.DDL_ALTER_DROP && this.statementType != StatementType.DDL_OTHER && this.getCachedInfo(this.sqlText)) {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.PREPARED_UPDATE_EXECUTE);
                if (IRISConnection.Feature.isFastInsertOption(this.statementFeatureOption)) {
                    this.writeFastInsertParameters(this.output.wire);
                } else {
                    this.output.wire.set(this.autoGeneratedKeyColumn);
                    this.output.wire.set(0);
                    this.writeParameters(this.output.wire);
                }
                this.output.send(this.connection.messageCount.getCount());
                if (this.input.readMessage(this, 0, 504) == 404) {
                    this.update404();
                }
            }
        } else {
            this.sendDirectUpdateRequest();
        }
        this.connection.cachedPrepares.markAsNotBeingExecuted(this.serverCursorNumber, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void sendDirectUpdateRequest() throws SQLException {
        this.serverCursorNumber = this.connection.getServerCursorNumber();
        this.connection.updateCache();
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.DIRECT_UPDATE);
            this.output.wire.setSQLText(this.sqlText);
            this.output.wire.append(this.additionalParameterInfo);
            this.output.wire.set(this.autoGeneratedKeyColumn);
            this.output.wire.set(0);
            this.writeParameters(this.output.wire);
            this.output.send(this.connection.messageCount.getCount());
            try {
                this.input.readMessage(this, 0, 100);
            }
            catch (SQLException sqlEx) {
                try {
                    if (this.connection.isFastInsertOption()) {
                        this.checkStatementFeature(this.input.wire);
                    }
                    this.parameterInfo(this.input.wire);
                }
                catch (Exception exception) {
                }
                finally {
                    this.connection.recycledServerCursorNumber = this.serverCursorNumber;
                }
                throw sqlEx;
            }
            if (this.connection.isFastInsertOption()) {
                this.checkStatementFeature(this.input.wire);
            }
            this.parameterInfo(this.input.wire);
        }
        if (this.addToServerCache) {
            this.connection.addCachedPrepare(this, this.autoGeneratedKeyColumn != null);
        } else {
            this.connection.recycledServerCursorNumber = this.serverCursorNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void cleanUpFetches() throws SQLException {
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            while (this.outstandingReads > 0) {
                if (this.input.readMessage(this, 3, -1) == 100) {
                    this.fetchDone = true;
                }
                --this.outstandingReads;
            }
        }
        this.input.messages.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        IRISStatement iRISStatement = this;
        synchronized (iRISStatement) {
            this.cleanUpFetches();
            if (this.parameters != null) {
                this.parameters.clear();
            }
            this.hasStreamParameters = false;
            if (this.columns != null) {
                this.columns.clear();
            }
            if (this.myResultSet != null) {
                this.myResultSet.close();
                this.myResultSet = null;
            }
            if (this.connection.cachedPrepares.isOwner(this.serverCursorNumber, this)) {
                if (this.hasStreamColumns) {
                    this.CloseAllStreams();
                }
                this.connection.cachedPrepares.markAsNotBeingExecuted(this.serverCursorNumber, this);
            }
            this.fetchDone = false;
            this.genericExecuteCalled = false;
            this.maxRows = 0;
            this.fetchSize = 0;
            this.parameterSets = 0;
            this.batchCount = 0;
            this.batchBuffer = null;
            this.batchException = BATCH_EXCEPTION_NONE;
            this.updateCnt = 0;
            this.autoGeneratedKeyColumn = null;
            this.updatableRSTableName = null;
            this.updatableRSColumnNames = null;
            this.multipleResultSets = false;
            this.mrsDone = false;
            this.hasStreamColumns = false;
            this.sqlText = null;
            this.serverCursorNumber = 0;
            this.statementType = StatementType.UPDATE;
            if (this.outputParameterList != null) {
                this.outputParameterList.clearList();
            }
            this.execParams = null;
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void CloseAllStreams() throws SQLException {
        try {
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.CLOSE_STREAM);
                this.output.wire.set(0);
                this.output.send(this.connection.messageCount.getCount());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.maxFieldSize = max;
        OutStream outStream = this.output;
        synchronized (outStream) {
            this.output.wire.setMaxFieldSize(max);
        }
    }

    public int getStatementFeatureOption() {
        return this.statementFeatureOption;
    }

    @Override
    public synchronized int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public synchronized void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("Invalid number of rows specified: " + max, "S1000");
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public synchronized int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public synchronized void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        this.canceled = true;
        this.connection.cancelStatement(this);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    private synchronized boolean executeStoredProcedure() throws SQLException {
        if (this.getCachedInfo(this.sqlText)) {
            if (this.statementType == StatementType.UPDATE || this.statementType == StatementType.DIRECT_CALL_UPDATE || this.statementType == StatementType.PREPARED_CALL_UPDATE) {
                this.storedProcedureUpdate();
                return false;
            }
            this.storedProcedureQuery();
            return true;
        }
        return this.directExecuteStoredProcedure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean directExecuteStoredProcedure() throws SQLException {
        this.serverCursorNumber = this.connection.getServerCursorNumber();
        this.connection.updateCache();
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.DIRECT_STORED_PROCEDURE);
            this.output.wire.set(this.sqlText);
            if (this.resultSetType == 1004) {
                this.output.wire.set(1);
            } else {
                this.output.wire.set(0);
            }
            this.output.wire.set(this.queryTimeout);
            this.output.wire.set(this.maxRows);
            this.writeStoredProcedureParameters();
            this.output.send(this.connection.messageCount.getCount());
            int error = this.input.readMessage(this, 0, 100);
            this.processStoredProcedureMetaData(this.input.wire, true);
            if (this.multipleResultSets) {
                return this.executeMultipleResultSets(false);
            }
            this.connection.addCachedPrepare(this, true);
            if (error == 100) {
                this.handleError100(100);
                return true;
            }
            this.getOutputParameters(this.input.wire);
            if (this.statementType == StatementType.UPDATE || this.statementType == StatementType.DIRECT_CALL_UPDATE || this.statementType == StatementType.PREPARED_CALL_UPDATE) {
                this.connection.cachedPrepares.markAsNotBeingExecuted(this.serverCursorNumber, this);
                return false;
            }
            if (this.myResultSet == null) {
                this.createResultSet();
            }
            if (this.resultSetType == 1003) {
                this.handleError100(this.input.readMessage(this, 2, 100));
            }
            return true;
        }
    }

    void handleError100(int err) throws SQLException {
        if (err == 100) {
            this.fetchDone = true;
            if (this.hasStreamColumns) {
                this.connection.cachedPrepares.markAsBeingExecuted(this.serverCursorNumber, this);
            } else {
                this.connection.cachedPrepares.markAsNotBeingExecuted(this.serverCursorNumber, this);
            }
        } else {
            this.connection.cachedPrepares.markAsBeingExecuted(this.serverCursorNumber, this);
        }
    }

    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open.", "08003");
        }
        this.LogMessage("execute", sql);
        this.cleanUp();
        this.updateCnt = 0;
        this.preparse(sql);
        this.genericExecuteCalled = true;
        if (this.getSQLDialect() != 0) {
            boolean ret = this.directExecuteDialect();
            if (ret) {
                this.statementType = StatementType.QUERY;
            }
            return ret;
        }
        if (this.statementType == StatementType.QUERY) {
            this.Query(sql);
            this.updateCnt = -1;
            return true;
        }
        if (this.statementType == StatementType.CALLWITHRESULT) {
            throw new SQLException("No output parameters allowed.");
        }
        if (this.statementType == StatementType.CALL) {
            if (this.executeStoredProcedure()) {
                return !this.fetchDone || this.input.wire.Header.getMessageLength() != 0;
            }
            if (!this.multipleResultSets && this.parameterSets == 0) {
                this.updateCnt = this.input.wire.getInt();
            }
            return false;
        }
        this.Update(sql);
        if (this.getSQLDialect() != 0) {
            return this.updateCnt < 0;
        }
        if (this.parameterSets == 0) {
            this.updateCnt = this.input.wire.getInt();
        }
        if (this.statementType == StatementType.STMT_USE) {
            this.connection.resetOnUse();
        }
        return false;
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (!this.genericExecuteCalled || this.statementType != StatementType.QUERY && this.statementType != StatementType.DIRECT_CALL_QUERY && this.statementType != StatementType.PREPARED_CALL_QUERY) {
            return null;
        }
        if (this.multipleResultSets) {
            if (this.myResultSet == null && this.updateCnt == -1) {
                return null;
            }
            if (this.mrsDone) {
                return null;
            }
            this.columnInfo(this.input.wire);
        } else {
            this.genericExecuteCalled = false;
        }
        if (this.myResultSet == null) {
            this.createResultSet();
        }
        return this.myResultSet;
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this.statementType == StatementType.QUERY || this.statementType == StatementType.DIRECT_CALL_QUERY || this.statementType == StatementType.PREPARED_CALL_QUERY) {
            return -1;
        }
        if (!this.multipleResultSets) {
            this.genericExecuteCalled = false;
        }
        int uc = this.updateCnt;
        this.updateCnt = -1;
        return uc;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    int getColumnType(int column) {
        return this.columns.get((int)(column - 1)).type;
    }

    String getColumnName(int column) {
        return this.columns.get((int)(column - 1)).name;
    }

    String getColumnLabel(int column) {
        return this.columns.get((int)(column - 1)).label;
    }

    String getColumnTableName(int column) {
        return this.columns.get((int)(column - 1)).tableName;
    }

    String getColumnSchemaName(int column) {
        return this.columns.get((int)(column - 1)).schema;
    }

    String getColumnCatalogName(int column) {
        return this.columns.get((int)(column - 1)).catalog;
    }

    int getColumnPrecision(int column) {
        return this.columns.get((int)(column - 1)).precision;
    }

    int getColumnScale(int column) {
        int scale = this.columns.get((int)(column - 1)).scale;
        return scale == -1 ? 0 : scale;
    }

    int getColumnNullable(int column) {
        return this.columns.get((int)(column - 1)).nullable;
    }

    boolean isReadOnly(int column) {
        return this.columns.get((int)(column - 1)).isReadOnly;
    }

    boolean isAutoIncrement(int column) {
        return this.columns.get((int)(column - 1)).isAutoIncrement;
    }

    boolean isRowId(int column) {
        return this.columns.get((int)(column - 1)).isRowId;
    }

    boolean isCaseSensitive(int column) {
        return this.columns.get((int)(column - 1)).isCaseSensitive;
    }

    boolean isCurrency(int column) {
        return this.columns.get((int)(column - 1)).isCurrency;
    }

    int getParameterScale(int parameter) {
        return this.parameters.get((int)parameter).scale;
    }

    int getParameterPrecision(int parameter) {
        return this.parameters.get((int)parameter).precision;
    }

    Parameter.ParameterMode getParameterMode(int parameter) {
        return this.parameters.get((int)parameter).mode;
    }

    boolean isOutParameter(int parameter) {
        Parameter.ParameterMode mode = this.parameters.get((int)parameter).mode;
        return mode == Parameter.ParameterMode.INPUT_OUTPUT || mode == Parameter.ParameterMode.OUTPUT;
    }

    private void isNotDefaultOrReplaced(int parameter) throws SQLException {
        Parameter.ParameterMode mode = this.parameters.get((int)parameter).mode;
        if (mode != Parameter.ParameterMode.REPLACED_LITERAL && mode != Parameter.ParameterMode.DEFAULT_PARAMETER) {
            throw new SQLException("Parameters not allowed in Statement class.", "07001", 7001);
        }
    }

    int getUserParameterType(int i) throws SQLException {
        return this.parameters.getUserParameter((int)i).type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setParameterModeAndScale(int parameter, int scale) {
        this.setParameterMode(parameter);
        ParameterCollection parameterCollection = this.parameters;
        synchronized (parameterCollection) {
            this.parameters.get((int)parameter).scale = scale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setParameterMode(int parameter) {
        ParameterCollection parameterCollection = this.parameters;
        synchronized (parameterCollection) {
            Parameter par = this.parameters.get(parameter);
            par.mode = par.mode == Parameter.ParameterMode.INPUT || par.mode == Parameter.ParameterMode.INPUT_OUTPUT ? Parameter.ParameterMode.INPUT_OUTPUT : Parameter.ParameterMode.OUTPUT;
            par.bound = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbindParameter(int i) throws SQLException {
        ParameterCollection parameterCollection = this.parameters;
        synchronized (parameterCollection) {
            Parameter par = this.parameters.get(i);
            if (par.mode != Parameter.ParameterMode.REPLACED_LITERAL && par.mode != Parameter.ParameterMode.DEFAULT_PARAMETER) {
                par.bound = false;
                par.mode = Parameter.ParameterMode.UNKNOWN;
                par.values.clear();
                par.whatever.clear();
            }
        }
    }

    synchronized void multipleResultSetsMetaData(BufferRO wire, boolean serverHasReturn, boolean directExecute) throws SQLException {
        this.multipleResultSets = true;
        this.mrsDone = false;
        if (!this.storedProcedureParameterInfo(wire, serverHasReturn, directExecute)) {
            throw new SQLException("Parameter list mismatch.", "07001", 7001);
        }
        this.statementType = this instanceof IRISCallableStatement ? StatementType.QUERY : (this instanceof IRISPreparedStatement ? StatementType.PREPARED_CALL_QUERY : StatementType.DIRECT_CALL_QUERY);
    }

    synchronized void processStoredProcedureMetaData(BufferRO wire, boolean directExecute) throws SQLException {
        int retStmtType = wire.getInt();
        if (retStmtType < 0) {
            if (retStmtType == -1) {
                this.multipleResultSetsMetaData(wire, false, directExecute);
            } else {
                this.multipleResultSetsMetaData(wire, true, directExecute);
            }
            return;
        }
        if (retStmtType % 2 == StatementType.QUERY.ordinal()) {
            this.columnInfo(wire);
        }
        if (!this.storedProcedureParameterInfo(wire, retStmtType > 1, directExecute)) {
            if (directExecute && retStmtType % 2 == StatementType.QUERY.ordinal()) {
                if (this.resultSetType == 1003) {
                    this.handleError100(this.input.readMessage(this, 2, 100));
                }
                this.input.wire.moveToEnd();
            }
            if (directExecute) {
                throw new SQLException("Parameter list mismatch.", "07001", 7001);
            }
        }
        if (this instanceof IRISCallableStatement) {
            this.statementType = StatementType.values()[retStmtType % 2];
            return;
        }
        if (this instanceof IRISPreparedStatement) {
            this.statementType = retStmtType % 2 == StatementType.QUERY.ordinal() ? StatementType.PREPARED_CALL_QUERY : StatementType.PREPARED_CALL_UPDATE;
            return;
        }
        this.statementType = retStmtType % 2 == StatementType.QUERY.ordinal() ? StatementType.DIRECT_CALL_QUERY : StatementType.DIRECT_CALL_UPDATE;
    }

    void checkStatementFeature(BufferRO wire) throws SQLException {
        this.statementFeatureOption = wire.getInt();
        if (IRISConnection.Feature.isFastOption(this.statementFeatureOption)) {
            if (IRISConnection.Feature.isFastInsertOption(this.statementFeatureOption)) {
                this.keyCount = wire.getInt();
            }
            this.maxRowItemCount = wire.getInt();
        } else {
            this.maxRowItemCount = 0;
        }
    }

    void columnInfo(BufferRO wire) throws SQLException {
        int cnt = wire.getInt();
        this.columns = new ArrayList<Column>(cnt);
        if (cnt <= 0) {
            return;
        }
        for (int i = 1; i <= cnt; ++i) {
            Column temp = new Column();
            temp.name = wire.getString();
            temp.type = wire.getInt();
            switch (temp.type) {
                case 9: {
                    temp.type = 91;
                    break;
                }
                case 10: {
                    temp.type = 92;
                    break;
                }
                case 11: {
                    temp.type = 93;
                    break;
                }
            }
            temp.precision = wire.getInt();
            temp.scale = wire.getInt();
            if (wire.isNull() && (temp.type == 92 || temp.type == 1092)) {
                temp.scale = -1;
            }
            temp.nullable = wire.getInt();
            temp.label = wire.getString();
            temp.tableName = wire.getString();
            temp.schema = wire.getString();
            temp.catalog = wire.getString();
            String additionalMD = wire.getString();
            temp.isAutoIncrement = additionalMD.charAt(0) == '\u0001';
            temp.isCaseSensitive = additionalMD.charAt(1) == '\u0001';
            temp.isCurrency = additionalMD.charAt(2) == '\u0001';
            boolean bl = temp.isReadOnly = additionalMD.charAt(3) == '\u0001';
            if (additionalMD.length() >= 12) {
                temp.isRowId = additionalMD.charAt(11) == '\u0001';
            }
            temp.slotPosition = IRISConnection.Feature.isFastSelectOption(this.statementFeatureOption) ? wire.getInt() : i;
            this.columns.add(temp);
            this.hasStreamColumns = this.containsStreams();
        }
    }

    private boolean containsStreams() {
        for (Column column : this.columns) {
            if (column.type != -4 && column.type != -1) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean storedProcedureParameterInfo(BufferRO wire, boolean serverHasReturn, boolean directExecute) throws SQLException {
        int count;
        block18: {
            int size;
            block22: {
                block24: {
                    block23: {
                        block20: {
                            block21: {
                                block19: {
                                    count = wire.getInt();
                                    if (!(this instanceof IRISCallableStatement) && this.hasReturnValue == 1) {
                                        wire.moveToEnd();
                                        return false;
                                    }
                                    if (this.execParams == null) break block19;
                                    for (size = this.parameters.size(); size < count; ++size) {
                                        this.parameters.add(0, new Parameter());
                                    }
                                    if (serverHasReturn) {
                                        this.hasReturnValue = 1;
                                    }
                                    break block18;
                                }
                                if (size != count) break block20;
                                if (!serverHasReturn || this.hasReturnValue != 2) break block21;
                                this.hasReturnValue = 2;
                                break block18;
                            }
                            if (!serverHasReturn && this.hasReturnValue == 0) {
                                this.hasReturnValue = 0;
                                break block18;
                            } else if (size == 1 && count == 1 && this.getParameterMode(0) == Parameter.ParameterMode.DEFAULT_PARAMETER && this.hasReturnValue == 0 && serverHasReturn || this.getParameterMode(0) == Parameter.ParameterMode.UNKNOWN && this.hasReturnValue == 1 && serverHasReturn) {
                                this.parameters.remove(0);
                                --this.paramsSent;
                                this.parameters.add(0, new Parameter());
                                this.hasReturnValue = 1;
                                break block18;
                            } else {
                                wire.moveToEnd();
                                return false;
                            }
                        }
                        if (size != count + 1) break block22;
                        if (serverHasReturn || this.hasReturnValue != 2) break block23;
                        this.hasReturnValue = 3;
                        break block18;
                    }
                    if ((size != 2 || count != 1) && (size != 1 || count != 0)) break block24;
                    if (this.getParameterMode(size - 1) != Parameter.ParameterMode.DEFAULT_PARAMETER) {
                        wire.moveToEnd();
                        return false;
                    }
                    if (serverHasReturn && this.hasReturnValue == 2) {
                        this.parameters.remove(size - 1);
                        --this.paramsSent;
                        this.hasReturnValue = 2;
                        break block18;
                    } else if (!serverHasReturn && this.hasReturnValue == 0) {
                        this.parameters.remove(size - 1);
                        --this.paramsSent;
                        this.hasReturnValue = 0;
                        break block18;
                    } else {
                        wire.moveToEnd();
                        return false;
                    }
                }
                wire.moveToEnd();
                return false;
            }
            if (size == count - 1) {
                if (serverHasReturn && this.hasReturnValue == 0) {
                    this.parameters.add(0, new Parameter());
                    this.hasReturnValue = 1;
                } else {
                    this.parameters.add(new Parameter(Parameter.ParameterMode.DEFAULT_PARAMETER));
                }
            } else {
                if (serverHasReturn && this.hasReturnValue == 0) {
                    this.hasReturnValue = 1;
                    Parameter par = new Parameter();
                    par.mode = Parameter.ParameterMode.OUTPUT;
                    this.parameters.add(0, par);
                    ++size;
                }
                while (size < count) {
                    this.parameters.add(new Parameter(Parameter.ParameterMode.DEFAULT_PARAMETER));
                    ++size;
                }
            }
        }
        this.readParameterData(wire, count, true);
        return true;
    }

    void parameterInfo(BufferRO wire) throws SQLException {
        int cnt = wire.getInt();
        if (cnt != this.parameters.size()) {
            throw new SQLException("Invalid number of parameters.", "07001", 7001);
        }
        this.readParameterData(wire, cnt, false);
        int flag = wire.getInt();
        this.addToServerCache = (flag & 1) == 1;
        boolean bl = this.shardedInsert = (flag & 2) == 2;
        if (this.connection.getProtocolVersion() > 65) {
            boolean bl2 = this.batchInsertErrorFormat = (flag & 4) == 4;
        }
        if (IRISConnection.Feature.isFastInsertOption(this.statementFeatureOption)) {
            this.parameters.prepDefault(wire, this.maxRowItemCount, this.keyCount, IRISConnection.Feature.isFastColumnarOption(this.statementFeatureOption));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readParameterData(BufferRO wire, int cnt, boolean isStoredProcedure) throws SQLException {
        ParameterCollection parameterCollection = this.parameters;
        synchronized (parameterCollection) {
            int r = 0;
            int userParamCnt = 0;
            this.parameters.userIndex = new int[cnt + 1];
            Arrays.fill(this.parameters.userIndex, -1);
            if (this.hasReturnValue == 3) {
                ++r;
            }
            if (this.hasReturnValue == 1) {
                --userParamCnt;
            }
            String tableSpec = "";
            for (int i = 0; i < cnt; ++i) {
                Parameter par = this.parameters.get(i + r);
                par.type = wire.getInt();
                switch (par.type) {
                    case 9: {
                        par.type = 91;
                        break;
                    }
                    case 10: {
                        par.type = 92;
                        break;
                    }
                    case 11: {
                        par.type = 93;
                        break;
                    }
                    case -4: 
                    case -1: {
                        this.hasStreamParameters = true;
                        break;
                    }
                }
                par.precision = wire.getInt();
                par.scale = wire.getInt();
                if (wire.isNull() && (par.type == 92 || par.type == 1092)) {
                    par.scale = -1;
                }
                if (IRISConnection.Feature.isFastInsertOption(this.statementFeatureOption)) {
                    par.nullable = wire.getInt();
                    par.slotPosition = wire.getInt();
                    par.truncate = wire.getInt();
                    switch (par.type) {
                        case 8: {
                            par.minVal = wire.getDoubleObject();
                            par.maxVal = wire.getDoubleObject();
                            break;
                        }
                        case 2: 
                        case 92: 
                        case 1092: {
                            par.minVal = wire.getBigDecimal();
                            par.maxVal = wire.getBigDecimal();
                            break;
                        }
                        case 93: {
                            par.minVal = wire.getTimestamp();
                            par.maxVal = wire.getTimestamp();
                            break;
                        }
                        default: {
                            par.minVal = wire.getLongObject();
                            par.maxVal = wire.getLongObject();
                        }
                    }
                    if (i == 0) {
                        tableSpec = wire.getString() + ".";
                    }
                    par.name = tableSpec + wire.getString();
                } else {
                    par.nullable = wire.getInt();
                    par.slotPosition = i + r;
                }
                if (isStoredProcedure) {
                    par.name = wire.getString();
                    wire.getInt();
                }
                if (par.mode == Parameter.ParameterMode.REPLACED_LITERAL) continue;
                this.parameters.userIndex[++userParamCnt] = i + r;
            }
            this.parameters.userParamCnt = userParamCnt;
            if (isStoredProcedure) {
                this.parameters.updateNames();
            }
        }
    }

    synchronized boolean getCachedInfo(String sql) throws SQLException {
        IRISConnection.CachedPrepare cp = this.connection.cachedPrepares.GetStatement(sql + this.additionalParameterInfo.toString(), this);
        if (cp == null) {
            return false;
        }
        this.serverCursorNumber = cp.serverCursorNumber;
        this.hasStreamParameters = cp.hasStreamParameters;
        if (this.statementType == StatementType.CALL || this.statementType == StatementType.CALLWITHRESULT) {
            if (this.parameters.size() != cp.parameters.size()) {
                if (this.statementType == StatementType.CALL && this.hasReturnValue == 0 && cp.hasReturnValue == 1 && this.parameters.size() + 1 == cp.parameters.size()) {
                    this.parameters.add(0, new Parameter(Parameter.ParameterMode.OUTPUT));
                } else if (cp.parameters.isEmpty() && this.parameters.size() == 1) {
                    this.parameters.clear();
                } else {
                    this.connection.cachedPrepares.remove(this.serverCursorNumber);
                    if (this.connection.recycledServerCursorNumber == -1) {
                        this.connection.recycledServerCursorNumber = this.serverCursorNumber;
                    }
                    return false;
                }
            }
            this.statementType = cp.statementType == StatementType.QUERY ? StatementType.PREPARED_CALL_QUERY : (cp.statementType == StatementType.UPDATE ? StatementType.PREPARED_CALL_UPDATE : cp.statementType);
            this.hasReturnValue = cp.hasReturnValue;
            this.multipleResultSets = cp.multipleResultSets;
            this.mrsDone = false;
            if (!(this.multipleResultSets || this.statementType != StatementType.QUERY && this.statementType != StatementType.PREPARED_CALL_QUERY && this.statementType != StatementType.DIRECT_CALL_QUERY)) {
                this.columns = new ArrayList<Column>(cp.columns);
                this.hasStreamColumns = cp.hasStreamColumns;
                this.createResultSet();
            }
        } else if (this.statementType == StatementType.QUERY) {
            this.columns = new ArrayList<Column>(cp.columns);
            this.hasStreamColumns = cp.hasStreamColumns;
            this.createResultSet();
        }
        if (this.statementType == StatementType.UPDATE && this.autoGeneratedKeyColumn == null) {
            this.connection.cachedPrepares.markAsNotBeingExecuted(this.serverCursorNumber, this);
        }
        this.batchInsertErrorFormat = cp.batchInsertErrorFormat;
        this.shardedInsert = cp.shardedInsert;
        this.parameters.updateParameterInfo(cp.parameters);
        this.statementFeatureOption = cp.statementFeatureOption;
        this.maxRowItemCount = cp.maxRowItemCount;
        this.keyCount = cp.keyCount;
        return true;
    }

    Parser preparseAddID(String sql) throws SQLException {
        Parser preparser = new Parser(sql, this.connection.connectionInfo.delimitedIds == 1, 2);
        try {
            preparser.preparse();
        }
        catch (Throwable th) {
            throw new SQLException("SQL preparser error:\n" + th.getMessage());
        }
        if (preparser.getStatementType() != StatementType.QUERY) {
            this.originalSqlText = sql;
            return preparser;
        }
        this.statementType = StatementType.QUERY;
        this.updateParameters(preparser);
        this.sqlText = preparser.getPreparsedSQL();
        this.additionalParameterInfo = preparser.getParamInfo();
        this.originalSqlText = sql;
        return null;
    }

    void preparse(String sql, StatementType stmtType, long paramCount) throws SQLException {
        this.statementType = stmtType;
        this.sqlText = sql;
        int k = 1;
        while ((long)k < paramCount) {
            this.parameters.add(new Parameter());
            ++k;
        }
    }

    private String stripSemiColon(String sql) {
        if (sql.contains(";")) {
            String tmpSql = sql.substring(0, sql.lastIndexOf(";"));
            if (sql.toUpperCase().contains("CREATE")) {
                if (sql.trim().endsWith(";")) {
                    return tmpSql;
                }
                return sql;
            }
            int n = sql.length();
            for (int i = 0; i < n; ++i) {
                if ('-' == sql.charAt(i) && i < n - 1 && '-' == sql.charAt(i + 1)) {
                    ++i;
                    while (i < n && '\n' != sql.charAt(i)) {
                        ++i;
                    }
                }
                if (i >= n) break;
                if ('/' == sql.charAt(i) && i < n - 1 && '*' == sql.charAt(i + 1)) {
                    ++i;
                    while (i < n && ('*' != sql.charAt(i) || i >= n - 1 || '/' != sql.charAt(i + 1))) {
                        ++i;
                    }
                }
                if (i >= n) break;
                if ('\'' == sql.charAt(i)) {
                    ++i;
                    while (i < n && '\'' != sql.charAt(i)) {
                        ++i;
                    }
                }
                if (i >= n) break;
                if ('\"' == sql.charAt(i)) {
                    ++i;
                    while (i < n && '\"' != sql.charAt(i)) {
                        ++i;
                    }
                }
                if (i >= n) break;
                if (';' != sql.charAt(i)) continue;
                if (i == n - 1) {
                    return sql.substring(0, i);
                }
                while (i++ < n && ' ' == sql.charAt(i) || '\t' == sql.charAt(i) || '\n' == sql.charAt(i)) {
                    if (i >= n - 1) continue;
                    if ('-' == sql.charAt(i) && '-' == sql.charAt(i + 1)) {
                        return sql.substring(0, i);
                    }
                    if ('/' != sql.charAt(i) || '*' != sql.charAt(i + 1)) continue;
                    return sql.substring(0, i);
                }
            }
        }
        return sql;
    }

    protected StatementType preparseStmtType(String sql) {
        this.hasReturnValue = 0;
        if (sql.toUpperCase().startsWith("SELECT")) {
            if (sql.toUpperCase().contains("INTO")) {
                return StatementType.UPDATE;
            }
            return StatementType.QUERY;
        }
        if (sql.toUpperCase().startsWith("UPDATE") || sql.toUpperCase().startsWith("INSERT")) {
            return StatementType.UPDATE;
        }
        if (sql.toUpperCase().contains("CALL") || sql.toUpperCase().contains("EXEC")) {
            if (sql.toUpperCase().startsWith("?")) {
                this.hasReturnValue = 2;
                return StatementType.CALLWITHRESULT;
            }
            return StatementType.CALL;
        }
        return StatementType.DDL_OTHER;
    }

    void preparse(String sql) throws SQLException {
        sql = this.stripSemiColon(sql.trim());
        Parser preparser = null;
        if (this.getSQLDialect() != 0) {
            this.statementType = this.preparseStmtType(sql);
            this.sqlText = sql;
            this.execParams = null;
            this.additionalParameterInfo = new ListWriter(6, this.connection.connectionInfo);
            this.additionalParameterInfo.set(0);
            return;
        }
        IRISConnection.CachedSQL csql = this.connection.prePreparseCache.get(sql);
        if (csql != null && csql.resultSetConcurrency == this.resultSetConcurrency) {
            this.hasReturnValue = csql.hasReturnValue;
            this.parameters = new ParameterCollection(csql.parameters, false);
            this.sqlText = csql.sqlText;
            this.statementType = csql.statementType;
            this.additionalParameterInfo = csql.additionalParameterInfo;
            return;
        }
        if (this.resultSetConcurrency == 1008) {
            preparser = this.preparseAddID(sql);
            if (preparser == null) {
                return;
            }
            this.additionalParameterInfo = preparser.getParamInfo();
        }
        try {
            if (preparser == null) {
                preparser = new Parser(sql, this.connection.connectionInfo.delimitedIds == 1, 0);
                preparser.preparse();
                this.execParams = preparser.getExecParams();
                this.additionalParameterInfo = preparser.getParamInfo();
            }
            this.statementType = preparser.getStatementType();
            this.sqlText = preparser.getPreparsedSQL();
            switch (this.statementType) {
                case CALL: {
                    this.hasReturnValue = 0;
                    break;
                }
                case CALLWITHRESULT: {
                    this.hasReturnValue = 2;
                    break;
                }
                case DDL_ALTER_DROP: 
                case DDL_OTHER: 
                case STMT_USE: {
                    this.updateParameters(preparser);
                    return;
                }
            }
            this.updateParameters(preparser);
            this.connection.addPrePreparseCache(sql, this);
        }
        catch (Throwable th) {
            throw new SQLException("SQL preparser error:\n" + th.getMessage(), "42000", 51);
        }
    }

    void updateParameters(Parser preparser) {
        int cnt = preparser.getParametersCount();
        if (cnt == 0) {
            return;
        }
        this.parameters.userIndex = new int[cnt + 1];
        Arrays.fill(this.parameters.userIndex, -1);
        cnt = 0;
        int userParamCnt = 0;
        for (Parser.ParserParameter parameter : preparser.getParameters()) {
            switch (parameter.type) {
                case '?': {
                    this.parameters.addUserParam(new Parameter());
                    this.parameters.userIndex[++userParamCnt] = cnt;
                    break;
                }
                case 'd': {
                    this.parameters.add(new Parameter(Parameter.ParameterMode.DEFAULT_PARAMETER));
                    break;
                }
                case 'c': {
                    this.parameters.add(new Parameter(parameter.value));
                    break;
                }
                default: {
                    throw new Error("Should not have gotten here...");
                }
            }
            ++cnt;
        }
        this.parameters.userParamCnt = userParamCnt;
    }

    void validateParameters() throws SQLException {
        for (int i = 0; i < this.parameters.size(); ++i) {
            this.isNotDefaultOrReplaced(i);
        }
    }

    public Map<Integer, Object> getReplacedLiterals() {
        TreeMap<Integer, Object> constants = new TreeMap<Integer, Object>();
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter par = this.parameters.get(i);
            if (par.mode != Parameter.ParameterMode.REPLACED_LITERAL) continue;
            constants.put(i + 1, par.values.get(0));
        }
        return constants;
    }

    synchronized void writeParameters(BufferWrite wire) throws SQLException {
        int sets = this.parameterSets;
        if (this.parameterSets == 0) {
            sets = 1;
        }
        wire.set(sets);
        wire.set(this.parameters.size());
        for (int j = 0; j < sets; ++j) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                Parameter par = this.parameters.get(i);
                if (par.mode == Parameter.ParameterMode.REPLACED_LITERAL) {
                    wire.setParameter(par, 0, false);
                    continue;
                }
                if (par.mode == Parameter.ParameterMode.DEFAULT_PARAMETER) {
                    wire.setUndefined();
                    continue;
                }
                if (par.values.get(j) instanceof StreamWrapper) {
                    wire.setObject(this.sendStream(i, (StreamWrapper)par.values.get(j)));
                    continue;
                }
                wire.setParameter(par, j, false);
            }
        }
    }

    synchronized int writeFastInsertParameters(BufferWrite wire) throws SQLException {
        int offset;
        int sets = this.parameterSets;
        int messageCount = -1;
        int vectorParam = 0;
        if (this.parameterSets == 0) {
            sets = 1;
        }
        wire.writeBatchCount(-1);
        wire.set(this.autoGeneratedKeyColumn);
        wire.set(0);
        wire.set(this.keyCount + this.parameters.node_number);
        BufferWrite prepWire = new BufferWrite(this.connection.connectionInfo);
        Counting cnt = new Counting();
        if (this.bus != null && this.bus.getErrors() >= sets) {
            this.bus.throwException("No rows updated!");
        }
        while (cnt.j < sets) {
            if (this.bus == null || !this.bus.rowErrored(cnt.j)) {
                offset = 0;
                SQLValidationException eCollection = null;
                try {
                    cnt.i = 0;
                    while (cnt.i < this.maxRowItemCount) {
                        try {
                            if (cnt.i < this.keyCount) {
                                if (cnt.i == 1) {
                                    offset = wire.getBufferOffset();
                                }
                                messageCount = this.setOutputParam(cnt, wire);
                            } else {
                                messageCount = this.setOutputParam(cnt, prepWire);
                                if (messageCount == -2) {
                                    messageCount = -1;
                                    wire.set(prepWire, true);
                                    prepWire.clearList();
                                }
                                if (messageCount == -3) {
                                    vectorParam = cnt.i + 1;
                                    break;
                                }
                            }
                        }
                        catch (SQLValidationException ex) {
                            if (eCollection == null) {
                                eCollection = ex;
                            }
                            eCollection.setNextException(ex);
                        }
                        ++cnt.i;
                    }
                    if (vectorParam == 1) break;
                    if (eCollection != null) {
                        throw eCollection;
                    }
                    wire.set(prepWire, true);
                }
                catch (SQLException ex) {
                    if (this.bus != null) {
                        if (offset != 0) {
                            wire.setBufferOffset(offset);
                        }
                        this.bus.setException((SQLValidationException)ex, false, cnt.j);
                    }
                    throw ex;
                }
                catch (Exception ex) {
                    if (this.bus != null) {
                        if (offset != 0) {
                            wire.setBufferOffset(offset);
                        }
                        this.bus.throwException(ex.getMessage());
                    }
                    throw ex;
                }
                prepWire.clearList();
            }
            ++cnt.j;
        }
        this.fiParamSetsSent = sets - (this.bus == null ? 0 : this.bus.getErrors());
        if (this.fiParamSetsSent <= 1) {
            this.batchInsertErrorFormat = false;
        }
        if (this.fiParamSetsSent == 0) {
            wire.clearList();
            if (this.bus != null && this.bus.getErrors() >= sets) {
                this.bus.throwException("No rows updated!");
            }
        }
        wire.writeBatchCount(this.fiParamSetsSent);
        if (vectorParam == 0) {
            return messageCount;
        }
        cnt.j = 0;
        cnt.i = vectorParam;
        if (this.bus != null) {
            this.bus.getRowErrors();
        }
        while (cnt.i < this.maxRowItemCount) {
            offset = 0;
            try {
                messageCount = this.setOutputVector(cnt.i, prepWire);
            }
            catch (SQLException ex) {
                if (this.bus != null) {
                    if (offset != 0) {
                        wire.setBufferOffset(offset);
                    }
                    this.bus.setException((SQLValidationException)ex, false, cnt.j);
                    this.bus.updateCount[cnt.j] = -3;
                }
                throw ex;
            }
            catch (Exception ex) {
                if (this.bus != null) {
                    if (offset != 0) {
                        wire.setBufferOffset(offset);
                    }
                    this.bus.throwException(ex.getMessage());
                }
                throw ex;
            }
            prepWire.clearList();
            ++cnt.i;
        }
        return messageCount;
    }

    private int setOutputParam(Counting cnt, BufferWrite outWire) throws SQLException {
        int messageCount = -1;
        int index = this.parameters.outParamSlots[cnt.i];
        if (index > 0) {
            Parameter par = this.parameters.get(index - 1);
            if (par.slotPosition > 8192) {
                return -3;
            }
            if (par.mode == Parameter.ParameterMode.REPLACED_LITERAL || par.values.size() < cnt.j + 1) {
                outWire.setParameter(par, 0, true);
            } else if (par.mode == Parameter.ParameterMode.DEFAULT_PARAMETER) {
                outWire.setUndefined();
            } else {
                if (par.values.get(cnt.j) instanceof StreamWrapper) {
                    throw new SQLException("FastInsert Error writing StreamWrapper!");
                }
                outWire.setParameter(par, cnt.j, true);
            }
        } else {
            boolean atNodeEnd;
            if (index == 0) {
                return -2;
            }
            if (index == -3) {
                return -3;
            }
            int truncateRow = -1;
            int startDefOffset = this.parameters.paramDefValues.rowIndex[cnt.i];
            do {
                if (this.parameters.outParamSlots[cnt.i] == -2) {
                    truncateRow = cnt.i;
                }
                ++cnt.i;
            } while (cnt.i < this.maxRowItemCount && this.parameters.outParamSlots[cnt.i] == -1 && cnt.i != this.keyCount);
            boolean bl = atNodeEnd = cnt.i == this.maxRowItemCount || this.parameters.outParamSlots[cnt.i] == 0;
            if (!atNodeEnd) {
                int length = this.parameters.paramDefValues.rowIndex[cnt.i] - startDefOffset;
                outWire.appendFI(this.parameters.rowOfDefaultValues, startDefOffset, length);
            } else if (truncateRow > -1) {
                int length = this.parameters.paramDefValues.rowIndex[truncateRow + 1] - startDefOffset;
                outWire.appendFI(this.parameters.rowOfDefaultValues, startDefOffset, length);
            }
            if (atNodeEnd && cnt.i != this.maxRowItemCount) {
                return -2;
            }
            --cnt.i;
        }
        return messageCount;
    }

    private int setOutputVector(int parNum, BufferWrite outWire) throws SQLException {
        int messageCount = -1;
        int index = this.parameters.outParamSlots[parNum];
        if (index > 0) {
            Parameter par = this.parameters.get(index - 1);
            if (par.mode == Parameter.ParameterMode.REPLACED_LITERAL) {
                this.output.wire.set(5);
                this.output.wire.setParameter(par, 0, true);
            } else if (par.values.size() == 1) {
                this.output.wire.set(5);
                this.output.wire.setParameter(par, 0, true);
            } else {
                this.output.wire.set(0);
                outWire.setVectorBuffer(par, this.bus);
                if (par.outBuffer != null) {
                    this.output.wire.set(par.outBuffer, true);
                }
            }
        } else {
            int startDefOffset = this.parameters.paramDefValues.rowIndex[parNum++];
            int length = this.parameters.paramDefValues.rowIndex[parNum] - startDefOffset;
            this.output.wire.set(5);
            this.output.wire.appendFI(this.parameters.rowOfDefaultValues, startDefOffset, length);
        }
        return messageCount;
    }

    synchronized Object sendStream(int parameterIndex, StreamWrapper s) throws SQLException {
        int length = s.length;
        int jdbcType = this.parameters.get((int)parameterIndex).type;
        try {
            int maxFieldSize;
            int available;
            if (s.type != 4 && (available = ((InputStream)s.data).available()) > 0 && (length < 0 || length > available)) {
                length = available;
            }
            if ((maxFieldSize = this.output.wire.getMaxFieldSize()) != 0 && length > maxFieldSize) {
                length = maxFieldSize;
            }
            if (length == 0) {
                return "";
            }
            if (jdbcType != -1 && jdbcType != -4) {
                return FakeStream.sendStream(s.data, length, s.type);
            }
            return RealStream.sendStream(this.connection, s.data, length, s.type, jdbcType, this.serverCursorNumber);
        }
        catch (IOException e) {
            throw new SQLException("Error writing stream: " + e.getMessage());
        }
    }

    synchronized void cleanUp() throws SQLException {
        if (this.myResultSet != null) {
            this.myResultSet.close();
            this.myResultSet = null;
        }
        if (this.parameters != null) {
            this.parameters.clear();
        }
        this.hasStreamParameters = false;
        this.multipleResultSets = false;
        this.mrsDone = false;
        this.fetchDone = false;
        this.genericExecuteCalled = false;
        this.parameterSets = 0;
        this.updateCnt = 0;
        this.updatableRSTableName = null;
        this.updatableRSColumnNames = null;
        this.execParams = null;
        this.statementType = StatementType.UPDATE;
        this.statementFeatureOption = 0;
        this.maxRowItemCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void query404() throws SQLException {
        if (this.getSQLDialect() != 0) {
            this.directExecuteDialect();
            return;
        }
        this.connection.cachedPrepares.remove(this.serverCursorNumber);
        this.connection.recycledServerCursorNumber = this.serverCursorNumber;
        IRISStatement iRISStatement = this;
        synchronized (iRISStatement) {
            this.updatableRSTableName = null;
            this.validateParameters();
            if (this instanceof IRISCallableStatement || this.statementType == StatementType.PREPARED_CALL_QUERY || this.statementType == StatementType.DIRECT_CALL_QUERY) {
                this.directExecuteStoredProcedure();
            } else {
                this.sendDirectQueryRequest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update404() throws SQLException {
        if (this.getSQLDialect() != 0) {
            this.directExecuteDialect();
            return;
        }
        this.connection.cachedPrepares.remove(this.serverCursorNumber);
        this.connection.recycledServerCursorNumber = this.serverCursorNumber;
        IRISStatement iRISStatement = this;
        synchronized (iRISStatement) {
            this.validateParameters();
            this.resetStreams();
            if (this instanceof IRISCallableStatement || this.statementType == StatementType.PREPARED_CALL_UPDATE || this.statementType == StatementType.DIRECT_CALL_UPDATE) {
                try {
                    this.directExecuteStoredProcedure();
                }
                catch (SQLException ex) {
                    if (this.bus != null && this.input.wire.Header.getError() != 400) {
                        this.processStoredProcedureMetaData(this.input.wire, true);
                    }
                    throw ex;
                }
            } else {
                this.sendDirectUpdateRequest();
            }
        }
    }

    synchronized void resetStreams() throws SQLException {
        try {
            int sets = this.parameterSets;
            if (this.parameterSets == 0) {
                sets = 1;
            }
            for (int j = 0; j < sets; ++j) {
                for (int i = 0; i < this.parameters.size(); ++i) {
                    Parameter par = this.parameters.get(i);
                    if (par.whatever == null || j >= par.whatever.size() || par.whatever.get(j) != null || !(par.values.get(j) instanceof StreamWrapper)) continue;
                    StreamWrapper stream = (StreamWrapper)par.values.get(j);
                    if (stream.type == 0 || stream.type == 1) {
                        ((InputStream)stream.data).reset();
                        continue;
                    }
                    if (stream.type != 4) continue;
                    ((Reader)stream.data).reset();
                }
            }
        }
        catch (IOException e) {
            throw new SQLException("Unable to complete a 404-logic request as the statement includes input stream data that cannot be rewound to the beginning");
        }
    }

    synchronized void getOutputParameters(BufferRO roList) throws SQLException {
        int beg = roList.getOffset();
        int i = 0;
        if (this.hasReturnValue == 3) {
            ++i;
        }
        if (this.hasReturnValue > 0) {
            ++this.paramsSent;
        }
        while (i < this.paramsSent) {
            block9: {
                try {
                    if (this.isOutParameter(i)) {
                        roList.nextUnlessUndefined();
                    } else {
                        roList.next();
                    }
                }
                catch (SQLException e) {
                    if (e instanceof BufferRO.NoMoreDataException) break block9;
                    throw e;
                }
            }
            ++i;
        }
        if (this.hasReturnValue == 3) {
            this.outputParameterList = roList.getOutputParameterList(beg, true);
            this.hasReturnValue = 2;
        } else {
            this.outputParameterList = roList.getOutputParameterList(beg, false);
        }
        this.parameters.prepListIndex(this.outputParameterList);
    }

    synchronized void updateResultSet() throws SQLException {
        this.Query(this.originalSqlText);
        this.resultSetConcurrency = 1008;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void storedProcedureUpdate() throws SQLException {
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.STORED_PROCEDURE_UPDATE_EXECUTE);
            this.output.wire.set(0);
            this.output.wire.set(0);
            this.output.wire.set(this.maxRows);
            this.writeStoredProcedureParameters();
            this.output.send(this.connection.messageCount.getCount());
            try {
                if (this.input.readMessage(this, 0, 504) == 404) {
                    this.update404();
                } else {
                    this.getOutputParameters(this.input.wire);
                    this.connection.cachedPrepares.markAsNotBeingExecuted(this.serverCursorNumber, this);
                }
            }
            catch (Exception ex) {
                try {
                    this.getOutputParameters(this.input.wire);
                    this.connection.cachedPrepares.markAsNotBeingExecuted(this.serverCursorNumber, this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void storedProcedureQuery() throws SQLException {
        if (this.multipleResultSets) {
            this.executeMultipleResultSets(false);
            return;
        }
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.STORED_PROCEDURE_QUERY_EXECUTE);
            if (this.resultSetType == 1004) {
                this.output.wire.set(1);
            } else {
                this.output.wire.set(0);
            }
            this.output.wire.set(this.queryTimeout);
            this.output.wire.set(this.maxRows);
            this.writeStoredProcedureParameters();
            this.output.send(this.connection.messageCount.getCount());
            int error = this.input.readMessage(this, 0, 504);
            if (error == 404) {
                this.handleError504(404);
                return;
            }
            if (error == 100) {
                this.handleError100(100);
                return;
            }
            this.getOutputParameters(this.input.wire);
            this.handleError100(this.input.readMessage(this, 2, 100));
        }
    }

    synchronized void writeStoredProcedureParameters() throws SQLException {
        int i = 0;
        if (this.parameterSets != 0) {
            this.output.wire.set(this.parameterSets);
            this.paramsSent = this.parameters.size();
            this.output.wire.set(this.paramsSent);
            for (int j = 0; j < this.parameterSets; ++j) {
                for (i = 0; i < this.paramsSent; ++i) {
                    Parameter par = this.parameters.get(i);
                    if (par.values.get(j) instanceof StreamWrapper) {
                        this.output.wire.setObject(this.sendStream(i, (StreamWrapper)par.values.get(j)));
                        continue;
                    }
                    this.output.wire.setParameter(par, j, false);
                }
            }
            return;
        }
        this.output.wire.set(1);
        if (this.hasReturnValue != 0) {
            i = 1;
        }
        this.paramsSent = this.parameters.size() - i;
        this.output.wire.set(this.paramsSent);
        while (i < this.parameters.size()) {
            Parameter par = this.parameters.get(i);
            if (par.mode == Parameter.ParameterMode.OUTPUT || par.mode == Parameter.ParameterMode.DEFAULT_PARAMETER) {
                this.output.wire.setUndefined();
            } else if (par.values.get(0) instanceof StreamWrapper) {
                this.output.wire.setObject(this.sendStream(i, (StreamWrapper)par.values.get(0)));
            } else {
                this.output.wire.setParameter(par, 0, false);
            }
            ++i;
        }
    }

    private int[] computeUpdateCount(List<Integer> v) {
        int[] updateCount = new int[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            updateCount[i] = v.get(i);
        }
        return updateCount;
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLException("Unsupported fetch direction.", "IM001");
        }
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public synchronized void setFetchSize(int rows) throws SQLException {
        int max = this.getMaxRows();
        if (rows < 0 || max != 0 && rows > max) {
            throw new SQLException("Invalid number of rows specified: " + rows, "S1000");
        }
        this.fetchSize = rows;
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    @Override
    public synchronized void addBatch(String sql) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (!this.batchException.equals(BATCH_EXCEPTION_NONE)) {
            return;
        }
        this.cleanUp();
        this.preparse(sql);
        if (this.statementType == StatementType.QUERY) {
            this.batchException = BATCH_EXCEPTION_QUERY;
            return;
        }
        if (this.statementType == StatementType.CALL || this.statementType == StatementType.CALLWITHRESULT) {
            this.batchException = BATCH_EXCEPTION_SP;
            return;
        }
        ++this.batchCount;
        this.validateParameters();
        if (this.batchCount == 1) {
            this.batchBuffer = new BufferWrite(this.connection.connectionInfo);
            this.batchBuffer.writeHeader(0, IRISConnection.EXECUTE_STATEMENT_BATCH);
            this.batchBuffer.writeBatchCount(-1);
            this.batchBuffer.set(0);
        }
        this.batchBuffer.setSQLText(this.sqlText);
        this.writeParameters(this.batchBuffer);
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this instanceof IRISPreparedStatement) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                this.unbindParameter(i);
            }
            this.fiParamSetsSent = 0;
            this.parameterSets = 0;
            this.parameters.arrayBound = false;
            return;
        }
        this.batchCount = 0;
        this.batchBuffer = null;
        this.runningBatch = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int[] executeBatch() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open.", "08003");
        }
        if (this.batchCount == 0) {
            if (!this.batchException.equals(BATCH_EXCEPTION_NONE)) {
                throw new BatchUpdateException("Statement.addBatch called with a " + this.batchException, "24000", 24000, new int[0]);
            }
            return new int[0];
        }
        ArrayList<Integer> updateCount = new ArrayList<Integer>();
        SQLException ex = null;
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            BufferWrite oldWire = this.output.setWire(this.batchBuffer);
            this.output.wire.writeBatchCount(this.batchCount);
            this.output.send(this.connection.messageCount.getCount());
            try {
                this.input.readMessage(0, 0, 100);
            }
            catch (SQLException e) {
                this.connection.cachedPrepares.remove(this.serverCursorNumber);
                this.connection.recycledServerCursorNumber = this.serverCursorNumber;
                if (this.input.wire == null || this.input.wire.isEnd()) {
                    throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), null);
                }
                ex = e;
            }
            this.output.setWire(oldWire);
            int sets = this.batchCount;
            this.batchCount = 0;
            for (int i = 0; i < sets; ++i) {
                int x = this.input.wire.getInt();
                if (x == -3) {
                    if (ex != null) {
                        throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), this.computeUpdateCount(updateCount));
                    }
                    throw new BatchUpdateException("Not all rows updated", this.computeUpdateCount(updateCount));
                }
                updateCount.add(x);
            }
        }
        if (!this.batchException.equals(BATCH_EXCEPTION_NONE)) {
            throw new BatchUpdateException("Statement.addBatch called with a " + this.batchException, "24000", 24000, this.computeUpdateCount(updateCount));
        }
        if (ex != null) {
            throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), this.computeUpdateCount(updateCount));
        }
        this.batchBuffer = null;
        return this.computeUpdateCount(updateCount);
    }

    Parameter getExecParam(int index) throws SQLException {
        Parameter parameter = this.execParams.get(index - 1);
        if (parameter == null) {
            throw new SQLException("Parameter list mismatch.");
        }
        return parameter;
    }

    Parameter getExecParamByName(String parameterName) throws SQLException {
        return this.execParams.get(parameterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void prepareStoredProcedure() throws SQLException {
        this.serverCursorNumber = this.connection.getServerCursorNumber();
        this.connection.updateCache();
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.PREPARE_STORED_PROCEDURE);
            this.output.wire.set(this.sqlText);
            this.output.send(this.connection.messageCount.getCount());
            this.input.readMessage(this, 0, 0);
            this.processStoredProcedureMetaData(this.input.wire, false);
            if (this.multipleResultSets) {
                return;
            }
        }
        this.connection.addCachedPrepare(this, this.statementType == StatementType.QUERY);
    }

    public void setSQLDialect(int dialect) {
        this.sqlDialect = dialect;
    }

    public int getSQLDialect() {
        return this.sqlDialect;
    }

    private synchronized boolean directExecuteDialect() throws SQLException {
        this.multipleResultSets = true;
        this.mrsDone = false;
        this.serverCursorNumber = this.connection.getServerCursorNumber();
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            int results;
            this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.DIRECT_EXECUTE_DIALECT);
            this.output.wire.set(this.sqlDialect);
            this.output.wire.set(this.sqlText);
            if (this.resultSetType == 1004) {
                this.output.wire.set(1);
            } else {
                this.output.wire.set(0);
            }
            this.output.wire.set(this.queryTimeout);
            this.output.wire.set(this.maxRows);
            this.output.send(this.connection.messageCount.getCount());
            this.createResultSet();
            int error = this.input.readMessage(this, 2, 100);
            int parameterCount = this.input.wire.getInt();
            for (int i = 0; i < parameterCount; ++i) {
                this.parameters.add(new Parameter());
            }
            this.readParameterData(this.input.wire, parameterCount, false);
            if (error == 100) {
                this.handleError100(100);
            }
            if ((results = this.input.wire.getInt()) >= 0) {
                this.updateCnt = results;
                return false;
            }
            if (results == -1) {
                this.updateCnt = -1;
                return true;
            }
            if (results == -2) {
                this.updateCnt = -1;
                return false;
            }
            throw new SQLException("Invalid result type value: " + results, "S1000");
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public synchronized boolean getMoreResults(int current) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        if (this.mrsDone || !this.multipleResultSets || this.statementType != StatementType.PREPARED_CALL_QUERY && this.statementType != StatementType.DIRECT_CALL_QUERY && this.statementType != StatementType.CALL && this.statementType != StatementType.CALLWITHRESULT && (this.statementType != StatementType.QUERY || !(this instanceof IRISCallableStatement) && this.getSQLDialect() == 0)) {
            return false;
        }
        if (current < 1 || current > 3) {
            throw new SQLException("Invalid flag value: " + current, "S1000");
        }
        if (current == 2) {
            throw new SQLException("KEEP_CURRENT_RESULT not supported.", "IM001");
        }
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.GET_MORE_RESULTS);
            this.output.wire.set(current);
            this.output.send(this.connection.messageCount.getCount());
            int error = this.input.readMessage(this, 0, 100);
            int results = this.input.wire.getInt();
            if (results >= 0) {
                this.updateCnt = results;
                return false;
            }
            if (results == -1) {
                this.createResultSet();
                if (error == 100) {
                    this.fetchDone = true;
                } else {
                    this.fetchDone = false;
                    this.myResultSet.requestFetch(this.connection.messageCount.getCount());
                }
                return true;
            }
            if (results == -2) {
                this.updateCnt = -1;
                this.genericExecuteCalled = true;
                this.mrsDone = true;
                return false;
            }
            throw new SQLException("Invalid result type value: " + results, "S1000");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open.", "08003");
        }
        if (this.autoGeneratedKeyColumn == null) {
            this.columns = new ArrayList<Column>();
            this.fetchDone = true;
            return this.createNewResultSet();
        }
        if (this.statementType != StatementType.UPDATE) {
            throw new SQLException("Not an INSERT statement.", "S1000");
        }
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.GET_AUTO_GENERATED_KEYS);
            this.output.send(this.connection.messageCount.getCount());
            if (this.input.readMessage(this, 0, 100) != 100) {
                throw new SQLException("Error retrieving auto-generated keys.", "S1000");
            }
            this.fetchDone = true;
        }
        if (this.input.wire.isEnd()) {
            this.columns = new ArrayList<Column>();
            this.fetchDone = true;
            return this.createNewResultSet();
        }
        this.columns = new ArrayList<Column>(1);
        this.columnInfo(this.input.wire);
        return this.createNewResultSet();
    }

    @Override
    public int executeUpdate(String sql, int generatedKeys) throws SQLException {
        this.autoGeneratedKeyColumn = generatedKeys == 1 ? "-1" : null;
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int generatedKeys) throws SQLException {
        this.autoGeneratedKeyColumn = generatedKeys == 1 ? "-1" : null;
        return this.execute(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed.", "IM001");
        }
        this.autoGeneratedKeyColumn = Integer.toString(columnIndexes[0]);
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed.", "IM001");
        }
        this.autoGeneratedKeyColumn = Integer.toString(columnIndexes[0]);
        return this.execute(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed.", "IM001");
        }
        this.autoGeneratedKeyColumn = columnNames[0];
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (columnNames.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed.", "IM001");
        }
        this.autoGeneratedKeyColumn = columnNames[0];
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    synchronized boolean executeMultipleResultSets(boolean validate) throws SQLException {
        this.fetchDone = false;
        if (validate) {
            this.validateParameters();
        }
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            int results;
            this.output.wire.writeHeader(this.serverCursorNumber, IRISConnection.EXECUTE_MULTIPLE_RESULT_SETS);
            if (this.resultSetType == 1004) {
                this.output.wire.set(1);
            } else {
                this.output.wire.set(0);
            }
            this.output.wire.set(this.queryTimeout);
            if (this.getSQLDialect() != 0) {
                this.writeParameters(this.output.wire);
            } else {
                this.writeStoredProcedureParameters();
            }
            this.output.send(this.connection.messageCount.getCount());
            this.createResultSet();
            if (this.input.readMessage(this, 2, 100) == 100) {
                this.fetchDone = true;
            }
            if (this.getSQLDialect() == 0) {
                this.getOutputParameters(this.input.wire);
            }
            if ((results = this.input.wire.getInt()) >= 0) {
                this.updateCnt = results;
                return false;
            }
            if (results == -1) {
                return true;
            }
            if (results == -2) {
                this.updateCnt = -1;
                this.mrsDone = true;
                this.myResultSet.isAfterLast = true;
                return false;
            }
            throw new SQLException("Invalid result type value: " + results, "S1000");
        }
    }

    static boolean compareParInfoString(ListWriter s1, ListWriter s2) {
        return Arrays.equals(s1.getBuffer(), s2.getBuffer());
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean p) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        throw new SQLException("Not supported.", "IM001");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        return this.closeOnCompletion;
    }

    void LogMessage(String api, String message) {
        if (null != this.connection && null != this.connection.device && null != this.connection.device.conParams) {
            this.connection.device.conParams.writeToLog(api + ":\n" + message);
        }
    }

    class Counting {
        int i = 0;
        int j = 0;

        public Counting() {
        }

        public Counting(int i, int j) {
            this.i = i;
            this.j = j;
        }
    }

    public static enum StatementType {
        UPDATE,
        QUERY,
        CALL,
        SYNC_COMMIT,
        ASYNC_COMMIT,
        STREAMS_OFF,
        STREAMS_ON,
        CALLWITHRESULT,
        DDL_ALTER_DROP,
        DDL_OTHER,
        DIRECT_CALL_QUERY,
        DIRECT_CALL_UPDATE,
        PREPARED_CALL_QUERY,
        PREPARED_CALL_UPDATE,
        SQL_DIALECT,
        STMT_USE,
        WITH;

    }

    static final class Column
    extends Descriptor
    implements Cloneable {
        String label;
        String tableName;
        String schema = "";
        String catalog = "";
        boolean isAutoIncrement = false;
        boolean isCaseSensitive = false;
        boolean isCurrency;
        boolean isReadOnly = false;
        boolean isRowId = false;

        Column() {
        }

        protected Object clone() {
            Column clone = new Column();
            clone.cloneMe(this);
            clone.label = this.label;
            clone.tableName = this.tableName;
            clone.schema = this.schema;
            clone.catalog = this.catalog;
            clone.isAutoIncrement = this.isAutoIncrement;
            clone.isCaseSensitive = this.isCaseSensitive;
            clone.isCurrency = this.isCurrency;
            clone.isReadOnly = this.isReadOnly;
            clone.isRowId = this.isRowId;
            return clone;
        }
    }

    static final class StreamWrapper {
        Object data;
        int type;
        int length;

        StreamWrapper(Object d, int t, int l) {
            this.data = d;
            this.type = t;
            this.length = l;
        }
    }
}

