/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.IRISResultSet;
import com.intersystems.jdbc.IRISStatement;
import com.intersystems.jdbc.IRISUpdatableResultSet;
import com.intersystems.jdbc.ResultSetRow;
import java.sql.SQLException;

public class IRISStaticResultSet
extends IRISResultSet {
    int lastRow = -1;
    int lastFetchedRow = 0;

    IRISStaticResultSet(IRISStatement stmt) throws SQLException {
        super(stmt);
    }

    @Override
    public synchronized boolean next() throws SQLException {
        this.throwIfClosed();
        if (!this.streamsFetchedAsLiterals.isEmpty()) {
            this.closeLiteralStreams();
        }
        if (this.currentRow == 0) {
            return this.staticFetch(1, this.statement.fetchSize);
        }
        if (this.isAfterLast || this.lastRow != -1 && this.currentRow > this.lastRow) {
            return false;
        }
        if (this.currentRow == this.lastRow) {
            this.isAfterLast = true;
            return false;
        }
        if (this.currentRow == this.lastFetchedRow) {
            if (this.statement.fetchDone) {
                this.isAfterLast = true;
                return false;
            }
            return this.staticFetch(this.currentRow + 1, this.statement.fetchSize);
        }
        if (!this.rsRow.indexRow(this.statement.input.wire.getBuffer(), this.statement.input.wire.getEndLength())) {
            if (this.statement.fetchDone) {
                this.isAfterLast = true;
                return false;
            }
            return this.staticFetch(this.currentRow + 1, this.statement.fetchSize);
        }
        ++this.currentRow;
        return true;
    }

    @Override
    public synchronized boolean isBeforeFirst() throws SQLException {
        this.throwIfClosed();
        return this.currentRow == 0;
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        this.throwIfClosed();
        return this.isAfterLast;
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        this.throwIfClosed();
        return this.currentRow == 1;
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        this.throwIfClosed();
        return !this.isAfterLast && this.lastRow == this.currentRow;
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        this.throwIfClosed();
        this.statement.fetchDone = false;
        this.currentRow = 0;
        this.lastFetchedRow = 0;
        this.isAfterLast = false;
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        this.throwIfClosed();
        this.statement.fetchDone = false;
        if (!this.isAfterLast) {
            this.last();
            this.next();
        }
    }

    @Override
    public synchronized boolean first() throws SQLException {
        this.throwIfClosed();
        this.statement.fetchDone = false;
        return this.staticFetch(1, this.statement.fetchSize);
    }

    @Override
    public synchronized boolean last() throws SQLException {
        this.throwIfClosed();
        this.isAfterLast = false;
        this.statement.fetchDone = false;
        if (!this.staticFetch(0, 1)) {
            return false;
        }
        this.lastRow = this.currentRow;
        return true;
    }

    @Override
    public synchronized boolean absolute(int row) throws SQLException {
        this.throwIfClosed();
        this.isAfterLast = false;
        this.statement.fetchDone = false;
        if (row == 0) {
            this.beforeFirst();
            return false;
        }
        if (row == 1) {
            return this.first();
        }
        if (row == -1) {
            return this.last();
        }
        if (this.lastRow == -1) {
            int cr = this.currentRow;
            this.last();
            this.currentRow = cr;
        }
        if (row < 0) {
            if ((row = this.lastRow + row + 1) <= 0) {
                this.currentRow = 0;
                return false;
            }
            return this.staticFetch(row, this.statement.fetchSize);
        }
        if (row > this.lastRow) {
            this.isAfterLast = true;
            this.currentRow = this.lastRow;
            return false;
        }
        return this.staticFetch(row, this.statement.fetchSize);
    }

    @Override
    public synchronized boolean relative(int rows) throws SQLException {
        this.throwIfClosed();
        if (this.isAfterLast || this.currentRow == 0) {
            throw new SQLException("Invalid cursor position.");
        }
        this.statement.fetchDone = false;
        this.isAfterLast = false;
        if (rows == 0) {
            return true;
        }
        if ((rows += this.currentRow) <= 0) {
            this.currentRow = 0;
            return false;
        }
        if (this.lastRow == -1) {
            int cr = this.currentRow;
            this.last();
            this.currentRow = cr;
        }
        if (rows > this.lastRow) {
            this.isAfterLast = true;
            return false;
        }
        return this.staticFetch(rows, this.statement.fetchSize);
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        this.throwIfClosed();
        this.statement.fetchDone = false;
        if (this.isAfterLast) {
            this.isAfterLast = false;
            return this.staticFetch(this.lastRow, this.statement.fetchSize);
        }
        if (this.currentRow <= 1) {
            this.currentRow = 0;
            return false;
        }
        this.rsRow.newBuffer = true;
        return this.staticFetch(this.currentRow - 1, this.statement.fetchSize);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLException("Not supported.", "IM001");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getType() throws SQLException {
        return 1004;
    }

    @Override
    public synchronized int getRow() throws SQLException {
        if (this.isAfterLast) {
            return 0;
        }
        return this.currentRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean staticFetch(int offset, int size) throws SQLException {
        this.throwIfClosed();
        if (size == 0) {
            size = 10;
        }
        this.isAfterLast = false;
        this.statement.fetchDone = false;
        IRISConnection.MessageCount messageCount = this.statement.connection.messageCount;
        synchronized (messageCount) {
            this.statement.output.wire.writeHeader(this.statement.serverCursorNumber, IRISConnection.FETCH_STATIC_CURSOR);
            this.statement.output.wire.set(offset);
            this.statement.output.wire.set(size);
            this.statement.output.send(this.statement.connection.messageCount.getCount());
            int err = this.statement.input.readMessage(this.statement, 0, 100);
            int off = this.statement.input.wire.getInt();
            int rows = this.statement.input.wire.getInt();
            this.lastFetchedRow = rows == 0 ? this.currentRow : off + rows - 1;
            if (offset == 0 || err == 100) {
                this.statement.fetchDone = true;
                this.lastRow = this.lastFetchedRow;
            }
            if (rows == 0) {
                return false;
            }
            if (this.currentRow == 0) {
                this.rsRow = this.statement.myResultSet != null && this.statement.myResultSet instanceof IRISUpdatableResultSet ? new ResultSetRow(this.statement.columns.size() + 1, this.statement.input.wire.getOffset()) : new ResultSetRow(this.statement.columns.size(), this.statement.input.wire.getOffset());
            }
            this.currentRow = offset > 0 ? offset : this.lastRow;
            if (!this.rsRow.indexRow(this.statement.input.wire.getBuffer(), this.statement.input.wire.getEndLength(), this.statement.input.wire.getOffset()) && this.statement.fetchDone) {
                this.isAfterLast = true;
                return false;
            }
            return true;
        }
    }
}

