/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.IRISStatement;
import com.intersystems.jdbc.IRISStaticResultSet;
import com.intersystems.jdbc.ResultSetRow;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class IRISUpdatableResultSet
extends IRISStaticResultSet {
    private PreparedStatement update;
    private Statement delete = null;
    private String statementText;
    private String[] columns;
    private Map<String, Object> values;
    private boolean onInsertRow = false;
    private int moveToCurrentRow;
    private Map<Integer, Integer> deletedRows = null;

    IRISUpdatableResultSet(IRISStatement stmt) throws SQLException {
        super(stmt);
        this.init();
    }

    @Override
    public final String getString(int i) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (String)this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getString(i);
    }

    @Override
    public final boolean getBoolean(int i) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (Boolean)this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getBoolean(i);
    }

    @Override
    public final byte getByte(int i) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (Byte)this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getByte(i);
    }

    @Override
    public final short getShort(int i) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (Short)this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getShort(i);
    }

    @Override
    public final int getInt(int i) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (Integer)this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getInt(i);
    }

    @Override
    public final long getLong(int i) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (Long)this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getLong(i);
    }

    @Override
    public final float getFloat(int i) throws SQLException {
        return (float)this.getDouble(i);
    }

    @Override
    public final double getDouble(int i) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (Double)this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getDouble(i);
    }

    @Override
    @Deprecated
    public final BigDecimal getBigDecimal(int i, int scale) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (BigDecimal)this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getBigDecimal(i);
    }

    @Override
    public final byte[] getBytes(int i) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (byte[])this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getBytes(i);
    }

    @Override
    public final Date getDate(int i) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (Date)this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getDate(i);
    }

    @Override
    public final Time getTime(int i) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (Time)this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getTime(i);
    }

    @Override
    public final Timestamp getTimestamp(int i) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (Timestamp)this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getTimestamp(i);
    }

    @Override
    public final InputStream getAsciiStream(int i) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (InputStream)this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getAsciiStream(i);
    }

    @Override
    public final InputStream getBinaryStream(int i) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (InputStream)this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getBinaryStream(i);
    }

    @Override
    public final Date getDate(int i, Calendar cal) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (Date)this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getDate(i, cal);
    }

    @Override
    public final Time getTime(int i, Calendar cal) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (Time)this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getTime(i, cal);
    }

    @Override
    public final Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (Timestamp)this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getTimestamp(i, cal);
    }

    @Override
    public final Blob getBlob(int i) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (Blob)this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getBlob(i);
    }

    @Override
    public final Clob getClob(int i) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return (Clob)this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getClob(i);
    }

    @Override
    public final Object getObject(int i) throws SQLException {
        this.check(i);
        if (this.values.containsKey(this.columns[i])) {
            return this.values.get(this.columns[i]);
        }
        this.insertRowCheck();
        return super.getObject(i);
    }

    @Override
    public final void updateNull(int i) throws SQLException {
        this.check(i);
        this.updateNull(this.columns[i]);
    }

    @Override
    public final void updateBoolean(int i, boolean x) throws SQLException {
        this.check(i);
        this.updateBoolean(this.columns[i], x);
    }

    @Override
    public final void updateByte(int i, byte x) throws SQLException {
        this.check(i);
        this.updateByte(this.columns[i], x);
    }

    @Override
    public final void updateShort(int i, short x) throws SQLException {
        this.check(i);
        this.updateShort(this.columns[i], x);
    }

    @Override
    public final void updateInt(int i, int x) throws SQLException {
        this.check(i);
        this.updateInt(this.columns[i], x);
    }

    @Override
    public final void updateLong(int i, long x) throws SQLException {
        this.check(i);
        this.updateLong(this.columns[i], x);
    }

    @Override
    public final void updateFloat(int i, float x) throws SQLException {
        this.check(i);
        this.updateFloat(this.columns[i], x);
    }

    @Override
    public final void updateDouble(int i, double x) throws SQLException {
        this.check(i);
        this.updateDouble(this.columns[i], x);
    }

    @Override
    public final void updateBigDecimal(int i, BigDecimal x) throws SQLException {
        this.check(i);
        this.updateBigDecimal(this.columns[i], x);
    }

    @Override
    public final void updateString(int i, String x) throws SQLException {
        this.check(i);
        this.updateString(this.columns[i], x);
    }

    @Override
    public final void updateBytes(int i, byte[] x) throws SQLException {
        this.check(i);
        this.updateBytes(this.columns[i], x);
    }

    @Override
    public final void updateDate(int i, Date x) throws SQLException {
        this.check(i);
        this.updateDate(this.columns[i], x);
    }

    @Override
    public final void updateTime(int i, Time x) throws SQLException {
        this.check(i);
        this.updateTime(this.columns[i], x);
    }

    @Override
    public final void updateTimestamp(int i, Timestamp x) throws SQLException {
        this.check(i);
        this.updateTimestamp(this.columns[i], x);
    }

    @Override
    public final void updateAsciiStream(int i, InputStream x, int length) throws SQLException {
        this.check(i);
        this.updateAsciiStream(this.columns[i], x, length);
    }

    @Override
    public final void updateBinaryStream(int i, InputStream x, int length) throws SQLException {
        this.check(i);
        this.updateBinaryStream(this.columns[i], x, length);
    }

    @Override
    public final void updateCharacterStream(int i, Reader x, int length) throws SQLException {
        this.check(i);
        this.updateCharacterStream(this.columns[i], x, length);
    }

    @Override
    public final void updateObject(int i, Object x, int scale) throws SQLException {
        this.check(i);
        this.updateObject(this.columns[i], x, scale);
    }

    @Override
    public final void updateObject(int i, Object x) throws SQLException {
        this.check(i);
        this.updateObject(this.columns[i], x);
    }

    @Override
    public final void updateNull(String columnName) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, null);
    }

    @Override
    public final void updateBoolean(String columnName, boolean x) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, x);
    }

    @Override
    public final void updateByte(String columnName, byte x) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, x);
    }

    @Override
    public final void updateShort(String columnName, short x) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, x);
    }

    @Override
    public final void updateInt(String columnName, int x) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, x);
    }

    @Override
    public final void updateLong(String columnName, long x) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, x);
    }

    @Override
    public final void updateFloat(String columnName, float x) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, Float.valueOf(x));
    }

    @Override
    public final void updateDouble(String columnName, double x) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, x);
    }

    @Override
    public final void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, x);
    }

    @Override
    public final void updateString(String columnName, String x) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, x);
    }

    @Override
    public final void updateBytes(String columnName, byte[] x) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, x);
    }

    @Override
    public final void updateDate(String columnName, Date x) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, x);
    }

    @Override
    public final void updateTime(String columnName, Time x) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, x);
    }

    @Override
    public final void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, x);
    }

    @Override
    public final void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, new ObjectWrapper(0, x, length));
    }

    @Override
    public final void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, new ObjectWrapper(1, x, length));
    }

    @Override
    public final void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, new ObjectWrapper(2, x, length));
    }

    @Override
    public final void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, new ObjectWrapper(3, x, scale));
    }

    @Override
    public final void updateObject(String columnName, Object x) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, x);
    }

    @Override
    public final void updateBlob(int i, Blob x) throws SQLException {
        this.check(i);
        this.updateBlob(this.columns[i], x);
    }

    @Override
    public final void updateBlob(String columnName, Blob x) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, x);
    }

    @Override
    public final void updateClob(int i, Clob x) throws SQLException {
        this.check(i);
        this.updateClob(this.columns[i], x);
    }

    @Override
    public final void updateClob(String columnName, Clob x) throws SQLException {
        this.check(columnName);
        this.values.put(columnName, x);
    }

    @Override
    public final synchronized void insertRow() throws SQLException {
        int i;
        if (!this.onInsertRow) {
            throw new SQLException("The cursor is currently not positioned on the insert row.");
        }
        this.statementText = "INSERT INTO " + this.statement.updatableRSTableName + " (";
        for (i = 1; i < this.columns.length - 1; ++i) {
            this.statementText = this.statementText + this.columns[i] + ", ";
        }
        this.statementText = this.statementText + this.columns[this.columns.length - 1] + ") VALUES (";
        for (i = 1; i < this.columns.length - 1; ++i) {
            this.statementText = this.statementText + "?,";
        }
        this.statementText = this.statementText + "?)";
        this.update = this.statement.connection.prepareStatement(this.statementText);
        for (i = 1; i < this.columns.length; ++i) {
            if (this.values.containsKey(this.columns[i])) {
                Object obj = this.values.get(this.columns[i]);
                if (obj instanceof ObjectWrapper) {
                    this.setObjectWrapper(this.update, i, (ObjectWrapper)obj);
                    continue;
                }
                this.update.setObject(i, obj);
                continue;
            }
            if (this.statement.getColumnNullable(i) != 0) {
                this.update.setNull(i, this.statement.getColumnType(i));
                continue;
            }
            throw new SQLException("Not all non-nullable columns in the insert row have value.");
        }
        this.update.executeUpdate();
        this.onInsertRow = false;
    }

    @Override
    public final synchronized void updateRow() throws SQLException {
        String key;
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row.");
        }
        if (this.values.isEmpty()) {
            throw new SQLException("No values to update specified.");
        }
        this.statementText = "UPDATE " + this.statement.updatableRSTableName + " SET ";
        Iterator<String> iter = this.values.keySet().iterator();
        if (iter.hasNext()) {
            key = iter.next();
            this.statementText = this.statementText + key + " = ?";
        }
        while (iter.hasNext()) {
            key = iter.next();
            this.statementText = this.statementText + ", " + key + " = ?";
        }
        this.statementText = this.statementText + " WHERE " + this.columns[0] + " = ?";
        this.update = this.statement.connection.prepareStatement(this.statementText);
        int count = 1;
        for (Object obj : this.values.values()) {
            if (obj instanceof ObjectWrapper) {
                this.setObjectWrapper(this.update, count, (ObjectWrapper)obj);
            } else {
                this.update.setObject(count, obj);
            }
            ++count;
        }
        this.update.setInt(count, this.rowID);
        this.update.executeUpdate();
    }

    @Override
    public final synchronized void deleteRow() throws SQLException {
        if (this.onInsertRow || this.isAfterLast) {
            throw new SQLException("Invalid cursor position.");
        }
        if (this.delete == null) {
            this.delete = this.statement.connection.createStatement();
        }
        this.delete.executeUpdate("DELETE FROM " + this.statement.updatableRSTableName + " WHERE " + this.columns[0] + " = " + this.rowID);
        if (this.deletedRows == null) {
            this.deletedRows = new TreeMap<Integer, Integer>();
        }
        if (this.statement.resultSetType == 1003) {
            --this.currentRow;
        }
        this.deletedRows.put(this.rowID, this.currentRow);
        this.closed = false;
        this.isAfterLast = false;
    }

    @Override
    public synchronized int getRow() throws SQLException {
        if (this.deletedRows != null) {
            if (this.deletedRows.containsValue(this.currentRow)) {
                if (this.isAfterLast) {
                    return 0;
                }
                throw new SQLException("No current row");
            }
            int row = super.getRow();
            if (row < 1) {
                return row;
            }
            int d = 0;
            for (int i : this.deletedRows.values()) {
                if (i >= row) continue;
                ++d;
            }
            return row -= d;
        }
        return super.getRow();
    }

    @Override
    public final void refreshRow() throws SQLException {
        this.statement.connection.recycledServerCursorNumber = this.statement.serverCursorNumber;
        this.statement.sendDirectQueryRequest();
        this.currentRow = 0;
        this.closed = false;
        this.isAfterLast = false;
        this.cacheResultSetOref = null;
        this.lastRow = -1;
        this.lastFetchedRow = 0;
        this.statement.updatableRSTableName = null;
        this.init();
    }

    @Override
    public final synchronized void cancelRowUpdates() throws SQLException {
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row.");
        }
        this.values.clear();
    }

    @Override
    public final synchronized void moveToInsertRow() throws SQLException {
        this.onInsertRow = true;
        this.moveToCurrentRow = this.isAfterLast ? 0 : this.currentRow;
    }

    @Override
    public final synchronized void moveToCurrentRow() throws SQLException {
        if (this.onInsertRow) {
            this.currentRow = this.moveToCurrentRow;
        }
        this.onInsertRow = false;
    }

    @Override
    public final synchronized boolean next() throws SQLException {
        this.throwIfClosed();
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row.");
        }
        if (this.deletedRows != null && !this.deletedRows.isEmpty() && this.deletedRows.containsValue(this.currentRow + 1)) {
            return this.relative(1);
        }
        this.values.clear();
        if (!this.streamsFetchedAsLiterals.isEmpty()) {
            this.closeLiteralStreams();
        }
        if (this.statement.resultSetType == 1003) {
            if (this.statement.getMaxRows() != 0 && this.currentRow == this.statement.getMaxRows()) {
                return false;
            }
            if (this.rsRow == null) {
                this.rsRow = IRISConnection.Feature.isFastSelectOption(this.statement.statementFeatureOption) ? new ResultSetRow(this.statement.maxRowItemCount, this.statement.columns, this.statement.input.wire.getOffset()) : new ResultSetRow(this.statement.columns.size() + 1, this.statement.input.wire.getOffset());
            }
            while (!this.rsRow.indexRow(this.statement.input.wire.getBuffer(), this.statement.input.wire.getEndLength())) {
                if (this.statement.fetchDone) {
                    this.isAfterLast = true;
                    return false;
                }
                this.fetchMoreData(!this.rsRow.partialIndex);
            }
            ++this.currentRow;
            this.rowID = this.getRowID();
            if (this.deletedRows == null || !this.deletedRows.containsKey(this.rowID)) {
                if (this.deletedRows != null) {
                    this.deletedRows.clear();
                }
                return true;
            }
            throw new SQLException("Cannot get a value from a deleted row.");
        }
        boolean x = super.next();
        if (x) {
            this.rowID = this.getRowID();
            if (this.deletedRows == null || !this.deletedRows.containsKey(this.rowID)) {
                return true;
            }
            throw new SQLException("Cannot get a value from a deleted row.");
        }
        if (this.deletedRows != null && this.deletedRows.containsKey(this.rowID)) {
            this.lastRow = this.currentRow - 1;
            if (this.lastFetchedRow > this.lastRow) {
                this.lastFetchedRow = this.lastRow;
            }
        }
        return x;
    }

    @Override
    public final synchronized boolean isBeforeFirst() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable.");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row.");
        }
        return super.isBeforeFirst();
    }

    @Override
    public final synchronized boolean isAfterLast() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row.");
        }
        return super.isAfterLast();
    }

    @Override
    public final synchronized boolean isFirst() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable.");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row.");
        }
        return super.isFirst();
    }

    @Override
    public final synchronized boolean isLast() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable.");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row.");
        }
        return super.isLast();
    }

    @Override
    public final synchronized void beforeFirst() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable.");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row.");
        }
        this.values.clear();
        if (this.deletedRows != null && this.deletedRows.size() > 0) {
            this.refreshRow();
        }
        super.beforeFirst();
    }

    @Override
    public final synchronized void afterLast() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable.");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row.");
        }
        this.values.clear();
        super.afterLast();
    }

    @Override
    public final synchronized boolean first() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable.");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row.");
        }
        this.values.clear();
        if (this.deletedRows != null && !this.deletedRows.isEmpty()) {
            this.refreshRow();
        }
        return super.first();
    }

    @Override
    public final synchronized boolean last() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        if (this.deletedRows != null && !this.deletedRows.isEmpty()) {
            this.refreshRow();
        }
        return super.last();
    }

    @Override
    public final synchronized boolean absolute(int row) throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        if (this.deletedRows != null && !this.deletedRows.isEmpty()) {
            this.refreshRow();
        }
        return super.absolute(row);
    }

    @Override
    public final synchronized boolean relative(int rows) throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        int holdRow = this.isAfterLast ? (this.deletedRows != null && this.deletedRows.containsKey(this.rowID) ? this.currentRow : this.currentRow + 1) : this.currentRow;
        int upperBound = Math.max(this.currentRow + rows, this.currentRow);
        if (this.deletedRows != null && !this.deletedRows.isEmpty()) {
            for (int deletedRow : this.deletedRows.values()) {
                if (deletedRow >= upperBound) continue;
                --holdRow;
            }
            this.refreshRow();
        }
        this.currentRow = holdRow;
        int absPos = rows + holdRow;
        if (absPos > 0) {
            return super.absolute(absPos);
        }
        this.beforeFirst();
        return false;
    }

    @Override
    public final synchronized boolean previous() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        if (this.deletedRows != null && !this.deletedRows.isEmpty()) {
            int curRow = this.currentRow;
            for (int deleteRow : this.deletedRows.values()) {
                if (deleteRow >= this.currentRow) continue;
                --curRow;
            }
            if (curRow < this.currentRow) {
                boolean afterLast = this.isAfterLast;
                this.refreshRow();
                this.absolute(curRow);
                this.isAfterLast = afterLast;
            }
        }
        return super.previous();
    }

    @Override
    public final synchronized int getType() throws SQLException {
        return this.statement.resultSetType;
    }

    @Override
    public final boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public final boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public final boolean rowDeleted() throws SQLException {
        if (this.deletedRows != null) {
            return this.deletedRows.containsKey(this.rowID);
        }
        return false;
    }

    private synchronized void init() throws SQLException {
        int size = this.statement.columns.size();
        if (size <= 0) {
            throw new SQLException("Invalid result set");
        }
        if (this.statement.updatableRSTableName == null) {
            this.statement.updatableRSTableName = this.statement.getColumnTableName(1);
            String schemaName = this.statement.getColumnSchemaName(1);
            this.statement.updatableRSColumnNames = new String[size];
            this.statement.updatableRSColumnNames[0] = this.statement.getColumnName(1);
            this.statement.columns.remove(0);
            for (int i = 1; i < size; ++i) {
                if (!this.statement.updatableRSTableName.equals(this.statement.getColumnTableName(i))) {
                    throw new SQLException("Positioned updates are only supported whenthe query references a single table");
                }
                this.statement.updatableRSColumnNames[i] = this.statement.getColumnName(i);
            }
            this.statement.updatableRSTableName = schemaName + "." + this.statement.updatableRSTableName;
        }
        this.values = new HashMap<String, Object>();
        this.columns = this.statement.updatableRSColumnNames;
        this.deletedRows = null;
    }

    @Override
    synchronized boolean staticFetch(int offset, int size) throws SQLException {
        boolean sf = super.staticFetch(offset, size);
        if (sf) {
            this.rowID = this.getRowID();
        }
        return sf;
    }

    private void setObjectWrapper(PreparedStatement stmt, int i, ObjectWrapper o) throws SQLException {
        if (o.type == 0) {
            stmt.setAsciiStream(i, (InputStream)o.obj, o.lengthOrScale);
        } else if (o.type == 1) {
            stmt.setBinaryStream(i, (InputStream)o.obj, o.lengthOrScale);
        } else if (o.type == 2) {
            stmt.setCharacterStream(i, (Reader)o.obj, o.lengthOrScale);
        } else {
            int type = this.statement.getColumnType(i);
            if (type == 3 || type == 2) {
                stmt.setObject(i, o.obj, type, o.lengthOrScale);
            } else {
                stmt.setObject(i, o.obj);
            }
        }
    }

    private void check(int i) throws SQLException {
        this.throwIfClosed();
        if (i <= 0 || i >= this.columns.length) {
            throw new SQLException("Invalid column number.", "S1002", 463);
        }
    }

    private void check(String name) throws SQLException {
        this.throwIfClosed();
        for (int i = 1; i <= this.columns.length + 1; ++i) {
            if (!this.columns[i].equalsIgnoreCase(name)) continue;
            return;
        }
        throw new SQLException("Invalid column name: " + name + ".", "S1002", 463);
    }

    private void insertRowCheck() throws SQLException {
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called.");
        }
    }

    @Override
    public final void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            length = IRISUpdatableResultSet.getInputStreamLength(x, length);
        }
        this.updateAsciiStream(columnIndex, x, (int)length);
    }

    @Override
    public final void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            length = IRISUpdatableResultSet.getInputStreamLength(x, length);
        }
        this.updateBinaryStream(columnIndex, x, (int)length);
    }

    @Override
    public final void updateCharacterStream(int columnIndex, Reader reader, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("Stream too long: " + length);
        }
        this.updateCharacterStream(columnIndex, reader, (int)length);
    }

    @Override
    public final void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            length = IRISUpdatableResultSet.getInputStreamLength(x, length);
        }
        this.updateAsciiStream(columnLabel, x, (int)length);
    }

    @Override
    public final void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            length = IRISUpdatableResultSet.getInputStreamLength(x, length);
        }
        this.updateBinaryStream(columnLabel, x, (int)length);
    }

    @Override
    public final void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("Stream too long: " + length);
        }
        this.updateCharacterStream(columnLabel, reader, (int)length);
    }

    @Override
    public final void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.updateBinaryStream(columnIndex, inputStream, length);
    }

    @Override
    public final void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.updateBinaryStream(columnLabel, inputStream, length);
    }

    @Override
    public final void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, reader, length);
    }

    @Override
    public final void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public final void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.updateAsciiStream(columnIndex, x, -1);
    }

    @Override
    public final void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.updateBinaryStream(columnIndex, x, -1);
    }

    @Override
    public final void updateCharacterStream(int columnIndex, Reader reader) throws SQLException {
        this.updateCharacterStream(columnIndex, reader, -1);
    }

    @Override
    public final void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.updateAsciiStream(columnLabel, x, -1);
    }

    @Override
    public final void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.updateBinaryStream(columnLabel, x, -1);
    }

    @Override
    public final void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(columnLabel, reader, -1);
    }

    @Override
    public final void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(columnIndex, inputStream);
    }

    @Override
    public final void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(columnLabel, inputStream);
    }

    @Override
    public final void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.updateCharacterStream(columnIndex, reader);
    }

    @Override
    public final void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(columnLabel, reader);
    }

    private static int getInputStreamLength(InputStream x, long length) throws SQLException {
        int available = 0;
        try {
            available = x.available();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (available == 0 || available > Integer.MAX_VALUE) {
            throw new SQLException("Stream too long: " + length);
        }
        return available;
    }

    @Override
    public final void updateNCharacterStream(int columnIndex, Reader reader, long length) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.updateCharacterStream(columnIndex, reader, length);
    }

    @Override
    public final void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public final void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.updateCharacterStream(columnIndex, x);
    }

    @Override
    public final void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public final void updateNString(int columnIndex, String nString) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.updateString(columnIndex, nString);
    }

    @Override
    public final void updateNString(String columnLabel, String nString) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.updateString(columnLabel, nString);
    }

    @Override
    public final void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.updateClob(columnIndex, reader, length);
    }

    @Override
    public final void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.updateClob(columnLabel, reader, length);
    }

    @Override
    public final void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.updateClob(columnIndex, reader);
    }

    @Override
    public final void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.updateClob(columnLabel, reader);
    }

    @Override
    public final void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.updateClob(columnIndex, (Clob)nClob);
    }

    @Override
    public final void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.throwIfNotUnicodeServer();
        this.updateClob(columnLabel, (Clob)nClob);
    }

    private static class ObjectWrapper {
        static final int ASCII_STREAM = 0;
        static final int BINARY_STREAM = 1;
        static final int CHARACTER_STREAM = 2;
        static final int OBJECT_WITH_SCALE = 3;
        int type;
        Object obj;
        int lengthOrScale;

        ObjectWrapper(int t, Object o, int ls) {
            this.obj = o;
            this.type = t;
            this.lengthOrScale = ls;
        }
    }
}

