/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.BufferRO;
import com.intersystems.jdbc.BufferUtils;
import com.intersystems.jdbc.ConnectionInformation;
import com.intersystems.jdbc.DBList;
import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.IRISResultSet;
import com.intersystems.jdbc.IRISStatement;
import com.intersystems.jdbc.ListItem;
import com.intersystems.jdbc.ListReader;
import com.intersystems.jdbc.LogFileStream;
import com.intersystems.jdbc.MessageHeader;
import com.intersystems.jdbc.Stream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

public class InStream {
    static final int SEND_DATA = 0;
    static final int BYTE_STREAM = 1;
    static final int FETCH_DATA = 2;
    static final int OOB_FETCH = 3;
    static final int GATEWAY = 4;
    static final int IRISNATIVE = 5;
    public IRISConnection connection;
    private LogFileStream logFile;
    public BufferRO wire;
    String locale;
    public InputStream inputStream;
    LinkedBlockingQueue<BufferRO> messages = new LinkedBlockingQueue(1);
    static final int sysioErrorBase = 51712;

    public InStream(IRISConnection conn) {
        this.inputStream = conn.device.getInputStream();
        this.connection = conn;
        this.logFile = this.connection.getLogFile();
        this.setLocale(conn.connectionInfo);
    }

    public InStream(InputStream i, LogFileStream l) {
        this.inputStream = i;
        this.connection = null;
        this.logFile = l;
        this.locale = null;
    }

    InStream(IRISConnection conn, BufferRO inWire) {
        this.inputStream = conn.device.getInputStream();
        this.connection = conn;
        this.logFile = this.connection.getLogFile();
        this.setLocale(conn.connectionInfo);
        this.wire = inWire;
    }

    public void setDevInStream(InputStream inStream) {
        this.inputStream = inStream;
    }

    public void setLocale(ConnectionInformation connInfo) {
        this.locale = !connInfo.isUnicodeServer && !connInfo.serverLocale.toUpperCase().matches("ISO8859_1") ? connInfo.serverLocale : null;
    }

    public void setLocale(String inLocale, boolean isUnicodeServer) {
        this.locale = !isUnicodeServer && !inLocale.toUpperCase().matches("ISO8859_1") ? inLocale : null;
    }

    private int read(byte[] buffer, int offset, int count) throws SQLException, IOException {
        int len = this.inputStream.read(buffer, offset, count);
        if (len < 1) {
            this.inputStream.close();
            if (this.connection != null) {
                this.connection.close();
            }
            if (len == 0) {
                throw new SQLException("Server unexpectedly closing communication device", "08S01", 461);
            }
            throw new SQLException("Communication error:  Server closed communication device", "08S01", 461);
        }
        return len;
    }

    private int readBuffer(byte[] buffer, int offset, int count) throws SQLException, IOException {
        int cb;
        for (cb = 0; cb < count; cb += this.read(buffer, offset + cb, count - cb)) {
        }
        return cb;
    }

    private int readBuffer(BufferRO list) throws SQLException, IOException {
        int cb;
        int count = list.Header.getMessageLength();
        int offset = list.getEndLength();
        for (cb = 0; cb < count; cb += this.read(list.getBuffer(), offset + cb, count - cb)) {
        }
        list.addToEndLength(cb);
        if (this.logFile != null) {
            this.logFile.dump(list.getBuffer(), offset, cb, 0, list.Header.hBuffer, this.connection == null ? "-1" : this.connection.connectionInfo.srvJobNumber, this.connection == null ? -1 : this.connection.device.hashCode());
        }
        return cb;
    }

    private boolean checkHeader(MessageHeader header, int msgCount, int stmt_id, int type) throws SQLException, IOException {
        this.readBuffer(header.hBuffer, 0, 14);
        if (header.getCount() == msgCount && stmt_id == header.getStatementID()) {
            return false;
        }
        if (this.isHeaderInitiatedFromIRIS(header, type)) {
            return true;
        }
        if (type == 5 && header.getCount() == msgCount) {
            return false;
        }
        if (header.getMessageLength() > 0 && header.getCount() == 0 && header.getStatementID() == 0 && header.getError() == 0) {
            return false;
        }
        if (header.getCount() != msgCount) {
            String errorMsg = "Invalid Message Count (452); expected: " + msgCount + " got: " + header.getCount() + ". Server returned: " + header.getError() + ". Closing Connection";
            if (this.logFile != null) {
                this.logFile.logApiTime("ERROR: " + errorMsg, this.connection == null ? "-1" : this.connection.connectionInfo.srvJobNumber, this.connection == null ? -1 : this.connection.device.hashCode());
            }
            this.closeOnBadHeader(header);
            throw new SQLException(errorMsg, "08S01", 452);
        }
        if (stmt_id != 0 && stmt_id != header.getStatementID()) {
            String errorMsg = "Invalid Statement Number (452); expected: " + stmt_id + " got: " + header.getStatementID() + ". Server returned: " + header.getError();
            if (this.logFile != null) {
                this.logFile.logApiTime("ERROR: " + errorMsg, this.connection == null ? "-1" : this.connection.connectionInfo.srvJobNumber, this.connection == null ? -1 : this.connection.device.hashCode());
            }
            this.closeOnBadHeader(header);
            throw new SQLException(errorMsg + ". Connection closed", "08S01", 452);
        }
        this.closeOnBadHeader(header);
        throw new SQLException("Invalid message received");
    }

    int readMessage(IRISStatement stmt, int type, int allowError) throws SQLException {
        int stmt_id = stmt.serverCursorNumber;
        if (this.connection.activeFetchStatement != null && (this.connection.activeFetchStatement != stmt || this.connection.activeFetchStatement == stmt && type < 2) && this.connection.activeFetchStatement.weakResultSetReference != null && this.connection.activeFetchStatement.outstandingReads > 0) {
            ((IRISResultSet)this.connection.activeFetchStatement.weakResultSetReference.get()).readOOBFetch();
        }
        if (type == 2 && stmt != null && stmt.resultSetType == 1004) {
            type = 0;
        }
        int ret = this.readMessage(stmt, this.connection.messageCount.count, stmt_id, type, allowError, type == 2);
        this.connection.activeFetchStatement = type == 2 && ret == 0 ? stmt : null;
        return ret;
    }

    int readMessage(int stmt_id, int type, int allowError) throws SQLException {
        this.connection.checkOutStandingFetches();
        return this.readMessage(null, this.connection.messageCount.count, stmt_id, type, allowError, false);
    }

    int readMessage(Object stream, int messageCount, int stmt_id, int type, int allowError) throws SQLException {
        this.connection.checkOutStandingFetches();
        return this.readMessage(stream, messageCount, stmt_id, type, allowError, false);
    }

    private int readMessage(Object inObj, int messageCount, int stmt_id, int type, int allowError, boolean requestData) throws SQLException {
        while (this.readMessageInternal(inObj, messageCount, stmt_id, type, allowError, requestData)) {
            this.connection.getGateway().dispatchReentrancy(this, this.wire.Header.getError());
            this.connection.checkOutStandingFetches();
        }
        if (type == 1) {
            return 0;
        }
        return this.wire.Header.getError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readMessageInternal(Object inObj, int messageCount, int stmt_id, int type, int allowError, boolean requestData) throws SQLException {
        int highBit = 1;
        boolean isForGateway = false;
        MessageHeader header = new MessageHeader();
        try {
            if (type == 1) {
                Stream cstream = (Stream)inObj;
                int MessageLength = 0;
                cstream.RawBytesPtr = 0;
                while (highBit != 0) {
                    isForGateway = this.checkHeader(header, messageCount, stmt_id, type);
                    if (isForGateway) {
                        throw new SQLException("Cannot handle reentrancy in the middle of a stream");
                    }
                    MessageLength = header.getMessageLength();
                    highBit = header.getHighBit();
                    if (MessageLength == 0) {
                        if (this.logFile == null || highBit != 0) break;
                        this.logFile.dump(null, 0, 0, 0, header.hBuffer, this.connection.connectionInfo.srvJobNumber, this.connection.device.hashCode());
                        break;
                    }
                    MessageLength = this.readStream(header, cstream);
                }
                if (header.getError() == 403) {
                    throw new SQLException("Null stream 403 error! ", "S1000", header.getError());
                }
            } else {
                BufferRO list = null;
                IRISStatement stmt = (IRISStatement)inObj;
                if (stmt != null && stmt.outstandingReads > 0) {
                    messageCount = stmt.nextServerNumber;
                    --stmt.outstandingReads;
                }
                while (highBit != 0) {
                    isForGateway = this.checkHeader(header, messageCount, stmt_id, type);
                    if (!isForGateway) {
                        if (stmt != null && stmt.canceled && header.getError() == 0) {
                            header.setError(100);
                        }
                        if (requestData && header.getError() == 0 && stmt != null && stmt.weakResultSetReference != null) {
                            ((IRISResultSet)stmt.weakResultSetReference.get()).requestFetch(stmt.connection.messageCount.getCount());
                            requestData = false;
                        }
                    }
                    highBit = header.getHighBit();
                    if (list == null) {
                        list = new BufferRO(this.wire, header, this.locale, type == 2);
                    } else {
                        list.growBuffer(header);
                    }
                    this.readBuffer(list);
                }
                if (type == 3 && !isForGateway) {
                    this.messages.add(list);
                } else {
                    InStream inStream = this;
                    synchronized (inStream) {
                        this.wire = list;
                    }
                }
            }
            if (isForGateway) {
                return true;
            }
            int error = this.wire.Header.getError();
            if (error != 0 && error < 51712) {
                try {
                    if (this.connection == null) {
                        return isForGateway;
                    }
                    error = this.connection.processError(error, allowError);
                }
                catch (Exception e) {
                    if (!this.messages.isEmpty()) {
                        this.messages.remove();
                    }
                    throw e;
                }
            }
            return false;
        }
        catch (SocketTimeoutException e) {
            throw new SQLException(e.getClass().getSimpleName() + ": " + e.getMessage(), "08S01", 461);
        }
        catch (IOException e) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new SQLException("Communication error: " + e.getClass().getSimpleName() + ": " + e.getMessage(), "08S01", 461);
        }
    }

    private int readStream(MessageHeader header, Stream cstream) throws SQLException, IOException {
        int RawBytesPtr = cstream.RawBytesPtr;
        int MessageLength = header.getMessageLength();
        if (RawBytesPtr + MessageLength > cstream.RawBytes.length) {
            byte[] b = new byte[RawBytesPtr + MessageLength];
            if (RawBytesPtr > 0) {
                BufferUtils.copyByteArray(cstream.RawBytes, 0, b, 0, RawBytesPtr);
            }
            cstream.RawBytes = b;
        }
        int cb = this.readBuffer(cstream.RawBytes, RawBytesPtr, MessageLength);
        RawBytesPtr += cb;
        if (this.logFile != null) {
            this.logFile.dump(cstream.RawBytes, RawBytesPtr - MessageLength, MessageLength, 0, header.hBuffer, this.connection.connectionInfo.srvJobNumber, this.connection.device.hashCode());
        }
        cstream.RawBytesPtr = RawBytesPtr;
        return cb;
    }

    private void closeOnBadHeader(MessageHeader header) {
        if (this.logFile != null && !this.connection.isUsingSharedMemory()) {
            this.logAndConsumeBadMessage(header);
        }
        try {
            this.connection.close();
        }
        catch (Exception ex) {
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void logAndConsumeBadMessage(MessageHeader header) {
        if (header.getMessageLength() == 0) {
            this.logFile.dump(header, 0, this.connection == null ? "-1" : this.connection.connectionInfo.srvJobNumber, this.connection == null ? -1 : this.connection.device.hashCode());
            return;
        }
        try {
            this.connection.device.setSoTimeout(1000);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        BufferRO list = new BufferRO(this.wire, header, this.locale, true);
        while (header.getMessageLength() > 0) {
            try {
                this.readBuffer(list);
                if (this.connection.isUsingSharedMemory()) {
                    header = new MessageHeader();
                    continue;
                }
                this.readBuffer(header.hBuffer, 0, 14);
                list.clearList();
                list.growBuffer(header);
            }
            catch (Exception e) {
                header = new MessageHeader();
            }
        }
    }

    public int readMessage() throws SQLException {
        this.connection.checkOutStandingFetches();
        if (!this.readMessageInternal(null, -1, -1, 4, -1, false)) {
            throw new SQLException("Invalid message received");
        }
        return ((0xFF00 & this.wire.Header.getError()) >> 8) - 48;
    }

    public int readMessage(int sequenceNumber) throws SQLException {
        this.connection.checkOutStandingFetches();
        if (this.readMessageInternal(null, sequenceNumber, 0, 4, -1, false)) {
            throw new SQLException("Invalid message received");
        }
        return ((0xFF00 & this.wire.Header.getError()) >> 8) - 48;
    }

    public boolean checkSHeader(byte[] hash, Socket sock) throws SQLException, IOException, NoSuchAlgorithmException {
        MessageHeader sheader = new MessageHeader();
        try {
            int timeout = sock.getSoTimeout();
            sock.setSoTimeout(5000);
            this.readBuffer(sheader.hBuffer, 0, 14);
            sock.setSoTimeout(timeout);
        }
        catch (Exception e) {
            if (this.logFile != null) {
                this.logFile.logApi(e.getMessage());
            }
            return false;
        }
        if (this.logFile != null) {
            this.logFile.dump(sheader, 0, true);
        }
        if (sheader.getMessageLength() != 0 || sheader.getError() != 0) {
            return false;
        }
        byte[] headerBytes = BufferUtils.copyByteArray(sheader.hBuffer, 4, 8);
        byte[] inHash = MessageDigest.getInstance("SHA-256").digest(headerBytes);
        if (hash.length != inHash.length) {
            return false;
        }
        for (int i = 0; i < hash.length; ++i) {
            if (hash[i] == inHash[i]) continue;
            return false;
        }
        return true;
    }

    public final int readHeaderXEP(boolean read_data) throws SQLException, Exception {
        this.wire.clearList();
        this.readBuffer(this.wire.Header.hBuffer, 0, 14);
        int MessageLength = this.wire.Header.getMessageLength();
        int error = this.wire.Header.getError();
        if (error != 1 && error != 0) {
            if (MessageLength > 0) {
                this.wire.setBuffer(this.wire.Header);
                this.readBuffer(this.wire);
                throw new Exception(this.wire.getString());
            }
            if (this.logFile != null) {
                this.logFile.dump(this.wire.Header, 0);
            }
            throw new Exception("XEPError occured: " + error);
        }
        if (read_data) {
            if (MessageLength > 0) {
                this.wire.setBuffer(this.wire.Header);
                this.readBuffer(this.wire);
            } else if (this.logFile != null) {
                this.logFile.dump(this.wire.Header, 0);
            }
        } else if (this.logFile != null) {
            this.logFile.dump(this.wire.Header, 0);
        }
        return error;
    }

    byte[] readBytesXEP() throws SQLException, Exception {
        this.readHeaderXEP(false);
        return this.readBytesXEP(this.wire.Header.getMessageLength());
    }

    private byte[] readBytesXEP(int len) throws SQLException, IOException {
        byte[] ba = new byte[len];
        this.readBuffer(ba, 0, len);
        if (this.logFile != null) {
            this.logFile.dump(ba, 0, len, 0, this.wire.Header.hBuffer, this.connection.connectionInfo.srvJobNumber, this.connection.device.hashCode());
        }
        return ba;
    }

    List<byte[]> readListofByteArraysXEP2() throws Exception {
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        while (true) {
            this.readHeaderXEP(true);
            if (this.wire.Header.getMessageLength() == 0) break;
            byteArrays.add(this.wire.getBuffer());
        }
        return byteArrays;
    }

    public void readHeaderSYSIO(long msgid) throws SQLException {
        ArrayList<Integer> noAllowedErrors = new ArrayList<Integer>();
        this.readHeaderSYSIO(msgid, noAllowedErrors);
    }

    public int readHeaderSYSIO(long msgid, List<Integer> allowedErrors) throws SQLException {
        while (true) {
            this.connection.checkOutStandingFetches();
            if (!this.readMessageInternal(null, (int)msgid, 0, 5, -1, false)) break;
            this.connection.getGateway().dispatchReentrancy(this, this.wire.Header.getError());
        }
        int sysioReturnCode = this.wire.Header.getError() - 51712;
        if (sysioReturnCode != 0) {
            String errorMsg = "No error from SYSIO";
            if (this.wire.Header.getMessageLength() > 0) {
                ListItem it = this.readBodySingleNodeSYSIO();
                errorMsg = DBList.getString(it, this.locale);
            }
            if (!allowedErrors.contains(sysioReturnCode)) {
                throw new SQLException("Exception thrown on server (code = " + sysioReturnCode + ") : " + errorMsg);
            }
        }
        return sysioReturnCode;
    }

    public ListItem readBodySingleNodeSYSIO() {
        ListItem it = this.wire.m_item.clone();
        DBList.getListElement(it.nextOffset, it);
        this.wire.setOffset(it.nextOffset);
        return it;
    }

    public int readBodyManyNodesSYSIO(List<ListReader> listReaders) throws IOException {
        int[] dataLengthAndOffset = new int[]{0, 0};
        int dataLength = 0;
        int dataOffset = 0;
        byte[] readVal = null;
        int readOffset = 0;
        int copyOffset = 0;
        int copyLength = 0;
        boolean foundEndingSequence = false;
        int lengthRead = 0;
        while (!foundEndingSequence) {
            if (copyOffset == 0 && readVal != null && copyLength < readVal.length) {
                readOffset = copyLength;
            } else {
                dataOffset = dataLengthAndOffset[1];
                dataLength = dataLengthAndOffset[0];
                byte[] nextReadVal = new byte[dataOffset + dataLength > copyLength ? dataOffset + dataLength + 2 : copyLength + 65536];
                if (copyLength > 0) {
                    System.arraycopy(readVal, copyOffset, nextReadVal, 0, copyLength);
                    readOffset = copyLength;
                } else {
                    readOffset = 0;
                }
                readVal = nextReadVal;
            }
            int bytesRead = this.inputStream.read(readVal, readOffset, readVal.length - readOffset);
            if (this.logFile != null) {
                this.logFile.dump(readVal, readOffset, bytesRead, 0, null, this.connection.connectionInfo.srvJobNumber, this.connection.device.hashCode());
            }
            lengthRead += bytesRead;
            copyOffset = this.indexBytesToCacheList(readVal, readOffset + bytesRead, listReaders, dataLengthAndOffset);
            copyLength = readOffset + bytesRead - copyOffset;
            foundEndingSequence = copyOffset == -1;
        }
        return lengthRead - 2;
    }

    private int indexBytesToCacheList(byte[] readArr, int numBytes, List<ListReader> listReaders, int[] dataLengthAndOffset) {
        int readOffset;
        int dataLength = 0;
        int dataOffset = 0;
        for (readOffset = 0; readOffset < numBytes; readOffset += dataOffset + dataLength) {
            if (numBytes - readOffset < 7 && !InStream.isEndingSequenceSYSIO(readArr, numBytes)) {
                return readOffset;
            }
            DBList.getDataLengthAndOffset(readArr, readOffset, dataLengthAndOffset);
            dataLength = dataLengthAndOffset[0];
            dataOffset = dataLengthAndOffset[1];
            if (dataLength == 0 && InStream.isEndingSequenceSYSIO(readArr, readOffset + 2)) {
                return -1;
            }
            if (readOffset + dataOffset + dataLength > numBytes) {
                return readOffset;
            }
            ListItem li = new ListItem(readArr, readOffset + dataOffset + dataLength);
            li.nextOffset = readOffset;
            ListReader listReader = new ListReader(li, this.locale);
            listReaders.add(listReader);
        }
        return readOffset;
    }

    private static boolean isEndingSequenceSYSIO(byte[] buffer, int endOffset) {
        return buffer[endOffset - 2] == 2 && buffer[endOffset - 1] == -1;
    }

    public void setConnection(IRISConnection conn) {
        this.connection = conn;
    }

    public boolean isHeaderInitiatedFromIRIS(MessageHeader header, int type) {
        int data_length = header.getMessageLength();
        int message_id = header.getCount();
        int statement_id = header.getStatementID();
        if ((type == 4 || message_id > 0) && message_id % 2 == 0) {
            return true;
        }
        int function_code = header.getError();
        if (type == 4 && data_length == 0 && function_code == 0) {
            return true;
        }
        return data_length == 0 && message_id == 0 && statement_id == 0 && (function_code == 20825 || function_code == 13401);
    }
}

