/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.IRISWrapper;
import com.intersystems.jdbc.ParameterCollection;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class InternalParameterMetaData
extends IRISWrapper
implements ParameterMetaData {
    ParameterCollection parameters;

    InternalParameterMetaData(ParameterCollection p) {
        this.parameters = p;
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameters.size();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return this.parameters.get((int)(param - 1)).nullable;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        switch (this.parameters.get((int)(param - 1)).type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean isVectorFormat(int param) throws SQLException {
        return this.parameters.get(param - 1).isVector();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        return this.parameters.get((int)(param - 1)).precision;
    }

    @Override
    public int getScale(int param) throws SQLException {
        int scale = this.parameters.get((int)(param - 1)).scale;
        return scale == -1 ? 0 : scale;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        int parType = this.parameters.get((int)(param - 1)).type;
        if (parType > 1000) {
            parType -= 1000;
        }
        return parType;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        int parType = this.parameters.get((int)(param - 1)).type;
        if (parType > 1000) {
            parType -= 1000;
        }
        switch (parType) {
            case -5: {
                return "BIGINT";
            }
            case -7: {
                return "BIT";
            }
            case -2: {
                return "BINARY";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 2: {
                return "NUMERIC";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
            case 2002: {
                return "STRUCT";
            }
            case -51: {
                return "RESULTSET";
            }
        }
        return "UNKNOWN TYPE";
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        int parType = this.parameters.get((int)(param - 1)).type;
        if (parType > 1000) {
            parType -= 1000;
        }
        switch (parType) {
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case -7: {
                return "java.lang.Boolean";
            }
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 6: 
            case 8: {
                return "java.lang.Double";
            }
            case -4: 
            case -3: 
            case -2: {
                return "byte[]";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case -51: {
                return "java.sql.ResultSet";
            }
        }
        return "java.lang.String";
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        return this.parameters.get((int)(param - 1)).mode.ordinal();
    }
}

