/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.BufferRO;
import com.intersystems.jdbc.BufferUtils;
import com.intersystems.jdbc.DBList;
import com.intersystems.jdbc.ListItem;
import com.intersystems.jdbc.ListWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;

public class ListReader {
    protected int BUCKET_SIZE = 1024;
    protected String m_locale;
    protected ListItem m_item;

    public static ListReader createListReader() {
        return new ListReader();
    }

    public ListReader() {
        this.m_locale = null;
    }

    public ListReader(String sLocale) {
        this.m_locale = sLocale;
    }

    public ListReader(int iLength, String sLocale) {
        this.m_item = new ListItem(new byte[iLength]);
        this.m_item.listBufferEnd = 0;
        this.m_locale = sLocale;
    }

    public ListReader(byte[] buffer, int length, String sLocale) {
        this.m_item = new ListItem(buffer, length);
        this.m_locale = sLocale;
    }

    public ListReader(ListWriter wBuffer) {
        this.m_item = new ListItem(wBuffer.getBuffer(), wBuffer.getLength());
        this.m_locale = wBuffer.getLocale();
    }

    public void setList(byte[] buffer) {
        this.m_item = new ListItem(buffer, buffer.length);
    }

    public ListReader(ListItem li, String sLocale) {
        this.m_item = li;
        this.m_locale = sLocale;
    }

    int getOffset() {
        return this.m_item.nextOffset;
    }

    public void next() throws BufferRO.NoMoreDataException {
        try {
            DBList.getListElement(this.m_item.nextOffset, this.m_item);
        }
        catch (Exception ex) {
            throw new BufferRO.NoMoreDataException();
        }
    }

    public int getOffsetThenNext() throws BufferRO.NoMoreDataException {
        int off = this.m_item.nextOffset;
        this.next();
        return off;
    }

    int getOffsetSkipOne() throws BufferRO.NoMoreDataException {
        this.next();
        return this.m_item.nextOffset;
    }

    void setOffset(int value) {
        this.m_item.nextOffset = value;
    }

    int getEndLength() {
        return this.m_item.listBufferEnd;
    }

    int addToEndLength(int value) {
        return this.m_item.listBufferEnd += value;
    }

    public boolean isEnd() {
        return this.m_item.nextOffset >= this.m_item.listBufferEnd;
    }

    void isEndEx() throws BufferRO.NoMoreDataException {
        if (this.isEnd()) {
            throw new BufferRO.NoMoreDataException();
        }
    }

    public boolean isNull() {
        return this.m_item.isNull;
    }

    void setNull() {
        this.m_item.isNull = true;
    }

    public boolean jump(int offset) {
        if (offset == -1) {
            this.m_item.nextOffset = -1;
            this.m_item.isNull = true;
            return false;
        }
        this.m_item.nextOffset = offset;
        return this.m_item.nextOffset >= this.m_item.listBufferEnd;
    }

    boolean isPastLastItem() {
        return this.m_item.dataOffset >= this.m_item.listBufferEnd;
    }

    public void clearList() {
        this.m_item.listBufferEnd = 0;
        this.m_item.nextOffset = 0;
    }

    public void moveToEnd() {
        this.m_item.nextOffset = this.m_item.listBufferEnd;
    }

    public byte[] getBuffer() {
        return this.m_item.buffer;
    }

    public ListReader getInnerList() throws SQLException {
        byte[] ba = this.getByteArray();
        if (this.isNull()) {
            return null;
        }
        return new ListReader(new ListItem(ba), this.m_locale);
    }

    boolean getBoolean(int offset) throws SQLException {
        DBList.getListElement(offset, this.m_item);
        return DBList.getBoolean(this.m_item);
    }

    public boolean getBoolean() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getBoolean(this.m_item);
    }

    public Boolean getNullableBoolean() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        if (this.m_item.isNull) {
            return null;
        }
        return DBList.getBoolean(this.m_item);
    }

    double getDouble(int offset) throws SQLException {
        DBList.getListElement(offset, this.m_item);
        return DBList.getDouble(this.m_item);
    }

    public double getDouble() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getDouble(this.m_item);
    }

    public Double getNullableDouble() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        if (this.m_item.isNull) {
            return null;
        }
        return DBList.getDouble(this.m_item);
    }

    Double getDoubleObject() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        if (this.m_item.isNull) {
            return null;
        }
        return DBList.getDouble(this.m_item);
    }

    float getFloat(int offset) throws SQLException {
        DBList.getListElement(offset, this.m_item);
        return DBList.getFloat(this.m_item);
    }

    public float getFloat() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getFloat(this.m_item);
    }

    public Float getNullableFloat() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        if (this.m_item.isNull) {
            return null;
        }
        return Float.valueOf(DBList.getFloat(this.m_item));
    }

    int getInt(int offset) throws SQLException {
        DBList.getListElement(offset, this.m_item);
        return DBList.getInt(this.m_item);
    }

    public int getInt() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getInt(this.m_item);
    }

    public Integer getNullableInt() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        if (this.m_item.isNull) {
            return null;
        }
        return DBList.getInt(this.m_item);
    }

    long getLong(int offset) throws SQLException {
        DBList.getListElement(offset, this.m_item);
        return DBList.getLong(this.m_item);
    }

    public long getLong() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getLong(this.m_item);
    }

    public Long getNullableLong() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        if (this.m_item.isNull) {
            return null;
        }
        return DBList.getLong(this.m_item);
    }

    Long getLongObject() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        if (this.m_item.isNull) {
            return null;
        }
        return DBList.getLong(this.m_item);
    }

    short getShort(int offset) throws SQLException {
        DBList.getListElement(offset, this.m_item);
        return DBList.getShort(this.m_item);
    }

    public Short getNullableShort() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        if (this.m_item.isNull) {
            return null;
        }
        return DBList.getShort(this.m_item);
    }

    public short getShort() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getShort(this.m_item);
    }

    String getString(int offset) throws SQLException {
        DBList.getListElement(offset, this.m_item);
        return DBList.getString(this.m_item, this.m_locale);
    }

    public String getString() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getString(this.m_item, this.m_locale);
    }

    public String getStringWithAsciiZero() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        if (this.m_item.type == 1 && this.m_item.dataLength == 1 && this.m_item.buffer[this.m_item.dataOffset] == 0) {
            return "\u0000";
        }
        return DBList.getString(this.m_item, this.m_locale);
    }

    String getStringLen(int length) throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getString(this.m_item, this.m_locale, length);
    }

    Time getTime(int offset) throws SQLException {
        DBList.getListElement(offset, this.m_item);
        return DBList.getTime(this.m_item, null);
    }

    public Time getTime() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getTime(this.m_item, null);
    }

    public LocalTime getLocalTime(int offset) throws SQLException {
        Time t = this.getTime(offset);
        return t != null ? t.toLocalTime() : null;
    }

    public LocalTime getLocalTime() throws SQLException {
        Time t = this.getTime();
        return t != null ? t.toLocalTime() : null;
    }

    public String getTimeAsString(int scale) throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        if (this.m_item.isNull) {
            return null;
        }
        String TmString = DBList.getTime(this.m_item, null).toString();
        if (scale == 0) {
            return TmString;
        }
        String subSecTime = DBList.getString(this.m_item, null);
        int iDot = subSecTime.indexOf(46);
        if (iDot < 0) {
            return TmString;
        }
        subSecTime = subSecTime.substring(iDot);
        if (scale < 0) {
            return TmString + subSecTime;
        }
        int sLen = subSecTime.length() - 1;
        if (scale < sLen) {
            sLen = scale;
        }
        return TmString + subSecTime.substring(0, sLen + 1);
    }

    Date getDate(int offset) throws SQLException {
        DBList.getListElement(offset, this.m_item);
        return DBList.getDate(this.m_item, null);
    }

    public Date getDate() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getDate(this.m_item, null);
    }

    public LocalDate getLocalDate(int offset) throws SQLException {
        Date d = this.getDate(offset);
        return d != null ? d.toLocalDate() : null;
    }

    public LocalDate getLocalDate() throws SQLException {
        Date d = this.getDate();
        return d != null ? d.toLocalDate() : null;
    }

    Timestamp getTimestamp(int offset) throws SQLException {
        DBList.getListElement(offset, this.m_item);
        return DBList.getTimestamp(this.m_item, null);
    }

    public Timestamp getTimestamp() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getTimestamp(this.m_item, null);
    }

    public LocalDateTime getLocalDateTime(int offset) throws SQLException {
        Timestamp ts = this.getTimestamp(offset);
        return ts != null ? ts.toLocalDateTime() : null;
    }

    public LocalDateTime getLocalDateTime() throws SQLException {
        Timestamp ts = this.getTimestamp();
        return ts != null ? ts.toLocalDateTime() : null;
    }

    Date getDate(int offset, Calendar cal) throws SQLException {
        DBList.getListElement(offset, this.m_item);
        return DBList.getDate(this.m_item, cal);
    }

    Time getTime(int offset, Calendar cal) throws SQLException {
        DBList.getListElement(offset, this.m_item);
        return DBList.getTime(this.m_item, cal);
    }

    Timestamp getTimestamp(int offset, Calendar cal) throws SQLException {
        DBList.getListElement(offset, this.m_item);
        return DBList.getTimestamp(this.m_item, cal);
    }

    Date getDate(Calendar cal) throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getDate(this.m_item, cal);
    }

    Time getTime(Calendar cal) throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getTime(this.m_item, cal);
    }

    Timestamp getTimestamp(Calendar cal) throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getTimestamp(this.m_item, cal);
    }

    public byte[] getBytes(int length) throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getBytes(this.m_item, length);
    }

    public byte[] getRawBytes(int length) throws SQLException {
        this.m_item.dataOffset = this.m_item.nextOffset;
        this.m_item.nextOffset += length;
        return BufferUtils.copyByteArray(this.m_item.buffer, this.m_item.dataOffset, length);
    }

    byte[] getByteArray(int offset) throws SQLException {
        DBList.getListElement(offset, this.m_item);
        return DBList.getBytes(this.m_item, 0);
    }

    public byte[] getByteArray() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getBytes(this.m_item, 0);
    }

    byte getOneByte(int offset) throws SQLException {
        DBList.getListElement(offset, this.m_item);
        return DBList.getOneByte(this.m_item);
    }

    public byte getOneByte() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getOneByte(this.m_item);
    }

    public BigInteger getBigInteger() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getBigInteger(this.m_item);
    }

    public BigInteger getBigInteger(int offset) throws SQLException {
        DBList.getListElement(offset, this.m_item);
        return DBList.getBigInteger(this.m_item);
    }

    BigDecimal getBigDecimal(int offset, int scale) throws SQLException {
        DBList.getListElement(offset, this.m_item);
        return DBList.getBigDecimal(this.m_item, scale);
    }

    BigDecimal getBigDecimal(int offset) throws SQLException {
        DBList.getListElement(offset, this.m_item);
        return DBList.getBigDecimal(this.m_item);
    }

    BigDecimal getBigDecimal(int scale, boolean hasScale) throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getBigDecimal(this.m_item, scale);
    }

    public BigDecimal getBigDecimal() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getBigDecimal(this.m_item);
    }

    public BigDecimal getNullableBigDecimal() throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        if (this.m_item.isNull) {
            return null;
        }
        return DBList.getBigDecimal(this.m_item);
    }

    BigDecimal getBigDecimalScale(int offset, int scale, int precision, boolean bIgnoreZeroScale) throws SQLException {
        if (-1 == offset) {
            DBList.getListElement(this.m_item.nextOffset, this.m_item);
        } else {
            DBList.getListElement(offset, this.m_item);
        }
        BigDecimal bgDec = DBList.getBigDecimal(this.m_item);
        if (bgDec == null) {
            return null;
        }
        int iMinPrecision = 0;
        BigDecimal tmp = bgDec;
        while (tmp.compareTo(BigDecimal.ONE) >= 0) {
            ++iMinPrecision;
            tmp = tmp.divide(BigDecimal.TEN);
        }
        if (precision > iMinPrecision + scale && precision > bgDec.precision()) {
            MathContext mc = new MathContext(precision);
            bgDec = bgDec.round(mc);
        }
        if (bgDec.scale() > 0) {
            bgDec = bgDec.stripTrailingZeros();
        }
        if (scale > 0 || 0 == scale && bIgnoreZeroScale) {
            BigDecimal ret = bgDec.setScale(scale, RoundingMode.HALF_DOWN);
            return ret;
        }
        return bgDec;
    }

    public int getLength() {
        return this.m_item.listBufferEnd;
    }

    public byte getByte() {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getByte(this.m_item);
    }

    public java.util.Date getUtilDate() throws SQLException {
        String s = this.getString();
        if (s == null) {
            return null;
        }
        return new java.util.Date(Timestamp.valueOf(s).getTime());
    }

    public byte[] getBytesXEP() {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        if (this.m_item.isNull) {
            return null;
        }
        if (this.m_item.dataLength == 1 && this.m_item.buffer[this.m_item.dataOffset] == 0) {
            return new byte[0];
        }
        return DBList.getByteArray(this.m_item);
    }

    public final int count() {
        try {
            return DBList.count(this.m_item.buffer, this.m_item.listBufferEnd);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String[] getStringArray() throws SQLException {
        int len = this.count();
        String[] sArray = new String[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getString();
        }
        return sArray;
    }

    public Integer[] getIntWArray() throws SQLException {
        int len = this.count();
        Integer[] sArray = new Integer[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getInt();
        }
        return sArray;
    }

    public int[] getIntArray() throws SQLException {
        int len = this.count();
        int[] sArray = new int[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getInt();
        }
        return sArray;
    }

    public Long[] getLongWArray() throws SQLException {
        int len = this.count();
        Long[] sArray = new Long[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getLong();
        }
        return sArray;
    }

    public long[] getLongArray() throws SQLException {
        int len = this.count();
        long[] sArray = new long[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getLong();
        }
        return sArray;
    }

    public Short[] getShortWArray() throws SQLException {
        int len = this.count();
        Short[] sArray = new Short[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getShort();
        }
        return sArray;
    }

    public short[] getShortArray() throws SQLException {
        int len = this.count();
        short[] sArray = new short[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getShort();
        }
        return sArray;
    }

    public Double[] getDoubleWArray() throws SQLException {
        int len = this.count();
        Double[] sArray = new Double[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getDouble();
        }
        return sArray;
    }

    public double[] getDoubleArray() throws SQLException {
        int len = this.count();
        double[] sArray = new double[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getDouble();
        }
        return sArray;
    }

    public Float[] getFloatWArray() throws SQLException {
        int len = this.count();
        Float[] sArray = new Float[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = Float.valueOf(this.getFloat());
        }
        return sArray;
    }

    public float[] getFloatArray() throws SQLException {
        int len = this.count();
        float[] sArray = new float[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getFloat();
        }
        return sArray;
    }

    public Date[] getDateArray() throws SQLException {
        int len = this.count();
        Date[] sArray = new Date[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getDate();
        }
        return sArray;
    }

    public Time[] getTimeArray() throws SQLException {
        int len = this.count();
        Time[] sArray = new Time[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getTime();
        }
        return sArray;
    }

    public Timestamp[] getTimestampArray() throws SQLException {
        int len = this.count();
        Timestamp[] sArray = new Timestamp[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getTimestamp();
        }
        return sArray;
    }

    public java.util.Date[] getUtilDateArray() throws SQLException {
        int len = this.count();
        java.util.Date[] sArray = new java.util.Date[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getUtilDate();
        }
        return sArray;
    }

    public BigDecimal[] getBigDecimalArray() throws SQLException {
        int len = this.count();
        BigDecimal[] sArray = new BigDecimal[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getBigDecimal();
        }
        return sArray;
    }

    public Boolean[] getBooleanWArray() throws SQLException {
        int len = this.count();
        Boolean[] sArray = new Boolean[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getBoolean();
        }
        return sArray;
    }

    public boolean[] getBooleanArray() throws SQLException {
        int len = this.count();
        boolean[] sArray = new boolean[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getBoolean();
        }
        return sArray;
    }

    public byte[] getByteWArray() {
        int len = this.count();
        byte[] sArray = new byte[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = this.getByte();
        }
        return sArray;
    }

    public Character[] getCharWArray() {
        int len = this.count();
        Character[] sArray = new Character[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = Character.valueOf((char)this.getByte());
        }
        return sArray;
    }

    public String toString() {
        return DBList.toString(this.m_item.buffer, this.m_item.listBufferEnd, this.m_locale);
    }

    public Object getObject() throws SQLException {
        return this.getObject(false);
    }

    public Object getObject(boolean supportOREF) throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        return DBList.getObject(this.m_item, this.m_locale, supportOREF);
    }

    public Object getObjectWithAsciiZero(boolean supportOREF) throws SQLException {
        DBList.getListElement(this.m_item.nextOffset, this.m_item);
        if (this.m_item.type == 1 && this.m_item.dataLength == 1 && this.m_item.buffer[this.m_item.dataOffset] == 0) {
            return "\u0000";
        }
        return DBList.getObject(this.m_item, this.m_locale, supportOREF);
    }

    public String getNextOREF() {
        String oref = null;
        ListItem temp_listitem = new ListItem(this.m_item.buffer);
        DBList.getListElement(this.m_item.nextOffset, temp_listitem);
        if (DBList.isOREF(temp_listitem.type)) {
            try {
                oref = DBList.getString(temp_listitem, this.m_locale);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return oref;
    }

    public String[] peekListTypeFamilies(int count) throws SQLException {
        ListItem temp_listitem = new ListItem(this.m_item.buffer);
        temp_listitem.nextOffset = this.m_item.nextOffset;
        String[] typeFamilies = new String[count];
        for (int i = 0; i < count; ++i) {
            DBList.getListElement(temp_listitem.nextOffset, temp_listitem);
            String typeFamily = DBList.getListTypeFamily(temp_listitem);
            if (typeFamily != null && typeFamily.equals("%oref")) {
                typeFamily = DBList.getString(temp_listitem, this.m_locale);
            }
            typeFamilies[i] = typeFamily;
        }
        return typeFamilies;
    }
}

