/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.BufferUtils;
import com.intersystems.jdbc.ConnectionInformation;
import com.intersystems.jdbc.DBList;
import com.intersystems.jdbc.ListItem;
import com.intersystems.jdbc.SQLValidationException;
import com.intersystems.jdbc.TLSimpleDateFormat;
import com.intersystems.jdbc.ValidateNFormat;
import com.intersystems.util.ListUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.UUID;

public class ListWriter {
    private static int CHUNKSIZE = 256;
    static final int LARGE_INITIAL_SIZE = 100000;
    private int m_BucketSize = 1024;
    byte[] m_aData;
    int m_iOffset = 0;
    protected int m_lastReadOffset = 0;
    private String m_locale = null;
    boolean m_isUnicodeServer = true;
    private boolean m_compactDoubleEnabled = false;
    static long DATE_MAXVAL = 2980013L;
    static long DATE_MINVAL = -672045L;
    static BigDecimal TIME_MAXVAL = new BigDecimal("86399.999999999");
    static BigDecimal TIME_MINVAL = new BigDecimal(0);
    static Timestamp TIMESTAMP_MAXVAL = new Timestamp(253402318800000L);
    static Timestamp TIMESTAMP_MINVAL = new Timestamp(-4070890800000L);
    static long POSIX_MAXVAL = 1406323805406846975L;
    static long POSIX_MINVAL = -6979664624441081856L;
    int m_iSavedOffset = 0;

    public static ListWriter createListWriter() {
        return new ListWriter();
    }

    public ListWriter() {
        this.m_aData = new byte[CHUNKSIZE];
        this.m_iOffset = 0;
        this.m_locale = null;
    }

    public ListWriter(String locale) {
        this.m_aData = new byte[CHUNKSIZE];
        this.m_iOffset = 0;
        this.m_locale = locale;
    }

    public ListWriter(int nLen, String locale) {
        this.m_aData = new byte[nLen];
        this.m_iOffset = 0;
        this.m_locale = locale;
    }

    ListWriter(int nLen, ConnectionInformation info) {
        this.m_aData = new byte[nLen];
        this.m_iOffset = 0;
        this.m_locale = info.serverLocale;
        this.m_isUnicodeServer = info.isUnicodeServer;
        this.m_compactDoubleEnabled = info.compactDoubleEnabled;
    }

    public byte[] getBuffer() {
        return this.m_aData;
    }

    public void clearList() {
        this.m_iOffset = 0;
        this.m_lastReadOffset = 0;
    }

    public int getLength() {
        return this.m_iOffset;
    }

    void setLocale(String locale) {
        this.m_locale = locale;
    }

    String getLocale() {
        return this.m_locale;
    }

    public boolean isCompactDoubleEnabled() {
        return this.m_compactDoubleEnabled;
    }

    public void setCompactDoubleEnabled(boolean value) {
        this.m_compactDoubleEnabled = value;
    }

    public ListWriter trim() {
        byte[] b = BufferUtils.copyByteArray(this.m_aData, 0, this.m_iOffset);
        this.m_aData = b;
        return this;
    }

    void checkBufferSize(int additional) {
        if (this.m_iOffset + additional > this.m_aData.length) {
            this.growBuffer(this.m_iOffset + additional);
        }
    }

    void ensureBufferSize(int needed) {
        if (needed > this.m_aData.length) {
            this.growBuffer(needed);
        }
    }

    public void append(ListWriter list) throws SQLException {
        int len = list.m_iOffset;
        this.checkBufferSize(len);
        System.arraycopy(list.m_aData, 0, this.m_aData, this.m_iOffset, len);
        this.m_iOffset += len;
    }

    public void append(byte[] byteArray, int len, int offset) throws SQLException {
        this.checkBufferSize(len);
        System.arraycopy(byteArray, offset, this.m_aData, this.m_iOffset, len);
        this.m_iOffset += len;
    }

    public void append(byte[] byteArray, int len) throws SQLException {
        this.append(byteArray, len, 0);
    }

    public void append(byte[] byteArray) throws SQLException {
        this.append(byteArray, byteArray.length, 0);
    }

    private void growBuffer(int needed) {
        needed = needed + (needed >> 4) + this.m_BucketSize - 1 & ~(this.m_BucketSize - 1);
        this.m_BucketSize *= 2;
        if (needed < 0) {
            throw new RuntimeException("Exceeded maximum amount of memory that can be allocated for a given row.");
        }
        byte[] a = new byte[needed];
        System.arraycopy(this.m_aData, 0, a, 0, this.m_iOffset);
        this.m_aData = a;
    }

    public void setList(byte[] byteArray) {
        if (null == byteArray) {
            this.setNull();
            return;
        }
        this.m_aData = byteArray;
        this.m_iOffset = 0;
    }

    public byte[] getData() {
        byte[] b = new byte[this.m_iOffset];
        System.arraycopy(this.m_aData, 0, b, 0, this.m_iOffset);
        return b;
    }

    void reset() {
        this.m_iOffset = 0;
    }

    int getInt() throws SQLException {
        ListItem it = new ListItem(this.m_aData);
        this.m_iOffset = DBList.getListElement(this.m_iOffset, it);
        return DBList.getInt(it);
    }

    String getString() throws SQLException {
        ListItem it = new ListItem(this.m_aData);
        this.m_iOffset = DBList.getListElement(this.m_iOffset, it);
        return DBList.getString(it, this.m_locale);
    }

    public void setNull() {
        this.checkBufferSize(2);
        this.m_aData[this.m_iOffset++] = 2;
        this.m_aData[this.m_iOffset++] = 1;
    }

    void setFINull() {
        this.checkBufferSize(1);
        this.m_aData[this.m_iOffset++] = 1;
    }

    public void set(int i) throws SQLException {
        this.checkBufferSize(6);
        this.m_iOffset = DBList.setInt(this.m_aData, this.m_iOffset, i);
    }

    public void set(Integer value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.set((int)value);
        }
    }

    public void set(Short value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.set(value.intValue());
        }
    }

    public void set(short i) throws SQLException {
        this.checkBufferSize(6);
        this.m_iOffset = DBList.setInt(this.m_aData, this.m_iOffset, i);
    }

    public final void set(Byte value) throws SQLException {
        if (null == value) {
            this.setNull();
        } else {
            this.set((short)value.byteValue());
        }
    }

    public void set(String s) throws SQLException {
        if (s == null) {
            this.setNull();
            return;
        }
        int length = s.length() * 2;
        if (0 == length) {
            length = 1;
        }
        this.checkBufferSize(length + this.getBytesForLength(length) + 1);
        this.m_iOffset = DBList.setString(this.m_aData, this.m_iOffset, s, this.m_locale, this.m_isUnicodeServer);
    }

    public void setFI(String s) throws SQLException {
        int length = s.length() * 2;
        if (0 == length) {
            length = 1;
        }
        this.checkBufferSize(length + this.getBytesForLength(length) + 1);
        this.m_iOffset = DBList.setString(this.m_aData, this.m_iOffset, s, this.m_locale, this.m_isUnicodeServer);
    }

    public void setOref(String s) throws SQLException {
        int length = s.length() * 2;
        if (0 == length) {
            length = 1;
        }
        this.checkBufferSize(length + this.getBytesForLength(length) + 1);
        this.m_iOffset = DBList.setOref(this.m_aData, this.m_iOffset, s, this.m_locale, this.m_isUnicodeServer);
    }

    public void set(long l) throws SQLException {
        this.checkBufferSize(10);
        this.m_iOffset = DBList.setLong(this.m_aData, this.m_iOffset, l);
    }

    public void set(Long l) throws SQLException {
        if (null == l) {
            this.setNull();
        } else {
            this.set((long)l);
        }
    }

    public void set(double d) throws SQLException {
        this.checkBufferSize(10);
        this.m_iOffset = this.m_compactDoubleEnabled ? DBList.setCompactDouble(this.m_aData, this.m_iOffset, d) : DBList.setDouble(this.m_aData, this.m_iOffset, d);
    }

    public void set(Double d) throws SQLException {
        if (d == null) {
            this.setNull();
            return;
        }
        this.set((double)d);
    }

    public void set(float f) throws SQLException {
        if (this.m_compactDoubleEnabled) {
            this.checkBufferSize(6);
            this.m_iOffset = DBList.setCompactFloat(this.m_aData, this.m_iOffset, f);
        } else {
            double d = f;
            this.set(d);
        }
    }

    public void set(byte[] b) throws SQLException {
        if (null == b) {
            this.setNull();
            return;
        }
        int length = b.length;
        this.checkBufferSize(length + this.getBytesForLength(length) + 1);
        this.m_iOffset = 0 == length ? DBList.stuffEmptyString(this.m_aData, this.m_iOffset) : DBList.setByteArray(this.m_aData, this.m_iOffset, b, length);
    }

    public void set(byte[] b, int length) throws SQLException {
        this.set(b, 0, length);
    }

    public void set(byte[] b, int offset, int length) throws SQLException {
        if (null == b) {
            this.setNull();
            return;
        }
        this.checkBufferSize(length + this.getBytesForLength(length) + 1);
        this.m_iOffset = 0 == length ? DBList.stuffEmptyString(this.m_aData, this.m_iOffset) : DBList.setByteArray(this.m_aData, this.m_iOffset, b, offset, length);
    }

    void appendFI(byte[] b, int offset, int length) throws SQLException {
        if (null == b) {
            this.setNull();
            return;
        }
        this.checkBufferSize(length + this.getBytesForLength(length) + 1);
        this.m_iOffset = DBList.appendByteArray(this.m_aData, this.m_iOffset, b, offset, length);
    }

    public void set(ListWriter list) {
        if (null == list) {
            this.setNull();
            return;
        }
        this.checkBufferSize(list.m_iOffset + 4);
        this.m_iOffset = DBList.setByteArray(this.m_aData, this.m_iOffset, list.m_aData, list.m_iOffset);
    }

    void set(ListWriter list, boolean noHeader) {
        if (null == list) {
            this.setNull();
            return;
        }
        if (noHeader) {
            int lenBuff = list.m_iOffset - 14;
            this.checkBufferSize(this.getListSizeForLengthTypeData(lenBuff));
            this.m_iOffset = DBList.setByteArray(this.m_aData, this.m_iOffset, list.m_aData, 14, lenBuff);
        } else {
            this.set(list);
        }
    }

    public void set(boolean booleanValue) throws SQLException {
        this.checkBufferSize(4);
        this.m_iOffset = DBList.setBoolean(this.m_aData, this.m_iOffset, booleanValue);
    }

    public void set(BigInteger value) throws SQLException {
        this.checkBufferSize(11);
        this.m_iOffset = DBList.setBigInteger(this.m_aData, this.m_iOffset, value);
    }

    public void set(BigDecimal value) throws SQLException {
        this.checkBufferSize(11);
        this.m_iOffset = DBList.setBigDecimal(this.m_aData, this.m_iOffset, value);
    }

    public void set(Time value) throws SQLException {
        this.set(value, null);
    }

    void set(Time value, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        if (calendar == null) {
            this.m_iOffset = DBList.setString(this.m_aData, this.m_iOffset, value.toString(), null, false);
        } else {
            TLSimpleDateFormat dateFormat = new TLSimpleDateFormat("HH:mm:ss");
            dateFormat.setCalendar(calendar);
            this.m_iOffset = DBList.setString(this.m_aData, this.m_iOffset, dateFormat.format(new java.util.Date(value.getTime())), null, false);
        }
    }

    public void set(java.util.Date value) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.set(new Timestamp(value.getTime()).toString());
    }

    public void set(Date value) throws SQLException {
        this.set(value, null);
    }

    void set(Date value, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(30);
        if (calendar == null) {
            this.m_iOffset = DBList.setString(this.m_aData, this.m_iOffset, value.toString(), null, false);
        } else {
            TLSimpleDateFormat dateFormat = new TLSimpleDateFormat("yyyy-MM-dd");
            dateFormat.setCalendar(calendar);
            this.m_iOffset = DBList.setString(this.m_aData, this.m_iOffset, dateFormat.format(new java.util.Date(value.getTime())), null, false);
        }
    }

    public void set(Timestamp value) throws SQLException {
        this.set(value, null);
    }

    void set(Timestamp value, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(32);
        if (calendar == null) {
            this.m_iOffset = DBList.setString(this.m_aData, this.m_iOffset, ListUtil.canonizeTimestampString(value.toString()), null, false);
        } else {
            String sOriginalValue;
            TLSimpleDateFormat dateFormat = value.getNanos() > 0 ? new TLSimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS") : new TLSimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFormat.setCalendar(calendar);
            String sValue = dateFormat.format(value);
            if (value.getNanos() > 0 && (sOriginalValue = value.toString()).length() > 23) {
                int i = sOriginalValue.indexOf(46);
                String fraction = sOriginalValue.substring(i);
                i = sValue.indexOf(46);
                sValue = sValue.substring(0, i);
                sValue = sValue + fraction;
            }
            this.m_iOffset = DBList.setString(this.m_aData, this.m_iOffset, sValue, null, false);
        }
    }

    void setPosix(Time value) throws SQLException {
        this.setPosix(value, null);
    }

    void setPosix(Time value, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        this.m_iOffset = DBList.setLong(this.m_aData, this.m_iOffset, ValidateNFormat.PosixFromTime(value.getTime(), 0, calendar, true));
    }

    void setPosix(Date value) throws SQLException {
        this.setPosix(value, null);
    }

    void setPosix(Date value, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        this.m_iOffset = DBList.setLong(this.m_aData, this.m_iOffset, ValidateNFormat.PosixFromTime(value.getTime(), 0, calendar, false));
    }

    public static int setDatePosix(byte[] buffer, int offset, Date value, Calendar calendar) throws SQLException {
        return DBList.setLong(buffer, offset, ValidateNFormat.PosixFromTime(value.getTime(), 0, calendar, false));
    }

    void setPosix(Timestamp value) throws SQLException {
        this.setPosix(value, null);
    }

    void setPosix(Timestamp value, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        this.m_iOffset = DBList.setLong(this.m_aData, this.m_iOffset, ValidateNFormat.PosixFromTimestamp(value, calendar));
    }

    public void setH(Time value) throws SQLException {
        this.setH(value, null);
    }

    void setH(Time value, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        BigDecimal bdt = ValidateNFormat.TimeHorologFromTime(value, calendar);
        this.set(bdt);
    }

    void setH(Time value, String fractions, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        String out = Integer.toString(ValidateNFormat.HorologFromTime(value.getTime(), calendar));
        if (Integer.valueOf(fractions) > 0) {
            out = out + ".";
            out = out + fractions;
        }
        this.m_iOffset = DBList.setString(this.m_aData, this.m_iOffset, out, null, false);
    }

    public void setH(Date value) throws SQLException {
        this.setH(value, null);
    }

    void setH(Date value, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        this.m_iOffset = DBList.setInt(this.m_aData, this.m_iOffset, ValidateNFormat.HorologFromDate(value.getTime(), null, false));
    }

    public void setUndefined() {
        this.checkBufferSize(32);
        this.m_iOffset = DBList.setUndefined(this.m_aData, this.m_iOffset);
    }

    public void setObject(Object value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        if (value instanceof String) {
            this.set((String)value);
        } else if (value instanceof Integer) {
            this.set((Integer)value);
        } else if (value instanceof Double) {
            this.set((Double)value);
        } else if (value instanceof Float) {
            this.set((Float)value);
        } else if (value instanceof byte[]) {
            this.set((byte[])value);
        } else if (value instanceof char[]) {
            this.set(new String((char[])value));
        } else if (value instanceof ListWriter) {
            this.set((ListWriter)value);
        } else if (value instanceof BigDecimal) {
            this.set((BigDecimal)value);
        } else if (value instanceof Date) {
            this.set((Date)value);
        } else if (value instanceof Time) {
            this.set((Time)value);
        } else if (value instanceof Timestamp) {
            this.set((Timestamp)value);
        } else if (value instanceof Long) {
            this.set((Long)value);
        } else if (value instanceof BigInteger) {
            this.set((BigInteger)value);
        } else if (value instanceof Byte) {
            this.set((short)((Byte)value).byteValue());
        } else if (value instanceof Short) {
            this.set((Short)value);
        } else if (value instanceof Character) {
            this.set(value.toString());
        } else if (value instanceof Boolean) {
            this.set((boolean)((Boolean)value));
        } else if (value instanceof LocalDateTime) {
            this.set(Timestamp.valueOf((LocalDateTime)value));
        } else if (value instanceof LocalDate) {
            this.set(Date.valueOf((LocalDate)value));
        } else if (value instanceof LocalTime) {
            this.set(Time.valueOf((LocalTime)value));
        } else {
            throw new SQLException("Type out of range: " + value.getClass().getName(), "S1003");
        }
    }

    void setBigDecimal(Object value, Integer userScale, BigDecimal min, BigDecimal max, int scale) throws SQLException {
        try {
            BigDecimal bd;
            if (value instanceof String) {
                bd = new BigDecimal((String)value);
            } else if (value instanceof BigDecimal) {
                bd = (BigDecimal)value;
            } else if (value instanceof BigInteger) {
                bd = new BigDecimal((BigInteger)value);
            } else if (value instanceof Double) {
                bd = new BigDecimal((Double)value);
            } else if (value instanceof Float) {
                bd = new BigDecimal(((Float)value).floatValue());
            } else if (value instanceof Long) {
                bd = new BigDecimal((Long)value);
            } else if (value instanceof Integer) {
                bd = new BigDecimal((Integer)value);
            } else if (value instanceof Byte) {
                bd = new BigDecimal(((Byte)value).byteValue());
            } else if (value instanceof Short) {
                bd = new BigDecimal(((Short)value).shortValue());
            } else if (value instanceof Boolean) {
                bd = ((Boolean)value).booleanValue() ? new BigDecimal(1) : new BigDecimal(0);
            } else {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " Unsupported type conversion for BigDecimal");
            }
            if (min != null && min.compareTo(bd) == 1) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (BigDecimal: " + bd + ") < MIN (" + min + ")");
            }
            if (max != null && max.compareTo(bd) == -1) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (BigDecimal: " + bd + ") > MAX (" + max + ")");
            }
            if (userScale != null && userScale < scale) {
                this.set(bd.setScale((int)userScale, 1));
            } else if (bd.scale() == scale) {
                this.set(bd);
            } else {
                this.set(bd.setScale(scale, 4));
            }
        }
        catch (SQLValidationException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new SQLValidationException("Type not valid for BigDecimal conversion: " + value.getClass().getName() + "\n" + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setBinary(Object value, int precision, int truncate) throws SQLException {
        try {
            byte[] bt;
            block9: {
                bt = null;
                if (value instanceof String) {
                    String stemp = (String)value;
                    if (stemp.startsWith("0x")) {
                        bt = ValidateNFormat.hexStringToByteArray(stemp.substring(2));
                        break block9;
                    } else {
                        if (stemp.length() > precision) {
                            throw new SQLValidationException("Truncation (binary precision: " + precision + " length: " + stemp.length());
                        }
                        this.set(stemp);
                        return;
                    }
                }
                if (!(value instanceof byte[])) throw new SQLValidationException("Unsupported type conversion for Byte[]");
                bt = (byte[])value;
            }
            if (truncate == 2) {
                this.set(bt);
                return;
            }
            if (bt.length > precision) {
                throw new SQLValidationException("Truncation (binary precision: " + precision + " length: " + bt.length);
            }
            this.set(bt);
            return;
        }
        catch (SQLValidationException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new SQLValidationException("Type not valid for binary conversion: " + value.getClass().getName() + "\n" + ex.getMessage());
        }
    }

    void setDouble(Object value, Double min, Double max) throws SQLException {
        try {
            double db;
            if (value instanceof Double) {
                db = (Double)value;
            } else if (value instanceof String) {
                db = Double.parseDouble((String)value);
            } else if (value instanceof BigDecimal) {
                db = ((BigDecimal)value).doubleValue();
            } else if (value instanceof BigInteger) {
                db = ((BigInteger)value).doubleValue();
            } else if (value instanceof Float) {
                db = ((Float)value).doubleValue();
            } else if (value instanceof Long) {
                db = ((Long)value).doubleValue();
            } else if (value instanceof Integer) {
                db = ((Integer)value).doubleValue();
            } else if (value instanceof Short) {
                db = ((Short)value).doubleValue();
            } else if (value instanceof Byte) {
                db = ((Byte)value).doubleValue();
            } else if (value instanceof Boolean) {
                db = ((Boolean)value).booleanValue() ? 1.0 : 0.0;
            } else {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " Unsupported type conversion for Double");
            }
            if (min != null && db < min) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (Double: " + db + ") < MIN (" + min + ")");
            }
            if (max != null && db > max) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (Double: " + db + ") > MAX (" + max + ")");
            }
            this.set(db);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new SQLValidationException("Type out of range for Double conversion: " + value.getClass().getName() + "\n" + ex.getMessage());
        }
    }

    void setBit(Object value) throws SQLException {
        try {
            int outInt = ValidateNFormat.normalizeToInt(value);
            if (outInt < 0) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (Bit: " + outInt + ") < MIN (0)");
            }
            if (outInt > 1) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (Bit: " + outInt + ") > MAX (1)");
            }
            this.set(outInt);
        }
        catch (SQLValidationException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new SQLValidationException("Type out of range for Bit conversion: " + value.getClass().getName() + "\n" + ex.getMessage());
        }
    }

    void setByte(Object value, Long min, Long max) throws SQLException {
        try {
            int outInt = ValidateNFormat.normalizeToInt(value);
            if (min != null && outInt < min.intValue()) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (TinyInt: " + outInt + ") < MIN (" + min + ")");
            }
            if (outInt < -128) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (TinyInt: " + outInt + ") < MIN (-128)");
            }
            if (max != null && outInt > max.intValue()) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (TinyInt: " + outInt + ") > MAX (" + max + ")");
            }
            if (outInt > 127) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (TinyInt: " + outInt + ") > MAX (127)");
            }
            this.set(outInt);
        }
        catch (SQLValidationException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new SQLValidationException("Type out of range for TinyInt conversion: " + value.getClass().getName() + "\n" + ex.getMessage());
        }
    }

    void setShort(Object value, Long min, Long max) throws SQLException {
        try {
            int outInt = ValidateNFormat.normalizeToInt(value);
            if (outInt < Short.MIN_VALUE || outInt > Short.MAX_VALUE) {
                throw new SQLValidationException("(" + value.getClass().getName() + ": " + outInt + ") out of Short range)");
            }
            if (min != null && outInt < min.intValue()) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (SmallInt: " + outInt + ") < MIN (" + min + ")");
            }
            if (max != null && outInt > max.intValue()) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (SmallInt: " + outInt + ") > MAX (" + max + ")");
            }
            this.set(outInt);
        }
        catch (SQLValidationException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new SQLValidationException("Type out of range for SmallInt conversion: " + value.getClass().getName() + "\n" + ex.getMessage());
        }
    }

    void setInt(Object value, Long min, Long max) throws SQLException {
        try {
            int outInt = ValidateNFormat.normalizeToInt(value);
            if (min != null && outInt < min.intValue()) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (Integer: " + outInt + ") < MIN (" + min + ")");
            }
            if (outInt < Integer.MIN_VALUE) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (Integer: " + outInt + ") < MIN (" + Integer.MIN_VALUE + ")");
            }
            if (max != null && outInt > max.intValue()) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (Integer: " + outInt + ") > MAX (" + max + ")");
            }
            if (outInt > Integer.MAX_VALUE) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (Integer: " + outInt + ") < MAX (" + Integer.MAX_VALUE + ")");
            }
            this.set(outInt);
        }
        catch (SQLValidationException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new SQLValidationException("Type out of range for Integer conversion: " + value.getClass().getName() + "\n" + ex.getMessage());
        }
    }

    void setLong(Object value, Long min, Long max) throws SQLException {
        try {
            long outLong;
            if (value instanceof Long) {
                outLong = (Long)value;
            } else if (value instanceof String) {
                outLong = ValidateNFormat.parseLongTruncate((String)value);
            } else if (value instanceof BigDecimal) {
                BigDecimal bd = ((BigDecimal)value).setScale(0, 1);
                outLong = bd.longValue();
                BigDecimal tmpBd = new BigDecimal(outLong);
                if (tmpBd.compareTo(bd) != 0) {
                    throw new SQLValidationException("(" + value.getClass().getName() + ": " + outLong + ") out of Long range)");
                }
            } else if (value instanceof BigInteger) {
                outLong = ((BigInteger)value).longValue();
                BigInteger tmpBi = new BigInteger(Long.valueOf(outLong).toString());
                if (tmpBi.compareTo((BigInteger)value) != 0) {
                    throw new SQLValidationException("(" + value.getClass().getName() + ": " + outLong + ") out of Long range)");
                }
            } else if (value instanceof Double) {
                outLong = ((Double)value).longValue();
            } else if (value instanceof Float) {
                outLong = ((Float)value).longValue();
            } else if (value instanceof Integer) {
                outLong = ((Integer)value).longValue();
            } else if (value instanceof Short) {
                outLong = ((Short)value).longValue();
            } else if (value instanceof Byte) {
                outLong = ((Byte)value).longValue();
            } else if (value instanceof Boolean) {
                outLong = ((Boolean)value).booleanValue() ? 1L : 0L;
            } else {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " Unsupported type conversion for Long");
            }
            if (min != null && outLong < min) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (BigInt: " + outLong + ") < MIN (" + min + ")");
            }
            if (max != null && outLong > max) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (BigInt: " + outLong + ") > MAX (" + max + ")");
            }
            this.set(outLong);
        }
        catch (SQLValidationException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new SQLValidationException("Type out of range for BigInt conversion: " + value.getClass().getName() + "\n" + ex.getMessage());
        }
    }

    public void set(UUID value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.setGUID(value);
        }
    }

    void setGUID(Object value) throws SQLException {
        String str = value.toString();
        if (str.length() != 36) {
            throw new SQLValidationException("String length not 36 for GUID, only: " + str.length());
        }
        try {
            UUID v = UUID.fromString(str);
            this.set(v.toString());
            return;
        }
        catch (Exception ex) {
            throw new SQLValidationException("Format not valid for GUID conversion: " + value.getClass().getName() + "\n" + ex.getMessage());
        }
    }

    void setString(Object value, int precision, Long minLength, int truncate) throws SQLException {
        try {
            String str = value.toString();
            if (truncate == 2) {
                this.set(str);
            } else {
                if (minLength != null && str.length() < minLength.intValue()) {
                    throw new SQLValidationException("Varchar too small ( Value: '" + str.substring(0, str.length() > 10 ? 10 : str.length()) + " ...' Length: " + str.length() + ") minlen: (" + minLength + ")");
                }
                if (str.length() > precision) {
                    if (truncate == 0) {
                        throw new SQLValidationException("Truncation (Varchar Value: '" + str.substring(0, str.length() > 10 ? 10 : str.length()) + " ...' Length: " + str.length() + ") > maxlen:  (" + precision + ")");
                    }
                    this.set(str.substring(0, precision));
                } else {
                    this.set(str);
                }
            }
        }
        catch (SQLValidationException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new SQLValidationException("Type not valid for varchar conversion: " + value.getClass().getName() + "\n" + ex.getMessage());
        }
    }

    void setFIString(Object value, int precision, Long minLength, int truncate) throws SQLException {
        try {
            String str = value.toString();
            if (truncate == 2) {
                this.setFI(str);
            } else {
                if (minLength != null && str.length() < minLength.intValue()) {
                    throw new SQLValidationException("Varchar too small ( Value: '" + str.substring(0, str.length() > 10 ? 10 : str.length()) + "...' Length: " + str.length() + ") minlen: (" + minLength + ")");
                }
                if (str.length() > precision) {
                    if (truncate == 0) {
                        throw new SQLValidationException("Truncation (Varchar Value: '" + str.substring(0, str.length() > 10 ? 10 : str.length()) + "...' Length: " + str.length() + ") > maxlen:  (" + precision + ")");
                    }
                    this.setFI(str.substring(0, precision));
                } else {
                    this.setFI(str);
                }
            }
        }
        catch (SQLValidationException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new SQLValidationException("Type not valid for varchar conversion: " + value.getClass().getName() + "\n" + ex.getMessage());
        }
    }

    void setDateH(Object value, Calendar cal, Long min, Long max) throws SQLException {
        try {
            long lv;
            if (value instanceof String) {
                String st = (String)value;
                try {
                    lv = ValidateNFormat.HorologFromDate(ValidateNFormat.parseDateStringToTicks(st), cal, true);
                }
                catch (Exception ex) {
                    try {
                        lv = ValidateNFormat.parseLongTruncate(st);
                    }
                    catch (Exception ex1) {
                        throw new SQLValidationException("Invalid Date");
                    }
                }
            } else if (value instanceof Date) {
                lv = ValidateNFormat.HorologFromDate(((Date)value).getTime(), cal, false);
            } else if (value instanceof Timestamp) {
                lv = ValidateNFormat.HorologFromDate(((Timestamp)value).getTime(), cal, false);
            } else if (value instanceof BigDecimal) {
                lv = ((BigDecimal)value).longValue();
            } else if (value instanceof BigInteger) {
                lv = ((BigInteger)value).longValue();
            } else if (value instanceof Long) {
                lv = (Long)value;
            } else if (value instanceof Double) {
                lv = ((Double)value).longValue();
            } else if (value instanceof Float) {
                lv = ((Float)value).longValue();
            } else if (value instanceof Integer) {
                lv = ((Integer)value).longValue();
            } else if (value instanceof Short) {
                lv = ((Short)value).longValue();
            } else if (value instanceof Byte) {
                lv = ((Byte)value).longValue();
            } else if (value instanceof Boolean) {
                lv = (Boolean)value == true ? 1L : 0L;
            } else {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " Unsupported type conversion for Date");
            }
            if (min != null) {
                if (lv < min) {
                    throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (Date: " + lv + ") < MIN (" + min + ")");
                }
            } else if (lv < DATE_MINVAL) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (Date: " + lv + ") < DATE_MINVAL (" + DATE_MINVAL + ")");
            }
            if (max != null) {
                if (lv > max) {
                    throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (Date: " + lv + ") > MAX (" + max + ")");
                }
            } else if (lv > DATE_MAXVAL) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (Date: " + lv + ") > DATE_MAXVAL (" + DATE_MAXVAL + ")");
            }
            this.set(lv);
        }
        catch (SQLValidationException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new SQLValidationException("Type out of range for Date conversion: " + value.getClass().getName() + "\n" + ex.getMessage());
        }
    }

    void setTimeH(Object value, Calendar cal, BigDecimal min, BigDecimal max, int scale) throws SQLException {
        BigDecimal bdt = null;
        try {
            if (value instanceof String) {
                String st = (String)value;
                if (!st.contains(":")) {
                    bdt = new BigDecimal((String)value);
                } else {
                    long hlog = ValidateNFormat.NormalizedTime(ValidateNFormat.parseTimeString(st), cal);
                    st = st.indexOf(".") > 0 ? Long.toString(hlog) + st.substring(st.indexOf(".")).replaceAll("[^.0-9]", "") : Long.toString(hlog);
                }
                bdt = new BigDecimal(st);
            } else if (value instanceof Time) {
                bdt = ValidateNFormat.TimeHorologFromTime((Time)value, cal);
            } else if (value instanceof Timestamp) {
                bdt = ValidateNFormat.TimeHorologFromTimestamp((Timestamp)value, cal);
            } else if (value instanceof BigDecimal) {
                bdt = (BigDecimal)value;
            } else if (value instanceof BigInteger) {
                bdt = new BigDecimal((BigInteger)value);
            } else if (value instanceof Double) {
                bdt = new BigDecimal((Double)value);
            } else if (value instanceof Float) {
                bdt = new BigDecimal(((Float)value).floatValue());
            } else if (value instanceof Long) {
                bdt = new BigDecimal((Long)value);
            } else if (value instanceof Integer) {
                bdt = new BigDecimal((Integer)value);
            } else if (value instanceof Short) {
                bdt = new BigDecimal(((Short)value).shortValue());
            } else if (value instanceof Byte) {
                bdt = new BigDecimal(((Byte)value).byteValue());
            } else if (value instanceof Boolean) {
                bdt = (Boolean)value == true ? new BigDecimal(1) : new BigDecimal(0);
            } else {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " Unsupported type conversion for Time");
            }
            if (TIME_MINVAL.compareTo(bdt) == 1 || min != null && min.compareTo(bdt) == 1) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (Time: " + bdt + ") < MIN (" + (min != null ? min : TIME_MINVAL) + ")");
            }
            if (TIME_MAXVAL.compareTo(bdt) == -1 || max != null && max.compareTo(bdt) == -1) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (Time: " + bdt + ") > MAX (" + (max != null ? max : TIME_MAXVAL) + ")");
            }
            if (scale >= 0) {
                this.set(bdt.setScale(scale, 4));
            } else {
                this.set(bdt);
            }
        }
        catch (SQLValidationException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new SQLValidationException("Type out of range for Time conversion: " + value.getClass().getName() + "\n" + ex.getMessage());
        }
    }

    void setTimestamp(Object value, Calendar cal, Timestamp min, Timestamp max, int tzoffset) throws SQLException {
        Timestamp ts = null;
        try {
            if (value instanceof String) {
                ts = ValidateNFormat.parseTimestampStringToTimestamp((String)value, tzoffset, cal, true);
            } else if (value instanceof Timestamp) {
                ts = ValidateNFormat.TimestampNormalize((Timestamp)value, cal);
            } else if (value instanceof Date) {
                ts = ValidateNFormat.TimestampFromDate((Date)value, cal);
            } else if (value instanceof Time) {
                ts = ValidateNFormat.TimestampFromTime((Time)value, 0, cal);
            } else if (value instanceof Long) {
                ts = ValidateNFormat.TimeStampFromHorolog((Long)value, cal);
            } else if (value instanceof BigInteger) {
                ts = ValidateNFormat.TimeStampFromHorolog(((BigInteger)value).longValue(), cal);
            } else if (value instanceof Double) {
                ts = ValidateNFormat.TimeStampFromHorolog(((Double)value).longValue(), cal);
            } else if (value instanceof Float) {
                ts = ValidateNFormat.TimeStampFromHorolog(((Float)value).longValue(), cal);
            } else if (value instanceof Integer) {
                ts = ValidateNFormat.TimeStampFromHorolog(((Integer)value).longValue(), cal);
            } else if (value instanceof Short) {
                ts = ValidateNFormat.TimeStampFromHorolog(((Short)value).longValue(), cal);
            } else if (value instanceof Byte) {
                ts = ValidateNFormat.TimeStampFromHorolog(((Byte)value).longValue(), cal);
            } else if (value instanceof Boolean) {
                ts = ValidateNFormat.TimeStampFromHorolog((Boolean)value == true ? 1L : 0L, cal);
            } else {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " Unsupported type conversion for Timestamp");
            }
            if (min != null) {
                if (min.compareTo(ts) == 1) {
                    throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (TimeStamp: " + ts + ") < MIN (" + min + ")");
                }
            } else if (tzoffset != 2 && TIMESTAMP_MINVAL.compareTo(ts) == 1) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (TimeStamp: " + ts + ") < TIMESTAMP_MINVAL (" + TIMESTAMP_MINVAL.toString() + ")");
            }
            if (max != null) {
                if (max.compareTo(ts) == -1) {
                    throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (TimeStamp: " + ts + ") > MAX (" + max + ")");
                }
            } else if (tzoffset != 2 && TIMESTAMP_MAXVAL.compareTo(ts) <= 0) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (TimeStamp: " + ts + ") < TIMESTAMP_MAXVAL (" + TIMESTAMP_MAXVAL.toString() + ")");
            }
            this.set(ts);
        }
        catch (SQLValidationException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new SQLValidationException("Type out of range for Timestamp conversion: " + value.getClass().getName() + "\n" + ex.getMessage());
        }
    }

    void setPosix(Object value, Calendar cal, Long min, Long max, int tzoffset) throws SQLException {
        try {
            long lv = 0L;
            if (value instanceof String) {
                try {
                    Timestamp ts = ValidateNFormat.parseTimestampStringToTimestamp((String)value, tzoffset, cal, false);
                    lv = ValidateNFormat.PosixFromTime(ts.getTime(), ts.getNanos(), cal, false);
                }
                catch (Exception ex) {
                    throw new SQLValidationException("Invalid Posix string value: " + (String)value);
                }
            } else if (value instanceof Date) {
                lv = ValidateNFormat.PosixFromTime(((Date)value).getTime(), 0, cal, false);
            } else if (value instanceof Time) {
                lv = ValidateNFormat.PosixFromTime(((Time)value).getTime(), 0, cal, true);
            } else if (value instanceof Timestamp) {
                Timestamp ts = (Timestamp)value;
                lv = ValidateNFormat.PosixFromTime(ts.getTime(), ts.getNanos(), cal, false);
            } else if (value instanceof BigDecimal) {
                lv = ValidateNFormat.PosixIfHorologValue(((BigDecimal)value).longValue());
            } else if (value instanceof BigInteger) {
                lv = ValidateNFormat.PosixIfHorologValue(((BigInteger)value).longValue());
            } else if (value instanceof Long) {
                lv = ValidateNFormat.PosixIfHorologValue((Long)value);
            } else if (value instanceof Double) {
                lv = ValidateNFormat.PosixIfHorologValue(((Double)value).longValue());
            } else if (value instanceof Float) {
                lv = ValidateNFormat.PosixIfHorologValue(((Float)value).longValue());
            } else if (value instanceof Integer) {
                lv = ValidateNFormat.PosixIfHorologValue(((Integer)value).longValue());
            } else if (value instanceof Short) {
                lv = ValidateNFormat.PosixIfHorologValue(((Short)value).longValue());
            } else if (value instanceof Byte) {
                lv = ValidateNFormat.PosixIfHorologValue(((Byte)value).longValue());
            } else if (value instanceof Boolean) {
                lv = ValidateNFormat.PosixIfHorologValue((Boolean)value == true ? 1L : 0L);
            } else {
                throw new SQLValidationException("Unsupported type conversion for Posix");
            }
            if (min != null) {
                if (lv < min) {
                    throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (Posix: " + lv + ") < MIN (" + min + ")");
                }
            } else if (lv < POSIX_MINVAL) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (Posix: " + lv + ") < MIN (" + POSIX_MINVAL + ")");
            }
            if (max != null) {
                if (lv > max) {
                    throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (Posix: " + lv + ") > MAX (" + max + ")");
                }
            } else if (lv > POSIX_MAXVAL) {
                throw new SQLValidationException(value.getClass().getName() + " value: " + value.toString() + " (Posix: " + lv + ") > MAX (" + POSIX_MAXVAL + ")");
            }
            if (lv >= 0L ? lv < 0x1000000000000000L : lv > -6917529027641081857L) {
                throw new SQLValidationException(value.getClass().getName() + " input: " + value.toString() + " (Posix value out of range!)");
            }
            this.set(lv);
        }
        catch (SQLValidationException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new SQLValidationException("Type out of range for Posix conversion: " + value.getClass().getName() + "\n" + value.toString() + "\n" + ex.getMessage());
        }
    }

    private void wrapArray(int originalOffset) {
        int byteLen = this.m_iOffset - originalOffset;
        if (byteLen <= 255) {
            this.m_aData[originalOffset] = (byte)byteLen;
            this.m_aData[originalOffset + 1] = 1;
        } else if (--byteLen < 65536) {
            this.checkBufferSize(1);
            System.arraycopy(this.m_aData, originalOffset + 2, this.m_aData, originalOffset + 4, byteLen);
            this.m_aData[originalOffset] = 0;
            this.m_aData[originalOffset + 1] = (byte)byteLen;
            this.m_aData[originalOffset + 2] = (byte)(byteLen >> 8);
            this.m_aData[originalOffset + 3] = 1;
            this.m_iOffset += 2;
        } else {
            this.checkBufferSize(5);
            System.arraycopy(this.m_aData, originalOffset + 2, this.m_aData, originalOffset + 8, byteLen);
            this.m_aData[originalOffset] = 0;
            this.m_aData[originalOffset + 1] = 0;
            this.m_aData[originalOffset + 2] = 0;
            this.m_aData[originalOffset + 3] = (byte)byteLen;
            this.m_aData[originalOffset + 4] = (byte)(byteLen >> 8);
            this.m_aData[originalOffset + 5] = (byte)(byteLen >> 16);
            this.m_aData[originalOffset + 6] = (byte)(byteLen >> 24);
            this.m_aData[originalOffset + 7] = 1;
            this.m_iOffset += 6;
        }
    }

    public void set(String[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (String array1 : array) {
            this.set(array1);
        }
        this.wrapArray(originalOffset);
    }

    public void set(int[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Integer[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (Integer array1 : array) {
            this.set(array1);
        }
        this.wrapArray(originalOffset);
    }

    public void set(long[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Long[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (Long array1 : array) {
            this.set(array1);
        }
        this.wrapArray(originalOffset);
    }

    public void set(double[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Double[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (Double array1 : array) {
            this.set(array1);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Float value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.set(value.floatValue());
        }
    }

    public void set(short[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Short[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (Short array1 : array) {
            this.set(array1);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Float[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (Float array1 : array) {
            this.set(array1);
        }
        this.wrapArray(originalOffset);
    }

    public void set(float[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(boolean[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Date[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (Date array1 : array) {
            this.set(array1);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Time[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (Time array1 : array) {
            this.set(array1);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Timestamp[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (Timestamp array1 : array) {
            this.set(array1);
        }
        this.wrapArray(originalOffset);
    }

    public void set(java.util.Date[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (java.util.Date array1 : array) {
            this.set(array1);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Boolean value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.set((boolean)value);
        }
    }

    public void set(Boolean[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (Boolean array1 : array) {
            this.set(array1);
        }
        this.wrapArray(originalOffset);
    }

    public void set(BigDecimal[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (BigDecimal array1 : array) {
            this.set(array1);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Byte[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (Byte array1 : array) {
            this.set(array1);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Character value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.set((int)value.charValue());
        }
    }

    public void set(Character[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        for (Character array1 : array) {
            this.set(array1);
        }
        this.wrapArray(originalOffset);
    }

    void stuffRawInt(int offset, int value, int len) {
        this.ensureBufferSize(offset + len);
        DBList.stuffRawInt(this.m_aData, offset, value, len);
    }

    int read4ByteInt(byte[] ba, int offset) {
        return DBList.read4ByteInt(ba, offset);
    }

    int getBytesForLength(int len) {
        if (++len < 255) {
            return 1;
        }
        if (len < 65536) {
            return 3;
        }
        return 7;
    }

    int getListSizeForLengthTypeData(int len) {
        if (++len < 255) {
            return len + 1;
        }
        if (len < 65536) {
            return len + 3;
        }
        return len + 7;
    }

    boolean isWide(String s) {
        for (int j = 0; j < s.length(); ++j) {
            if (s.charAt(j) <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public final boolean atEnd() {
        return this.m_lastReadOffset >= this.m_iOffset;
    }

    public byte[] getBytes() {
        ListItem it = new ListItem(this.m_aData);
        this.m_lastReadOffset = DBList.getListElement(this.m_lastReadOffset, it);
        if (it.isNull) {
            return null;
        }
        if (it.dataLength == 1 && this.m_aData[it.dataOffset] == 0) {
            return new byte[0];
        }
        return DBList.getByteArray(it);
    }

    public void copyData(byte[] buffer, int offset) {
        System.arraycopy(this.m_aData, 0, buffer, offset, this.m_iOffset);
    }

    public String toString() {
        return DBList.toString(this.m_aData, this.m_iOffset, this.m_locale);
    }

    void saveCurrentOffset() {
        this.m_iSavedOffset = this.m_iOffset;
    }

    void setSavedOffsetTypeAsPassByReference() {
        DBList.setTypeAsPassByReference(this.m_aData, this.m_iSavedOffset);
    }

    void setSavedOffsetTypeAsLegacyOref() {
        DBList.setTypeAsLegacyOref(this.m_aData, this.m_iSavedOffset);
    }
}

