/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.BufferRO;
import com.intersystems.jdbc.MessageHeader;
import com.intersystems.jdbc.TLSimpleDateFormat;
import com.intersystems.util.VersionInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

public final class LogFileStream
implements AutoCloseable {
    static final int LOG_RECEIVED = 0;
    static final int LOG_SENT = 1;
    private static final String lineSeparator = System.getProperty("line.separator");
    private PrintWriter output;
    private StringBuffer buffer;
    private StringBuffer asciiDump;
    private boolean closed;
    private TLSimpleDateFormat simpleDateFormat = new TLSimpleDateFormat("MM/dd/yy-HH:mm:ss:SSS");
    public boolean bSkipLogging = false;
    private byte[] delayedWriteBuffer = null;
    private String logFileName = null;
    private int refCount = 0;
    private boolean cantClose = false;
    public int bytesPerLine = 16;

    public static void log(LogFileStream lf, String msg) {
        if (lf != null) {
            lf.logApi(msg);
        }
    }

    public LogFileStream(PrintWriter pw) {
        this.output = pw;
        this.buffer = new StringBuffer();
        this.asciiDump = new StringBuffer(20);
        this.logFileName = null;
    }

    public LogFileStream(String path) throws IOException {
        this.buffer = new StringBuffer();
        this.asciiDump = new StringBuffer(20);
        boolean bNewFile = false;
        if (path.startsWith("+")) {
            bNewFile = true;
            path = path.substring(1);
        }
        if (path.startsWith("-")) {
            this.bSkipLogging = true;
            path = path.substring(1);
        }
        if (path.toUpperCase().contentEquals("SYSTEM.OUT")) {
            this.output = new PrintWriter(System.out);
            this.cantClose = true;
            return;
        }
        File lf = new File(path);
        String filename = lf.getName();
        int pos = filename.lastIndexOf(".");
        this.bytesPerLine = pos > 2 && filename.substring(pos - 2, pos).equals("16") ? 16 : 14;
        this.logFileName = path;
        if (bNewFile) {
            lf.delete();
        }
        this.output = new PrintWriter(new FileOutputStream(lf, true), true);
        ++this.refCount;
    }

    protected synchronized void ref() {
        if (this.checkForOpenPrintWriter()) {
            ++this.refCount;
        }
    }

    protected boolean checkForOpenPrintWriter() {
        if (this.refCount > 0) {
            return true;
        }
        if (this.logFileName != null) {
            try {
                this.output = new PrintWriter(new FileOutputStream(new File(this.logFileName), true), true);
                ++this.refCount;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    protected PrintWriter getPrintWriter() {
        return this.output;
    }

    protected String getLogFileName() {
        return this.logFileName;
    }

    private String getCurrentTime() {
        return this.simpleDateFormat.format(Calendar.getInstance().getTime());
    }

    public final void dumpHeader() {
        this.checkForOpenPrintWriter();
        this.output.print(lineSeparator + "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
        this.output.print(lineSeparator + "\tStarted At:     " + DateFormat.getDateTimeInstance().format(new Date()));
        this.output.print(lineSeparator + "\tDriver Name:    com.intersystems.jdbc.IRISDriver");
        this.output.print(lineSeparator + "\tJar File Name:  " + VersionInfo.getJarFileName());
        this.output.print(lineSeparator + "\tClient Version: " + VersionInfo.getClientVersion());
        this.output.print(lineSeparator + "\tCompiled At:    " + VersionInfo.compiledAt());
        this.output.print(lineSeparator + "\tJDBC Version:   " + VersionInfo.getJDBCVersion());
        this.output.print(lineSeparator + "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-" + lineSeparator);
        this.output.flush();
    }

    void dump(MessageHeader header, int type) {
        this.dump(header, type, false);
    }

    void dump(MessageHeader header, int type, String jobID, int deviceID) {
        this.dump(new byte[0], 0, 0, type, header.hBuffer, jobID, deviceID);
    }

    void dump(MessageHeader header, int type, boolean delayWriteToLog) {
        if (delayWriteToLog) {
            this.delayedWriteBuffer = (byte[])header.hBuffer.clone();
        } else {
            this.dump(new byte[0], 0, 0, type, header.hBuffer, null, -1);
        }
    }

    void dump(BufferRO list, int type, String jobID, int deviceID) {
        this.dump(list.getBuffer(), list.getOffset(), list.getEndLength() - list.getOffset(), type, list.Header.hBuffer, jobID, deviceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void dump(byte[] stream, int offset, int count, int type, byte[] header, String jobID, int deviceID) {
        this.checkForOpenPrintWriter();
        this.asciiDump.delete(0, this.asciiDump.length());
        if (this.bSkipLogging && header != null) {
            if (header[12] == 89 && header[13] == 81 || jobID == "-1" && header[12] == 89 && header[13] == 52) {
                this.delayedWriteBuffer = null;
                return;
            }
        } else if (this.bSkipLogging && count == 14 && offset == 0 && type == 1 && (stream[12] == 89 && stream[13] == 81 || stream[12] == 89 && stream[13] == 52)) {
            this.delayedWriteBuffer = null;
            return;
        }
        if (this.delayedWriteBuffer != null) {
            byte[] delayedWriteBufferCopy = (byte[])this.delayedWriteBuffer.clone();
            this.delayedWriteBuffer = null;
            this.dump(new byte[0], 0, 0, 0, delayedWriteBufferCopy, jobID, deviceID);
        }
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            int i;
            if (type == 1) {
                this.buffer.append(lineSeparator).append("Sent: (").append(this.getCurrentTime()).append(") [ThreadID = ").append(Thread.currentThread().getId()).append(" ] [JobNumber = ").append(jobID).append(" ] [DeviceID = " + deviceID + " ]").append(lineSeparator);
            } else {
                this.buffer.append(lineSeparator).append("Received: (").append(this.getCurrentTime()).append(") [ThreadID = ").append(Thread.currentThread().getId()).append(" ] [JobNumber = ").append(jobID).append(" ] [DeviceID = " + deviceID + " ]").append(lineSeparator);
            }
            this.buffer.append("Header:").append(lineSeparator);
            if (header != null) {
                this.formatOffset(0);
                for (i = 0; i < 14; ++i) {
                    this.appendCurrent(header[i]);
                }
                this.formatLastLine(14);
            } else {
                this.formatOffset(0);
                for (i = 0; i < 14; ++i) {
                    this.appendCurrent(stream[i]);
                }
                this.formatLastLine(14);
                offset = 14;
                count -= 14;
            }
            int x = offset % this.bytesPerLine - 1;
            int end = count;
            if (count > 0) {
                this.buffer.append("Message:").append(lineSeparator);
            }
            if (stream != null) {
                if (stream.length >= offset + count) {
                    end += offset;
                }
                if (end > 0) {
                    this.formatOffset(0);
                }
                for (i = offset; i < end; ++i) {
                    this.appendCurrent(stream[i]);
                    if ((i - x) % this.bytesPerLine != 0) continue;
                    this.formatLine();
                    if (i + 1 >= end) continue;
                    this.formatOffset(i - offset + 1);
                }
                if (this.asciiDump.length() != 0) {
                    this.formatLastLine(count % this.bytesPerLine);
                }
            }
            PrintWriter printWriter = this.output;
            synchronized (printWriter) {
                this.output.println(this.buffer);
            }
            this.buffer.delete(0, this.buffer.length());
        }
        this.output.flush();
    }

    private synchronized void appendCurrent(byte val) {
        this.appendCurrentHex(val);
        if (val >= 32 && val < 127) {
            this.asciiDump.append((char)val);
        } else {
            this.asciiDump.append(".");
        }
    }

    private synchronized void appendCurrentHex(byte val) {
        int len;
        String x = Integer.toHexString(val).toUpperCase();
        if (x.length() == 1) {
            x = "0" + x;
        }
        if ((len = x.length()) > 2) {
            x = x.substring(len - 2, len);
        }
        if ((x = x + " ").length() == 2) {
            this.buffer.append("  ").append(x);
        } else if (x.length() == 3) {
            this.buffer.append(" ").append(x);
        } else {
            this.buffer.append(x);
        }
    }

    private synchronized void formatLine() {
        this.asciiDump.insert(0, "     ");
        this.buffer.append(this.asciiDump.toString()).append(lineSeparator);
        this.asciiDump.delete(0, this.asciiDump.length());
    }

    private synchronized void formatLastLine(int len) {
        if (len != 0) {
            for (int i = len; i < this.bytesPerLine; ++i) {
                this.asciiDump.insert(0, "    ");
            }
        }
        this.formatLine();
    }

    private void formatOffset(int Num) {
        this.buffer.append("  ");
        String x = Integer.toHexString(Num);
        int len = x.length();
        while (len++ < 4) {
            this.buffer.append("0");
        }
        this.buffer.append(x.toUpperCase() + ": ");
    }

    public final synchronized void logApiTime(String text, String jobID, int deviceID) {
        this.checkForOpenPrintWriter();
        this.output.println();
        this.output.println("(" + this.getCurrentTime() + ") [ThreadID = " + Thread.currentThread().getId() + "] [JobNumber = " + jobID + "] [DeviceID = " + deviceID + "]");
        this.output.println(text);
        this.output.flush();
    }

    public final synchronized void logApi(String text) {
        this.checkForOpenPrintWriter();
        this.output.println();
        this.output.println("(" + this.getCurrentTime() + ") [ThreadID = " + Thread.currentThread().getId() + "]");
        this.output.println(text);
        this.output.flush();
    }

    @Override
    public final synchronized void close() {
        if (this.cantClose) {
            return;
        }
        --this.refCount;
        if (this.refCount <= 0) {
            this.output.close();
        }
    }
}

