/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.BufferUtils;

class MessageHeader {
    static final int HEADER_SIZE = 14;
    byte[] hBuffer;

    MessageHeader() {
        this.hBuffer = new byte[14];
    }

    MessageHeader(byte[] buffer) throws Exception {
        if (buffer.length != 14) {
            throw new Exception("MessageHeader buffer must be 14 bytes!");
        }
        this.hBuffer = buffer;
    }

    static void setMessageLength(byte[] buffer, int value) {
        BufferUtils.setRaw4ByteInt(buffer, 0, value);
    }

    int getMessageLength() {
        return BufferUtils.get4ByteIntRaw(this.hBuffer, 0);
    }

    static void setCount(byte[] buffer, int value) {
        BufferUtils.setRaw4ByteInt(buffer, 4, value);
    }

    int getCount() {
        return BufferUtils.get4ByteIntRaw(this.hBuffer, 4);
    }

    static void setStatementID(byte[] buffer, int value) {
        BufferUtils.setRaw4ByteInt(buffer, 8, value);
    }

    int getStatementID() {
        return BufferUtils.get4ByteIntRaw(this.hBuffer, 8) & Integer.MAX_VALUE;
    }

    static void setMsgType(byte[] buffer, byte[] value) {
        buffer[12] = value[0];
        buffer[13] = value[1];
    }

    void setError(int value) {
        BufferUtils.set2ByteIntRaw(this.hBuffer, 12, (short)value);
    }

    int getError() {
        return this.hBuffer[12] & 0xFF | (this.hBuffer[13] & 0xFF) << 8;
    }

    int getHighBit() {
        return BufferUtils.get4ByteIntRaw(this.hBuffer, 8) & Integer.MIN_VALUE;
    }
}

