/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.BufferWrite;
import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.LogFileStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public final class OutStream {
    private LogFileStream logFile;
    public BufferWrite wire;
    OutputStream outputStream;
    private int protocolVersion = 69;
    private IRISConnection connection;

    public OutStream(OutputStream output, LogFileStream LF) {
        this.outputStream = output;
        this.logFile = LF;
        this.wire = new BufferWrite((String)null);
    }

    public OutStream(IRISConnection conn) {
        this.outputStream = conn.device.outStream;
        this.wire = new BufferWrite(conn.connectionInfo);
        this.connection = conn;
        this.logFile = this.connection.conParams.logFile;
    }

    public void setDevOutStream(OutputStream out) {
        this.outputStream = out;
    }

    public void setConnection(IRISConnection conn) {
        this.connection = conn;
        this.wire.setConnectionInfo(conn.connectionInfo);
    }

    public final synchronized void send(int count) throws SQLException {
        try {
            if (this.connection == null) {
                this.wire.dumpData(this.outputStream, count, this.logFile, "-1", -1);
            } else {
                this.wire.dumpData(this.outputStream, count, this.logFile, this.connection.connectionInfo.srvJobNumber, this.connection.device.hashCode());
            }
        }
        catch (IOException e) {
            throw new SQLException("Communication link failure: " + e.getMessage(), "08S01", 461);
        }
    }

    final synchronized BufferWrite setWire(BufferWrite w) {
        BufferWrite old = this.wire;
        this.wire = w;
        return old;
    }
}

