/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.BufferWrite;
import com.intersystems.jdbc.Descriptor;
import com.intersystems.jdbc.ParameterCollection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Parameter
extends Descriptor {
    int truncate;
    Object minVal;
    Object maxVal;
    List<Object> values;
    Object value;
    ParameterMode mode;
    boolean bound;
    List<Object> whatever;
    char paramType;
    boolean executeParam;
    public boolean parsermatched;
    public ParameterCollection matchedParamaterList;
    BufferWrite outBuffer = null;

    Parameter() {
        this.mode = ParameterMode.UNKNOWN;
        this.values = new ArrayList<Object>();
        this.whatever = new ArrayList<Object>();
        this.bound = false;
        this.value = null;
        this.name = "";
        this.bound = false;
        this.scale = -1;
        this.outBuffer = null;
    }

    Parameter(ParameterMode x) {
        this.mode = x;
        this.values = new ArrayList<Object>();
        this.whatever = new ArrayList<Object>();
        this.parsermatched = false;
        this.matchedParamaterList = null;
        this.paramType = (char)99;
        this.outBuffer = null;
    }

    public Parameter(Object x) {
        this.mode = ParameterMode.REPLACED_LITERAL;
        this.values = new ArrayList<Object>();
        this.whatever = new ArrayList<Object>();
        this.values.add(x);
        this.whatever.add(null);
        this.outBuffer = null;
    }

    Parameter(int t, int p, int s, int n, String nm, ParameterMode m, Object v) {
        this.type = t;
        this.precision = p;
        this.scale = s;
        this.nullable = n;
        this.name = nm;
        this.mode = m;
        if (this.mode == ParameterMode.REPLACED_LITERAL) {
            this.values = new ArrayList<Object>();
            this.values.add(v);
        }
        this.outBuffer = null;
    }

    public Parameter(String val, ParameterMode replacedLiteral) {
        this.mode = replacedLiteral;
        this.value = val;
        this.bound = false;
        this.parsermatched = false;
        this.matchedParamaterList = null;
        this.paramType = (char)99;
        this.outBuffer = null;
    }

    public Parameter(ParameterMode mode, char type) {
        this.mode = mode;
        this.value = null;
        this.parsermatched = false;
        this.matchedParamaterList = null;
        this.paramType = type;
    }

    public Parameter(String val, ParameterMode mode, char type) {
        this.mode = mode;
        this.value = val;
        this.parsermatched = false;
        this.matchedParamaterList = null;
        this.paramType = type;
    }

    public Parameter(byte[] bt, ParameterMode mode, int dbType, char ptype) {
        this.mode = mode;
        this.type = dbType;
        this.value = bt;
        this.bound = false;
        this.parsermatched = false;
        this.matchedParamaterList = null;
        this.paramType = ptype;
    }

    void copyCachedInfo(Parameter desc, boolean copyReplaced) {
        this.type = desc.type;
        this.precision = desc.precision;
        this.scale = desc.scale;
        this.nullable = desc.nullable;
        this.name = desc.name;
        this.truncate = desc.truncate;
        this.minVal = desc.minVal;
        this.maxVal = desc.maxVal;
        this.outBuffer = null;
        this.slotPosition = desc.slotPosition;
        if (this.mode != ParameterMode.REPLACED_LITERAL && desc.mode != ParameterMode.REPLACED_LITERAL && desc.mode != ParameterMode.UNKNOWN) {
            this.mode = desc.mode;
        }
        if (!copyReplaced) {
            return;
        }
        if (desc.mode == ParameterMode.REPLACED_LITERAL) {
            this.mode = ParameterMode.REPLACED_LITERAL;
            this.values = new ArrayList<Object>();
            this.whatever = new ArrayList<Object>();
            this.values.add(desc.values.get(0));
            this.whatever.add(null);
        }
    }

    public Parameter(Parameter p) {
        this.name = p.name;
        this.mode = p.mode;
        this.type = p.type;
        this.value = p.value;
        this.bound = p.bound;
        this.parsermatched = p.parsermatched;
        this.matchedParamaterList = p.matchedParamaterList;
        this.paramType = p.paramType;
        this.truncate = p.truncate;
        this.minVal = p.minVal;
        this.maxVal = p.maxVal;
    }

    public Parameter Clone() {
        Parameter p1 = new Parameter(this.name, this.mode);
        p1.type = this.type;
        p1.value = this.value;
        p1.bound = this.bound;
        p1.parsermatched = this.parsermatched;
        p1.matchedParamaterList = this.matchedParamaterList;
        p1.paramType = this.paramType;
        p1.truncate = this.truncate;
        p1.minVal = this.minVal;
        p1.maxVal = this.maxVal;
        return p1;
    }

    void bind(Object val, Object what, int parameterSets) throws SQLException {
        if (val instanceof ArrayList) {
            this.values = (List)val;
        } else {
            int size;
            if (parameterSets == 0) {
                this.values.clear();
                this.whatever.clear();
            }
            if (parameterSets + 1 < (size = this.values.size()) || size < parameterSets) {
                throw new SQLException("Not all parameters bound for this set.", "S1000");
            }
            if (parameterSets == size) {
                this.values.add(val);
                this.whatever.add(what);
            } else {
                this.values.set(size - 1, val);
                this.whatever.set(size - 1, what);
            }
        }
        this.bound = true;
        this.mode = this.mode == ParameterMode.OUTPUT || this.mode == ParameterMode.INPUT_OUTPUT ? ParameterMode.INPUT_OUTPUT : ParameterMode.INPUT;
        this.outBuffer = null;
    }

    boolean isVector() {
        return this.slotPosition > 8191;
    }

    public void SetName(String sName) {
        this.name = sName;
    }

    public String GetName() {
        return this.name;
    }

    public ParameterMode GetMode() {
        return this.mode;
    }

    public void SetMode(ParameterMode mode) {
        this.mode = mode;
    }

    public Object GetValue() {
        return this.value;
    }

    public Object GetValues() {
        return this.values;
    }

    public boolean GetBound() {
        return this.bound;
    }

    public char GetParamType() {
        return this.paramType;
    }

    public boolean isExecParam() {
        return this.executeParam;
    }

    public void SetExecParam(boolean value) {
        this.executeParam = value;
    }

    public static enum ParameterMode {
        UNKNOWN,
        INPUT,
        INPUT_OUTPUT,
        UNUSED,
        OUTPUT,
        REPLACED_LITERAL,
        DEFAULT_PARAMETER,
        RETURN_VALUE;

    }
}

