/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.ListReader;
import com.intersystems.jdbc.Parameter;
import com.intersystems.jdbc.ResultSetRow;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ParameterCollection
implements List<Parameter> {
    private ArrayList<Parameter> params;
    private HashMap<String, Integer> paramNames;
    private ResultSetRow paramRow;
    ResultSetRow paramDefValues;
    int[] userIndex;
    int userParamCnt = 0;
    int vectorParms = 0;
    byte[] rowOfDefaultValues;
    int[] outParamSlots;
    int node_number;
    boolean hasBoundByParamName = false;
    boolean arrayBound = false;

    public ParameterCollection() {
        this.params = new ArrayList();
        this.hasBoundByParamName = false;
    }

    ParameterCollection(ParameterCollection paramList, boolean shallowCopy) {
        if (shallowCopy) {
            this.params = paramList.params;
            this.paramNames = paramList.paramNames;
        } else {
            this.params = new ArrayList(paramList.size());
            for (int i = 0; i < paramList.size(); ++i) {
                Parameter parameter = new Parameter();
                parameter.copyCachedInfo(paramList.get(i), true);
                this.add(parameter);
            }
        }
        this.userParamCnt = paramList.userParamCnt;
        this.userIndex = paramList.userIndex;
        if (paramList.hasNamedParameters()) {
            this.updateNames();
        }
        this.outParamSlots = paramList.outParamSlots;
        this.paramDefValues = paramList.paramDefValues;
        this.node_number = paramList.node_number;
        this.hasBoundByParamName = false;
        this.rowOfDefaultValues = paramList.rowOfDefaultValues;
        this.arrayBound = false;
        this.vectorParms = paramList.vectorParms;
    }

    public ParameterCollection(int i) {
        this.params = new ArrayList(i);
        this.hasBoundByParamName = false;
        this.arrayBound = false;
    }

    @Override
    public boolean add(Parameter e) {
        return this.params.add(e);
    }

    public boolean addUserParam(Parameter e) {
        ++this.userParamCnt;
        return this.params.add(e);
    }

    @Override
    public void add(int index, Parameter element) {
        this.params.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends Parameter> c) {
        return this.params.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Parameter> c) {
        return this.params.addAll(index, c);
    }

    @Override
    public void clear() {
        this.params.clear();
        if (this.paramNames != null) {
            this.paramNames.clear();
        }
        this.hasBoundByParamName = false;
        this.arrayBound = false;
    }

    @Override
    public boolean contains(Object o) {
        return this.params.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.params.containsAll(c);
    }

    @Override
    public Parameter get(int index) {
        return this.params.get(index);
    }

    public Parameter get(String name) throws SQLException {
        try {
            this.hasBoundByParamName = true;
            return this.params.get(this.paramNames.get(name.toUpperCase()));
        }
        catch (Exception ex) {
            return null;
        }
    }

    Parameter getUserParameter(int userParameterNumber) throws SQLException {
        try {
            return this.get(this.userIndex[userParameterNumber]);
        }
        catch (Exception e) {
            throw new SQLException("Invalid parameter number: " + userParameterNumber, "S1002", 463);
        }
    }

    public int getUserParameterNumber(String name) throws SQLException {
        try {
            Integer rc = this.paramNames.get(name.toUpperCase());
            if (rc != null) {
                for (int i = 1; i <= this.userParamCnt; ++i) {
                    if (this.userIndex[i] != rc) continue;
                    return i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new SQLException("No such parameter: " + name, "S1093", 466);
    }

    public int getParameterIndex(String name) throws SQLException {
        try {
            this.hasBoundByParamName = true;
            Integer rc = this.paramNames.get(name.toUpperCase());
            if (rc == null) {
                throw new SQLException("No such parameter: " + name, "S1093", 466);
            }
            return rc;
        }
        catch (Exception ex) {
            throw new SQLException("No such parameter: " + name, "S1093", 466);
        }
    }

    int getUserParameterIndex(int userParameterNumber) throws SQLException {
        try {
            int rInt = this.userIndex[userParameterNumber];
            if (rInt == -1) {
                throw new SQLException("Invalid parameter number: " + userParameterNumber, "S1002", 463);
            }
            return rInt;
        }
        catch (Exception e) {
            throw new SQLException("Invalid parameter number: " + userParameterNumber, "S1002", 463);
        }
    }

    int getListOffset(String parameterName) throws SQLException {
        return this.paramRow.rowIndex[this.getParameterIndex(parameterName)];
    }

    int getListOffset(int rawIndex) throws SQLException {
        try {
            return this.paramRow.rowIndex[rawIndex];
        }
        catch (Exception e) {
            throw new SQLException("Invalid parameter number " + rawIndex, "S1093", 466);
        }
    }

    int getUserListOffset(int userParameterNumber) throws SQLException {
        try {
            return this.paramRow.rowIndex[this.userIndex[userParameterNumber]];
        }
        catch (Exception e) {
            throw new SQLException("Invalid parameter number " + userParameterNumber, "S1002", 463);
        }
    }

    void prepListIndex(ListReader listReader) throws SQLException {
        this.paramRow = new ResultSetRow(this.size(), listReader);
    }

    void prepDefault(ListReader wire, int defItemCnt, int keyCount, boolean vector) throws SQLException {
        this.rowOfDefaultValues = wire.getByteArray();
        this.node_number = 1;
        this.paramDefValues = new ResultSetRow(defItemCnt, this.rowOfDefaultValues);
        this.outParamSlots = new int[defItemCnt];
        Arrays.fill(this.outParamSlots, -1);
        for (int u = keyCount; u < defItemCnt; ++u) {
            int len = this.paramDefValues.rowIndex[u + 1] - this.paramDefValues.rowIndex[u];
            if (len == 2) {
                if (this.rowOfDefaultValues[this.paramDefValues.rowIndex[u] + 1] == 1) {
                    this.outParamSlots[u] = 0;
                    ++this.node_number;
                    continue;
                }
                this.outParamSlots[u] = -2;
                continue;
            }
            if (len <= 2) continue;
            this.outParamSlots[u] = -2;
        }
        for (int g = 0; g < this.params.size(); ++g) {
            this.outParamSlots[(this.params.get((int)g).slotPosition & 0xDFFF) - 1] = g + 1;
        }
        for (int h = defItemCnt - 1; h >= 0; --h) {
            if (this.outParamSlots[h] != 0) continue;
            if (!vector) break;
            this.outParamSlots[h] = -3;
            --this.node_number;
            this.vectorParms = defItemCnt - h - 1;
            break;
        }
    }

    boolean hasVectorParm() {
        return this.vectorParms > 0;
    }

    @Override
    public int indexOf(Object o) {
        return this.params.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    public boolean hasNamedParameters() {
        return this.paramNames != null && !this.paramNames.isEmpty();
    }

    @Override
    public Iterator<Parameter> iterator() {
        return this.params.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.params.lastIndexOf(o);
    }

    @Override
    public ListIterator<Parameter> listIterator() {
        return this.params.listIterator();
    }

    @Override
    public ListIterator<Parameter> listIterator(int index) {
        return this.params.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.params.remove(o);
    }

    @Override
    public Parameter remove(int index) {
        return this.params.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.params.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.params.retainAll(c);
    }

    @Override
    public Parameter set(int index, Parameter element) {
        return this.params.set(index, element);
    }

    @Override
    public int size() {
        return this.params.size();
    }

    public int userParametersSize() {
        if (this.userIndex == null) {
            return this.params.size();
        }
        return this.userParamCnt;
    }

    @Override
    public List<Parameter> subList(int fromIndex, int toIndex) {
        return this.params.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.params.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.params.toArray(a);
    }

    public void updateNames() {
        this.paramNames = new HashMap(this.size() + 1);
        for (int i = 0; i < this.size(); ++i) {
            this.paramNames.put(this.params.get((int)i).name.toUpperCase(), i);
        }
    }

    void updateParameterInfo(ParameterCollection fromParams) throws SQLException {
        try {
            for (int i = 0; i < fromParams.size(); ++i) {
                this.get(i).copyCachedInfo(fromParams.get(i), false);
            }
            if (this.userParamCnt != fromParams.size()) {
                this.userParamCnt = fromParams.userParamCnt;
                this.userIndex = fromParams.userIndex;
            }
            if (fromParams.hasNamedParameters()) {
                this.updateNames();
            }
            this.outParamSlots = fromParams.outParamSlots;
            this.paramDefValues = fromParams.paramDefValues;
            this.node_number = fromParams.node_number;
            this.rowOfDefaultValues = fromParams.rowOfDefaultValues;
        }
        catch (Exception ex) {
            if (fromParams.size() != this.size()) {
                throw new SQLException("Parameter mismatch.");
            }
            throw ex;
        }
    }

    void updateParameters(ParameterCollection parseParams) {
        int cnt = parseParams.size();
        if (cnt == 0) {
            return;
        }
        this.userIndex = new int[cnt + 1];
        int u = 0;
        block5: for (int i = 0; i < cnt; ++i) {
            Parameter parameter = parseParams.get(i);
            switch (parameter.type) {
                case 63: {
                    this.addUserParam(new Parameter());
                    this.userIndex[++u] = cnt;
                    continue block5;
                }
                case 100: {
                    this.add(new Parameter(Parameter.ParameterMode.DEFAULT_PARAMETER));
                    continue block5;
                }
                case 99: {
                    this.add(new Parameter(parameter.GetValue()));
                    continue block5;
                }
                default: {
                    throw new Error("Should not have gotten here...");
                }
            }
        }
        this.userParamCnt = u;
    }
}

