/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.IRISStatement;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class PrepareCollection
extends HashMap<Integer, IRISConnection.CachedPrepare> {
    final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    HashMap<String, Integer> sqlToId = new HashMap();
    private int unownedCnt = 0;
    int cachedStatementsToRemove = 100;
    private static final long serialVersionUID = 1L;

    PrepareCollection() {
    }

    @Override
    public void clear() {
        this.rwl.writeLock().lock();
        try {
            super.clear();
            this.sqlToId.clear();
            this.unownedCnt = 0;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRISConnection.CachedPrepare remove(Object key) {
        this.rwl.writeLock().lock();
        try {
            IRISConnection.CachedPrepare cp = (IRISConnection.CachedPrepare)super.get(key);
            if (cp == null) {
                IRISConnection.CachedPrepare cachedPrepare = null;
                return cachedPrepare;
            }
            this.sqlToId.remove(cp.sqlText + cp.additionalParameterInfo.toString());
            if (cp.ownedBy == null) {
                --this.unownedCnt;
            }
            IRISConnection.CachedPrepare cachedPrepare = (IRISConnection.CachedPrepare)super.remove(key);
            return cachedPrepare;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public IRISConnection.CachedPrepare get(Object key) {
        this.rwl.readLock().lock();
        try {
            IRISConnection.CachedPrepare cachedPrepare = (IRISConnection.CachedPrepare)super.get(key);
            return cachedPrepare;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRISConnection.CachedPrepare put(Integer key, IRISConnection.CachedPrepare value) {
        this.rwl.writeLock().lock();
        try {
            if (super.containsKey(key)) {
                IRISConnection.CachedPrepare cachedPrepare = null;
                return cachedPrepare;
            }
            IRISConnection.CachedPrepare cp = value;
            String sqlKey = cp.sqlText + cp.additionalParameterInfo.toString();
            if (this.sqlToId.containsKey(sqlKey)) {
                IRISConnection.CachedPrepare cachedPrepare = null;
                return cachedPrepare;
            }
            this.sqlToId.put(sqlKey, key);
            if (cp.ownedBy == null) {
                ++this.unownedCnt;
            }
            IRISConnection.CachedPrepare cachedPrepare = super.put(key, value);
            return cachedPrepare;
        }
        catch (Exception ex) {
            IRISConnection.CachedPrepare cachedPrepare = null;
            return cachedPrepare;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRISConnection.CachedPrepare GetStatement(String sqlText) {
        this.rwl.readLock().lock();
        try {
            Integer key = this.sqlToId.get(sqlText);
            IRISConnection.CachedPrepare cachedPrepare = (IRISConnection.CachedPrepare)super.get(key);
            return cachedPrepare;
        }
        catch (Exception ex) {
            IRISConnection.CachedPrepare cachedPrepare = null;
            return cachedPrepare;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRISConnection.CachedPrepare GetStatement(String sqlText, IRISStatement cmd) {
        this.rwl.readLock().lock();
        try {
            Integer key = this.sqlToId.get(sqlText);
            IRISConnection.CachedPrepare cp = (IRISConnection.CachedPrepare)super.get(key);
            if (cp != null) {
                if (cp.ownedBy != null) {
                    IRISConnection.CachedPrepare cachedPrepare = null;
                    return cachedPrepare;
                }
                cp.ownedBy = cmd;
                --this.unownedCnt;
                ++cp.refCount;
            }
            IRISConnection.CachedPrepare cachedPrepare = cp;
            return cachedPrepare;
        }
        catch (Exception ex) {
            IRISConnection.CachedPrepare cachedPrepare = null;
            return cachedPrepare;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean noOwner(int key) {
        this.rwl.readLock().lock();
        try {
            IRISConnection.CachedPrepare cp = (IRISConnection.CachedPrepare)super.get(key);
            if (cp == null || cp.ownedBy == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOwner(int key, IRISStatement cmd) {
        this.rwl.readLock().lock();
        try {
            IRISConnection.CachedPrepare cp = (IRISConnection.CachedPrepare)super.get(key);
            if (cp != null && cmd == cp.ownedBy) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsBeingExecuted(int key, IRISStatement cmd) {
        this.rwl.readLock().lock();
        try {
            IRISConnection.CachedPrepare cp = (IRISConnection.CachedPrepare)super.get(key);
            if (cp != null && null == cp.ownedBy) {
                cp.ownedBy = cmd;
                --this.unownedCnt;
            }
            return;
        }
        catch (Exception ex) {
            return;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsNotBeingExecuted(int key, IRISStatement cmd) {
        this.rwl.readLock().lock();
        try {
            IRISConnection.CachedPrepare cp = (IRISConnection.CachedPrepare)super.get(key);
            if (cp != null && cmd == cp.ownedBy) {
                cp.ownedBy = null;
                ++this.unownedCnt;
            }
            return;
        }
        catch (Exception ex) {
            return;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    void releaseWriteLock() {
        this.rwl.writeLock().unlock();
    }

    int getUnownedCount() {
        this.rwl.readLock().lock();
        try {
            int n = this.unownedCnt;
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    void writeLock() {
        this.rwl.writeLock().lock();
    }
}

