/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.DBList;
import com.intersystems.jdbc.IRISStatement;
import com.intersystems.jdbc.ListItem;
import com.intersystems.jdbc.ListReader;
import java.sql.SQLException;
import java.util.List;

class ResultSetRow {
    int[] rowIndex;
    int[] colIndex;
    int[] colIndexOffsets;
    boolean m_fastSelect;
    ListItem li;
    boolean newBuffer;
    boolean partialIndex;
    private int m_colCount;
    private int m_firstOffset;

    ResultSetRow(int count, int offset) {
        this.m_colCount = count;
        this.m_firstOffset = offset;
        this.newBuffer = true;
        this.partialIndex = false;
    }

    ResultSetRow(int rowcount, List<IRISStatement.Column> cols, int offset) {
        int colIndexSize = cols.size() + 1;
        this.colIndex = new int[colIndexSize];
        this.colIndex[0] = 0;
        for (int i = 0; i < cols.size(); ++i) {
            this.colIndex[i + 1] = cols.get((int)i).slotPosition - 1;
        }
        this.m_fastSelect = true;
        this.li = null;
        this.m_colCount = rowcount;
        this.m_firstOffset = offset;
        this.newBuffer = true;
        this.partialIndex = false;
    }

    ResultSetRow(List<IRISStatement.Column> cols, int rowcount, int offset) {
        int colIndexSize = cols.size();
        this.colIndex = new int[colIndexSize];
        for (int i = 0; i < colIndexSize; ++i) {
            this.colIndex[i] = cols.get((int)i).slotPosition - 1;
        }
        this.m_fastSelect = true;
        this.li = null;
        this.m_colCount = rowcount;
        this.m_firstOffset = offset;
        this.newBuffer = true;
        this.partialIndex = false;
    }

    ResultSetRow(int count, ListReader outParamList) throws SQLException {
        this.m_colCount = count;
        this.m_firstOffset = outParamList.getOffset();
        this.newBuffer = true;
        this.partialIndex = false;
        this.indexRow(outParamList.getBuffer(), outParamList.getEndLength());
    }

    ResultSetRow(int count, byte[] inBuffer) throws SQLException {
        this.m_colCount = count;
        this.m_firstOffset = 0;
        this.newBuffer = true;
        this.partialIndex = false;
        this.indexRow(inBuffer, inBuffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Update(int[] index) {
        this.newBuffer = false;
        if (this.m_fastSelect) {
            int colIndexSize = this.colIndex.length;
            this.colIndexOffsets = new int[colIndexSize + 1];
            for (int ii = 0; ii < colIndexSize; ++ii) {
                this.colIndexOffsets[ii] = index[this.colIndex[ii]];
            }
            this.colIndexOffsets[colIndexSize] = this.li.nextOffset;
            ResultSetRow resultSetRow = this;
            synchronized (resultSetRow) {
                this.rowIndex = this.colIndexOffsets;
            }
            return;
        }
        ResultSetRow resultSetRow = this;
        synchronized (resultSetRow) {
            this.rowIndex = index;
        }
    }

    boolean indexRow(byte[] buffer, int Length, int offset) throws SQLException {
        this.m_firstOffset = offset;
        this.newBuffer = true;
        return this.indexRow(buffer, Length);
    }

    boolean indexRow(byte[] buffer, int Length) throws SQLException {
        int i = 0;
        int j = 0;
        int[] index = new int[this.m_colCount + 1];
        if (this.newBuffer) {
            i = this.m_firstOffset;
            this.m_firstOffset = 0;
        } else {
            i = this.rowIndex[this.rowIndex.length - 1];
        }
        this.partialIndex = false;
        if (this.m_fastSelect) {
            if (i < Length) {
                if (this.li == null) {
                    this.li = new ListItem(buffer);
                } else if (this.newBuffer) {
                    this.li.buffer = buffer;
                }
                Length = DBList.getListElement(i, this.li);
                i = this.li.dataOffset;
                if (this.li.dataLength == 0) {
                    while (j < this.m_colCount) {
                        index[j] = -1;
                        ++j;
                    }
                    this.Update(index);
                    return true;
                }
            } else {
                if (this.rowIndex != null) {
                    this.rowIndex[this.rowIndex.length - 1] = 0;
                }
                return false;
            }
        }
        while (j <= this.m_colCount) {
            if (i > Length) {
                throw new SQLException("CacheResultSetRow::createIndexRowCursor offset out of range.");
            }
            if (i == Length) {
                if (j != 0) {
                    if (this.m_fastSelect) {
                        while (j <= this.m_colCount) {
                            index[j - 1] = -1;
                            ++j;
                        }
                        this.Update(index);
                        return true;
                    }
                    this.partialIndex = true;
                    if (this.newBuffer && this.rowIndex != null) {
                        this.rowIndex[this.rowIndex.length - 1] = 0;
                    }
                } else if (this.rowIndex != null) {
                    this.rowIndex[this.rowIndex.length - 1] = 0;
                }
                return false;
            }
            if (j == 0) {
                index[0] = i;
            } else {
                if (buffer[i] != 0) {
                    i += buffer[i] & 0xFF;
                } else if (buffer[i + 1] == 0 && buffer[i + 2] == 0) {
                    if (i + 6 < Length) {
                        i += (buffer[i + 3] & 0xFF | (buffer[i + 4] & 0xFF) << 8 | (buffer[i + 5] & 0xFF) << 16) + 7;
                    }
                } else if (i + 2 < Length) {
                    i += (buffer[i + 1] & 0xFF | (buffer[i + 2] & 0xFF) << 8) + 3;
                }
                index[j] = i;
            }
            ++j;
        }
        this.Update(index);
        return true;
    }

    static int[] indexLists(byte[] buffer, int Length, int startingOffset, int totalLists) throws SQLException {
        int i = startingOffset;
        int[] index = new int[totalLists + 1];
        for (int j = 0; j <= totalLists; ++j) {
            if (i >= Length) {
                throw new SQLException("ListIndex error, offset out of range.");
            }
            if (j == 0) {
                index[0] = i;
                continue;
            }
            if (buffer[i] != 0) {
                i += buffer[i] & 0xFF;
            } else if (buffer[i + 1] == 0 && buffer[i + 2] == 0) {
                if (i + 6 < Length) {
                    i += (buffer[i + 3] & 0xFF | (buffer[i + 4] & 0xFF) << 8 | (buffer[i + 5] & 0xFF) << 16) + 7;
                }
            } else if (i + 2 < Length) {
                i += (buffer[i + 1] & 0xFF | (buffer[i + 2] & 0xFF) << 8) + 3;
            }
            index[j] = i;
        }
        return index;
    }

    int getOffset(int Index2) {
        return this.rowIndex[Index2];
    }

    int getLastOffset() {
        return this.rowIndex[this.rowIndex.length - 1];
    }
}

