/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.IRISConnection;
import java.sql.SQLException;

class SQLValidationException
extends SQLException {
    String prefix = "[SQLCODE: <-104>:<Field validation failed in INSERT> <Field '";
    String typeError = "";
    String parName = "";
    static int vendorCode = 104;
    Integer rowNumber = null;

    public SQLValidationException(String reason) {
        super(reason, IRISConnection.getSQLState(vendorCode), vendorCode);
        if (reason != null) {
            this.typeError = reason;
        }
    }

    public SQLValidationException(String error, String reason, int code, boolean server) {
        super(reason, IRISConnection.getSQLState(code), code);
        if (reason != null) {
            this.typeError = reason;
        }
        if (error != null) {
            this.prefix = server ? "[SQLCODE: <-" + Integer.toString(code) + ">:" + error : error;
        }
    }

    public SQLValidationException(String string, String state, int rc) {
        super(string, state, rc);
    }

    public void setRowNumber(Integer number) {
        this.rowNumber = number;
    }

    public Integer getRowNumber() {
        return this.rowNumber;
    }

    @Override
    public String getMessage() {
        StringBuilder msg = new StringBuilder();
        if (this.rowNumber != null) {
            msg.append("Batch Row: " + this.rowNumber + " ");
        }
        msg.append(this.prefix);
        msg.append(this.parName);
        msg.append("' ");
        msg.append(this.typeError);
        for (SQLValidationException ex = (SQLValidationException)this.getNextException(); ex != null; ex = (SQLValidationException)ex.getNextException()) {
            msg.append(">];\n");
            msg.append(ex.prefix);
            msg.append(ex.parName);
            msg.append("' ");
            msg.append(ex.typeError);
        }
        return msg.append(">]").toString();
    }
}

