/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;

class TLSimpleDateFormat {
    private SimpleDateFormat sdf;
    private static ThreadLocal<HashMap<String, SimpleDateFormat>> tlMaps = new ThreadLocal<HashMap<String, SimpleDateFormat>>(){

        @Override
        protected HashMap<String, SimpleDateFormat> initialValue() {
            return new HashMap<String, SimpleDateFormat>();
        }
    };

    SimpleDateFormat getDateFormat(String format) {
        if (this.sdf == null) {
            HashMap<String, SimpleDateFormat> mapFormats = tlMaps.get();
            this.sdf = mapFormats.get(format);
            if (this.sdf == null) {
                this.sdf = new SimpleDateFormat(format);
                mapFormats.put(format, this.sdf);
            } else {
                this.sdf.setCalendar(Calendar.getInstance());
            }
        }
        return this.sdf;
    }

    TLSimpleDateFormat(String format) {
        this.getDateFormat(format);
    }

    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
        return this.sdf.format(date, toAppendTo, pos);
    }

    public Object parseObject(String source, ParsePosition pos) {
        return this.sdf.parse(source, pos);
    }

    public Date parse(String day) throws ParseException {
        return this.sdf.parse(day);
    }

    public void setTimeZone(TimeZone tz) {
        this.sdf.setTimeZone(tz);
    }

    public void setCalendar(Calendar cal) {
        this.sdf.setCalendar(cal);
    }

    public String format(Date date) {
        return this.sdf.format(date);
    }
}

