/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.ListWriter;
import com.intersystems.jdbc.SQLValidationException;
import com.intersystems.jdbc.TLSimpleDateFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Instant;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class ValidateNFormat {
    static final byte ITEM_UNDEF = -1;
    static final byte ITEM_PLACEHOLDER = 0;
    static final byte ITEM_ASCII = 1;
    static final byte ITEM_UNICODE = 2;
    static final byte ITEM_XUNICODE = 3;
    static final byte ITEM_POSINT = 4;
    static final byte ITEM_NEGINT = 5;
    static final byte ITEM_POSNUM = 6;
    static final byte ITEM_NEGNUM = 7;
    static final byte ITEM_DOUBLE = 8;
    static final long TWO_SIXTY = 0x1000000000000000L;
    static final long TWO_SIXTY_NEG = -1152921504606846976L;
    static final long TWO_SIXTY_NEG_REV = -6917529027641081857L;
    static final long TYPE_TAG_MASK = -8070450532247928833L;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_HOUR = 3600000L;
    private static final TimeZone s_TimeZone = TimeZone.getDefault();
    private static final long HOROLOG_ZERO = -4070908800000L;
    private static final long CALENDAR_CHANGE_MAX = -12218497200000L;
    private static final long CALENDAR_CHANGE_MIN = -12219292800000L;

    static int normalizeToInt(Object value) throws SQLValidationException {
        try {
            int outInt = 0;
            long tmplong = -1L;
            if (value instanceof Integer) {
                outInt = (Integer)value;
            } else if (value instanceof String) {
                tmplong = ValidateNFormat.parseLongTruncate((String)value);
                outInt = (int)tmplong;
            } else if (value instanceof BigDecimal) {
                tmplong = ((BigDecimal)value).longValue();
                outInt = (int)tmplong;
            } else if (value instanceof BigInteger) {
                tmplong = ((BigInteger)value).longValue();
                outInt = (int)tmplong;
            } else if (value instanceof Double) {
                tmplong = ((Double)value).longValue();
                outInt = (int)tmplong;
            } else if (value instanceof Float) {
                tmplong = ((Float)value).longValue();
                outInt = (int)tmplong;
            } else if (value instanceof Long) {
                tmplong = (Long)value;
                outInt = (int)tmplong;
            } else if (value instanceof Short) {
                outInt = ((Short)value).intValue();
            } else if (value instanceof Byte) {
                outInt = ((Byte)value).intValue();
            } else if (value instanceof Boolean) {
                outInt = ((Boolean)value).booleanValue() ? 1 : 0;
            } else {
                throw new Exception();
            }
            if (tmplong != -1L && (long)outInt != tmplong) {
                throw new SQLValidationException("(" + value.getClass().getName() + ": " + tmplong + ") out of range)");
            }
            return outInt;
        }
        catch (SQLValidationException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new SQLValidationException("Unsupported int conversion: " + value.getClass().getName() + "\n" + ex.getMessage());
        }
    }

    static long parseLongTruncate(String value) throws SQLValidationException {
        long lng;
        block2: {
            try {
                lng = Long.parseLong(value);
            }
            catch (Exception ex) {
                BigDecimal bd = new BigDecimal(value).setScale(0, 1);
                lng = bd.longValue();
                BigDecimal tmpBd = new BigDecimal(lng);
                if (tmpBd.compareTo(bd) == 0) break block2;
                throw new SQLValidationException("(" + value.getClass().getName() + ": " + lng + ") out of Long range)");
            }
        }
        return lng;
    }

    static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    static Time parseTimeStringToTime(String st, Calendar cal) throws Exception {
        java.util.Date d;
        String format = "HH:mm:ss";
        TLSimpleDateFormat dateFormat = new TLSimpleDateFormat(format);
        int indexTime = st.indexOf(":");
        if (indexTime != -1) {
            if (indexTime > 3) {
                st = st.substring(indexTime - 3, st.length()).trim();
            }
        } else {
            try {
                BigDecimal bd = new BigDecimal(st);
                return ValidateNFormat.TimeFromHorolog(bd, cal);
            }
            catch (Exception bd) {
                // empty catch block
            }
        }
        try {
            if (cal != null) {
                dateFormat.setCalendar(cal);
            }
            d = dateFormat.parse(st);
        }
        catch (ParseException e) {
            try {
                String[] sOut = st.split(Pattern.quote(":"));
                int size = sOut.length;
                format = format.substring(0, size * 3 - 1);
                dateFormat = new TLSimpleDateFormat(format);
                if (cal != null) {
                    dateFormat.setCalendar(cal);
                }
                d = dateFormat.parse(st);
            }
            catch (ParseException ex) {
                throw new Exception("Invalid Time: String cannot convert to Time: " + ex.getMessage());
            }
        }
        return new Time(d.getTime() + (long)ValidateNFormat.getMilliSeconds(st));
    }

    static int HorologFromTime(long time, Calendar calendar) {
        long offset;
        int horolog;
        Timestamp ts = new Timestamp(time);
        if (ts.getNanos() > 0) {
            ts.setNanos(0);
            time = ts.getTime();
        }
        if ((horolog = (int)(((offset = null == calendar ? (long)s_TimeZone.getOffset(time) : (long)calendar.getTimeZone().getOffset(time)) + time) % 86400000L / 1000L)) < 0) {
            horolog = 86400 + horolog;
        }
        return horolog;
    }

    static Time TimeFromHorolog(int horolog, Calendar calendar) {
        int offsetAfter;
        int time = horolog * 1000;
        TimeZone tz = null == calendar ? s_TimeZone : calendar.getTimeZone();
        int offset = tz.getOffset(time);
        int offsetBefore = tz.getOffset((long)time - 86400000L);
        time = offsetBefore == (offsetAfter = tz.getOffset((long)time + 86400000L)) ? (time -= offset) : (offsetBefore > offsetAfter ? (time -= tz.getOffset((long)(time - offset) + 3600000L)) : (time -= tz.getOffset((long)(time - offset) - 3600000L)));
        return new Time(time);
    }

    static Time TimeFromHorolog(BigDecimal horolog, Calendar calendar) {
        int offsetAfter;
        int time = horolog.scaleByPowerOfTen(3).intValue();
        TimeZone tz = null == calendar ? s_TimeZone : calendar.getTimeZone();
        int offset = tz.getOffset(time);
        int offsetBefore = tz.getOffset((long)time - 86400000L);
        time = offsetBefore == (offsetAfter = tz.getOffset((long)time + 86400000L)) ? (time -= offset) : (offsetBefore > offsetAfter ? (time -= tz.getOffset((long)(time - offset) + 3600000L)) : (time -= tz.getOffset((long)(time - offset) - 3600000L)));
        return new Time(time);
    }

    static Date DateFromHorolog(int horolog, Calendar calendar) {
        Date date;
        long time = -4070908800000L + (long)horolog * 86400000L;
        if (time > -12219292800000L) {
            long offset = null == calendar ? (long)s_TimeZone.getOffset(time - (long)s_TimeZone.getOffset(time)) : (long)calendar.getTimeZone().getOffset(time - (long)calendar.getTimeZone().getOffset(time));
            date = new Date(time -= offset);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            if (0 != cal.get(11)) {
                date = new Date(time + 3600000L);
            }
        } else {
            Instant it = Instant.ofEpochSecond(time / 1000L, 0L);
            TLSimpleDateFormat dateFormat = new TLSimpleDateFormat("yyyy-MM-dd");
            try {
                java.util.Date ddt = dateFormat.parse(it.toString());
                date = new Date(ddt.getTime());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }
        return date;
    }

    static long PosixFromTimestamp(Timestamp ts, Calendar calendar) {
        long time = ts.getTime();
        int nanos = ts.getNanos();
        long offset = 0L;
        if (time < -12218497200000L) {
            String ss = ts.toString();
            if (ss.length() > 10) {
                ss = ss.replace(' ', 'T');
                ss = ss + "Z";
            } else {
                ss = ss + "T00:00:00Z";
            }
            Instant it = Instant.parse(ss);
            time = it.getEpochSecond() * 1000L + (long)(nanos / 1000000);
        } else {
            offset = null == calendar ? (long)s_TimeZone.getOffset(time - (long)s_TimeZone.getOffset(time)) : (long)calendar.getTimeZone().getOffset(time - (long)calendar.getTimeZone().getOffset(time));
        }
        long posix = (time + offset) * 1000L;
        if (nanos > 0 && nanos != nanos / 1000000 * 1000000) {
            posix += (long)((nanos - nanos / 1000000 * 1000000) / 1000);
        }
        if (posix < 0L) {
            return posix & 0x9FFFFFFFFFFFFFFFL;
        }
        return posix | 0x1000000000000000L;
    }

    static Date DateFromPosix(long posix, Calendar calendar) {
        long time0;
        if (posix >= 0L) {
            if (posix < 0x1000000000000000L) {
                throw new NumberFormatException("Posix value out of range!");
            }
            time0 = posix ^ 0x1000000000000000L;
        } else {
            if (posix > -6917529027641081857L) {
                throw new NumberFormatException("Posix value out of range!");
            }
            time0 = posix | 0xF000000000000000L;
        }
        long time = time0 / 1000L;
        if (time0 > -12219292800000L) {
            long offset = 0L;
            if (time > -12218497200000L) {
                offset = null == calendar ? (long)s_TimeZone.getOffset(time - (long)s_TimeZone.getOffset(time)) : (long)calendar.getTimeZone().getOffset(time - (long)calendar.getTimeZone().getOffset(time));
            }
            time -= offset;
        } else {
            Timestamp ts = ValidateNFormat.TimestampFromPosix(posix, calendar);
            time = ts.getTime();
        }
        return new Date(time);
    }

    static Time TimeFromPosix(long posix, Calendar calendar) {
        long time0;
        if (posix >= 0L) {
            if (posix < 0x1000000000000000L) {
                throw new NumberFormatException("Posix value out of range!");
            }
            time0 = posix ^ 0x1000000000000000L;
        } else {
            if (posix > -6917529027641081857L) {
                throw new NumberFormatException("Posix value out of range!");
            }
            time0 = posix | 0xF000000000000000L;
        }
        long time = time0 / 1000L % 86400000L;
        if (time < 0L) {
            time += 86400000L;
        }
        int offset = 0;
        offset = null == calendar ? s_TimeZone.getOffset(time - (long)s_TimeZone.getOffset(time)) : calendar.getTimeZone().getOffset(time - (long)calendar.getTimeZone().getOffset(time));
        return new Time(time -= (long)offset);
    }

    static Timestamp TimestampFromPosix(long posix, Calendar calendar) {
        long time0;
        if (posix >= 0L) {
            if (posix < 0x1000000000000000L) {
                throw new NumberFormatException("Posix value out of range!");
            }
            time0 = posix ^ 0x1000000000000000L;
        } else {
            if (posix > -6917529027641081857L) {
                throw new NumberFormatException("Posix value out of range!");
            }
            time0 = posix | 0xF000000000000000L;
        }
        long time = time0 / 1000L;
        long xNano = time0 % 1000000L * 1000L;
        if (xNano < 0L) {
            xNano = 1000000000L + xNano;
            time = (time / 1000L - 1L) * 1000L;
        }
        if (time > -12219292800000L) {
            int offsetAfter;
            TimeZone tz = null == calendar ? s_TimeZone : calendar.getTimeZone();
            int offset = tz.getOffset(time);
            int offsetBefore = tz.getOffset(time - 86400000L);
            time = offsetBefore == (offsetAfter = tz.getOffset(time + 86400000L)) ? (time -= (long)offset) : (offsetBefore > offsetAfter ? (time -= (long)tz.getOffset(time - (long)offset + 3600000L)) : (time -= (long)tz.getOffset(time - (long)offset - 3600000L)));
        } else {
            Instant it = Instant.ofEpochSecond(time / 1000L, 0L);
            TLSimpleDateFormat dateFormat = new TLSimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                String sTime = it.toString();
                sTime = sTime.replace('T', ' ');
                sTime = sTime.replace("Z", "");
                java.util.Date ddt = dateFormat.parse(sTime);
                Date date = new Date(ddt.getTime());
                time = date.getTime();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }
        Timestamp timestmp = new Timestamp(time);
        if (0L != xNano) {
            timestmp.setNanos((int)xNano);
        }
        return timestmp;
    }

    static BigDecimal TimeHorologFromTimestamp(Timestamp ts, Calendar calendar) {
        long ticks;
        long offset = null == calendar ? (long)s_TimeZone.getOffset(ticks) : (long)calendar.getTimeZone().getOffset(ticks);
        int horolog = (int)((offset + (ticks = ts.getTime())) % 86400000L);
        if (horolog < 0) {
            horolog = 86400000 + horolog;
        }
        BigDecimal bd = new BigDecimal(horolog).scaleByPowerOfTen(-3).add(new BigDecimal(ts.getNanos() % 1000000).scaleByPowerOfTen(-9));
        return bd;
    }

    static BigDecimal TimeHorologFromTime(Time time, Calendar calendar) {
        long ticks;
        long offset = null == calendar ? (long)s_TimeZone.getOffset(ticks) : (long)calendar.getTimeZone().getOffset(ticks);
        int horolog = (int)((offset + (ticks = time.getTime())) % 86400000L);
        if (horolog < 0) {
            horolog = 86400000 + horolog;
        }
        BigDecimal bd = new BigDecimal(horolog).scaleByPowerOfTen(-3);
        return bd;
    }

    static int HorologFromDate(long time, Calendar calendar, boolean bFromString) {
        long offset = 0L;
        int date = 0;
        if (!bFromString && time <= -12218497200000L) {
            Date dt1 = new Date(time);
            try {
                time = ValidateNFormat.parseDateStringToTicks(dt1.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            offset = null == calendar ? (long)s_TimeZone.getOffset(time) : (long)calendar.getTimeZone().getOffset(time);
            time += offset;
        }
        long delta = time - -4070908800000L;
        date = (int)(delta / 86400000L);
        if (delta % 86400000L < 0L) {
            --date;
        }
        return date;
    }

    static long PosixFromTime(long time, int nanos, Calendar calendar, boolean fromTime) {
        long offset = 0L;
        if (fromTime || time > -12218497200000L) {
            offset = null == calendar ? (long)s_TimeZone.getOffset(time) : (long)calendar.getTimeZone().getOffset(time);
        }
        long posix = (time + offset) * 1000L;
        if (nanos > 0 && nanos != nanos / 1000000 * 1000000) {
            posix += (long)((nanos - nanos / 1000000 * 1000000) / 1000);
        }
        if (posix < 0L) {
            return posix & 0x9FFFFFFFFFFFFFFFL;
        }
        return posix | 0x1000000000000000L;
    }

    static long NormalizedTime(long time, Calendar calendar) {
        long offset = 0L;
        if (null != calendar) {
            offset = calendar.getTimeZone().getOffset(time);
        }
        return (offset + time) / 1000L;
    }

    static long parseTimeString(String st) throws Exception {
        java.util.Date d;
        String format = "HH:mm:ss";
        TLSimpleDateFormat dateFormat = new TLSimpleDateFormat(format);
        java.util.Date d0 = dateFormat.parse("00:00:00");
        try {
            d = dateFormat.parse(st);
        }
        catch (ParseException e) {
            try {
                String[] sOut = st.split(Pattern.quote(":"));
                int size = sOut.length;
                format = format.substring(0, size * 3 - 1);
                dateFormat = new TLSimpleDateFormat(format);
                d = dateFormat.parse(st);
            }
            catch (ParseException ex) {
                throw new Exception("Invalid Time: String cannot convert to Time: " + ex.getMessage());
            }
        }
        long dtime = d.getTime() - d0.getTime();
        if (dtime < 0L || dtime >= 86400000L) {
            throw new Exception("Invalid Time: String exceeded valid time!");
        }
        if (st.length() > 9) {
            if (st.trim().endsWith("PM")) {
                dtime = 43200000L;
            }
            return dtime + (long)ValidateNFormat.getMilliSeconds(st);
        }
        return dtime;
    }

    static String getTimeString(String st) throws Exception {
        java.util.Date d;
        String format = "HH:mm:ss";
        TLSimpleDateFormat dateFormat = new TLSimpleDateFormat(format);
        java.util.Date d0 = dateFormat.parse("00:00:00");
        try {
            d = dateFormat.parse(st);
            if (st.trim().endsWith("PM") && !st.startsWith("12:")) {
                d.setTime(d.getTime() + 43200000L);
            }
        }
        catch (ParseException e) {
            try {
                String[] sOut = st.split(Pattern.quote(":"));
                int size = sOut.length;
                format = format.substring(0, size * 3 - 1);
                dateFormat = new TLSimpleDateFormat(format);
                d = dateFormat.parse(st);
            }
            catch (ParseException ex) {
                throw new Exception("Invalid Time: String cannot convert to Time: " + ex.getMessage());
            }
        }
        long dtime = d.getTime() - d0.getTime();
        if (dtime < 0L || dtime >= 86400000L) {
            throw new Exception("Invalid Time: String exceeded valid time!");
        }
        return dateFormat.format(d);
    }

    static String getDateString(String st) throws Exception {
        int sRetDay;
        int day;
        TLSimpleDateFormat dateFormat = new TLSimpleDateFormat("yyyy-MM-dd");
        java.util.Date d = dateFormat.parse(st);
        if (d.getTime() <= -12218497200000L) {
            return st;
        }
        String sRet = dateFormat.format(d);
        if (st.compareToIgnoreCase(sRet) == 0) {
            return sRet;
        }
        String[] sOut = st.split(Pattern.quote("-"));
        if (sOut.length > 2 && (day = Integer.parseInt(sOut[2])) == (sRetDay = Integer.parseInt(sRet.split("-")[2]))) {
            return sRet;
        }
        throw new SQLValidationException("Invalid Date String format: Not valid day!");
    }

    static String getSybaseDateString(String st) throws Exception {
        try {
            TLSimpleDateFormat sybaseFormat = new TLSimpleDateFormat("MMM dd yyyy");
            java.util.Date d = sybaseFormat.parse(st);
            TLSimpleDateFormat dateFormat = new TLSimpleDateFormat("yyyy-MM-dd");
            return dateFormat.format(d);
        }
        catch (Exception e) {
            throw new SQLValidationException("Invalid Sybase Date String format: Not valid day! " + e.getMessage());
        }
    }

    static long parseDateStringToTicks(String st) throws Exception {
        TLSimpleDateFormat dateFormat = new TLSimpleDateFormat("yyyy-MM-dd");
        String[] splitDate = st.split(" ");
        try {
            java.util.Date d = splitDate.length > 2 ? dateFormat.parse(ValidateNFormat.getSybaseDateString(st)) : dateFormat.parse(splitDate[0]);
            long lt = d.getTime();
            if (lt <= -12218497200000L) {
                Instant inst = Instant.parse(st + "T12:00:00Z");
                lt = inst.getEpochSecond() * 1000L;
            }
            return lt;
        }
        catch (Exception e) {
            throw new SQLValidationException("Invalid Date String format: Not valid day! " + e.getMessage());
        }
    }

    static Timestamp parseTimestampStringToTimestamp(String st, int tzoffset, Calendar cal, boolean doNotCheckGregorian) throws Exception {
        Timestamp ts = null;
        String stTimestamp = null;
        boolean getNanos = false;
        String[] splitDate = st.length() > 10 && 'T' == st.charAt(10) ? st.split("T") : st.split(" ");
        if (splitDate.length == 2) {
            stTimestamp = ValidateNFormat.getDateString(splitDate[0]) + " " + ValidateNFormat.getTimeString(splitDate[1]);
            if (splitDate[1].length() > 9) {
                getNanos = true;
            }
        } else if (splitDate.length == 1) {
            if (st.indexOf("-") < 2) {
                if (!st.contains(":")) {
                    long horolog = Long.parseLong(st);
                    ts = horolog > ListWriter.DATE_MAXVAL || horolog < ListWriter.DATE_MINVAL ? ValidateNFormat.TimestampFromPosix(horolog, cal) : ValidateNFormat.TimeStampFromHorolog(horolog, cal);
                    return ts;
                }
                ts = ValidateNFormat.parseTimeStringToTimestamp(st, tzoffset, cal);
                return ts;
            }
            stTimestamp = ValidateNFormat.getDateString(splitDate[0]);
        } else {
            stTimestamp = ValidateNFormat.getSybaseDateString(st) + " " + ValidateNFormat.getTimeString(splitDate[splitDate.length - 1]);
            if (splitDate[splitDate.length - 1].length() > 9) {
                getNanos = true;
            }
        }
        String format = "yyyy-MM-dd HH:mm:ss".substring(0, stTimestamp.length());
        TLSimpleDateFormat tsFormat = new TLSimpleDateFormat(format);
        if (cal != null) {
            tsFormat.setCalendar(cal);
        }
        java.util.Date d = tsFormat.parse(stTimestamp);
        if (!doNotCheckGregorian && d.getTime() <= -12218497200000L) {
            long lt = ValidateNFormat.EpochFromString(st);
            ts = new Timestamp(lt);
        } else {
            ts = new Timestamp(d.getTime());
        }
        if (getNanos) {
            ts.setNanos(ValidateNFormat.getNanoSeconds(st));
        }
        return ts;
    }

    public static Timestamp TimeStampFromHorolog(long horolog, Calendar calendar) {
        long time = -4070908800000L + horolog * 86400000L;
        long offset = null == calendar ? (long)s_TimeZone.getOffset(time - (long)s_TimeZone.getOffset(time)) : (long)calendar.getTimeZone().getOffset(time - (long)calendar.getTimeZone().getOffset(time));
        return new Timestamp(time -= offset);
    }

    public static long PosixIfHorologValue(long horologOrPosix) {
        if (horologOrPosix < ListWriter.DATE_MINVAL || horologOrPosix > ListWriter.DATE_MAXVAL) {
            return horologOrPosix;
        }
        return (horologOrPosix - 47117L) * 86400000L * 1000L & 0x8FFFFFFFFFFFFFFFL | 0x1000000000000000L;
    }

    static Timestamp TimestampNormalize(Timestamp ts, Calendar calendar) {
        if (null == calendar) {
            return ts;
        }
        TLSimpleDateFormat dateFormat = new TLSimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setCalendar(calendar);
        String sValue = dateFormat.format(ts);
        Timestamp tsRet = Timestamp.valueOf(sValue);
        tsRet.setNanos(ts.getNanos());
        return tsRet;
    }

    static Timestamp TimestampFromDate(Date dt, Calendar calendar) {
        long time = dt.getTime();
        long offset = 0L;
        if (null != calendar) {
            offset = calendar.getTimeZone().getOffset(time);
        }
        Timestamp ts = new Timestamp(time + offset);
        return ts;
    }

    static Timestamp TimestampFromTime(Time time, int nanos, Calendar calendar) {
        long ticks = time.getTime();
        long offset = null == calendar ? (long)s_TimeZone.getOffset(ticks) : (long)calendar.getTimeZone().getOffset(ticks);
        Timestamp ts = new Timestamp(ticks + offset);
        if (nanos > 0) {
            ts.setNanos(nanos);
        }
        return ts;
    }

    static Timestamp parseTimeStringToTimestamp(String st, int svrTimezone, Calendar cal) throws Exception {
        String stime = ValidateNFormat.getTimeString(st);
        String sDate = ValidateNFormat.getCurrentDate(svrTimezone) + " " + stime;
        try {
            TLSimpleDateFormat tsFormat = new TLSimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (cal != null) {
                tsFormat.setCalendar(cal);
            }
            java.util.Date d = tsFormat.parse(sDate);
            Timestamp ts = new Timestamp(d.getTime());
            if (st.length() > 9) {
                ts.setNanos(ValidateNFormat.getNanoSeconds(st));
            }
            return ts;
        }
        catch (Exception e) {
            throw new Exception("Invalid Time format conversion to Timestamp!");
        }
    }

    static String getCurrentDate(int svrTimezone) {
        TLSimpleDateFormat dateFormat = new TLSimpleDateFormat("yyyy-MM-dd");
        long lgTime = System.currentTimeMillis() - (long)(svrTimezone * 60 * 1000);
        return dateFormat.format(new java.util.Date(lgTime));
    }

    static int getMilliSeconds(String value) {
        int millisec = 0;
        String[] sOut = value.split(Pattern.quote("."));
        if (sOut.length == 2) {
            try {
                String st = (sOut[1].replaceAll("[^0-9]", "") + "000").substring(0, 3);
                return Integer.parseInt(st);
            }
            catch (Exception st) {
                // empty catch block
            }
        }
        if ((sOut = value.split(Pattern.quote(":"))).length == 4) {
            try {
                String st = (sOut[3].replaceAll("[^0-9]", "") + "000").substring(0, 3);
                return Integer.parseInt(st);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return millisec;
    }

    static int getNanoSeconds(String value) {
        int nanosec = 0;
        String[] sOut = value.split(Pattern.quote("."));
        if (sOut.length == 2) {
            try {
                String st = (sOut[1].replaceAll("[^0-9]", "") + "000000000").substring(0, 9);
                return Integer.parseInt(st);
            }
            catch (Exception st) {
                // empty catch block
            }
        }
        if ((sOut = value.split(Pattern.quote(":"))).length == 4) {
            try {
                String st = (sOut[3].replaceAll("[^0-9]", "") + "000000000").substring(0, 9);
                return Integer.parseInt(st);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nanosec;
    }

    static boolean isIntegerValue(BigDecimal bd) {
        return bd.signum() == 0 || bd.scale() <= 0 || bd.stripTrailingZeros().scale() <= 0;
    }

    static long EpochFromString(String st) {
        String sTs = "";
        String[] sOut = st.split(Pattern.quote("-"));
        if (sOut.length < 3) {
            return 0L;
        }
        String[] sDOut = sOut[2].split(Pattern.quote(" "));
        int Date2 = Integer.parseInt(sDOut[0]);
        int Hour = 0;
        int Min = 0;
        int Sec = 0;
        int Milli = 0;
        if (sDOut.length > 1) {
            String[] sTime = sDOut[1].split(Pattern.quote("."));
            if (sTime.length > 1) {
                Milli = Integer.parseInt(sTime[1]);
            }
            String[] sDt = sTime[0].split(Pattern.quote(":"));
            switch (sDt.length) {
                case 3: {
                    Sec = Integer.parseInt(sDt[2]);
                }
                case 2: {
                    Min = Integer.parseInt(sDt[1]);
                }
                case 1: {
                    Hour = Integer.parseInt(sDt[0]);
                    break;
                }
            }
        }
        sTs = String.format("%s-%s-%02dT%02d:%02d:%02dZ", sOut[0], sOut[1], Date2, Hour, Min, Sec);
        Instant inst = Instant.parse(sTs);
        long lt = inst.getEpochSecond() * 1000L + (long)Milli;
        return lt;
    }

    static Timestamp TimestampFromEpoch(long millis) {
        Instant it = Instant.ofEpochSecond(millis / 1000L, millis % 1000L);
        TLSimpleDateFormat dateFormat = new TLSimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            String sTime = it.toString();
            sTime = sTime.replace('T', ' ');
            sTime = sTime.replace("Z", "");
            java.util.Date ddt = dateFormat.parse(sTime);
            Date date = new Date(ddt.getTime());
            return new Timestamp(date.getTime());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }
}

