/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc.preparser;

import com.intersystems.jdbc.IRISStatement;
import com.intersystems.jdbc.ListWriter;
import com.intersystems.jdbc.Parameter;
import com.intersystems.jdbc.ParameterCollection;
import com.intersystems.jdbc.preparser.PreParseResult;
import com.intersystems.jdbc.preparser.PreParser;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Parser {
    private PreParser m_preparser = null;
    private PreParseResult m_sqlResult = null;
    ParameterCollection m_Parameters = new ParameterCollection();
    private String m_sql;

    public Parser(String sql, boolean delIds, int addRID) {
        this.m_preparser = new PreParser(delIds, addRID);
        this.m_sql = sql;
    }

    public void preparse() throws SQLException {
        try {
            this.m_sqlResult = this.m_preparser.PreParse(this.m_sql, this.m_Parameters);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IRISStatement.StatementType getStatementType() {
        return this.m_sqlResult.p_eStmtType;
    }

    public String getOptionName() {
        try {
            throw new Exception("getOptionName Not Supported");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getOptionValue() {
        try {
            throw new Exception("getOptionValue Not Supported");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getParametersCount() {
        return this.m_Parameters.size() - this.m_preparser.m_ExecParamCount;
    }

    public String getPreparsedSQL() {
        return this.m_sqlResult.sResult;
    }

    public List getParameters() {
        if (0 == this.m_Parameters.size()) {
            return null;
        }
        ArrayList<ParserParameter> parameters = new ArrayList<ParserParameter>();
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            Parameter cp = this.m_Parameters.get(i);
            if (cp.isExecParam()) continue;
            ParserParameter p = new ParserParameter(cp.GetParamType(), cp.GetValue());
            parameters.add(p);
        }
        return parameters;
    }

    public ListWriter getParamInfo() {
        return this.m_preparser.ParamInfoGet().trim();
    }

    public ParameterCollection getExecParams() {
        if (0 == this.m_Parameters.size()) {
            return null;
        }
        ParameterCollection eXparameters = new ParameterCollection();
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            Parameter cp = this.m_Parameters.get(i);
            if (!cp.isExecParam()) continue;
            Parameter p = new Parameter(cp);
            eXparameters.add(p);
        }
        if (eXparameters.size() > 0) {
            eXparameters.updateNames();
            return eXparameters;
        }
        return null;
    }

    public static class ParserParameter {
        public char type;
        public Object value;

        public ParserParameter(char t, Object v) {
            this.type = t;
            this.value = v;
        }
    }
}

