/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc.preparser;

import com.intersystems.jdbc.IRISStatement;
import com.intersystems.jdbc.ListWriter;
import com.intersystems.jdbc.Parameter;
import com.intersystems.jdbc.ParameterCollection;
import com.intersystems.jdbc.preparser.CheckPoint;
import com.intersystems.jdbc.preparser.ITokenEnumerator;
import com.intersystems.jdbc.preparser.ParseToken;
import com.intersystems.jdbc.preparser.PreParseResult;
import com.intersystems.jdbc.preparser.Scanner;
import com.intersystems.jdbc.preparser.Token;
import com.intersystems.jdbc.preparser.TokenList;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PreParser {
    Scanner m_Scanner;
    boolean m_bDelimitedIdentifiers;
    boolean m_bBracketSubstitution = false;
    TokenList m_Tokens;
    private IRISStatement.StatementType m_eStmtType;
    private int m_nUndefinedCount;
    private int m_addRowID;
    public int m_ExecParamCount = 0;
    static ConcurrentHashMap<String, Token.TOKEN> s_KeywordTable = new ConcurrentHashMap();
    static ConcurrentHashMap<String, IRISStatement.StatementType> s_StatementTable;
    static ConcurrentHashMap<String, IRISStatement.StatementType> s_ParsedStatements;
    boolean hasNamedParameters = false;
    static ConcurrentHashMap<String, Boolean> s_TransactionStatements;
    static ConcurrentHashMap<String, Boolean> s_mapReservedKeywords;
    static Set<String> s_ReservedKeywords;
    static String s_replaceparm;
    static final int SQL_DIALECT_DEFAULT = 0;
    static final int SQL_DIALECT_MSSQL = 1;
    static final int SQL_DIALECT_SYBASE = 2;
    private boolean m_CacheOnServer = false;
    private ListWriter m_ParamInfo;

    boolean CacheOnServerGet() {
        return this.m_CacheOnServer;
    }

    private void CacheOnServerSet(boolean b) {
        this.m_CacheOnServer = b;
    }

    ListWriter ParamInfoGet() {
        return this.m_ParamInfo;
    }

    private void ParamInfoSet(ListWriter s) {
        this.m_ParamInfo = s;
    }

    PreParser() {
        this(false, 0);
    }

    PreParser(boolean p_bDelimitedIdentifiers, int addRID) {
        this.m_bDelimitedIdentifiers = p_bDelimitedIdentifiers;
        this.m_addRowID = addRID;
        this.CacheOnServerSet(false);
    }

    PreParseResult PreParse(String p_strInput, ParameterCollection p_Parameters) throws Exception {
        this.Tokenize(p_strInput);
        return this.Resolve(p_strInput, p_Parameters);
    }

    private void Tokenize(String p_strInput) throws Exception {
        this.m_Scanner = new Scanner(p_strInput);
        this.m_Tokens = new TokenList();
        block31: while (this.m_Scanner.CurrentTokenGet() != ParseToken.tokEOS) {
            this.m_Scanner.SkipWhitespace();
            switch (this.m_Scanner.CurrentTokenGet()) {
                case tokEOS: {
                    continue block31;
                }
                case tokDOT: {
                    if (ParseToken.tokDIGIT != this.m_Scanner.PeekNextToken()) {
                        this.m_Scanner.BeginLexeme();
                        this.m_Scanner.NextToken();
                        this.m_Tokens.Append(new Token(Token.TOKEN.UNKNOWN, this.m_Scanner.EndLexeme(), this.m_Scanner.EndUpperLexeme()));
                        continue block31;
                    }
                }
                case tokDIGIT: {
                    String t_strNumber = this.m_Scanner.Hex();
                    if (this.m_Scanner.m_boolReturn) {
                        this.m_Tokens.Append(new Token(Token.TOKEN.HEX, t_strNumber));
                        continue block31;
                    }
                    t_strNumber = this.m_Scanner.Number();
                    if (!this.m_Scanner.m_boolReturn) {
                        throw new Exception("Invalid Numeric Constant");
                    }
                    this.m_Tokens.Append(new Token(Token.TOKEN.CONSTANT, t_strNumber));
                    continue block31;
                }
                case tokMINUS: {
                    String t_strNumber;
                    Token.TOKEN t_eToken;
                    if (this.m_Scanner.PeekNextToken() == ParseToken.tokMINUS) {
                        this.m_Scanner.Skip(2);
                        this.m_Scanner.BeginLexeme();
                        this.m_Scanner.SkipToEndOfLine();
                        continue block31;
                    }
                    if (this.m_Scanner.PeekNextToken() == ParseToken.tokGREAT) {
                        this.m_Scanner.BeginLexeme();
                        this.m_Scanner.Skip(2);
                        this.m_Tokens.Append(new Token(Token.TOKEN.OP, this.m_Scanner.EndLexeme()));
                        continue block31;
                    }
                    Token.TOKEN tOKEN = t_eToken = this.m_Tokens.Last() != null ? this.m_Tokens.Last().GetValue().TokenTypeGet() : Token.TOKEN.UNKNOWN;
                    if ((t_eToken == Token.TOKEN.OP || t_eToken == Token.TOKEN.OPEN_PAREN || t_eToken == Token.TOKEN.COMMA) && (this.m_Scanner.PeekNextToken() == ParseToken.tokDIGIT || this.m_Scanner.PeekNextToken() == ParseToken.tokDOT && this.m_Scanner.PeekNextNextToken() == ParseToken.tokDIGIT)) {
                        t_strNumber = this.m_Scanner.Number();
                        if (!this.m_Scanner.m_boolReturn) {
                            throw new Exception("Invalid Numeric Constant");
                        }
                        this.m_Tokens.Append(new Token(Token.TOKEN.CONSTANT, t_strNumber));
                        continue block31;
                    }
                    this.m_Scanner.NextToken();
                    this.m_Tokens.Append(new Token(Token.TOKEN.OP, "-"));
                    continue block31;
                }
                case tokPLUS: {
                    String t_strNumber;
                    Token.TOKEN t_eToken;
                    Token.TOKEN tOKEN = t_eToken = this.m_Tokens.Last() != null ? this.m_Tokens.Last().GetValue().TokenTypeGet() : Token.TOKEN.UNKNOWN;
                    if ((t_eToken == Token.TOKEN.OP || t_eToken == Token.TOKEN.OPEN_PAREN || t_eToken == Token.TOKEN.COMMA) && (this.m_Scanner.PeekNextToken() == ParseToken.tokDIGIT || this.m_Scanner.PeekNextToken() == ParseToken.tokDOT && this.m_Scanner.PeekNextNextToken() == ParseToken.tokDIGIT)) {
                        t_strNumber = this.m_Scanner.Number();
                        if (!this.m_Scanner.m_boolReturn) {
                            throw new Exception("Invalid Numeric Constant");
                        }
                        this.m_Tokens.Append(new Token(Token.TOKEN.CONSTANT, t_strNumber));
                        continue block31;
                    }
                    this.m_Tokens.Append(new Token(Token.TOKEN.OP, "+"));
                    this.m_Scanner.NextToken();
                    continue block31;
                }
                case tokLBRACK: {
                    String t_strString;
                    Token.TOKEN t_eToken;
                    if (this.m_bBracketSubstitution) {
                        if (!this.m_bDelimitedIdentifiers) {
                            throw new Exception("Delimited identifiers must be enabled on the server to support brackets");
                        }
                        t_strString = this.m_Scanner.ParseBrackets(this.m_bDelimitedIdentifiers);
                        t_eToken = this.m_Scanner.m_tempToken;
                        this.m_Tokens.Append(new Token(t_eToken, t_strString));
                        continue block31;
                    }
                    this.m_Scanner.BeginLexeme();
                    this.m_Scanner.NextToken();
                    this.m_Tokens.Append(new Token(Token.TOKEN.UNKNOWN, this.m_Scanner.EndLexeme(), this.m_Scanner.EndUpperLexeme()));
                    continue block31;
                }
                case tokDQUOTE: 
                case tokSQUOTE: {
                    String t_strString = this.m_Scanner.String(this.m_bDelimitedIdentifiers);
                    Token.TOKEN t_eToken = this.m_Scanner.m_tempToken;
                    this.m_Tokens.Append(new Token(t_eToken, t_strString));
                    continue block31;
                }
                case tokSLASH: {
                    if (this.m_Scanner.PeekNextToken() == ParseToken.tokASTER) {
                        this.m_Scanner.BeginLexeme();
                        this.m_Scanner.Skip(2);
                        if (!this.m_Scanner.Comment()) {
                            throw new Exception("Unexpected End-Of-Statement");
                        }
                        this.m_Tokens.Append(new Token(Token.TOKEN.UNKNOWN, this.m_Scanner.EndLexeme(), this.m_Scanner.EndUpperLexeme()));
                        continue block31;
                    }
                    this.m_Scanner.BeginLexeme();
                    this.m_Scanner.NextToken();
                    this.m_Tokens.Append(new Token(Token.TOKEN.OP, this.m_Scanner.EndLexeme(), this.m_Scanner.EndUpperLexeme()));
                    continue block31;
                }
                case tokQUEST: {
                    this.m_Tokens.Append(new Token(Token.TOKEN.QUESTION_MARK, "?"));
                    this.m_Scanner.NextToken();
                    continue block31;
                }
                case tokATSIGN: {
                    this.m_Scanner.NextToken();
                    if (this.m_Scanner.CurrentTokenGet() == ParseToken.tokDIGIT) {
                        throw new Exception("Parameter Name error, First value cannot be a digit: " + this.m_Scanner.CurrentChar());
                    }
                    String t_strID = this.m_Scanner.Identifier();
                    if (t_strID.equals("")) {
                        this.m_Tokens.Append(new Token(Token.TOKEN.QUESTION_MARK, "?"));
                        continue block31;
                    }
                    this.m_Tokens.Append(new Token(Token.TOKEN.ATSIGN, "@" + t_strID));
                    continue block31;
                }
                case tokLPARN: {
                    this.m_Tokens.Append(new Token(Token.TOKEN.OPEN_PAREN, "("));
                    this.m_Scanner.NextToken();
                    continue block31;
                }
                case tokRPARN: {
                    this.m_Tokens.Append(new Token(Token.TOKEN.CLOSE_PAREN, ")"));
                    this.m_Scanner.NextToken();
                    continue block31;
                }
                case tokCOMMA: {
                    this.m_Tokens.Append(new Token(Token.TOKEN.COMMA, ","));
                    this.m_Scanner.NextToken();
                    continue block31;
                }
                case tokCOLON: {
                    this.m_Scanner.NextToken();
                    String t_strVariable = this.m_Scanner.Variable();
                    t_strVariable = ":" + t_strVariable;
                    this.m_Tokens.Append(new Token(Token.TOKEN.VAR, t_strVariable));
                    continue block31;
                }
                case tokLETTER: 
                case tokPERCENT: 
                case tokDOLLAR: 
                case tokUSCORE: 
                case tokPOUND: {
                    Token.TOKEN t_eToken = Token.TOKEN.ID;
                    String t_strID = this.m_Scanner.Identifier();
                    String t_strIDUpper = this.m_Scanner.EndUpperLexeme();
                    if (s_KeywordTable.containsKey(t_strIDUpper) && (t_eToken = s_KeywordTable.get(t_strIDUpper)) == Token.TOKEN.NOT) {
                        t_strID = this.m_Scanner.checkForNotPredicates();
                        t_strIDUpper = t_strID.toUpperCase();
                    }
                    this.m_Tokens.Append(new Token(t_eToken, t_strID, t_strIDUpper));
                    continue block31;
                }
                case tokLESS: {
                    this.m_Scanner.BeginLexeme();
                    if (this.m_Scanner.PeekNextToken() == ParseToken.tokEQUAL || this.m_Scanner.PeekNextToken() == ParseToken.tokGREAT) {
                        this.m_Scanner.NextToken();
                    }
                    this.m_Scanner.NextToken();
                    this.m_Tokens.Append(new Token(Token.TOKEN.OP, this.m_Scanner.EndLexeme()));
                    continue block31;
                }
                case tokEXCLA: 
                case tokGREAT: 
                case tokASTER: {
                    this.m_Scanner.BeginLexeme();
                    if (this.m_Scanner.PeekNextToken() == ParseToken.tokEQUAL) {
                        this.m_Scanner.NextToken();
                    }
                    this.m_Scanner.NextToken();
                    this.m_Tokens.Append(new Token(Token.TOKEN.OP, this.m_Scanner.EndLexeme()));
                    continue block31;
                }
                case tokEQUAL: {
                    this.m_Scanner.BeginLexeme();
                    if (this.m_Scanner.PeekNextToken() == ParseToken.tokASTER) {
                        this.m_Scanner.NextToken();
                    }
                    this.m_Scanner.NextToken();
                    this.m_Tokens.Append(new Token(Token.TOKEN.OP, this.m_Scanner.EndLexeme()));
                    continue block31;
                }
                case tokVBAR: {
                    this.m_Scanner.BeginLexeme();
                    Token.TOKEN t_eToken = Token.TOKEN.OP;
                    if (this.m_Scanner.PeekNextToken() == ParseToken.tokVBAR) {
                        this.m_Scanner.Skip(2);
                    } else {
                        this.m_Scanner.NextToken();
                        t_eToken = Token.TOKEN.UNKNOWN;
                    }
                    this.m_Tokens.Append(new Token(t_eToken, this.m_Scanner.EndLexeme(), this.m_Scanner.EndUpperLexeme()));
                    continue block31;
                }
                case tokLBRACE: {
                    String t_strKeyword;
                    this.m_Scanner.NextToken();
                    CheckPoint t_CP = this.m_Scanner.CreateCheckPoint();
                    this.m_Scanner.SkipWhitespace();
                    switch (t_strKeyword = this.m_Scanner.Keyword()) {
                        case "d": 
                        case "ds": 
                        case "t": 
                        case "ts": {
                            this.m_Tokens.Append(new Token(Token.TOKEN.UNKNOWN, "{"));
                            this.m_Tokens.Append(new Token(Token.TOKEN.DTS, t_strKeyword));
                            continue block31;
                        }
                    }
                    this.m_Scanner.RestoreCheckPoint(t_CP);
                    this.m_Tokens.Append(new Token(Token.TOKEN.UNKNOWN, "{"));
                    continue block31;
                }
            }
            this.m_Scanner.BeginLexeme();
            this.m_Scanner.NextToken();
            this.m_Tokens.Append(new Token(Token.TOKEN.UNKNOWN, this.m_Scanner.EndLexeme(), this.m_Scanner.EndUpperLexeme()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private PreParseResult Resolve(String p_strInput, ParameterCollection p_Parameters) throws Exception {
        block125: {
            block127: {
                block130: {
                    block129: {
                        block128: {
                            block126: {
                                block124: {
                                    pOut = new PreParseResult();
                                    t_SB = new StringBuilder();
                                    pOut.p_eStmtType = IRISStatement.StatementType.UPDATE;
                                    if (this.ParamInfoGet() == null) {
                                        this.ParamInfoSet(new ListWriter(100, null));
                                    } else {
                                        this.ParamInfoGet().clearList();
                                    }
                                    t_Enum = this.m_Tokens.GetEnumerator();
                                    v0 = t_bBoundParameters = p_Parameters.size() > 0;
                                    if (this.m_Tokens.Count() >= 2) break block124;
                                    t_SB.append(p_strInput);
                                    break block125;
                                }
                                t_Enum.MoveNext();
                                t_str = t_Enum.Current().UpperLexeme;
                                while (Token.TOKEN.UNKNOWN == t_Enum.Current().TokenTypeGet() && 0 == t_str.indexOf("/*")) {
                                    t_Enum.MoveNext();
                                    t_str = t_Enum.Current().UpperLexeme;
                                }
                                if (!PreParser.s_ParsedStatements.containsKey(t_str)) break block126;
                                this.m_eStmtType = pOut.p_eStmtType = PreParser.s_ParsedStatements.get(t_str);
                                if (IRISStatement.StatementType.WITH == this.m_eStmtType) {
                                    this.m_eStmtType = pOut.p_eStmtType = this.GetTypeForCTE(t_Enum.Clone());
                                }
                                this.CacheOnServerSet(true);
                                break block127;
                            }
                            if (!PreParser.s_StatementTable.containsKey(t_str)) break block128;
                            pOut.p_eStmtType = PreParser.s_StatementTable.get(t_str);
                            if (this.m_bBracketSubstitution && this.m_bDelimitedIdentifiers) {
                                t_Enum.Reset();
                                while (t_Enum.MoveNext()) {
                                    t_SB.append(t_Enum.Current().Lexeme);
                                    t_SB.append(" ");
                                }
                            } else {
                                t_SB.append(p_strInput);
                                if (t_str.equals("EXPLAIN") && pOut.p_eStmtType == IRISStatement.StatementType.CALLWITHRESULT) {
                                    pQuery = p_strInput;
                                    pAlt = "ShowPlan";
                                    pStat = "0";
                                    pQuery = pQuery.substring(pQuery.toUpperCase().indexOf("EXPLAIN") + "EXPLAIN".length());
                                    while (t_Enum.MoveNext()) {
                                        if (t_Enum.Current().UpperLexeme.equals("ALT")) {
                                            pAlt = "ShowPlanAlt";
                                            pQuery = pQuery.substring(pQuery.toUpperCase().indexOf("ALT") + "ALT".length());
                                            continue;
                                        }
                                        if (t_Enum.Current().UpperLexeme.equals("STAT")) {
                                            pStat = "1";
                                            pQuery = pQuery.substring(pQuery.toUpperCase().indexOf("STAT") + "STAT".length());
                                            continue;
                                        }
                                        p_Parameters.clear();
                                        p_Parameters.add(new Parameter(pQuery, Parameter.ParameterMode.REPLACED_LITERAL));
                                        p_Parameters.add(new Parameter(pStat, Parameter.ParameterMode.REPLACED_LITERAL));
                                        p_Parameters.add(new Parameter(pAlt, Parameter.ParameterMode.REPLACED_LITERAL));
                                        p_Parameters.add(new Parameter("", Parameter.ParameterMode.REPLACED_LITERAL));
                                        pOut.sResult = "select %SYSTEM . QUERY_PLAN ( :%qpar(1) , :%qpar(2) , :%qpar(3) , :%qpar(4) ) as Plan";
                                        pOut.p_eStmtType = IRISStatement.StatementType.QUERY;
                                        this.m_ParamInfo.set(4);
                                        this.m_ParamInfo.set(99);
                                        this.m_ParamInfo.set(2);
                                        this.m_ParamInfo.set(99);
                                        this.m_ParamInfo.set(1);
                                        this.m_ParamInfo.set(99);
                                        this.m_ParamInfo.set(1);
                                        this.m_ParamInfo.set(99);
                                        this.m_ParamInfo.set(1);
                                        this.CacheOnServerSet(false);
                                        return pOut;
                                    }
                                }
                            }
                            break block125;
                        }
                        if (PreParser.s_TransactionStatements.containsKey(t_str)) {
                            this.CacheOnServerSet(true);
                        } else if (t_str.startsWith("(") && t_Enum.MoveNext()) {
                            bEnd = false;
                            while (t_Enum.Current().UpperLexeme.equals("(")) {
                                if (t_Enum.MoveNext()) continue;
                                bEnd = true;
                                break;
                            }
                            if (!bEnd) {
                                t_str = t_Enum.Current().UpperLexeme;
                                if (t_str.equals("SELECT")) {
                                    pOut.p_eStmtType = PreParser.s_ParsedStatements.get(t_str);
                                }
                                t_Enum.MovePrevious();
                                this.CacheOnServerSet(true);
                            }
                        }
                        if (!this.m_Tokens.First().GetValue().UpperEquals("SET")) break block129;
                        t_NewEnum = this.m_Tokens.GetEnumerator();
                        if (t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("TRANSACTION")) {
                            this.CacheOnServerSet(true);
                        }
                        if (5 == this.m_Tokens.Count()) {
                            t_NewEnum.Reset();
                            if (t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("OPTION")) {
                                if (t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("BLOB_SUPPORT")) {
                                    if (t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("=")) {
                                        if (t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("1")) {
                                            pOut.p_eStmtType = IRISStatement.StatementType.STREAMS_ON;
                                        } else if (t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("0")) {
                                            pOut.p_eStmtType = IRISStatement.StatementType.STREAMS_OFF;
                                        }
                                    }
                                } else if (t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("SYNCHRONOUS_COMMIT") && t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("=")) {
                                    if (t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("1")) {
                                        pOut.p_eStmtType = IRISStatement.StatementType.SYNC_COMMIT;
                                    } else if (t_NewEnum.MoveNext() && t_NewEnum.Current().UpperEquals("0")) {
                                        pOut.p_eStmtType = IRISStatement.StatementType.ASYNC_COMMIT;
                                    }
                                }
                            }
                        }
                        t_Enum.Reset();
                        while (t_Enum.MoveNext()) {
                            t_SB.append(t_Enum.Current().Lexeme);
                            t_SB.append(" ");
                        }
                        break block125;
                    }
                    if (this.CacheOnServerGet() || !this.Exec(t_SB, p_Parameters)) break block130;
                    this.CacheOnServerSet(true);
                    pOut.p_eStmtType = this.m_eStmtType;
                    break block125;
                }
                this.m_nUndefinedCount = 0;
                if (this.CacheOnServerGet() || !this.Call(t_SB, p_Parameters)) break block127;
                this.CacheOnServerSet(true);
                pOut.p_eStmtType = this.m_eStmtType;
                break block125;
            }
            t_SB.setLength(0);
            t_nOpenParen = 0;
            t_nOrdinal = 0;
            t_nRound = 0;
            t_nRoundNested = 0;
            t_Enum.Reset();
            t_bQuitLoop = false;
            bFirstElement = true;
            orderbyToken = null;
            lastToken = null;
            orderbyParen = 0;
            while (!t_bQuitLoop && t_Enum.MoveNext()) {
                t_Token = t_Enum.Current();
                if (bFirstElement) {
                    bFirstElement = false;
                    if (t_Token.UpperEquals("{")) {
                        throw new SQLException("'{' encountered at the beginning of the statement", "37000", 37000);
                    }
                }
                if (null != lastToken && lastToken == orderbyToken && orderbyParen - t_nOpenParen <= 0) {
                    orderbyToken = t_Token;
                    lastToken = t_Token;
                }
                block0 : switch (1.$SwitchMap$com$intersystems$jdbc$preparser$Token$TOKEN[t_Token.TokenTypeGet().ordinal()]) {
                    case 1: {
                        ++t_nOrdinal;
                        if (t_bBoundParameters) break;
                        p_Parameters.add(new Parameter("?", Parameter.ParameterMode.UNKNOWN, '?'));
                        break;
                    }
                    case 2: {
                        this.hasNamedParameters = true;
                        ++t_nOrdinal;
                        if (!t_bBoundParameters || p_Parameters.size() == 0) {
                            p_Parameters.add(new Parameter(t_Token.Lexeme, Parameter.ParameterMode.UNKNOWN));
                            break;
                        }
                        if (this.matchUpParam(p_Parameters, t_Token.Lexeme, p_Parameters.size())) break;
                        p_Parameters.add(new Parameter(t_Token.Lexeme, Parameter.ParameterMode.UNKNOWN));
                        break;
                    }
                    case 3: {
                        ++t_nOrdinal;
                        cp = new Parameter(PreParser.HexStringToByteArray(t_Token.Lexeme), Parameter.ParameterMode.REPLACED_LITERAL, -2, '?');
                        p_Parameters.add(cp);
                        t_Token.TokenTypeSet(Token.TOKEN.QUESTION_MARK);
                        break;
                    }
                    case 4: {
                        if (null != orderbyToken && t_Enum.Current().UpperEquals("UNION")) {
                            orderbyToken = null;
                        }
                        if (t_Token.UpperEquals("ROWS")) {
                            while (t_Enum.MoveNext()) {
                                startParen = t_nOpenParen;
                                bAtTheEnd = true;
                                while (t_Enum.MoveNext()) {
                                    if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.OPEN_PAREN) {
                                        ++t_nOpenParen;
                                    }
                                    if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.CLOSE_PAREN) {
                                        --t_nOpenParen;
                                    }
                                    if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.QUESTION_MARK || t_Enum.Current().TokenTypeGet() == Token.TOKEN.ATSIGN) {
                                        t_Enum.Current().TokenTypeSet(Token.TOKEN.UNKNOWN);
                                    }
                                    if (t_nOpenParen >= startParen) continue;
                                    bAtTheEnd = false;
                                    break;
                                }
                                if (bAtTheEnd || t_Enum.Current().TokenTypeGet() != Token.TOKEN.CLOSE_PAREN) continue;
                                break;
                            }
                        }
                        if (null != lastToken && lastToken == orderbyToken) {
                            orderbyToken = t_Token;
                            lastToken = t_Token;
                            break;
                        }
                        if (t_Token.UpperEquals("ORDER") && (t_NewEnum = t_Enum.Clone()).MoveNext() && (t_NewToken = t_NewEnum.Current()).UpperEquals("BY")) {
                            orderbyToken = t_NewToken;
                            orderbyParen = t_nOpenParen;
                            if (t_nOpenParen == 0) break;
                            while (t_Enum.MoveNext()) {
                                if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.CLOSE_PAREN) {
                                    if (orderbyParen <= --t_nOpenParen) continue;
                                    break;
                                }
                                if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.OPEN_PAREN) {
                                    ++t_nOpenParen;
                                    continue;
                                }
                                if (Token.TOKEN.QUESTION_MARK == t_Enum.Current().TokenTypeGet()) {
                                    ++t_nOrdinal;
                                    p_Parameters.add(new Parameter("?", Parameter.ParameterMode.UNKNOWN, '?'));
                                    continue;
                                }
                                if (Token.TOKEN.ID != t_Enum.Current().TokenTypeGet() || !t_Enum.Current().UpperEquals("UNION")) continue;
                            }
                        }
                        if (t_Token.UpperContains("JSON_") || t_Token.UpperContains("_JSON")) {
                            startParen = t_nOpenParen;
                            while (t_Enum.MoveNext()) {
                                if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.OPEN_PAREN) {
                                    ++t_nOpenParen;
                                }
                                if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.CLOSE_PAREN) {
                                    --t_nOpenParen;
                                }
                                if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.QUESTION_MARK || t_Enum.Current().TokenTypeGet() == Token.TOKEN.ATSIGN) {
                                    ++t_nOrdinal;
                                    if (!t_bBoundParameters) {
                                        p_Parameters.add(new Parameter("?", Parameter.ParameterMode.UNKNOWN, '?'));
                                    }
                                }
                                if (t_nOpenParen != startParen) continue;
                            }
                        }
                        if ((t_Token.UpperEquals("ROUND") || t_Token.UpperEquals("TO_CHAR") || t_Token.UpperEquals("TO_DATE") || t_Token.UpperEquals("TO_TIMESTAMP") || t_Token.UpperEquals("TO_POSIXTIME")) && this.m_eStmtType == IRISStatement.StatementType.QUERY && t_nRound == 0) {
                            t_nRound = 1;
                        }
                        if (!t_Token.UpperEquals("DATEPART") && !t_Token.UpperEquals("TIMESTAMPADD") && !t_Token.UpperEquals("TIMESTAMPDIFF") && !t_Token.UpperEquals("DATEADD") && !t_Token.UpperEquals("DATENAME") && !t_Token.UpperEquals("DATEDIFF") && !t_Token.UpperEquals("DATE_TRUNC") || !t_Enum.MoveNext()) break;
                        if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.OPEN_PAREN) {
                            while (t_Enum.MoveNext()) {
                                if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.CONSTANT) {
                                    t_Enum.Current().TokenTypeSet(Token.TOKEN.ID);
                                    break block0;
                                }
                                if (t_Enum.Current().TokenTypeGet() != Token.TOKEN.COMMA && t_Enum.Current().TokenTypeGet() != Token.TOKEN.CLOSE_PAREN) continue;
                                break block0;
                            }
                            break;
                        }
                        t_Enum.MovePrevious();
                        break;
                    }
                    case 5: {
                        parenLevel = 0;
                        t_TokenLast = null;
                        inOrderBy = false;
                        t_nParamIndex = true;
                        while (t_Enum.MoveNext()) {
                            if (null != t_TokenLast && 0 == t_TokenLast.UpperLexeme.compareTo("ORDER") && 0 == t_Enum.Current().UpperLexeme.compareTo("BY")) {
                                inOrderBy = true;
                            }
                            t_TokenLast = t_Enum.Current();
                            if (parenLevel != true || t_Enum.Current().TokenTypeGet() != Token.TOKEN.COMMA) ** GOTO lbl272
                            while (t_Enum.MoveNext()) {
                                if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.CONSTANT) {
                                    t_Enum.Current().TokenTypeSet(Token.TOKEN.ID);
                                    if (parenLevel != 1) continue;
                                } else {
                                    if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.OPEN_PAREN) {
                                        ++parenLevel;
                                        continue;
                                    }
                                    if (t_Enum.Current().TokenTypeGet() != Token.TOKEN.CLOSE_PAREN || --parenLevel != 1) continue;
                                }
                                ** GOTO lbl305
                            }
                            ** GOTO lbl305
lbl272:
                            // 1 sources

                            if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.OPEN_PAREN) {
                                ++parenLevel;
                            } else if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.CLOSE_PAREN) {
                                if (parenLevel == 1) break block0;
                                --parenLevel;
                            } else if (t_Enum.Current().TokenTypeGet() == Token.TOKEN.CONSTANT) {
                                bSubstitute = true;
                                if (inOrderBy) {
                                    bSubstitute = false;
                                }
                                if (parenLevel > 1) {
                                    t_Enum.MovePrevious();
                                    if (Token.TOKEN.OPEN_PAREN == t_Enum.Current().TokenTypeGet()) {
                                        t_Enum.MoveNext();
                                        t_Enum.MoveNext();
                                        if (Token.TOKEN.CLOSE_PAREN == t_Enum.Current().TokenTypeGet()) {
                                            bSubstitute = false;
                                        }
                                        t_Enum.MovePrevious();
                                    } else {
                                        t_Enum.MoveNext();
                                    }
                                }
                                if (bSubstitute) {
                                    t_Token = t_Enum.Current();
                                    t_nOrdinal = this.DynamicVariable(t_bBoundParameters, t_Token, t_nOrdinal, p_Parameters);
                                }
                            } else if (Token.TOKEN.QUESTION_MARK == t_Enum.Current().TokenTypeGet()) {
                                p_Parameters.add(new Parameter("?", Parameter.ParameterMode.UNKNOWN, '?'));
                            }
lbl305:
                            // 9 sources

                            if (parenLevel != 0) continue;
                            break block0;
                        }
                        break;
                    }
                    case 6: {
                        t_NewEnum = t_Enum.Clone();
                        if (!t_NewEnum.MoveNext() || Token.TOKEN.OPEN_PAREN != (t_NewToken = t_NewEnum.Current()).TokenTypeGet()) break;
                        while (t_NewEnum.MoveNext() && (t_NewToken = t_NewEnum.Current()).TokenTypeGet() != Token.TOKEN.CLOSE_PAREN) {
                        }
                        t_Enum = t_NewEnum;
                        break;
                    }
                    case 7: {
                        ++t_nOpenParen;
                        t_NewEnum = t_Enum.Clone();
                        if (t_nRound > 0) {
                            ++t_nRoundNested;
                        }
                        if (!t_NewEnum.MoveNext() || Token.TOKEN.OPEN_PAREN != (t_NewToken = t_NewEnum.Current()).TokenTypeGet()) break;
                        ++t_nOpenParen;
                        if (!t_NewEnum.MoveNext()) break;
                        t_NewToken = t_NewEnum.Current();
                        v1 = bCurlyBrace = 0 == t_NewToken.Lexeme.compareTo("{");
                        if (Token.TOKEN.CONSTANT != t_NewToken.TokenTypeGet() && !bCurlyBrace || !t_NewEnum.MoveNext()) break;
                        t_NewToken = t_NewEnum.Current();
                        if (bCurlyBrace) {
                            while (0 != t_NewToken.Lexeme.compareTo("}")) {
                                if (!t_NewEnum.MoveNext()) {
                                    bCurlyBrace = false;
                                    break;
                                }
                                t_NewToken = t_NewEnum.Current();
                            }
                            bCurlyBrace = false;
                            if (!t_NewEnum.MoveNext()) break;
                            t_NewToken = t_NewEnum.Current();
                        }
                        if (Token.TOKEN.CLOSE_PAREN != t_NewToken.TokenTypeGet()) break;
                        --t_nOpenParen;
                        if (!t_NewEnum.MoveNext() || Token.TOKEN.CLOSE_PAREN != (t_NewToken = t_NewEnum.Current()).TokenTypeGet()) break;
                        --t_nOpenParen;
                        t_Enum = t_NewEnum;
                        if (t_nRound <= 0) break;
                        --t_nRoundNested;
                        break;
                    }
                    case 8: {
                        if (t_nRound > 0) {
                            --t_nRoundNested;
                        }
                        --t_nOpenParen;
                        break;
                    }
                    case 9: {
                        t_NewEnum = t_Enum.Clone();
                        if (!t_NewEnum.MoveNext() || Token.TOKEN.OPEN_PAREN != (t_NewToken = t_NewEnum.Current()).TokenTypeGet() || !t_NewEnum.MoveNext() || t_NewEnum.Current().TokenTypeGet() != Token.TOKEN.CONSTANT || !t_NewEnum.MoveNext() || t_NewEnum.Current().TokenTypeGet() != Token.TOKEN.CLOSE_PAREN) break;
                        t_Enum = t_NewEnum;
                        break;
                    }
                    case 10: {
                        if (t_nRound == 2 && t_nRoundNested == 1) {
                            t_Enum.MoveNext();
                            if (Token.TOKEN.COMMA != t_Enum.Current().TokenTypeGet()) {
                                t_nRound = 0;
                                t_nRoundNested = 0;
                            }
                            t_Enum.MovePrevious();
                            break;
                        }
                        if (null != lastToken && lastToken == orderbyToken) {
                            orderbyToken = t_Token;
                            lastToken = t_Token;
                            break;
                        }
                        t_NewEnum = t_Enum.Clone();
                        if (t_NewEnum.MoveNext() && t_NewEnum.Current().TokenTypeGet() == Token.TOKEN.CLOSE_PAREN) {
                            t_NewEnum.MovePrevious();
                            if (t_NewEnum.MovePrevious() && t_NewEnum.Current().Lexeme.charAt(0) == '-') {
                                t_NewEnum.MovePrevious();
                            }
                            if (t_Enum.Current() != null && t_NewEnum.Current().TokenTypeGet() == Token.TOKEN.OPEN_PAREN) {
                                t_NewEnum.MovePrevious();
                                if (t_Enum.Current() != null && (Token.TOKEN.ID != t_NewEnum.Current().TokenTypeGet() || PreParser.s_replaceparm.indexOf(t_NewEnum.Current().UpperLexeme) > 0)) {
                                    t_Enum.MoveNext();
                                    break;
                                }
                            }
                        }
                        if (t_Enum.Current() != null) {
                            c = t_Enum.Current().Lexeme.toCharArray();
                            iSize = c.length;
                            if (c[0] == '\'' || c[0] == '\"') {
                                aEnd = c[c.length - 1];
                                if (aEnd != c[0]) {
                                    throw new SQLException("unmatched quote in " + t_Enum.Current().Lexeme);
                                }
                                t_Enum.Current().m_format = iSize < 32 ? 1 : (iSize < 128 ? 2 : (iSize < 512 ? 3 : 4));
                            } else {
                                isInt = true;
                                for (ii = 0; ii < t_Enum.Current().Lexeme.length(); ++ii) {
                                    if (c[ii] != '.' && c[ii] != 'e' && c[ii] != 'E') continue;
                                    isInt = false;
                                    break;
                                }
                                t_Enum.Current().m_format = isInt ? (t_Enum.Current().Lexeme.length() > 21 || c[0] == '-' && t_Enum.Current().Lexeme.length() > 20 ? (iSize < 32 ? 1 : (iSize < 128 ? 2 : (iSize < 512 ? 3 : 4))) : 10) : 11;
                            }
                        }
                        t_nOrdinal = this.DynamicVariable(t_bBoundParameters, t_Token, t_nOrdinal, p_Parameters);
                        break;
                    }
                    case 11: {
                        t_NewEnum = t_Enum.Clone();
                        if (!t_NewEnum.MovePrevious() || (t_PreviousToken = t_NewEnum.Current()).TokenTypeGet() == Token.TOKEN.NOT || t_PreviousToken.TokenTypeGet() == Token.TOKEN.IS || t_PreviousToken.TokenTypeGet() == Token.TOKEN.THEN || t_PreviousToken.TokenTypeGet() == Token.TOKEN.COMMA || t_PreviousToken.TokenTypeGet() == Token.TOKEN.OPEN_PAREN || t_PreviousToken.TokenTypeGet() == Token.TOKEN.ELSE || t_PreviousToken.UpperLexeme.contentEquals("SELECT")) break;
                        t_nOrdinal = this.Null(t_bBoundParameters, t_Token, t_nOrdinal, p_Parameters);
                        break;
                    }
                    case 12: {
                        if (t_nRoundNested != 1 || t_nRound != 1) break;
                        ++t_nRound;
                        break;
                    }
                }
                if (Token.TOKEN.COMMA == t_Token.TokenTypeGet() || Token.TOKEN.OPEN_PAREN == t_Token.TokenTypeGet() || Token.TOKEN.CLOSE_PAREN == t_Token.TokenTypeGet()) continue;
                lastToken = t_Token;
            }
            t_Enum.Reset();
            t_nParamIndex = 1;
            t_count = 0;
            bExecute = false;
            while (t_Enum.MoveNext()) {
                ++t_count;
                t_Token = t_Enum.Current();
                if (t_Token.UpperEquals("EXECUTE")) {
                    bExecute = true;
                }
                if (2 == t_count && bExecute) {
                    if (t_Token.UpperEquals("SELECT")) {
                        pOut.p_eStmtType = IRISStatement.StatementType.QUERY;
                        t_SB.setLength(0);
                    } else if (t_Token.UpperEquals("UPDATE") || t_Token.UpperEquals("INSERT")) {
                        pOut.p_eStmtType = IRISStatement.StatementType.UPDATE;
                        t_SB.setLength(0);
                    }
                }
                if (Token.TOKEN.QUESTION_MARK == t_Token.TokenTypeGet() || Token.TOKEN.ATSIGN == t_Token.TokenTypeGet()) {
                    t_SB.append(String.format(":%%qpar(%d)", new Object[]{t_nParamIndex++}));
                    if (t_count >= t_Enum.Count()) continue;
                    t_SB.append(' ');
                    continue;
                }
                t_SB.append(t_Token.Lexeme);
                if (t_count < t_Enum.Count()) {
                    t_SB.append(' ');
                }
                if (t_Token.UpperEquals("SELECT")) {
                    this.appendRowId(t_SB);
                }
                if (!t_Token.UpperEquals("ORDER") || !(haveMore = t_Enum.MoveNext())) continue;
                t_SB.append(t_Enum.Current().Lexeme);
                if (t_count < t_Enum.Count()) {
                    t_SB.append(' ');
                }
                if (!t_Enum.Current().UpperEquals("BY")) continue;
                this.appendIdAdded(t_SB);
            }
        }
        this.m_ParamInfo.set(p_Parameters.size() - this.m_ExecParamCount);
        if (p_Parameters.size() - this.m_ExecParamCount > 0) {
            t_Enum.Reset();
            nParamIndex = 1;
            while (t_Enum.MoveNext()) {
                if (Token.TOKEN.QUESTION_MARK != t_Enum.Current().TokenTypeGet() && Token.TOKEN.ATSIGN != t_Enum.Current().TokenTypeGet()) continue;
                if (t_Enum.Current().m_replaced) {
                    this.m_ParamInfo.set(99);
                } else {
                    this.m_ParamInfo.set(63);
                }
                this.m_ParamInfo.set(t_Enum.Current().m_format);
                if (nParamIndex++ != p_Parameters.size()) continue;
            }
        }
        pOut.sResult = t_SB.toString();
        return pOut;
    }

    static byte[] HexStringToByteArray(String hex) throws Exception {
        if (hex.length() % 2 == 1) {
            throw new Exception("The binary key cannot have an odd number of digits");
        }
        byte[] arr = new byte[hex.length() - 2 >> 1];
        int i = 0;
        int j = 1;
        while (j < hex.length() >> 1) {
            arr[i] = (byte)((PreParser.GetHexVal(hex.charAt(j << 1)) << 4) + PreParser.GetHexVal(hex.charAt((j << 1) + 1)));
            ++j;
            ++i;
        }
        return arr;
    }

    static int GetHexVal(char hex) {
        char val;
        return val - ((val = hex) < ':' ? 48 : (val < 'a' ? 55 : 87));
    }

    int Null(boolean p_bBoundParameters, Token p_Token, int p_nOrdinal, ParameterCollection p_Parameters) {
        ++p_nOrdinal;
        Parameter t_Parameter = new Parameter(Parameter.ParameterMode.DEFAULT_PARAMETER, 'c');
        if (p_bBoundParameters) {
            p_Parameters.add(p_nOrdinal - 1, t_Parameter);
        } else {
            p_Parameters.add(t_Parameter);
        }
        p_Token.Lexeme = "?";
        p_Token.TokenTypeSet(Token.TOKEN.QUESTION_MARK);
        p_Token.m_replaced = true;
        return p_nOrdinal;
    }

    boolean Call(StringBuilder p_SB, ParameterCollection p_Parameters) throws Exception {
        boolean t_bRet;
        block36: {
            Parameter returnParam;
            Token t_Token;
            ITokenEnumerator t_Enum;
            block37: {
                block35: {
                    block34: {
                        t_bRet = false;
                        this.m_eStmtType = IRISStatement.StatementType.UPDATE;
                        p_SB.setLength(0);
                        t_Enum = this.m_Tokens.GetEnumerator();
                        t_Enum.MoveNext();
                        String t_str = t_Enum.Current().UpperLexeme;
                        while (Token.TOKEN.UNKNOWN == t_Enum.Current().TokenTypeGet() && 0 == t_str.indexOf("/*")) {
                            t_Enum.MoveNext();
                            t_str = t_Enum.Current().UpperLexeme;
                        }
                        t_Token = t_Enum.Current();
                        if (t_Token.Lexeme.charAt(0) == '{') {
                            t_Enum.MoveNext();
                            t_Token = t_Enum.Current();
                        }
                        returnParam = null;
                        if (t_Token.TokenTypeGet() != Token.TOKEN.QUESTION_MARK) break block34;
                        returnParam = new Parameter("?", Parameter.ParameterMode.RETURN_VALUE, '?');
                        if (t_Enum.MoveNext() && t_Enum.Current().Lexeme.charAt(0) == '=' && t_Enum.MoveNext()) break block35;
                        break block36;
                    }
                    if (!(t_Enum.Current().UpperEquals("CALL") || t_Enum.Current().UpperEquals("EXEC") || t_Enum.Current().UpperEquals("EXECUTE"))) {
                        return false;
                    }
                }
                if (t_Token.TokenTypeGet() != Token.TOKEN.ATSIGN) break block37;
                this.hasNamedParameters = true;
                returnParam = new Parameter(t_Token.Lexeme, Parameter.ParameterMode.RETURN_VALUE);
                if (!t_Enum.MoveNext() || t_Enum.Current().Lexeme.charAt(0) != '=' || !t_Enum.MoveNext()) break block36;
            }
            if (!(t_Enum.Current().UpperEquals("CALL") || t_Enum.Current().UpperEquals("EXEC") || t_Enum.Current().UpperEquals("EXECUTE") ? false == t_Enum.MoveNext() : Token.TOKEN.STRFUNCTION == t_Enum.Current().TokenTypeGet())) {
                p_SB.append(t_Enum.Current().Lexeme);
                t_Token = t_Enum.Current();
                if (t_Token.UpperEquals("SELECT") || t_Token.UpperEquals("UPDATE") || t_Token.UpperEquals("INSERT")) {
                    p_SB.setLength(0);
                } else if (t_Enum.MoveNext()) {
                    t_Token = t_Enum.Current();
                    if (t_Token.UpperEquals("SELECT") || t_Token.UpperEquals("UPDATE") || t_Token.UpperEquals("INSERT")) {
                        p_SB.setLength(0);
                    } else {
                        boolean t_bQuitLoop = false;
                        while (t_Token.Lexeme.charAt(0) == '.') {
                            p_SB.append('.');
                            if (!t_Enum.MoveNext()) {
                                t_bQuitLoop = true;
                                break;
                            }
                            t_Token = t_Enum.Current();
                            if (t_Token.TokenTypeGet() != Token.TOKEN.ID) continue;
                            p_SB.append(t_Token.Lexeme);
                            if (!t_Enum.MoveNext()) {
                                t_bQuitLoop = true;
                                break;
                            }
                            t_Token = t_Enum.Current();
                        }
                        boolean t_bBoundParameters = p_Parameters.size() > 0;
                        int t_nOrdinal = 0;
                        if (returnParam != null) {
                            ++t_nOrdinal;
                            if (!t_bBoundParameters) {
                                p_Parameters.add(0, returnParam);
                            } else if (!this.matchUpParam(p_Parameters, returnParam.GetName(), t_nOrdinal - 1) && p_Parameters.get(0).GetMode() != Parameter.ParameterMode.RETURN_VALUE) {
                                p_Parameters.add(0, returnParam);
                            }
                        }
                        if (!t_bQuitLoop) {
                            Token.TOKEN t_eLastToken = Token.TOKEN.UNKNOWN;
                            block10: do {
                                t_Token = t_Enum.Current();
                                switch (t_Token.TokenTypeGet()) {
                                    case QUESTION_MARK: {
                                        t_eLastToken = Token.TOKEN.QUESTION_MARK;
                                        ++t_nOrdinal;
                                        if (t_bBoundParameters) continue block10;
                                        p_Parameters.add(new Parameter("?", Parameter.ParameterMode.UNKNOWN, '?'));
                                        break;
                                    }
                                    case ATSIGN: {
                                        this.hasNamedParameters = true;
                                        t_eLastToken = Token.TOKEN.ATSIGN;
                                        ++t_nOrdinal;
                                        if (!t_bBoundParameters || p_Parameters.size() == 0) {
                                            p_Parameters.add(new Parameter(t_Token.Lexeme, Parameter.ParameterMode.UNKNOWN));
                                            break;
                                        }
                                        if (this.matchUpParam(p_Parameters, t_Token.Lexeme, t_nOrdinal - 1)) continue block10;
                                        p_Parameters.add(new Parameter(t_Token.Lexeme, Parameter.ParameterMode.UNKNOWN));
                                        break;
                                    }
                                    case HEX: {
                                        ++t_nOrdinal;
                                        t_eLastToken = Token.TOKEN.QUESTION_MARK;
                                        Parameter cp = new Parameter(PreParser.HexStringToByteArray(t_Token.Lexeme), Parameter.ParameterMode.REPLACED_LITERAL, -2, '?');
                                        p_Parameters.add(cp);
                                        t_Token.TokenTypeSet(Token.TOKEN.QUESTION_MARK);
                                        break;
                                    }
                                    case ID: 
                                    case CONSTANT: {
                                        Token t_PreviousToken;
                                        ITokenEnumerator t_NewEnum = t_Enum.Clone();
                                        if (t_NewEnum.MovePrevious() && (t_PreviousToken = t_NewEnum.Current()).TokenTypeGet() == Token.TOKEN.OP) {
                                            t_nOrdinal = this.DynamicVariable(t_bBoundParameters, new Token(Token.TOKEN.CONSTANT, t_PreviousToken.Lexeme, t_PreviousToken.UpperLexeme), t_nOrdinal, p_Parameters);
                                            t_Token.TokenTypeSet(Token.TOKEN.QUESTION_MARK);
                                            t_eLastToken = Token.TOKEN.QUESTION_MARK;
                                            break;
                                        }
                                        t_nOrdinal = this.DynamicVariable(t_bBoundParameters, t_Token, t_nOrdinal, p_Parameters);
                                        t_eLastToken = Token.TOKEN.QUESTION_MARK;
                                        break;
                                    }
                                    case NULL: {
                                        t_nOrdinal = this.Null(t_bBoundParameters, t_Token, t_nOrdinal, p_Parameters);
                                        t_eLastToken = t_Token.TokenTypeGet();
                                        break;
                                    }
                                    case CLOSE_PAREN: 
                                    case COMMA: {
                                        if (Token.TOKEN.COMMA == t_eLastToken || Token.TOKEN.OPEN_PAREN == t_eLastToken) {
                                            Parameter t_Parameter = new Parameter(Parameter.ParameterMode.DEFAULT_PARAMETER, 'd');
                                            ++t_nOrdinal;
                                            ++this.m_nUndefinedCount;
                                            if (t_bBoundParameters) {
                                                p_Parameters.add(t_nOrdinal - 1, t_Parameter);
                                            } else {
                                                p_Parameters.add(t_Parameter);
                                            }
                                        }
                                        t_eLastToken = t_Token.TokenTypeGet();
                                        break;
                                    }
                                    default: {
                                        t_eLastToken = t_Token.TokenTypeGet();
                                    }
                                }
                            } while (t_Enum.MoveNext());
                        }
                        this.m_eStmtType = returnParam == null ? IRISStatement.StatementType.CALL : IRISStatement.StatementType.CALLWITHRESULT;
                        t_bRet = true;
                    }
                }
            }
        }
        return t_bRet;
    }

    boolean matchUpParam(ParameterCollection param, String paramName, int numParam) {
        boolean match = false;
        if (!this.hasNamedParameters || paramName == null || paramName.equals("") || paramName.charAt(0) != '@') {
            return false;
        }
        for (int i = 0; i < param.size(); ++i) {
            if (param.get(i).GetName().toUpperCase() != paramName.toUpperCase() && "@" + param.get(i).GetName().toUpperCase() != paramName.toUpperCase()) continue;
            match = true;
            if (i != numParam) {
                Parameter cp;
                Parameter cporig = cp = param.get(i);
                if (!cporig.parsermatched) {
                    param.remove(i);
                } else {
                    cp = cporig.Clone();
                    cp.SetName(cporig.GetName() + Integer.toString(numParam));
                    cp.SetMode(Parameter.ParameterMode.UNKNOWN);
                    if (cporig.matchedParamaterList == null) {
                        cporig.matchedParamaterList = new ParameterCollection(5);
                    }
                    cporig.matchedParamaterList.add(cp);
                }
                cp.parsermatched = true;
                param.add(numParam, cp);
                break;
            }
            param.get((int)i).parsermatched = true;
            break;
        }
        return match;
    }

    boolean Exec(StringBuilder p_SB, ParameterCollection p_Parameters) {
        boolean t_bRet;
        block26: {
            boolean t_bHasReturnType;
            Token t_Token;
            ITokenEnumerator t_Enum;
            block27: {
                t_bRet = false;
                this.m_eStmtType = IRISStatement.StatementType.UPDATE;
                t_Enum = this.m_Tokens.GetEnumerator();
                t_Enum.MoveNext();
                t_Token = t_Enum.Current();
                if (!t_Token.UpperEquals("EXEC") && !t_Token.UpperEquals("EXECUTE")) break block26;
                this.m_eStmtType = IRISStatement.StatementType.CALL;
                t_Enum.MoveNext();
                String t_str = t_Enum.Current().UpperLexeme;
                while (Token.TOKEN.UNKNOWN == t_Enum.Current().TokenTypeGet() && 0 == t_str.indexOf("/*")) {
                    t_Enum.MoveNext();
                    t_str = t_Enum.Current().UpperLexeme;
                }
                t_Token = t_Enum.Current();
                if (t_Token.UpperEquals("SELECT") || t_Token.UpperEquals("UPDATE") || t_Token.UpperEquals("INSERT")) break block26;
                t_bRet = true;
                t_bHasReturnType = false;
                if ('@' != t_Token.Lexeme.charAt(0)) break block27;
                t_bHasReturnType = true;
                if (!t_Enum.MoveNext() || !t_Enum.MoveNext()) break block26;
                t_Token = t_Enum.Current();
                if (t_Token.Lexeme != "=" || !t_Enum.MoveNext()) break block26;
                t_Token = t_Enum.Current();
            }
            p_SB.append(t_Token.Lexeme);
            if (!t_Enum.MoveNext()) {
                return true;
            }
            t_Token = t_Enum.Current();
            boolean t_bQuitLoop = false;
            while (t_Token.Lexeme.charAt(0) == '.') {
                p_SB.append('.');
                if (!t_Enum.MoveNext()) {
                    t_bQuitLoop = true;
                    break;
                }
                t_Token = t_Enum.Current();
                if (t_Token.TokenTypeGet() != Token.TOKEN.ID) continue;
                p_SB.append(t_Token.Lexeme);
                if (!t_Enum.MoveNext()) {
                    t_bQuitLoop = true;
                    break;
                }
                t_Token = t_Enum.Current();
            }
            if (!t_bQuitLoop) {
                int t_nOrdinal = 0;
                do {
                    if (Token.TOKEN.COMMA == (t_Token = t_Enum.Current()).TokenTypeGet()) {
                        if (!t_Enum.MoveNext()) break;
                        t_Token = t_Enum.Current();
                    }
                    if (t_Token.UpperEquals("WITH RECOMPILE")) break;
                    String t_strParameterName = "";
                    if (t_Token.Lexeme.charAt(0) == '@') {
                        if (t_Enum.MoveNext()) {
                            t_strParameterName = t_Enum.Current().Lexeme;
                            boolean bMoveNext = t_Enum.MoveNext();
                            if (!bMoveNext || t_Enum.Current().Lexeme != "=") {
                                if (!bMoveNext) {
                                    t_bQuitLoop = true;
                                }
                                Parameter t_Param = new Parameter((Object)Parameter.ParameterMode.INPUT_OUTPUT);
                                t_Param.SetName(t_Token.Lexeme.substring(1));
                                t_Param.SetExecParam(true);
                                ++this.m_ExecParamCount;
                                p_Parameters.add(t_Param);
                                continue;
                            }
                            t_Enum.MoveNext();
                        }
                        t_Token = t_Enum.Current();
                        t_Enum.MoveNext();
                    }
                    switch (t_Token.TokenTypeGet()) {
                        case QUESTION_MARK: 
                        case OPEN_PAREN: 
                        case CLOSE_PAREN: 
                        case UNKNOWN: {
                            break;
                        }
                        default: {
                            if (t_Token != null && Token.TOKEN.OPEN_PAREN != t_Token.TokenTypeGet()) {
                                if (t_Token.Lexeme.charAt(0) == '-') {
                                    if (!t_Enum.MoveNext()) {
                                        t_bQuitLoop = true;
                                        break;
                                    }
                                    t_Token = t_Enum.Current();
                                    Token t_NewToken = new Token(Token.TOKEN.CONSTANT, "-" + t_Token.Lexeme, "-" + t_Token.UpperLexeme);
                                    t_nOrdinal = this.DynamicVariable(false, t_NewToken, t_nOrdinal, p_Parameters);
                                } else {
                                    t_nOrdinal = this.DynamicVariable(false, t_Token, t_nOrdinal, p_Parameters);
                                }
                            }
                            Parameter t_Parameter = p_Parameters.get(p_Parameters.size() - 1);
                            t_Parameter.SetName(t_strParameterName);
                            t_Parameter.SetExecParam(true);
                            ++this.m_ExecParamCount;
                        }
                    }
                } while (t_Enum.MoveNext());
                if (!t_bQuitLoop) {
                    if (t_bHasReturnType) {
                        this.m_eStmtType = IRISStatement.StatementType.CALLWITHRESULT;
                        Parameter t_ReturnParam = new Parameter((Object)Parameter.ParameterMode.UNKNOWN);
                        t_ReturnParam.SetExecParam(true);
                        ++this.m_ExecParamCount;
                        p_Parameters.add(0, t_ReturnParam);
                    } else {
                        this.m_eStmtType = IRISStatement.StatementType.CALL;
                    }
                    t_bRet = true;
                }
            }
        }
        if (0 == this.m_ExecParamCount) {
            return false;
        }
        return t_bRet;
    }

    int DynamicVariable(boolean p_bBoundParameters, Token p_Token, int p_nOrdinal, ParameterCollection p_Parameters) {
        ++p_nOrdinal;
        String t_strItem = p_Token.Lexeme;
        char t_c = t_strItem.charAt(0);
        StringBuilder t_strBld = new StringBuilder(p_Token.Lexeme);
        switch (t_c) {
            case '\"': 
            case '\'': {
                t_strBld.delete(0, 1);
                if (t_strBld.length() > 0) {
                    int ii = t_strBld.length() - 1;
                    t_strBld.delete(ii, ii + 1);
                }
                for (int t_i = 0; t_i < t_strBld.length() - 1; ++t_i) {
                    if (t_strBld.charAt(t_i) != t_c || t_strBld.charAt(t_i + 1) != t_c) continue;
                    t_strBld.delete(t_i, t_i + 1);
                }
                t_strItem = t_strBld.toString();
                break;
            }
            default: {
                if (p_Token.Lexeme.indexOf(101) != -1 || p_Token.Lexeme.indexOf(69) != -1) {
                    try {
                        double t_double = Double.parseDouble(p_Token.Lexeme.toLowerCase());
                        t_strItem = Double.toString(t_double);
                    }
                    catch (Exception t_double) {}
                    break;
                }
                int p = 0;
                if (t_strBld.charAt(p) == '+') {
                    t_strBld.delete(0, 1);
                }
                if (t_strBld.charAt(p) == '-') {
                    ++p;
                }
                while (p < t_strBld.length() && t_strBld.charAt(p) == '0') {
                    t_strBld.delete(p, p + 1);
                }
                t_strItem = p >= t_strBld.length() ? "0" : t_strBld.toString();
            }
        }
        if (p_bBoundParameters) {
            p_Parameters.add(p_nOrdinal - 1, new Parameter(t_strItem, Parameter.ParameterMode.REPLACED_LITERAL));
        } else {
            p_Parameters.add(new Parameter(t_strItem, Parameter.ParameterMode.REPLACED_LITERAL));
        }
        p_Token.Lexeme = "?";
        p_Token.TokenTypeSet(Token.TOKEN.QUESTION_MARK);
        p_Token.m_replaced = true;
        return p_nOrdinal;
    }

    private void appendRowId(StringBuilder sb) {
        if (this.m_addRowID != 0) {
            sb.append("%ID ,");
        }
    }

    private void appendIdAdded(StringBuilder sb) {
        if (this.m_addRowID == 2) {
            sb.append("%IDADDED ");
        }
    }

    private IRISStatement.StatementType GetTypeForCTE(ITokenEnumerator t_NewEnumTemp) {
        while (t_NewEnumTemp.MoveNext()) {
            while (t_NewEnumTemp.MoveNext() && !t_NewEnumTemp.Current().UpperEquals("AS")) {
            }
            int iBr = 0;
            while (t_NewEnumTemp.MoveNext()) {
                if (Token.TOKEN.OPEN_PAREN == t_NewEnumTemp.Current().TokenTypeGet()) {
                    ++iBr;
                    continue;
                }
                if (Token.TOKEN.CLOSE_PAREN == t_NewEnumTemp.Current().TokenTypeGet()) {
                    --iBr;
                }
                if (0 != iBr) continue;
            }
            if (!t_NewEnumTemp.MoveNext() || Token.TOKEN.COMMA == t_NewEnumTemp.Current().TokenTypeGet()) continue;
            if (t_NewEnumTemp.Current().UpperEquals("SELECT")) {
                return IRISStatement.StatementType.QUERY;
            }
            return IRISStatement.StatementType.UPDATE;
        }
        return IRISStatement.StatementType.UPDATE;
    }

    static {
        s_KeywordTable.put("AND", Token.TOKEN.OP);
        s_KeywordTable.put("BETWEEN", Token.TOKEN.OP);
        s_KeywordTable.put("CHAR", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("CHARACTER", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("DEC", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("DECIMAL", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("FLOAT", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("IS", Token.TOKEN.IS);
        s_KeywordTable.put("LIKE", Token.TOKEN.OP);
        s_KeywordTable.put("LONGVARBINARY", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("LONGVARCHAR", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("NCHAR", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("NOT[", Token.TOKEN.OP);
        s_KeywordTable.put("NOT", Token.TOKEN.NOT);
        s_KeywordTable.put("NULL", Token.TOKEN.NULL);
        s_KeywordTable.put("NUMBER", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("NUMERIC", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("NVARCHAR", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("RAW", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("STARTSWITH", Token.TOKEN.OP);
        s_KeywordTable.put("THEN", Token.TOKEN.THEN);
        s_KeywordTable.put("ELSE", Token.TOKEN.ELSE);
        s_KeywordTable.put("VARBINARY", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("VARCHAR", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("VARCHAR2", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("VARYING", Token.TOKEN.DATATYPE);
        s_KeywordTable.put("_", Token.TOKEN.NOT);
        s_KeywordTable.put("%SQLUPPER", Token.TOKEN.STRFUNCTION);
        s_KeywordTable.put("%STRING", Token.TOKEN.STRFUNCTION);
        s_KeywordTable.put("%SQLSTRING", Token.TOKEN.STRFUNCTION);
        s_KeywordTable.put("%TRUNCATE", Token.TOKEN.STRFUNCTION);
        s_KeywordTable.put("TRUNCATE", Token.TOKEN.STRFUNCTION);
        s_KeywordTable.put("COLLATE", Token.TOKEN.STRFUNCTION);
        s_KeywordTable.put("%COLLATE", Token.TOKEN.STRFUNCTION);
        s_StatementTable = new ConcurrentHashMap();
        s_StatementTable.put("ALTER", IRISStatement.StatementType.DDL_ALTER_DROP);
        s_StatementTable.put("CANCEL", IRISStatement.StatementType.DDL_OTHER);
        s_StatementTable.put("CREATE", IRISStatement.StatementType.DDL_OTHER);
        s_StatementTable.put("DROP", IRISStatement.StatementType.DDL_ALTER_DROP);
        s_StatementTable.put("GRANT", IRISStatement.StatementType.DDL_OTHER);
        s_StatementTable.put("REVOKE", IRISStatement.StatementType.DDL_OTHER);
        s_StatementTable.put("%CHECKPRIV", IRISStatement.StatementType.DDL_OTHER);
        s_StatementTable.put("TRAIN", IRISStatement.StatementType.DDL_OTHER);
        s_StatementTable.put("TUNE", IRISStatement.StatementType.DDL_OTHER);
        s_StatementTable.put("VALIDATE", IRISStatement.StatementType.DDL_OTHER);
        s_StatementTable.put("LOAD", IRISStatement.StatementType.DDL_OTHER);
        s_StatementTable.put("PURGE", IRISStatement.StatementType.DDL_OTHER);
        s_StatementTable.put("FREEZE", IRISStatement.StatementType.DDL_OTHER);
        s_StatementTable.put("UNFREEZE", IRISStatement.StatementType.DDL_OTHER);
        s_StatementTable.put("BUILD", IRISStatement.StatementType.DDL_OTHER);
        s_StatementTable.put("LOCK", IRISStatement.StatementType.DDL_OTHER);
        s_StatementTable.put("UNLOCK", IRISStatement.StatementType.DDL_OTHER);
        s_StatementTable.put("THROUGH", IRISStatement.StatementType.QUERY);
        s_StatementTable.put("USE", IRISStatement.StatementType.STMT_USE);
        s_StatementTable.put("EXPLAIN", IRISStatement.StatementType.CALLWITHRESULT);
        s_ParsedStatements = new ConcurrentHashMap();
        s_ParsedStatements.put("SELECT", IRISStatement.StatementType.QUERY);
        s_ParsedStatements.put("INSERT", IRISStatement.StatementType.UPDATE);
        s_ParsedStatements.put("DELETE", IRISStatement.StatementType.UPDATE);
        s_ParsedStatements.put("UPDATE", IRISStatement.StatementType.UPDATE);
        s_ParsedStatements.put("WITH", IRISStatement.StatementType.WITH);
        s_TransactionStatements = new ConcurrentHashMap();
        s_TransactionStatements.put("COMMIT", true);
        s_TransactionStatements.put("ROLLBACK", true);
        s_TransactionStatements.put("START", true);
        s_TransactionStatements.put("%INTRANSACTION", true);
        s_TransactionStatements.put("%INTRANS", true);
        s_TransactionStatements.put("%BEGTRANS", true);
        s_replaceparm = " SELECT TOP WHERE ON AND OR NOT BETWEEN %STARTSWITH LIKE CASE WHEN ELSE THEN";
        s_mapReservedKeywords = new ConcurrentHashMap();
        s_ReservedKeywords = Collections.newSetFromMap(s_mapReservedKeywords);
        s_ReservedKeywords.add("%AFTERHAVING");
        s_ReservedKeywords.add("%ALLINDEX");
        s_ReservedKeywords.add("%ALPHAUP");
        s_ReservedKeywords.add("%ALTER");
        s_ReservedKeywords.add("%BEGTRANS");
        s_ReservedKeywords.add("%CHECKPRIV");
        s_ReservedKeywords.add("%CLASSNAME");
        s_ReservedKeywords.add("%CLASSPARAMETER");
        s_ReservedKeywords.add("%DBUGFULL");
        s_ReservedKeywords.add("%DELDATA");
        s_ReservedKeywords.add("%DESCRIPTION");
        s_ReservedKeywords.add("%EXACT");
        s_ReservedKeywords.add("%EXTERNAL");
        s_ReservedKeywords.add("%FILE");
        s_ReservedKeywords.add("%FIRSTTABLE");
        s_ReservedKeywords.add("%FLATTEN");
        s_ReservedKeywords.add("%FOREACH");
        s_ReservedKeywords.add("%FULL");
        s_ReservedKeywords.add("%ID");
        s_ReservedKeywords.add("%IDADDED");
        s_ReservedKeywords.add("%IGNOREINDEX");
        s_ReservedKeywords.add("%IGNOREINDICES");
        s_ReservedKeywords.add("%INLIST");
        s_ReservedKeywords.add("%INORDER");
        s_ReservedKeywords.add("%INTERNAL");
        s_ReservedKeywords.add("%INTEXT");
        s_ReservedKeywords.add("%INTRANS");
        s_ReservedKeywords.add("%INTRANSACTION");
        s_ReservedKeywords.add("%KEY");
        s_ReservedKeywords.add("%MATCHES");
        s_ReservedKeywords.add("%MCODE");
        s_ReservedKeywords.add("%MERGE");
        s_ReservedKeywords.add("%MINUS");
        s_ReservedKeywords.add("%MVR");
        s_ReservedKeywords.add("%NOCHECK");
        s_ReservedKeywords.add("%NODELDATA");
        s_ReservedKeywords.add("%NOFLATTEN");
        s_ReservedKeywords.add("%NOFPLAN");
        s_ReservedKeywords.add("%NOINDEX");
        s_ReservedKeywords.add("%NOLOCK");
        s_ReservedKeywords.add("%NOMERGE");
        s_ReservedKeywords.add("%NOPARALLEL");
        s_ReservedKeywords.add("%NOREDUCE");
        s_ReservedKeywords.add("%NORUNTIME");
        s_ReservedKeywords.add("%NOSVSO");
        s_ReservedKeywords.add("%NOTOPOPT");
        s_ReservedKeywords.add("%NOTRIGGER");
        s_ReservedKeywords.add("%NOUNIONOROPT");
        s_ReservedKeywords.add("%NUMROWS");
        s_ReservedKeywords.add("%ODBCIN");
        s_ReservedKeywords.add("%ODBCOUT");
        s_ReservedKeywords.add("%PARALLEL");
        s_ReservedKeywords.add("%PLUS");
        s_ReservedKeywords.add("%PROFILE");
        s_ReservedKeywords.add("%PROFILE_ALL");
        s_ReservedKeywords.add("%PUBLICROWID");
        s_ReservedKeywords.add("%ROUTINE");
        s_ReservedKeywords.add("%ROWCOUNT");
        s_ReservedKeywords.add("%RUNTIMEIN");
        s_ReservedKeywords.add("%RUNTIMEOUT");
        s_ReservedKeywords.add("%STARTSWITH");
        s_ReservedKeywords.add("%STARTTABLE");
        s_ReservedKeywords.add("%SQLSTRING");
        s_ReservedKeywords.add("%SQLUPPER");
        s_ReservedKeywords.add("%STRING");
        s_ReservedKeywords.add("%TABLENAME");
        s_ReservedKeywords.add("%TRUNCATE");
        s_ReservedKeywords.add("%UPPER");
        s_ReservedKeywords.add("%VALUE");
        s_ReservedKeywords.add("%VID");
        s_ReservedKeywords.add("ABSOLUTE");
        s_ReservedKeywords.add("ADD");
        s_ReservedKeywords.add("ALL");
        s_ReservedKeywords.add("ALLOCATE");
        s_ReservedKeywords.add("ALTER");
        s_ReservedKeywords.add("AND");
        s_ReservedKeywords.add("ANY");
        s_ReservedKeywords.add("ARE");
        s_ReservedKeywords.add("AS");
        s_ReservedKeywords.add("ASC");
        s_ReservedKeywords.add("ASSERTION");
        s_ReservedKeywords.add("AT");
        s_ReservedKeywords.add("AUTHORIZATION");
        s_ReservedKeywords.add("AVG");
        s_ReservedKeywords.add("BEGIN");
        s_ReservedKeywords.add("BETWEEN");
        s_ReservedKeywords.add("BIT");
        s_ReservedKeywords.add("BIT_LENGTH");
        s_ReservedKeywords.add("BOTH");
        s_ReservedKeywords.add("BY");
        s_ReservedKeywords.add("CASCADE");
        s_ReservedKeywords.add("CASE");
        s_ReservedKeywords.add("CAST");
        s_ReservedKeywords.add("CHAR");
        s_ReservedKeywords.add("CHARACTER");
        s_ReservedKeywords.add("CHARACTER_LENGTH");
        s_ReservedKeywords.add("CHAR_LENGTH");
        s_ReservedKeywords.add("CHECK");
        s_ReservedKeywords.add("CLOSE");
        s_ReservedKeywords.add("COALESCE");
        s_ReservedKeywords.add("COLLATE");
        s_ReservedKeywords.add("COMMIT");
        s_ReservedKeywords.add("CONNECT");
        s_ReservedKeywords.add("CONNECTION");
        s_ReservedKeywords.add("CONSTRAINT");
        s_ReservedKeywords.add("CONSTRAINTS");
        s_ReservedKeywords.add("CONTINUE");
        s_ReservedKeywords.add("CONVERT");
        s_ReservedKeywords.add("CORRESPONDING");
        s_ReservedKeywords.add("COUNT");
        s_ReservedKeywords.add("CREATE");
        s_ReservedKeywords.add("CROSS");
        s_ReservedKeywords.add("CURRENT");
        s_ReservedKeywords.add("CURRENT_DATE");
        s_ReservedKeywords.add("CURRENT_TIME");
        s_ReservedKeywords.add("CURRENT_TIMESTAMP");
        s_ReservedKeywords.add("CURRENT_USER");
        s_ReservedKeywords.add("CURSOR");
        s_ReservedKeywords.add("DATE");
        s_ReservedKeywords.add("DEALLOCATE");
        s_ReservedKeywords.add("DEC");
        s_ReservedKeywords.add("DECIMAL");
        s_ReservedKeywords.add("DECLARE");
        s_ReservedKeywords.add("DEFAULT");
        s_ReservedKeywords.add("DEFERRABLE");
        s_ReservedKeywords.add("DEFERRED");
        s_ReservedKeywords.add("DELETE");
        s_ReservedKeywords.add("DESC");
        s_ReservedKeywords.add("DESCRIBE");
        s_ReservedKeywords.add("DESCRIPTOR");
        s_ReservedKeywords.add("DIAGNOSTICS");
        s_ReservedKeywords.add("DISCONNECT");
        s_ReservedKeywords.add("DISTINCT");
        s_ReservedKeywords.add("DOMAIN");
        s_ReservedKeywords.add("DOUBLE");
        s_ReservedKeywords.add("DROP");
        s_ReservedKeywords.add("ELSE");
        s_ReservedKeywords.add("END");
        s_ReservedKeywords.add("ENDEXEC");
        s_ReservedKeywords.add("ESCAPE");
        s_ReservedKeywords.add("EXCEPT");
        s_ReservedKeywords.add("EXCEPTION");
        s_ReservedKeywords.add("EXEC");
        s_ReservedKeywords.add("EXECUTE");
        s_ReservedKeywords.add("EXISTS");
        s_ReservedKeywords.add("EXTERNAL");
        s_ReservedKeywords.add("EXTRACT");
        s_ReservedKeywords.add("FALSE");
        s_ReservedKeywords.add("FETCH");
        s_ReservedKeywords.add("FIRST");
        s_ReservedKeywords.add("FLOAT");
        s_ReservedKeywords.add("FOR");
        s_ReservedKeywords.add("FOREIGN");
        s_ReservedKeywords.add("FOUND");
        s_ReservedKeywords.add("FROM");
        s_ReservedKeywords.add("FULL");
        s_ReservedKeywords.add("GET");
        s_ReservedKeywords.add("GLOBAL");
        s_ReservedKeywords.add("GO");
        s_ReservedKeywords.add("GOTO");
        s_ReservedKeywords.add("GRANT");
        s_ReservedKeywords.add("GROUP");
        s_ReservedKeywords.add("HAVING");
        s_ReservedKeywords.add("HOUR");
        s_ReservedKeywords.add("IDENTITY");
        s_ReservedKeywords.add("IMMEDIATE");
        s_ReservedKeywords.add("IN");
        s_ReservedKeywords.add("INDICATOR");
        s_ReservedKeywords.add("INITIALLY");
        s_ReservedKeywords.add("INNER");
        s_ReservedKeywords.add("INPUT");
        s_ReservedKeywords.add("INSENSITIVE");
        s_ReservedKeywords.add("INSERT");
        s_ReservedKeywords.add("INT");
        s_ReservedKeywords.add("INTEGER");
        s_ReservedKeywords.add("INTERSECT");
        s_ReservedKeywords.add("INTERVAL");
        s_ReservedKeywords.add("INTO");
        s_ReservedKeywords.add("IS");
        s_ReservedKeywords.add("ISOLATION");
        s_ReservedKeywords.add("JOIN");
        s_ReservedKeywords.add("LANGUAGE");
        s_ReservedKeywords.add("LAST");
        s_ReservedKeywords.add("LEADING");
        s_ReservedKeywords.add("LEFT");
        s_ReservedKeywords.add("LEVEL");
        s_ReservedKeywords.add("LIKE");
        s_ReservedKeywords.add("LOCAL");
        s_ReservedKeywords.add("LOWER");
        s_ReservedKeywords.add("MATCH");
        s_ReservedKeywords.add("MAX");
        s_ReservedKeywords.add("MIN");
        s_ReservedKeywords.add("MINUTE");
        s_ReservedKeywords.add("MODULE");
        s_ReservedKeywords.add("NAMES");
        s_ReservedKeywords.add("NATIONAL");
        s_ReservedKeywords.add("NATURAL");
        s_ReservedKeywords.add("NCHAR");
        s_ReservedKeywords.add("NEXT");
        s_ReservedKeywords.add("NO");
        s_ReservedKeywords.add("NOT");
        s_ReservedKeywords.add("NULL");
        s_ReservedKeywords.add("NULLIF");
        s_ReservedKeywords.add("NUMERIC");
        s_ReservedKeywords.add("OCTET_LENGTH");
        s_ReservedKeywords.add("OF");
        s_ReservedKeywords.add("ON");
        s_ReservedKeywords.add("ONLY");
        s_ReservedKeywords.add("OPEN");
        s_ReservedKeywords.add("OPTION");
        s_ReservedKeywords.add("OR");
        s_ReservedKeywords.add("OUTER");
        s_ReservedKeywords.add("OUTPUT");
        s_ReservedKeywords.add("OVERLAPS");
        s_ReservedKeywords.add("PAD");
        s_ReservedKeywords.add("PARTIAL");
        s_ReservedKeywords.add("PREPARE");
        s_ReservedKeywords.add("PRESERVE");
        s_ReservedKeywords.add("PRIMARY");
        s_ReservedKeywords.add("PRIOR");
        s_ReservedKeywords.add("PRIVILEGES");
        s_ReservedKeywords.add("PROCEDURE");
        s_ReservedKeywords.add("PUBLIC");
        s_ReservedKeywords.add("READ");
        s_ReservedKeywords.add("REAL");
        s_ReservedKeywords.add("REFERENCES");
        s_ReservedKeywords.add("RELATIVE");
        s_ReservedKeywords.add("RESTRICT");
        s_ReservedKeywords.add("REVOKE");
        s_ReservedKeywords.add("RIGHT");
        s_ReservedKeywords.add("ROLE");
        s_ReservedKeywords.add("ROLLBACK");
        s_ReservedKeywords.add("ROWS");
        s_ReservedKeywords.add("SCHEMA");
        s_ReservedKeywords.add("SCROLL");
        s_ReservedKeywords.add("SECOND");
        s_ReservedKeywords.add("SECTION");
        s_ReservedKeywords.add("SELECT");
        s_ReservedKeywords.add("SESSION_USER");
        s_ReservedKeywords.add("SET");
        s_ReservedKeywords.add("SHARD");
        s_ReservedKeywords.add("SMALLINT");
        s_ReservedKeywords.add("SOME");
        s_ReservedKeywords.add("SPACE");
        s_ReservedKeywords.add("SQLERROR");
        s_ReservedKeywords.add("SQLSTATE");
        s_ReservedKeywords.add("STATISTICS");
        s_ReservedKeywords.add("SUBSTRING");
        s_ReservedKeywords.add("SUM");
        s_ReservedKeywords.add("SYSDATE");
        s_ReservedKeywords.add("SYSTEM_USER");
        s_ReservedKeywords.add("TABLE");
        s_ReservedKeywords.add("TEMPORARY");
        s_ReservedKeywords.add("THEN");
        s_ReservedKeywords.add("TIME");
        s_ReservedKeywords.add("TIMEZONE_HOUR");
        s_ReservedKeywords.add("TIMEZONE_MINUTE");
        s_ReservedKeywords.add("TO");
        s_ReservedKeywords.add("TOP");
        s_ReservedKeywords.add("TRAILING");
        s_ReservedKeywords.add("TRANSACTION");
        s_ReservedKeywords.add("TRIM");
        s_ReservedKeywords.add("TRUE");
        s_ReservedKeywords.add("UNION");
        s_ReservedKeywords.add("UNIQUE");
        s_ReservedKeywords.add("UPDATE");
        s_ReservedKeywords.add("UPPER");
        s_ReservedKeywords.add("USER");
        s_ReservedKeywords.add("USING");
        s_ReservedKeywords.add("VALUES");
        s_ReservedKeywords.add("VARCHAR");
        s_ReservedKeywords.add("VARYING");
        s_ReservedKeywords.add("WHEN");
        s_ReservedKeywords.add("WHENEVER");
        s_ReservedKeywords.add("WHERE");
        s_ReservedKeywords.add("WITH");
        s_ReservedKeywords.add("WORK");
        s_ReservedKeywords.add("WRITE");
    }
}

