/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc.preparser;

import com.intersystems.jdbc.preparser.CheckPoint;
import com.intersystems.jdbc.preparser.ParseToken;
import com.intersystems.jdbc.preparser.Token;
import java.util.Locale;

class Scanner {
    String m_strSource;
    String m_strUpperSource;
    int m_nIndex;
    int m_nSourceLen;
    int m_nLexemeBegin;
    Token.TOKEN m_tempToken;
    boolean m_boolReturn;
    private ParseToken m_CurrentToken = null;
    static ParseToken[] s_tokenTab = new ParseToken[]{ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokTAB, ParseToken.tokNEWLN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokRETURN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokUNKN, ParseToken.tokSPACE, ParseToken.tokEXCLA, ParseToken.tokDQUOTE, ParseToken.tokPOUND, ParseToken.tokDOLLAR, ParseToken.tokPERCENT, ParseToken.tokAMPER, ParseToken.tokSQUOTE, ParseToken.tokLPARN, ParseToken.tokRPARN, ParseToken.tokASTER, ParseToken.tokPLUS, ParseToken.tokCOMMA, ParseToken.tokMINUS, ParseToken.tokDOT, ParseToken.tokSLASH, ParseToken.tokDIGIT, ParseToken.tokDIGIT, ParseToken.tokDIGIT, ParseToken.tokDIGIT, ParseToken.tokDIGIT, ParseToken.tokDIGIT, ParseToken.tokDIGIT, ParseToken.tokDIGIT, ParseToken.tokDIGIT, ParseToken.tokDIGIT, ParseToken.tokCOLON, ParseToken.tokSEMI, ParseToken.tokLESS, ParseToken.tokEQUAL, ParseToken.tokGREAT, ParseToken.tokQUEST, ParseToken.tokATSIGN, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLBRACK, ParseToken.tokBSLASH, ParseToken.tokRBRACK, ParseToken.tokARROW, ParseToken.tokUSCORE, ParseToken.tokBQUOTE, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLETTER, ParseToken.tokLBRACE, ParseToken.tokVBAR, ParseToken.tokRBRACE, ParseToken.tokTILDE, ParseToken.tokUNKN};

    ParseToken CurrentTokenGet() {
        return this.m_CurrentToken;
    }

    private void CurrentTokenSet(ParseToken token) {
        this.m_CurrentToken = token;
    }

    char CurrentChar() {
        if (this.m_nIndex >= this.m_nSourceLen) {
            return '\u0000';
        }
        return this.m_strSource.charAt(this.m_nIndex);
    }

    Scanner() {
        this.Initialize("");
    }

    Scanner(String p_strSource) {
        this.Initialize(p_strSource);
    }

    CheckPoint CreateCheckPoint() {
        return new CheckPoint(this.m_nIndex, this.m_nLexemeBegin);
    }

    void RestoreCheckPoint(CheckPoint p_CP) {
        this.m_nIndex = p_CP.m_nIndex - 1;
        this.m_nLexemeBegin = p_CP.m_nLexemeBegin;
        this.NextToken();
    }

    void BeginLexeme() {
        this.m_nLexemeBegin = this.m_nIndex;
    }

    String EndLexeme() {
        int t_nLexemeLen = this.m_nIndex - this.m_nLexemeBegin;
        if (t_nLexemeLen < 0) {
            return "";
        }
        return this.m_strSource.substring(this.m_nLexemeBegin, this.m_nLexemeBegin + t_nLexemeLen);
    }

    String EndUpperLexeme() {
        int t_nLexemeLen = this.m_nIndex - this.m_nLexemeBegin;
        if (t_nLexemeLen < 0) {
            return "";
        }
        return this.m_strUpperSource.substring(this.m_nLexemeBegin, this.m_nLexemeBegin + t_nLexemeLen);
    }

    ParseToken NextToken() {
        if (this.m_nIndex != this.m_nSourceLen) {
            ++this.m_nIndex;
            if (this.m_nIndex >= this.m_nSourceLen) {
                this.CurrentTokenSet(ParseToken.tokEOS);
            } else {
                this.CurrentTokenSet(this.Classify(this.m_strSource.charAt(this.m_nIndex)));
            }
        }
        return this.CurrentTokenGet();
    }

    ParseToken PeekNextToken() {
        return this.PeekAhead(1);
    }

    ParseToken PeekNextNextToken() {
        return this.PeekAhead(2);
    }

    char PeekNextChar() {
        return this.PeekAheadChar(1);
    }

    char PeekNextNextChar() {
        return this.PeekAheadChar(2);
    }

    void SkipToEndOfLine() {
        while (!this.IsNewLine(this.CurrentTokenGet())) {
            this.NextToken();
            if (this.CurrentTokenGet() != ParseToken.tokEOS) continue;
            break;
        }
    }

    boolean IsNewLine(ParseToken p_eToken) {
        switch (p_eToken) {
            case tokNEWLN: 
            case tokCRLF: 
            case tokRETURN: {
                return true;
            }
        }
        return false;
    }

    boolean IsWhitespace(ParseToken p_eToken) {
        switch (p_eToken) {
            case tokNEWLN: 
            case tokCRLF: 
            case tokRETURN: 
            case tokTAB: 
            case tokSPACE: {
                return true;
            }
        }
        return false;
    }

    void SkipWhitespace() {
        while (this.IsWhitespace(this.CurrentTokenGet())) {
            this.NextToken();
            if (this.CurrentTokenGet() != ParseToken.tokEOS) continue;
            break;
        }
    }

    void Skip(int t_nTokens) {
        for (int t_i = 0; t_i < t_nTokens; ++t_i) {
            this.NextToken();
        }
    }

    String Keyword() {
        this.BeginLexeme();
        while (this.CurrentTokenGet() == ParseToken.tokLETTER) {
            this.NextToken();
        }
        return this.EndLexeme();
    }

    boolean Comment() {
        boolean t_bRet = false;
        while (this.CurrentTokenGet() != ParseToken.tokEOS) {
            if (ParseToken.tokASTER == this.CurrentTokenGet() && ParseToken.tokSLASH == this.PeekNextToken()) {
                this.Skip(2);
                t_bRet = true;
                break;
            }
            this.NextToken();
        }
        return t_bRet;
    }

    String Number() {
        this.m_boolReturn = true;
        this.BeginLexeme();
        if (ParseToken.tokMINUS == this.CurrentTokenGet() || ParseToken.tokPLUS == this.CurrentTokenGet()) {
            this.NextToken();
        }
        while (ParseToken.tokDIGIT == this.CurrentTokenGet()) {
            this.NextToken();
        }
        if (ParseToken.tokDOT == this.CurrentTokenGet()) {
            this.NextToken();
            while (ParseToken.tokDIGIT == this.CurrentTokenGet()) {
                this.NextToken();
            }
        }
        if (ParseToken.tokLETTER == this.CurrentTokenGet() && ('E' == this.CurrentChar() || 'e' == this.CurrentChar())) {
            this.NextToken();
            if (ParseToken.tokPLUS == this.CurrentTokenGet() || ParseToken.tokMINUS == this.CurrentTokenGet()) {
                this.NextToken();
            }
            if (ParseToken.tokDIGIT != this.CurrentTokenGet()) {
                this.m_boolReturn = false;
            } else {
                while (ParseToken.tokDIGIT == this.CurrentTokenGet()) {
                    this.NextToken();
                }
            }
        }
        return this.EndLexeme();
    }

    String Hex() {
        char c;
        this.m_boolReturn = true;
        if (this.CurrentChar() == '0' && ((c = this.PeekAheadChar(1)) == 'X' || c == 'x')) {
            this.BeginLexeme();
            do {
                this.NextToken();
            } while (this.CurrentTokenGet() == ParseToken.tokDIGIT || this.CurrentTokenGet() == ParseToken.tokLETTER);
            return this.EndLexeme();
        }
        this.m_boolReturn = false;
        return this.EndLexeme();
    }

    String String(boolean p_bDelimitedIdentifiers) {
        String t_strRet;
        this.m_tempToken = null;
        this.BeginLexeme();
        ParseToken t_eToken = this.CurrentTokenGet();
        this.NextToken();
        while (ParseToken.tokEOS != this.CurrentTokenGet()) {
            if (t_eToken == this.CurrentTokenGet()) {
                if (t_eToken == this.PeekNextToken()) {
                    this.Skip(2);
                    continue;
                }
                this.NextToken();
                break;
            }
            this.NextToken();
        }
        this.m_tempToken = "\"\"" == (t_strRet = this.EndLexeme()) || "''" == t_strRet ? Token.TOKEN.CONSTANT : (t_strRet.startsWith("'") || false == p_bDelimitedIdentifiers ? Token.TOKEN.CONSTANT : Token.TOKEN.ID);
        return t_strRet;
    }

    String ParseBrackets(boolean p_bDelimitedIdentifiers) {
        this.m_tempToken = null;
        this.NextToken();
        this.BeginLexeme();
        while (true) {
            if (ParseToken.tokEOS == this.CurrentTokenGet() || ParseToken.tokRBRACK == this.CurrentTokenGet()) break;
            this.NextToken();
        }
        String t_strRet = "\"" + this.EndLexeme() + "\"";
        this.NextToken();
        this.m_tempToken = Token.TOKEN.ID;
        return t_strRet;
    }

    String Variable() {
        block1: {
            this.BeginLexeme();
            if (ParseToken.tokLETTER != this.CurrentTokenGet()) break block1;
            do {
                this.NextToken();
            } while (this.CurrentTokenGet() == ParseToken.tokDIGIT || this.CurrentTokenGet() == ParseToken.tokLETTER || this.CurrentTokenGet() == ParseToken.tokUSCORE);
        }
        return this.EndLexeme();
    }

    String Identifier() {
        this.BeginLexeme();
        ParseToken t_eToken = this.CurrentTokenGet();
        if (ParseToken.tokLETTER == t_eToken || ParseToken.tokPERCENT == t_eToken || ParseToken.tokDOLLAR == t_eToken || ParseToken.tokPOUND == t_eToken || ParseToken.tokUSCORE == t_eToken) {
            boolean t_bQuitLoop = false;
            do {
                switch (this.NextToken()) {
                    case tokLETTER: 
                    case tokDIGIT: 
                    case tokUSCORE: 
                    case tokAMPER: 
                    case tokDOLLAR: 
                    case tokPOUND: 
                    case tokATSIGN: {
                        break;
                    }
                    default: {
                        t_bQuitLoop = true;
                    }
                }
            } while (!t_bQuitLoop);
        }
        return this.EndLexeme();
    }

    private void Initialize(String p_strSource) {
        this.m_strSource = p_strSource;
        this.m_strUpperSource = p_strSource.toUpperCase(Locale.ROOT);
        this.m_nSourceLen = p_strSource.length();
        if (this.m_strUpperSource.length() != this.m_nSourceLen) {
            int iStart = 0;
            int iEnd = 0;
            this.m_strUpperSource = "";
            String strTemp = "";
            String strTempUpper = "";
            for (int i = 0; i < this.m_nSourceLen; ++i) {
                if (' ' != this.m_strSource.charAt(i) && '\t' != this.m_strSource.charAt(i) && '\n' != this.m_strSource.charAt(i) && '\r' != this.m_strSource.charAt(i) && i != this.m_nSourceLen - 1) continue;
                iEnd = i;
                if (i == this.m_nSourceLen - 1) {
                    ++iEnd;
                }
                strTemp = this.m_strSource.substring(iStart, iEnd);
                iStart = i;
                strTempUpper = strTemp.toUpperCase(Locale.ROOT);
                this.m_strUpperSource = strTemp.length() != strTempUpper.length() ? this.m_strUpperSource + strTemp : this.m_strUpperSource + strTempUpper;
            }
        }
        this.m_nIndex = -1;
        this.m_nLexemeBegin = 0;
        this.NextToken();
    }

    private ParseToken PeekAhead(int p_nChars) {
        int t_nOffset = this.m_nIndex + p_nChars;
        if (t_nOffset >= this.m_nSourceLen) {
            return ParseToken.tokEOS;
        }
        return this.Classify(this.m_strSource.charAt(t_nOffset));
    }

    private char PeekAheadChar(int p_nChars) {
        int t_nOffset = this.m_nIndex + p_nChars;
        if (t_nOffset >= this.m_nSourceLen) {
            return '\u0000';
        }
        return this.m_strSource.charAt(t_nOffset);
    }

    private ParseToken Classify(char p_ch) {
        if (p_ch < '\u0080') {
            return s_tokenTab[p_ch];
        }
        if ('\u00a0' == p_ch) {
            return ParseToken.tokSPACE;
        }
        return ParseToken.tokLETTER;
    }

    String checkForNotPredicates() {
        if (!this.IsWhitespace(this.CurrentTokenGet())) {
            switch (this.CurrentTokenGet()) {
                case tokRBRACK: 
                case tokLBRACK: 
                case tokEQUAL: 
                case tokGREAT: 
                case tokLESS: 
                case tokEXCLA: {
                    this.NextToken();
                    return this.EndLexeme();
                }
            }
        }
        return this.EndLexeme();
    }
}

