/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbcgateway;

import com.intersystems.gateway.GatewayContext;
import com.intersystems.jdbcgateway.StreamContainer;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class JDBCGateway {
    List<Connection> connList = new ArrayList<Connection>();
    List<PreparedStatement> stmtList = new ArrayList<PreparedStatement>();
    List<ResultSet> rsList = new ArrayList<ResultSet>();
    HashMap<Connection, List<Integer>> connToSt = new HashMap();
    HashMap<Connection, List<Integer>> connToRs = new HashMap();
    HashMap<PreparedStatement, ResultSet> stToRs = new HashMap();
    HashMap<PreparedStatement, ResultSetMetaData> stToMd = new HashMap();
    HashMap<PreparedStatement, StreamContainer> stToStrCont = new HashMap();
    HashMap<ResultSet, List<Object>> rsToLOB = new HashMap();
    HashMap<PreparedStatement, List<Object>> stToLOB = new HashMap();
    SQLException sqlEx = null;
    Exception ex = null;
    boolean isXA = false;

    public String getErrorText() {
        if (this.sqlEx == null) {
            return "";
        }
        StringBuilder errText = new StringBuilder("Remote JDBC error: ");
        do {
            errText = errText.append(this.sqlEx.getMessage()).append(". ");
            this.sqlEx = this.sqlEx.getNextException();
        } while (this.sqlEx != null);
        return errText.toString();
    }

    public byte[] getBinary(int sind, int colnum) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSet rs = this.stToRs.get(pstmt);
            return rs.getBytes(colnum);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return null;
        }
    }

    public String getString(int sind, int colnum) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSet rs = this.stToRs.get(pstmt);
            if (rs != null) {
                return rs.getString(colnum);
            }
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
        }
        return "";
    }

    public byte[] stgetBinary(int sind, int colnum) {
        this.sqlEx = null;
        try {
            CallableStatement pstmt = (CallableStatement)this.stmtList.get(sind);
            return pstmt.getBytes(colnum);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return null;
        }
    }

    public String stgetString(int sind, int colnum) {
        this.sqlEx = null;
        try {
            CallableStatement pstmt = (CallableStatement)this.stmtList.get(sind);
            return pstmt.getString(colnum);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return "";
        }
    }

    public String stgetDate(int sind, int colnum) {
        this.sqlEx = null;
        try {
            CallableStatement pstmt = (CallableStatement)this.stmtList.get(sind);
            Date dt = pstmt.getDate(colnum);
            return dt.toString();
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return "";
        }
    }

    public String stgetTime(int sind, int colnum) {
        this.sqlEx = null;
        try {
            CallableStatement pstmt = (CallableStatement)this.stmtList.get(sind);
            Time tm = pstmt.getTime(colnum);
            return tm.toString();
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return "";
        }
    }

    public String stgetTimestamp(int sind, int colnum) {
        this.sqlEx = null;
        try {
            CallableStatement pstmt = (CallableStatement)this.stmtList.get(sind);
            Timestamp ts = pstmt.getTimestamp(colnum);
            return ts.toString();
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return "";
        }
    }

    public int setString(int sind, int parnum, String s) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            pstmt.setString(parnum, s);
            return 0;
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int setValueBinary(int sind, int parnum, byte[] ba) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            if (ba == null) {
                pstmt.setNull(parnum, -2);
                return 0;
            }
            pstmt.setBytes(parnum, ba);
        }
        catch (Throwable ex) {
            if (ex instanceof SQLException) {
                this.sqlEx = (SQLException)ex;
            }
            return -1;
        }
        return 0;
    }

    public int setValue(int sind, int parnum, String s, int sqlType) {
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            int normType = this.normalize(sqlType);
            try {
                ParameterMetaData pmd = pstmt.getParameterMetaData();
                int ptype = pmd.getParameterType(parnum);
                this.setAsType(pstmt, parnum, s, ptype);
                return 0;
            }
            catch (Throwable throwable) {
                this.setAsType(pstmt, parnum, s, normType);
                return 0;
            }
        }
        catch (Throwable ex) {
            if (ex instanceof SQLException) {
                if (this.sqlEx != null) {
                    this.sqlEx.setNextException((SQLException)ex);
                } else {
                    this.sqlEx = (SQLException)ex;
                }
            } else if (ex instanceof Exception) {
                if (this.sqlEx != null) {
                    this.sqlEx.setNextException(new SQLException(ex.getClass().getSimpleName() + ": " + ex.getMessage()));
                } else {
                    this.sqlEx = new SQLException(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                }
            }
            return -1;
        }
    }

    public int setValueDirect(int sind, int parnum, String s, int sqlType) {
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            int normType = this.normalize(sqlType);
            try {
                this.setAsType(pstmt, parnum, s, normType);
                return 0;
            }
            catch (Throwable throwable) {
                ParameterMetaData pmd = pstmt.getParameterMetaData();
                int ptype = pmd.getParameterType(parnum);
                this.setAsType(pstmt, parnum, s, ptype);
                return 0;
            }
        }
        catch (Throwable ex) {
            if (ex instanceof SQLException) {
                if (this.sqlEx != null) {
                    this.sqlEx.setNextException((SQLException)ex);
                } else {
                    this.sqlEx = (SQLException)ex;
                }
            } else if (ex instanceof Exception) {
                if (this.sqlEx != null) {
                    this.sqlEx.setNextException(new SQLException(ex.getClass().getSimpleName() + ": " + ex.getMessage()));
                } else {
                    this.sqlEx = new SQLException(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                }
            }
            return -1;
        }
    }

    private int normalize(int sqlType) {
        int normalized = sqlType;
        switch (sqlType) {
            case 11: {
                normalized = 93;
                break;
            }
            case 10: {
                normalized = 92;
                break;
            }
            case 9: {
                normalized = 91;
            }
        }
        return normalized;
    }

    private void setAsType(PreparedStatement pstmt, int parnum, String s, int sqlType) throws Throwable {
        if (s == null) {
            pstmt.setNull(parnum, sqlType);
            return;
        }
        switch (sqlType) {
            case 93: {
                pstmt.setTimestamp(parnum, Timestamp.valueOf(s));
                break;
            }
            case 92: {
                pstmt.setTime(parnum, Time.valueOf(s));
                break;
            }
            case 91: {
                pstmt.setDate(parnum, Date.valueOf(s.substring(0, 10)));
                break;
            }
            case -5: {
                pstmt.setLong(parnum, Long.parseLong(s));
                break;
            }
            case 6: {
                pstmt.setFloat(parnum, Float.parseFloat(s));
                break;
            }
            case 4: {
                pstmt.setInt(parnum, Integer.parseInt(s));
                break;
            }
            case 8: {
                pstmt.setDouble(parnum, Double.parseDouble(s));
                break;
            }
            case 2: 
            case 3: {
                pstmt.setBigDecimal(parnum, new BigDecimal(s));
                break;
            }
            case 5: {
                pstmt.setShort(parnum, Short.parseShort(s));
                break;
            }
            case -7: 
            case 16: {
                boolean asBool = true;
                if (s.equals("") || s.equals("0")) {
                    asBool = false;
                }
                pstmt.setBoolean(parnum, asBool);
                break;
            }
            case 999: {
                pstmt.setObject(parnum, (Object)s, 999);
                break;
            }
            default: {
                pstmt.setString(parnum, s);
            }
        }
    }

    public int registerOutParameter(int sind, int parnum, int sqlType) {
        this.sqlEx = null;
        if (sqlType == 0) {
            sqlType = 12;
        }
        try {
            CallableStatement pstmt = (CallableStatement)this.stmtList.get(sind);
            pstmt.registerOutParameter(parnum, sqlType);
            return 0;
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public boolean wasError() {
        return this.sqlEx != null;
    }

    public boolean isXA() {
        return this.isXA;
    }

    public boolean next(int sind) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSet rs = this.stToRs.get(pstmt);
            if (rs != null) {
                return rs.next();
            }
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
        }
        return false;
    }

    public boolean cnext(int rind) {
        this.sqlEx = null;
        try {
            ResultSet rs = this.rsList.get(rind);
            return rs.next();
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return false;
        }
    }

    public String cgetString(int rind, int colnum) {
        this.sqlEx = null;
        try {
            ResultSet rs = this.rsList.get(rind);
            return rs.getString(colnum);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return "";
        }
    }

    public int cgetBLOB(int rind, int colnum) {
        this.sqlEx = null;
        try {
            ResultSet rs = this.rsList.get(rind);
            Blob bl = rs.getBlob(colnum);
            if (bl == null) {
                return -1;
            }
            return this.addLOBToMap(bl, rs);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getBLOB(int sind, int colnum) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSet rs = this.stToRs.get(pstmt);
            Blob bl = rs.getBlob(colnum);
            if (bl == null) {
                return -1;
            }
            return this.addLOBToMap(bl, rs);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getCLOB(int sind, int colnum) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSet rs = this.stToRs.get(pstmt);
            Clob bl = rs.getClob(colnum);
            if (bl == null) {
                return -1;
            }
            return this.addLOBToMap(bl, rs);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getArgCLOB(int sind, int colnum) {
        this.sqlEx = null;
        try {
            CallableStatement pstmt = (CallableStatement)this.stmtList.get(sind);
            Clob bl = pstmt.getClob(colnum);
            if (bl == null) {
                return -2;
            }
            return this.addStLOBToMap(bl, pstmt);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getArgBLOB(int sind, int colnum) {
        this.sqlEx = null;
        try {
            CallableStatement pstmt = (CallableStatement)this.stmtList.get(sind);
            Blob bl = pstmt.getBlob(colnum);
            if (bl == null) {
                return -1;
            }
            return this.addStLOBToMap(bl, pstmt);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public byte[] cgetBLOBBytes(int rind, int bind, long pos, int len) {
        this.sqlEx = null;
        try {
            ResultSet rs = this.rsList.get(rind);
            List<Object> al = this.rsToLOB.get(rs);
            Blob bl = (Blob)al.get(bind);
            if (bl == null) {
                return null;
            }
            return bl.getBytes(pos, len);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return null;
        }
    }

    public String cgetCLOBSubstr(int rind, int bind, long pos, int len) {
        this.sqlEx = null;
        try {
            ResultSet rs = this.rsList.get(rind);
            List<Object> al = this.rsToLOB.get(rs);
            Clob bl = (Clob)al.get(bind);
            if (bl == null) {
                return null;
            }
            return bl.getSubString(pos, len);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return null;
        }
    }

    public byte[] getBLOBBytes(int sind, int bind, long pos, int len) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSet rs = this.stToRs.get(pstmt);
            List<Object> al = this.rsToLOB.get(rs);
            Blob bl = (Blob)al.get(bind);
            if (bl == null) {
                return null;
            }
            byte[] bb = bl.getBytes(pos, len);
            if (bb == null || bb.length == 0) {
                return null;
            }
            return bb;
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return null;
        }
    }

    public byte[] getArgBLOBBytes(int sind, int bind, long pos, int len) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            List<Object> al = this.stToLOB.get(pstmt);
            Blob bl = (Blob)al.get(bind);
            if (bl == null) {
                return null;
            }
            byte[] bb = bl.getBytes(pos, len);
            if (bb == null || bb.length == 0) {
                return null;
            }
            return bb;
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return null;
        }
    }

    public String getCLOBSubstr(int sind, int bind, long pos, int len) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSet rs = this.stToRs.get(pstmt);
            List<Object> al = this.rsToLOB.get(rs);
            Clob bl = (Clob)al.get(bind);
            if (bl == null) {
                return null;
            }
            if (bl.length() + 1L >= pos + (long)len) {
                return bl.getSubString(pos, len);
            }
            String s = bl.getSubString(pos, (int)(bl.length() - pos + 1L));
            if (s == null || s.length() == 0) {
                return null;
            }
            return s;
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return null;
        }
    }

    public String getArgCLOBSubstr(int sind, int bind, long pos, int len) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            List<Object> al = this.stToLOB.get(pstmt);
            Clob bl = (Clob)al.get(bind);
            if (bl == null) {
                return null;
            }
            if (bl.length() + 1L >= pos + (long)len) {
                return bl.getSubString(pos, len);
            }
            String s = bl.getSubString(pos, (int)(bl.length() - pos + 1L));
            if (s.length() == 0) {
                return null;
            }
            return s;
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return null;
        }
    }

    public int cgetCLOB(int rind, int colnum) {
        this.sqlEx = null;
        try {
            ResultSet rs = this.rsList.get(rind);
            Clob bl = rs.getClob(colnum);
            if (bl == null) {
                return -1;
            }
            return this.addLOBToMap(bl, rs);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public ResultSet getRS(int sind) {
        this.ex = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSet rs = this.stToRs.get(pstmt);
            return rs;
        }
        catch (Exception ex_) {
            this.ex = ex_;
            return null;
        }
    }

    public int execUpdate(int sind) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            return pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getUpdateCount(int sind) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            return pstmt.getUpdateCount();
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int connect(String classname, String connString, String user, String pwd) {
        int rs;
        block8: {
            rs = -1;
            this.sqlEx = null;
            try {
                DriverManager.setLoginTimeout(30);
                if (classname == null) {
                    Connection c = DriverManager.getConnection(connString, user, pwd);
                    if (c == null) {
                        return rs;
                    }
                    rs = this.addConnection(c);
                    break block8;
                }
                if (classname.startsWith("driver:")) {
                    Connection c;
                    String driverName = classname.substring(7);
                    Class<?> driverClass = Class.forName(driverName, true, GatewayContext.getClassLoader());
                    Driver driver = (Driver)driverClass.newInstance();
                    Properties properties = new Properties();
                    if (user != null) {
                        properties.setProperty("user", user);
                    }
                    if (pwd != null) {
                        properties.setProperty("password", pwd);
                    }
                    if ((c = driver.connect(connString, properties)) == null) {
                        return rs;
                    }
                    rs = this.addConnection(c);
                    break block8;
                }
                throw new SQLException("Invalid classname parameter");
            }
            catch (Exception ex) {
                this.sqlEx = new SQLException(ex);
            }
        }
        return rs;
    }

    public int connectXA(String dsName, String stringInfo) {
        int rs = -1;
        this.sqlEx = null;
        try {
            Class<?> dsClass = Class.forName(dsName, true, GatewayContext.getClassLoader());
            XADataSource ds = (XADataSource)dsClass.newInstance();
            StringTokenizer st = new StringTokenizer(stringInfo, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.indexOf(61) == -1) continue;
                String key = token.substring(0, token.indexOf(61));
                String val = token.substring(token.indexOf(61) + 1);
                String methodName = "set" + key;
                Class[] partypes = new Class[1];
                Method meth = null;
                Object[] arglist = new Object[1];
                try {
                    partypes[0] = String.class;
                    meth = dsClass.getMethod(methodName, partypes);
                    arglist[0] = new String(val);
                }
                catch (NoSuchMethodException nmex) {
                    partypes[0] = Integer.TYPE;
                    meth = dsClass.getMethod(methodName, partypes);
                    arglist[0] = new Integer(val);
                }
                meth.invoke((Object)ds, arglist);
            }
            XAConnection xac1 = ds.getXAConnection();
            Connection c = xac1.getConnection();
            c.setAutoCommit(false);
            rs = this.addConnection(c);
        }
        catch (Exception ex_) {
            this.ex = ex_;
        }
        return rs;
    }

    public int connectWithPropString(String classname, String connString, String stringInfo) {
        int rs;
        block9: {
            rs = -1;
            this.sqlEx = null;
            try {
                Properties prop = new Properties();
                StringTokenizer st = new StringTokenizer(stringInfo, ";");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.indexOf(61) == -1) continue;
                    String key = token.substring(0, token.indexOf(61));
                    String val = token.substring(token.indexOf(61) + 1);
                    if (key.equals("password")) {
                        while (st.hasMoreTokens()) {
                            val = val + ";" + st.nextToken();
                        }
                    }
                    prop.put(key, val);
                }
                DriverManager.setLoginTimeout(30);
                if (classname == null) {
                    Connection c = DriverManager.getConnection(connString, prop);
                    if (c == null) {
                        return rs;
                    }
                    rs = this.addConnection(c);
                    break block9;
                }
                if (classname.startsWith("driver:")) {
                    String driverName = classname.substring(7);
                    Class<?> driverClass = Class.forName(driverName, true, GatewayContext.getClassLoader());
                    Driver driver = (Driver)driverClass.newInstance();
                    Connection c = driver.connect(connString, prop);
                    if (c == null) {
                        return rs;
                    }
                    rs = this.addConnection(c);
                    break block9;
                }
                throw new SQLException("Invalid classname parameter");
            }
            catch (Exception ex) {
                this.sqlEx = new SQLException(ex);
            }
        }
        return rs;
    }

    public int execQuery(int sind) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSet rs = pstmt.executeQuery();
            if (rs != null) {
                this.addRsToMap(pstmt, rs);
                ResultSetMetaData md = rs.getMetaData();
                this.addMdToMap(pstmt, md);
                return 0;
            }
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
        }
        return -1;
    }

    public int getGeneratedKeys(int sind) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSet rs = pstmt.getGeneratedKeys();
            if (rs != null) {
                this.addRsToMap(pstmt, rs);
                ResultSetMetaData md = rs.getMetaData();
                this.addMdToMap(pstmt, md);
                return 0;
            }
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
        }
        return -1;
    }

    public int getPreparedStatementMetaData(int sind) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSetMetaData md = pstmt.getMetaData();
            this.addMdToMap(pstmt, md);
            return 0;
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int initStrCont(int sind) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            StreamContainer sc = new StreamContainer();
            this.stToStrCont.put(pstmt, sc);
        }
        catch (Exception ex) {
            return -1;
        }
        return 0;
    }

    public int setBinaryStream(int sind, int ind) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            StreamContainer sc = this.stToStrCont.get(pstmt);
            int len = sc.getBinaryLength();
            if (len == 0) {
                pstmt.setNull(ind, -4);
                return 0;
            }
            pstmt.setBinaryStream(ind, sc.getInputStream(), len);
            return 0;
        }
        catch (Exception ex) {
            if (ex instanceof SQLException) {
                this.sqlEx = (SQLException)ex;
            }
            return -1;
        }
    }

    public int setCharacterStream(int sind, int ind) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            StreamContainer sc = this.stToStrCont.get(pstmt);
            int len = sc.getStrLength();
            if (len == 0) {
                Clob clob = null;
                pstmt.setClob(ind, clob);
                return 0;
            }
            pstmt.setCharacterStream(ind, (Reader)sc.getReader(), len);
            return 0;
        }
        catch (Exception ex) {
            if (ex instanceof SQLException) {
                this.sqlEx = (SQLException)ex;
            }
            return -1;
        }
    }

    public int addBytes(int sind, byte[] b) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            StreamContainer sc = this.stToStrCont.get(pstmt);
            return sc.addBytes(b);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public int addString(int sind, String s) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            StreamContainer sc = this.stToStrCont.get(pstmt);
            return sc.addString(s);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public int rmStrCont(int sind) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            this.stToStrCont.remove(pstmt);
        }
        catch (Exception ex) {
            return -1;
        }
        return 0;
    }

    public int getResultSet(int sind) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSet rs = this.stToRs.get(pstmt);
            if (rs != null) {
                rs.close();
                this.stToRs.remove(pstmt);
                int rind = this.rsList.indexOf(rs);
                if (rind != -1) {
                    this.removeResultSet(rind);
                    this.rsList.set(rind, null);
                }
            }
            if ((rs = pstmt.getResultSet()) == null) {
                return -1;
            }
            this.addRsToMap(pstmt, rs);
            ResultSetMetaData md = rs.getMetaData();
            this.addMdToMap(pstmt, md);
            return 0;
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getArgResultSet(int sind, int colnum) {
        this.sqlEx = null;
        try {
            CallableStatement pstmt = (CallableStatement)this.stmtList.get(sind);
            ResultSet rs = (ResultSet)pstmt.getObject(colnum);
            if (rs != null) {
                this.addRsToMap(pstmt, rs);
                ResultSetMetaData md = rs.getMetaData();
                this.addMdToMap(pstmt, md);
                return 0;
            }
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
        }
        return -1;
    }

    public int getMoreResults(int sind) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            boolean rc = pstmt.getMoreResults();
            if (!rc) {
                return 0;
            }
            return 1;
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int execute(int sind) {
        if (sind < 0) {
            return sind;
        }
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            boolean rc = pstmt.execute();
            if (rc) {
                return 1;
            }
            return 0;
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public boolean addBatch(int sind) {
        if (sind < 0) {
            return false;
        }
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            pstmt.addBatch();
            return true;
        }
        catch (SQLException ex) {
            if (this.sqlEx != null) {
                this.sqlEx.setNextException(ex);
            } else {
                this.sqlEx = ex;
            }
            return false;
        }
    }

    public int[] executeBatch(int sind) {
        if (sind < 0) {
            return null;
        }
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            int[] rc = pstmt.executeBatch();
            return rc;
        }
        catch (BatchUpdateException ex) {
            if (this.sqlEx != null) {
                this.sqlEx.setNextException(ex);
            } else {
                this.sqlEx = ex;
            }
            int[] rc = ex.getUpdateCounts();
            return rc;
        }
        catch (SQLException ex) {
            if (this.sqlEx != null) {
                this.sqlEx.setNextException(ex);
            } else {
                this.sqlEx = ex;
            }
            return null;
        }
    }

    public int getTables(int connIndex, String catalog, String schema, String table, String[] types) {
        this.sqlEx = null;
        try {
            Connection connection = this.connList.get(connIndex);
            DatabaseMetaData dbmd = connection.getMetaData();
            ResultSet resultSet = dbmd.getTables(catalog, schema, table, types);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getExportedKeys(int connIndex, String catalog, String schema, String table) {
        this.sqlEx = null;
        try {
            Connection connection = this.connList.get(connIndex);
            DatabaseMetaData dbmd = connection.getMetaData();
            ResultSet resultSet = dbmd.getExportedKeys(catalog, schema, table);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getImportedKeys(int connIndex, String catalog, String schema, String table) {
        this.sqlEx = null;
        try {
            Connection connection = this.connList.get(connIndex);
            DatabaseMetaData dbmd = connection.getMetaData();
            ResultSet resultSet = dbmd.getImportedKeys(catalog, schema, table);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getIndexInfo(int connIndex, String catalog, String schema, String table, boolean unique, boolean approximate) {
        this.sqlEx = null;
        try {
            Connection connection = this.connList.get(connIndex);
            DatabaseMetaData dbmd = connection.getMetaData();
            ResultSet resultSet = dbmd.getIndexInfo(catalog, schema, table, unique, approximate);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getCrossReference(int connIndex, String catalog, String schema, String table, String fcatalog, String fschema, String ftable) {
        this.sqlEx = null;
        try {
            Connection connection = this.connList.get(connIndex);
            DatabaseMetaData dbmd = connection.getMetaData();
            ResultSet resultSet = dbmd.getCrossReference(catalog, schema, table, fcatalog, fschema, ftable);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getColumns(int connIndex, String catalog, String schema, String table, String name) {
        this.sqlEx = null;
        try {
            Connection connection = this.connList.get(connIndex);
            DatabaseMetaData dbmd = connection.getMetaData();
            ResultSet resultSet = dbmd.getColumns(catalog, schema, table, name);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getPrimaryKeys(int connIndex, String catalog, String schema, String table) {
        this.sqlEx = null;
        try {
            Connection connection = this.connList.get(connIndex);
            DatabaseMetaData dbmd = connection.getMetaData();
            ResultSet resultSet = dbmd.getPrimaryKeys(catalog, schema, table);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getProcedureColumns(int connIndex, String catalog, String schema, String proc, String name) {
        this.sqlEx = null;
        try {
            Connection connection = this.connList.get(connIndex);
            DatabaseMetaData dbmd = connection.getMetaData();
            ResultSet resultSet = dbmd.getProcedureColumns(catalog, schema, proc, name);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getProcedures(int connIndex, String catalog, String schema, String name) {
        this.sqlEx = null;
        try {
            Connection connection = this.connList.get(connIndex);
            DatabaseMetaData dbmd = connection.getMetaData();
            ResultSet resultSet = dbmd.getProcedures(catalog, schema, name);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int columnCount(int sind) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSetMetaData md = this.stToMd.get(pstmt);
            if (md != null) {
                return md.getColumnCount();
            }
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
        }
        return -1;
    }

    public int getColumnType(int sind, int column) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSetMetaData md = this.stToMd.get(pstmt);
            return md.getColumnType(column);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public String getColumnTypeName(int sind, int column) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSetMetaData md = this.stToMd.get(pstmt);
            return md.getColumnTypeName(column);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return "";
        }
    }

    public int getPrecision(int sind, int column) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSetMetaData md = this.stToMd.get(pstmt);
            return md.getPrecision(column);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getScale(int sind, int column) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSetMetaData md = this.stToMd.get(pstmt);
            return md.getScale(column);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getColumnDisplaySize(int sind, int column) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSetMetaData md = this.stToMd.get(pstmt);
            return md.getColumnDisplaySize(column);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int isCurrency(int sind, int column) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSetMetaData md = this.stToMd.get(pstmt);
            if (md.isCurrency(column)) {
                return 1;
            }
            return 0;
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int isNullable(int sind, int column) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSetMetaData md = this.stToMd.get(pstmt);
            return md.isNullable(column);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int isAutoIncrement(int sind, int column) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSetMetaData md = this.stToMd.get(pstmt);
            if (md.isAutoIncrement(column)) {
                return 1;
            }
            return 0;
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int isCaseSensitive(int sind, int column) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSetMetaData md = this.stToMd.get(pstmt);
            if (md.isCaseSensitive(column)) {
                return 1;
            }
            return 0;
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int isReadOnly(int sind, int column) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSetMetaData md = this.stToMd.get(pstmt);
            if (md.isReadOnly(column)) {
                return 1;
            }
            return 0;
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public String getColumnName(int sind, int column) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSetMetaData md = this.stToMd.get(pstmt);
            return md.getColumnName(column);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return "";
        }
    }

    public String columnTypeName(int sind, int column) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSetMetaData md = this.stToMd.get(pstmt);
            return md.getColumnTypeName(column);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return "";
        }
    }

    public int removeStatement(int sind) {
        try {
            block16: {
                PreparedStatement pstmt;
                block15: {
                    this.sqlEx = null;
                    pstmt = this.stmtList.get(sind);
                    if (pstmt instanceof CallableStatement) {
                        this.removeAllArgLOBs(sind);
                    }
                    ResultSet rs = this.stToRs.get(pstmt);
                    try {
                        if (rs != null) {
                            int rind = this.rsList.indexOf(rs);
                            if (rind != -1) {
                                this.removeResultSet(rind);
                            } else {
                                this.rsToLOB.remove(rs);
                            }
                            rs.close();
                        }
                    }
                    catch (Exception ex) {
                        if (!(ex instanceof SQLException)) break block15;
                        this.sqlEx = (SQLException)ex;
                    }
                }
                this.stToRs.remove(pstmt);
                this.stToMd.remove(pstmt);
                this.stToStrCont.remove(pstmt);
                this.stmtList.set(sind, null);
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    if (!(ex instanceof SQLException)) break block16;
                    this.sqlEx = (SQLException)ex;
                }
            }
            for (int ii = 0; ii < this.connList.size(); ++ii) {
                if (this.connList.get(ii) == null) continue;
                Connection c = this.connList.get(ii);
                try {
                    List<Integer> al = this.connToSt.get(c);
                    if (al == null) continue;
                    for (int jj = 0; jj < al.size(); ++jj) {
                        Integer ind;
                        if (al.get(jj) == null || (ind = al.get(jj)) != sind) continue;
                        al.set(jj, null);
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return 0;
        }
        catch (Exception ex) {
            if (ex instanceof SQLException) {
                this.sqlEx = (SQLException)ex;
            }
            return -1;
        }
    }

    public int removeResultSet(int rind) {
        try {
            ResultSet rs = this.rsList.get(rind);
            rs.close();
            this.removeAllLOBs(rind);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
        }
        try {
            this.sqlEx = null;
            this.rsList.set(rind, null);
            for (int ii = 0; ii < this.connList.size(); ++ii) {
                if (this.connList.get(ii) == null) continue;
                Connection c = this.connList.get(ii);
                try {
                    List<Integer> al = this.connToRs.get(c);
                    if (al == null) continue;
                    for (int jj = 0; jj < al.size(); ++jj) {
                        Integer ind;
                        if (al.get(jj) == null || (ind = al.get(jj)) != rind) continue;
                        al.set(jj, null);
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public int closeAll() {
        for (int ii = 0; ii < this.connList.size(); ++ii) {
            block3: {
                if (this.connList.get(ii) == null) continue;
                Connection c = this.connList.get(ii);
                try {
                    c.close();
                }
                catch (Exception ex) {
                    if (!(ex instanceof SQLException)) break block3;
                    this.sqlEx = (SQLException)ex;
                }
            }
            this.removeConnection(ii);
        }
        return 0;
    }

    public int removeConnection(int connIndex) {
        try {
            Connection c = this.connList.get(connIndex);
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            List<Integer> al = this.connToSt.get(c);
            if (al != null) {
                for (int ii = 0; ii < al.size(); ++ii) {
                    if (al.get(ii) == null) continue;
                    Integer sind = al.get(ii);
                    this.removeStatement(sind);
                }
            }
            this.connToSt.remove(c);
            List<Integer> rl = this.connToRs.get(c);
            if (rl != null) {
                for (int ii = 0; ii < rl.size(); ++ii) {
                    if (rl.get(ii) == null) continue;
                    Integer rind = rl.get(ii);
                    this.removeResultSet(rind);
                }
            }
            this.connToRs.remove(c);
            this.connList.set(connIndex, null);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public int setAutoCommit(int connIndex, boolean autoCommit) {
        this.sqlEx = null;
        try {
            Connection c = this.connList.get(connIndex);
            c.setAutoCommit(autoCommit);
            return 0;
        }
        catch (Exception ex) {
            if (ex instanceof SQLException) {
                this.sqlEx = (SQLException)ex;
            }
            return -1;
        }
    }

    public int commitXA() {
        return -1;
    }

    public int rollbackXA() {
        return -1;
    }

    public int commit(int connIndex) {
        this.sqlEx = null;
        try {
            Connection c = this.connList.get(connIndex);
            c.commit();
            return 0;
        }
        catch (Exception ex) {
            if (ex instanceof SQLException) {
                this.sqlEx = (SQLException)ex;
            }
            return -1;
        }
    }

    public int rollback(int connIndex) {
        this.sqlEx = null;
        try {
            Connection c = this.connList.get(connIndex);
            c.rollback();
            return 0;
        }
        catch (Exception ex) {
            if (ex instanceof SQLException) {
                this.sqlEx = (SQLException)ex;
            }
            return -1;
        }
    }

    public int getColumnCount(int sind) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSetMetaData md = this.stToMd.get(pstmt);
            return md.getColumnCount();
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getParameterCount(int sind) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ParameterMetaData pmd = pstmt.getParameterMetaData();
            return pmd.getParameterCount();
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public String getParameterClassName(int sind, int pnumber) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ParameterMetaData pmd = pstmt.getParameterMetaData();
            return pmd.getParameterClassName(pnumber);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return "";
        }
    }

    public String getParameterTypeName(int sind, int pnumber) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ParameterMetaData pmd = pstmt.getParameterMetaData();
            return pmd.getParameterTypeName(pnumber);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return "";
        }
    }

    public int getParameterMode(int sind, int pnumber) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ParameterMetaData pmd = pstmt.getParameterMetaData();
            return pmd.getParameterMode(pnumber);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getParameterType(int sind, int pnumber) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ParameterMetaData pmd = pstmt.getParameterMetaData();
            return pmd.getParameterType(pnumber);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getParameterPrecision(int sind, int pnumber) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ParameterMetaData pmd = pstmt.getParameterMetaData();
            return pmd.getPrecision(pnumber);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int getParameterScale(int sind, int pnumber) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ParameterMetaData pmd = pstmt.getParameterMetaData();
            return pmd.getScale(pnumber);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int isParameterNullable(int sind, int pnumber) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ParameterMetaData pmd = pstmt.getParameterMetaData();
            return pmd.isNullable(pnumber);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int isParameterSigned(int sind, int pnumber) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ParameterMetaData pmd = pstmt.getParameterMetaData();
            return pmd.isSigned(pnumber) ? 1 : 0;
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int prepareStatement(int connIndex, String sql) {
        this.sqlEx = null;
        int res = -1;
        try {
            Connection c = this.connList.get(connIndex);
            PreparedStatement pstmt = c.prepareStatement(sql);
            res = this.addStatement(pstmt, c);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
        }
        return res;
    }

    public int prepareStatementGK(int connIndex, String sql) {
        this.sqlEx = null;
        int res = -1;
        try {
            Connection c = this.connList.get(connIndex);
            PreparedStatement pstmt = c.prepareStatement(sql, 1);
            res = this.addStatement(pstmt, c);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
        }
        return res;
    }

    public String getDatabaseProductName(int connIndex) {
        this.sqlEx = null;
        String res = "";
        try {
            Connection c = this.connList.get(connIndex);
            DatabaseMetaData dmd = c.getMetaData();
            return dmd.getDatabaseProductName();
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return res;
        }
    }

    public String getIdentifierQuoteString(int connIndex) {
        this.sqlEx = null;
        String res = "";
        try {
            Connection c = this.connList.get(connIndex);
            DatabaseMetaData dmd = c.getMetaData();
            return dmd.getIdentifierQuoteString();
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return res;
        }
    }

    public int prepareCall(int connIndex, String sql) {
        this.sqlEx = null;
        int res = -1;
        try {
            Connection c = this.connList.get(connIndex);
            CallableStatement pstmt = c.prepareCall(sql);
            res = this.addStatement(pstmt, c);
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
        }
        return res;
    }

    public int isValid(int connIndex) {
        this.sqlEx = null;
        int res = -1;
        int timeout = 15;
        try {
            Connection c = this.connList.get(connIndex);
            if (c.getClass().getSimpleName().contains("IfxSql")) {
                timeout = 0;
            }
            res = c.isValid(timeout) ? 1 : 0;
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
        }
        return res;
    }

    public int setXAMode(int mode) {
        return -1;
    }

    private int addConnection(Connection conn) {
        for (int ii = 0; ii < this.connList.size(); ++ii) {
            if (this.connList.get(ii) != null) continue;
            this.connList.set(ii, conn);
            return ii;
        }
        this.connList.add(conn);
        return this.connList.size() - 1;
    }

    private void addStToMap(Connection conn, int sind) {
        List<Object> al;
        if (!this.connToSt.containsKey(conn)) {
            al = new ArrayList();
            this.connToSt.put(conn, al);
        } else {
            al = this.connToSt.get(conn);
        }
        for (int jj = 0; jj < al.size(); ++jj) {
            if (al.get(jj) != null) continue;
            al.set(jj, new Integer(sind));
            return;
        }
        al.add(new Integer(sind));
    }

    private void addRsToMap(Connection conn, int sind) {
        List<Object> al;
        if (!this.connToRs.containsKey(conn)) {
            al = new ArrayList();
            this.connToRs.put(conn, al);
        } else {
            al = this.connToRs.get(conn);
        }
        for (int jj = 0; jj < al.size(); ++jj) {
            if (al.get(jj) != null) continue;
            al.set(jj, new Integer(sind));
            return;
        }
        al.add(new Integer(sind));
    }

    public int removeLOB(int sind, int lobIndex) {
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            ResultSet rs = this.stToRs.get(pstmt);
            if (rs == null) {
                return 0;
            }
            List<Object> al = this.rsToLOB.get(rs);
            if (al == null) {
                return 0;
            }
            if (lobIndex >= al.size()) {
                return 0;
            }
            Object lob = al.get(lobIndex);
            if (lob instanceof Clob) {
                ((Clob)lob).free();
            }
            if (lob instanceof Blob) {
                ((Blob)lob).free();
            }
            al.set(lobIndex, null);
            return 0;
        }
        catch (Exception _ex) {
            if (_ex instanceof SQLException) {
                this.sqlEx = (SQLException)_ex;
            }
            this.ex = _ex;
            return -1;
        }
    }

    public int removeArgLOB(int sind, int lobIndex) {
        try {
            CallableStatement pstmt = (CallableStatement)this.stmtList.get(sind);
            List<Object> al = this.stToLOB.get(pstmt);
            if (al == null) {
                return 0;
            }
            if (lobIndex >= al.size()) {
                return 0;
            }
            Object lob = al.get(lobIndex);
            if (lob instanceof Clob) {
                ((Clob)lob).free();
            }
            if (lob instanceof Blob) {
                ((Blob)lob).free();
            }
            al.set(lobIndex, null);
            return 0;
        }
        catch (Exception _ex) {
            if (_ex instanceof SQLException) {
                this.sqlEx = (SQLException)_ex;
            }
            this.ex = _ex;
            return -1;
        }
    }

    public int getQueryTimeout(int sind) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            return pstmt.getQueryTimeout();
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    public int setQueryTimeout(int sind, int timeout) {
        this.sqlEx = null;
        try {
            PreparedStatement pstmt = this.stmtList.get(sind);
            pstmt.setQueryTimeout(timeout);
            return 0;
        }
        catch (SQLException ex) {
            this.sqlEx = ex;
            return -1;
        }
    }

    private void removeAllLOBs(int rsIndex) {
        try {
            ResultSet rs = this.rsList.get(rsIndex);
            if (rs == null) {
                return;
            }
            List<Object> al = this.rsToLOB.get(rs);
            if (al == null) {
                return;
            }
            al = null;
            this.rsToLOB.remove(rs);
        }
        catch (Exception _ex) {
            this.ex = _ex;
        }
    }

    private void removeAllArgLOBs(int sind) {
        try {
            CallableStatement pstmt = (CallableStatement)this.stmtList.get(sind);
            if (pstmt == null) {
                return;
            }
            List<Object> al = this.stToLOB.get(pstmt);
            if (al == null) {
                return;
            }
            al = null;
            this.stToLOB.remove(pstmt);
        }
        catch (Exception _ex) {
            this.ex = _ex;
        }
    }

    private int addLOBToMap(Object lob, ResultSet rs) {
        List<Object> al;
        if (!this.rsToLOB.containsKey(rs)) {
            al = new ArrayList();
            this.rsToLOB.put(rs, al);
        } else {
            al = this.rsToLOB.get(rs);
        }
        for (int ii = 0; ii < al.size(); ++ii) {
            if (al.get(ii) != null) continue;
            al.set(ii, lob);
            return ii;
        }
        al.add(lob);
        return al.size() - 1;
    }

    private int addStLOBToMap(Object lob, PreparedStatement st) {
        List<Object> al;
        if (!this.stToLOB.containsKey(st)) {
            al = new ArrayList();
            this.stToLOB.put(st, al);
        } else {
            al = this.stToLOB.get(st);
        }
        for (int ii = 0; ii < al.size(); ++ii) {
            if (al.get(ii) != null) continue;
            al.set(ii, lob);
            return ii;
        }
        al.add(lob);
        return al.size() - 1;
    }

    private void addRsToMap(PreparedStatement st, ResultSet rs) {
        ResultSet rs1 = this.stToRs.get(st);
        if (rs1 != null) {
            int rind = this.rsList.indexOf(rs1);
            this.removeResultSet(rind);
        }
        this.stToRs.put(st, rs);
        for (int ii = 0; ii < this.rsList.size(); ++ii) {
            if (this.rsList.get(ii) != null) continue;
            this.rsList.set(ii, rs);
            return;
        }
        this.rsList.add(rs);
    }

    private void addMdToMap(PreparedStatement st, ResultSetMetaData md) {
        this.stToMd.put(st, md);
    }

    private int addStatement(PreparedStatement st, Connection conn) {
        for (int ii = 0; ii < this.stmtList.size(); ++ii) {
            if (this.stmtList.get(ii) != null) continue;
            this.stmtList.set(ii, st);
            this.addStToMap(conn, ii);
            return ii;
        }
        this.stmtList.add(st);
        this.addStToMap(conn, this.stmtList.size() - 1);
        return this.stmtList.size() - 1;
    }

    private int addResultSet(ResultSet rs, Connection conn) {
        for (int ii = 0; ii < this.rsList.size(); ++ii) {
            if (this.rsList.get(ii) != null) continue;
            this.rsList.set(ii, rs);
            this.addRsToMap(conn, ii);
            return ii;
        }
        this.rsList.add(rs);
        this.addRsToMap(conn, this.rsList.size() - 1);
        return this.rsList.size() - 1;
    }
}

